<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_group_list extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $id = XF::sanitize_var(XF::ifset('get','id',0),'int');
  $showacl = XF::sanitize_var(XF::ifset('get','acl',0),'booli');
  $this->gpc = array('id'=>$id,'acl'=>$showacl);
  unset($id,$showacl);

  $data = array();
    if ( $this->gpc['id'] !== 0 ){
      if ( $this->gpc['acl'] === 1 ){
      $sacl = XF::sql_query("SELECT a_id,a_action,a_allow FROM ".XF::tbl('acl')." WHERE a_use_group = true AND a_key = :id ORDER BY a_action ASC",array(
      'id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
        while ( $r = $sacl->fetchObject() ){
        $r->a_id = intval($r->a_id);
        $r->a_allow = (bool)$r->a_allow;
        $r->__action_str = '{:acl_seg_'.$r->a_action.'}';
        $data[] = (array)$r;
        }
      $sacl->closeCursor();
      XF::tan('acp_acl_edit');
      XFUI::load_lang_res('','acpacl');
      }
      else{
      $sgrp = XF::sql_query("SELECT * FROM ".XF::tbl('group')." WHERE g_id = :id",array(
      'id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
      $data = (array)$sgrp->fetchObject();
      $sgrp->closeCursor();
      $susr = XF::sql_query("SELECT COUNT(u_id) AS user_in_group FROM ".XF::tbl('user')." WHERE u_group = :id",array(
      'id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
      $group = $susr->fetchObject();
      $data['user_in_group'] = intval($group->user_in_group);
      $susr->closeCursor();
        if ( in_array($this->gpc['id'],array(1,2,3,4,5),true) )
        $data['user_in_group'] = 1;
      $data['g_post_approved'] = (bool)$data['g_post_approved'];
      $data['g_post_repeat'] = (bool)$data['g_post_repeat'];
      $data['g_post_filter'] = (bool)$data['g_post_filter'];
      $data['g_read_unapproved'] = (bool)$data['g_read_unapproved'];
      $data['g_executive'] = (bool)$data['g_executive'];
      XF::tan('acp_group_edit');
      XF::tan('acp_group_delete');
      }
    XFUI::ajax_init();
    }

  XFUI::html_head('{:user_group}');
  XF::$tpl->clear_cache('form_acp_group.tpl');
  XF::$tpl->assign('show_acl_form',$this->gpc['acl']);
  XF::$tpl->assign('selected_group',$this->gpc['id']);
  XF::$tpl->assign('weight_listing',array(1,2,3,4,5));
  XF::$tpl->assign('group_listing',XF::get_group('*'));
  XF::$tpl->assign('group_data',$data);
  XF::$tpl->display('form_acp_group.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * list user groups (directly done by run())
  * @since 1.0.0
  */
  public function execute(){}

}
?>