<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_cachemgr extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','overview');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $class = XF::sanitize_var(XF::ifset(XF::vault_query('request_method'),'f_class','-'),'enum','o=-,o=main,o=tpl,o=acl,o=user,o=topic,o=post,o=all');
  $topic = XF::sanitize_var(XF::ifset(XF::vault_query('request_method'),'f_topicid',0),'str');
  $post = XF::sanitize_var(XF::ifset(XF::vault_query('request_method'),'f_postid',0),'str');
  $this->gpc = array('class'=>$class,'topic'=>$topic,'post'=>$post);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('overview'));
  unset($class,$topic,$post);
    if ( $this->gpc['class'] !== '-' )
    return $this->execute();

  XF::tan('cachemgr');
  XFUI::html_head('{:cache_manager}');
  //XF::$tpl->clear_cache('form_cachemgr.tpl');
  XF::$tpl->display('form_cachemgr.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * perform actions on cache
  * @return true
  * @since 1.0.0
  */
  public function execute(){
  $tan = XF::sanitize_var(XF::ifset(XF::vault_query('request_method'),'tan',0),'int');
    if ( !isset($_SESSION['xf_tan']['cachemgr']) || $tan !== $_SESSION['xf_tan']['cachemgr'] )
    XFUI::html_redirect(-1,XF::link('cachemgr'));
  $t = XF::link('cachemgr');

    switch ( $this->gpc['class'] ){
    case 'main': case 'all':
    $a = array('acp_overview_request.tpl','acp_overview_statistic.tpl','mcp_overview.tpl','overview.tpl','overview_recent_posts.tpl');
    XFCache::purge('simple','config');
    XFCache::purge('simple','group');
    XFCache::purge('simple','post_recent');
    XFCache::purge('simple','post_reported');
    XFCache::purge('simple','post_timespan');
    XFCache::purge('simple','subject_prefix');
    XFCache::purge('simple','count_post');
    XFCache::purge('simple','count_user');
      foreach ( $a as $v ){
        if ( XF::$tpl->is_cached($v) )
        XF::$tpl->clear_cache($v);
      }
      if ( $this->gpc['class'] === 'all' ){
      XFCache::purge('pool','*');
      XFCache::purge('tpl');
      }
    break;
    case 'tpl':
    XFCache::purge('tpl');
    break;
    case 'acl':
    $sacl = XF::sql_query("SELECT a_action FROM ".XF::tbl('acl')." GROUP BY a_action",'',__METHOD__,__LINE__);
      while ( $r = $sacl->fetchObject() )
      XFCache::purge('acl',crc32($r->a_action));
    $sacl->closeCursor();
    break;
    case 'user':
    $susr = XF::sql_query("SELECT MIN(u_id) AS min_id,MAX(u_id) AS max_id FROM ".XF::tbl('user'),'',__METHOD__,__LINE__);
    $r = $susr->fetchObject();
    $susr->closeCursor();
      for ( $i = (int)$r->min_id ; $i <= (int)$r->max_id ; $i++ )
      XFCache::purge('user',$i);
    break;
    case 'topic':
    $a = explode(',',$this->gpc['topic']);
      foreach ( $a as $k=>$v ){
        if ( $k !== 0 && $v === '*' )
        continue;
      XFCache::purge('topic',(int)$v);
      XF::tpl_use_cache_pool((int)$v,'begin');
      XF::$tpl->clear_cache('topic_quick_jump.tpl',(int)$v);
      XF::tpl_use_cache_pool(0,'reset');
        if ( $k === 0 && $v === '*' )
        break;
      }
      if ( sizeof($a) === 1 && $a[0] !== '*' )
      $t = XF::link('topic',array('id'=>$a[0]));
    break;
    case 'post':
    $a = explode(',',$this->gpc['post']);
    $b = true;
    XF::tpl_use_cache_pool(0,'begin');
      foreach ( $a as $k=>$v ){
        if ( $k === 0 && $v === '*' ){
        XF::tpl_use_cache_pool(0,'reset');
        XFCache::purge('pool','*');
        $b = false;
        break;
        }
      XF::tpl_use_cache_pool($v,'change');
        if ( XF::$tpl->is_cached('post.tpl',(int)$v) )
        XF::$tpl->clear_cache('post.tpl',(int)$v);
      }
      if ( $b )
      XF::tpl_use_cache_pool(0,'reset');
      if ( sizeof($a) === 1 && $a[0] !== '*' )
      $t = XF::link('topic',array('post'=>$a[0]));
    break;
    default: break;
    }

  XF::logger('info','class',$this->gpc['class'],'topic',$this->gpc['topic'],'post',$this->gpc['post']);
  XF::tan('cachemgr','-');
  $this->success = true;
  XFUI::html_redirect(1,$t,'{:cachemgr_success}');
  return true;
  }

}
?>