<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_login extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
/**
* @var boolean redirect to 'my profile' after login?
*/
public $to_profile = false;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','login');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::ajax_init();
  XFUI::html_head('{:login}');
  XF::$tpl->display('form_login.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $uid = XF::sanitize_var($input['f_user'],'uid');
  $pwd = XF::sanitize_var($input['f_pass_hash'],'str','restrict');
  $this->gpc = array('f_user'=>$uid,'f_pass'=>$pwd);
  $this->markgpc = array('f_user','f_pass');
  return true;
  }

  /**
  * log an user in
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
  require_once(XF::vault_query('root_path').'/class.auth.php');
  $auth = XFAuth::check($this->gpc['f_user'],$this->gpc['f_pass']);
  // TODO: [idle] execute() konqueror had problems with sha1.js - if a password contains unicode the hash is calculated wrong
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,XF::arr2str($auth));
    if ( !$auth['valid_user'] )
    $this->error = '{:incorrect_username}';
    if ( !$auth['active'] && empty($this->error) )
    $this->error = '{:account_not_active}';
    if ( $auth['login_fail'] >= XF::get_cfg('auth_max_faillogin') && empty($this->error) )
    $this->error = '{:too_many_fail_logins}';
    if ( !$auth['valid_password'] && empty($this->error) )
    $this->error = '{:incorrect_password}';
  XF::statistic('login_attempt');

    if ( empty($this->error) ){
      try {
        if ( !XF::sql_transaction('begin',array('user'=>'w','user_blacklist'=>'r','user_bookmark'=>'r')) )
        throw new XFE('unable to begin database transaction');
        if ( session_id() === '' && !headers_sent() )
        session_start();
        if ( session_id() !== '' ){
        header('Set-Cookie: ');
        XF::cookie(XF::get_cfg('cookie_session'),session_id());
        $token = XF::token(8);
        $_SESSION['xf_authentication'] = array( // authenticate this user...
        'id'=>$auth['id'],
        'status'=>'clear',
        'username'=>$auth['username'],
        'password'=>'*',
        'token'=>$token,
        'time'=>XF::vault_query('uts'),
        'client_hash'=>XF::vault_query('client_hash'),
        'ip'=>sha1(XF::vault_query('client_ip'))
        );
        // okay, put some more to session dataset ;)
        $_SESSION['xf_generation'] = 1;
        $_SESSION['xf_tan'] = array();
        $_SESSION['xf_blacklist'] = array();
        $_SESSION['xf_bookmark'] = array();
        $susr = XF::sql_query("SELECT u_time_last_read FROM ".XF::tbl('user')." WHERE u_id = :id",
        array('id'=>array($auth['id'],'int')),__METHOD__,__LINE__);
        $userdata = $susr->fetchObject();
        $_SESSION['xf_read_tracker'] = array('global'=>intval($userdata->u_time_last_read),'local'=>array());
        $susr->closeCursor();
        $subl = XF::sql_query("SELECT ub_u_id_dst FROM ".XF::tbl('user_blacklist')." WHERE ub_u_id_src = :id",
        array('id'=>array($auth['id'],'int')),__METHOD__,__LINE__);
          while ( $r = $subl->fetchObject() )
          $_SESSION['xf_blacklist'][] = intval($r->ub_u_id_dst);
        $subl->closeCursor();
        $sbmk = XF::sql_query("SELECT uk_p_id FROM ".XF::tbl('user_bookmark')." WHERE uk_u_id = :id",
        array('id'=>array($auth['id'],'int')),__METHOD__,__LINE__);
          while ( $r = $subl->fetchObject() )
          $_SESSION['xf_bookmark'][] = intval($r->ub_p_id);
        $sbmk->closeCursor();
        $u = XF::sql_query("UPDATE ".XF::tbl('user')." SET u_login_token = :token, u_login_count = u_login_count+1 WHERE u_id = :id",array(
        'id'=>array($auth['id'],'int'),
        'token'=>array($token,'int')),__METHOD__,__LINE__);
          if ( !$u )
          throw new XFE('could not update dataset for user "'.$this->gpc['id'].'"');
          if ( $auth['login_count'] === 0 )
          $this->to_profile = true;
        XFCache::purge('user',$auth['id']);
        XF::logger('info','userid',$auth['id'],'username',$auth['username']);
        XF::statistic('login_success');
        XF::sql_transaction('commit');
        $this->success = true;
        }
        else
        throw new XFE('session could not be started');
      } catch ( XFE $E ){ XF::cookie(XF::get_cfg('cookie_session'),null); session_destroy(); $E->handle(); if ( $E->check_abort() ) return false; }
    }
    else{
      if ( $auth['id'] && !$auth['valid_password'] && $auth['login_fail'] < XF::get_cfg('auth_max_faillogin') ){
      XF::sql_query("UPDATE ".XF::tbl('user')." SET u_login_fail = u_login_fail+1 WHERE u_id = :id",
      array('id'=>array($auth['id'],'int')),__METHOD__,__LINE__);
      XFCache::purge('user',$auth['id']);
      }
    }

  return true;
  }

}

  function xfaf_login($input){
  $a = new XFAction_login();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
      return xfaf_success(($a->to_profile)?XF::link('ucp_profile','',false):XF::link('search',array('stage'=>'by_last_read'),false),'{:you_are_now_logged_in}');
    else
    return xfaf_failure($a->get_error());
  }

?>