/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.sitemap.PatternException;

public abstract class MapStackResolver {
    public static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));

    public abstract String resolve(List var1) throws PatternException;

    public static boolean needsResolve(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        if (expression.charAt(0) == '{') {
            return true;
        }
        if (expression.length() < 2) {
            return false;
        }
        int pos = 1;
        while ((pos = expression.indexOf(123, pos)) != -1) {
            if (expression.charAt(pos - 1) != '\\') {
                return true;
            }
            ++pos;
        }
        return false;
    }

    public static String unescape(String expression) {
        if (expression == null || expression.indexOf("\\{") == -1) {
            return expression;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (ch == '\\' && i < expression.length() - 1 && expression.charAt(i + 1) == '{') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    public static MapStackResolver getResolver(String expression) throws PatternException {
        if (MapStackResolver.needsResolve(expression)) {
            return new CompiledResolver(expression);
        }
        return new NullResolver(expression);
    }

    public static Parameters buildParameters(Map expressions, List mapStack) throws PatternException {
        if (expressions == null || expressions.size() == 0) {
            return Parameters.EMPTY_PARAMETERS;
        }
        Parameters result = new Parameters();
        Iterator iter = expressions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            result.setParameter(((MapStackResolver)entry.getKey()).resolve(mapStack), ((MapStackResolver)entry.getValue()).resolve(mapStack));
        }
        return result;
    }

    public static Map resolveMap(Map expressions, List mapStack) throws PatternException {
        int size;
        if (expressions == null || (size = expressions.size()) == 0) {
            return EMPTY_MAP;
        }
        HashMap<String, String> result = new HashMap<String, String>(size);
        Iterator iter = expressions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            result.put(((MapStackResolver)entry.getKey()).resolve(mapStack), ((MapStackResolver)entry.getValue()).resolve(mapStack));
        }
        return result;
    }

    private static class CompiledResolver
    extends MapStackResolver {
        private String originalExpr;
        private String[] strings;
        private int[] levels;

        public CompiledResolver(String expression) throws PatternException {
            this.originalExpr = expression;
            this.compile(expression);
        }

        public String toString() {
            return this.originalExpr;
        }

        private void compile(String expr) throws PatternException {
            ArrayList<String> stringList = new ArrayList<String>();
            ArrayList<Integer> levelList = new ArrayList<Integer>();
            int length = expr.length();
            int prev = 0;
            while (prev < length) {
                int pos = prev;
                while (pos < length && (pos = expr.indexOf(123, pos)) != -1 && pos != 0 && expr.charAt(pos - 1) == '\\') {
                    ++pos;
                }
                if (pos >= length || pos == -1) {
                    if (prev >= length) break;
                    stringList.add(CompiledResolver.unescape(expr.substring(prev)));
                    levelList.add(new Integer(-1));
                    break;
                }
                if (prev < ++pos - 1) {
                    stringList.add(CompiledResolver.unescape(expr.substring(prev, pos - 1)));
                    levelList.add(new Integer(-1));
                }
                int level = 1;
                while (expr.startsWith("../", pos)) {
                    ++level;
                    pos += "../".length();
                }
                int end = expr.indexOf(125, pos);
                if (end == -1) {
                    throw new PatternException("Unmatched '{' in " + expr);
                }
                stringList.add(expr.substring(pos, end));
                levelList.add(new Integer(level));
                prev = end + 1;
            }
            this.strings = new String[stringList.size()];
            this.levels = new int[stringList.size()];
            for (int i = 0; i < this.strings.length; ++i) {
                this.strings[i] = (String)stringList.get(i);
                this.levels[i] = (Integer)levelList.get(i);
            }
        }

        public final String resolve(List mapStack) throws PatternException {
            StringBuffer result = new StringBuffer();
            int stackSize = mapStack.size();
            for (int i = 0; i < this.strings.length; ++i) {
                int level = this.levels[i];
                if (level == -1) {
                    result.append(this.strings[i]);
                    continue;
                }
                if (level > stackSize) {
                    throw new PatternException("Error while evaluating '" + this.originalExpr + "' : not so many levels");
                }
                Object value = ((Map)mapStack.get(stackSize - level)).get(this.strings[i]);
                if (value == null) continue;
                result.append(value);
            }
            return result.toString();
        }
    }

    private static class NullResolver
    extends MapStackResolver {
        private String originalExpr = null;
        private String expression = null;

        public NullResolver(String expression) {
            if (expression != null) {
                this.originalExpr = expression;
                this.expression = NullResolver.unescape(expression);
            }
        }

        public String toString() {
            return this.originalExpr;
        }

        public final String resolve(List mapStack) {
            return this.expression;
        }
    }
}

