/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.search.IndexSearchAdapter;
import org.eclipse.jdt.internal.core.search.PathCollector;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodReferencePattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class SuperTypeNamesCollector
implements ITypeRequestor {
    MethodReferencePattern pattern;
    MatchLocator locator;
    IType type;
    IProgressMonitor progressMonitor;
    char[][][] result;
    int resultIndex;

    public SuperTypeNamesCollector(MethodReferencePattern pattern, MatchLocator locator, IType type, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.locator = locator;
        this.type = type;
        this.progressMonitor = progressMonitor;
    }

    private CompilationUnitDeclaration buildBindings(org.eclipse.jdt.core.ICompilationUnit compilationUnit) throws JavaModelException {
        IBuffer buffer;
        IFile file = compilationUnit.isWorkingCopy() ? (IFile)compilationUnit.getOriginalElement().getResource() : (IFile)compilationUnit.getResource();
        final String fileName = file.getFullPath().lastSegment();
        final char[] mainTypeName = fileName.substring(0, fileName.length() - 5).toCharArray();
        final char[] source = compilationUnit.isWorkingCopy() ? (Object)((buffer = compilationUnit.getBuffer()) == null ? null : buffer.getCharacters()) : Util.getResourceContentsAsCharArray(file);
        ICompilationUnit sourceUnit = new ICompilationUnit(){

            public char[] getContents() {
                return source;
            }

            public char[] getFileName() {
                return fileName.toCharArray();
            }

            public char[] getMainTypeName() {
                return mainTypeName;
            }

            public char[][] getPackageName() {
                return null;
            }
        };
        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration unit = this.locator.parser.dietParse(sourceUnit, compilationResult);
        if (unit != null) {
            this.locator.lookupEnvironment.buildTypeBindings(unit);
            this.locator.lookupEnvironment.completeTypeBindings(unit, false);
        }
        return unit;
    }

    protected char[][][] collect() throws JavaModelException {
        if (this.type != null) {
            this.result = new char[1][][];
            this.resultIndex = 0;
            JavaProject javaProject = (JavaProject)this.type.getJavaProject();
            this.locator.initializeNameEnvironment(javaProject);
            this.locator.initialize(javaProject);
            NameLookup nameLookup = this.locator.nameLookup;
            synchronized (nameLookup) {
                this.locator.nameLookup.setUnitsToLookInside(this.locator.workingCopies);
                try {
                    try {
                        if (this.type.isBinary()) {
                            BinaryTypeBinding binding = this.locator.cacheBinaryType(this.type);
                            if (binding != null) {
                                this.collectSuperTypeNames(binding);
                            }
                        } else {
                            org.eclipse.jdt.core.ICompilationUnit unit = this.type.getCompilationUnit();
                            CompilationUnitDeclaration parsedUnit = this.buildBindings(unit);
                            if (parsedUnit != null) {
                                parsedUnit.traverse((IAbstractSyntaxTreeVisitor)new TypeDeclarationVisitor(), parsedUnit.scope);
                            }
                        }
                    }
                    catch (AbortCompilation abortCompilation) {
                        Object var5_10 = null;
                        this.locator.nameLookup.setUnitsToLookInside(null);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_11 = null;
                    this.locator.nameLookup.setUnitsToLookInside(null);
                    throw throwable;
                }
                Object var5_12 = null;
                this.locator.nameLookup.setUnitsToLookInside(null);
            }
            return this.result;
        }
        String[] paths = this.getPathsOfDeclaringType();
        if (paths != null) {
            Util.sort(paths);
            JavaProject previousProject = null;
            this.result = new char[1][][];
            this.resultIndex = 0;
            try {
                int i = 0;
                int length = paths.length;
                while (i < length) {
                    try {
                        Openable openable = this.locator.handleFactory.createOpenable(paths[i], this.locator.scope);
                        if (openable != null) {
                            IClassFile classFile;
                            BinaryTypeBinding binding;
                            IJavaProject project = openable.getJavaProject();
                            if (!project.equals(previousProject)) {
                                if (previousProject != null) {
                                    this.locator.nameLookup.setUnitsToLookInside(null);
                                }
                                previousProject = (JavaProject)project;
                                this.locator.initializeNameEnvironment(previousProject);
                                this.locator.initialize(previousProject);
                                this.locator.nameLookup.setUnitsToLookInside(this.locator.workingCopies);
                            }
                            if (openable instanceof org.eclipse.jdt.core.ICompilationUnit) {
                                org.eclipse.jdt.core.ICompilationUnit unit = (org.eclipse.jdt.core.ICompilationUnit)((Object)openable);
                                CompilationUnitDeclaration parsedUnit = this.buildBindings(unit);
                                if (parsedUnit != null) {
                                    parsedUnit.traverse((IAbstractSyntaxTreeVisitor)new TypeDeclarationVisitor(), parsedUnit.scope);
                                }
                            } else if (openable instanceof IClassFile && this.matches(binding = this.locator.cacheBinaryType((classFile = (IClassFile)((Object)openable)).getType()))) {
                                this.collectSuperTypeNames(binding);
                            }
                        }
                    }
                    catch (AbortCompilation abortCompilation) {
                    }
                    catch (JavaModelException javaModelException) {}
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var9_19 = null;
                if (previousProject != null) {
                    this.locator.nameLookup.setUnitsToLookInside(null);
                }
                throw throwable;
            }
            Object var9_20 = null;
            if (previousProject != null) {
                this.locator.nameLookup.setUnitsToLookInside(null);
            }
            this.result = new char[this.resultIndex][][];
            System.arraycopy(this.result, 0, this.result, 0, this.resultIndex);
            return this.result;
        }
        return null;
    }

    protected boolean matches(ReferenceBinding type) {
        if (type == null || type.compoundName == null) {
            return false;
        }
        return this.matches(type.compoundName);
    }

    protected boolean matches(char[][] compoundName) {
        int length = compoundName.length;
        if (length == 0) {
            return false;
        }
        char[] simpleName = compoundName[length - 1];
        char[] declaringSimpleName = this.pattern.declaringSimpleName;
        char[] declaringQualification = this.pattern.declaringQualification;
        int last = length - 1;
        if (declaringSimpleName != null) {
            if (this.pattern.matchesName(simpleName, declaringSimpleName)) {
                char[][] qualification = new char[last][];
                System.arraycopy(compoundName, 0, qualification, 0, last);
                return this.pattern.matchesName(declaringQualification, CharOperation.concatWith(qualification, '.'));
            }
            if (!CharOperation.endsWith(simpleName, declaringSimpleName)) {
                return false;
            }
            char[][] cArray = compoundName;
            compoundName = new char[length + 1][];
            System.arraycopy(cArray, 0, compoundName, 0, last);
            int dollar = CharOperation.indexOf('$', simpleName);
            if (dollar == -1) {
                return false;
            }
            compoundName[last] = CharOperation.subarray(simpleName, 0, dollar);
            compoundName[length] = CharOperation.subarray(simpleName, dollar + 1, simpleName.length);
            return this.matches(compoundName);
        }
        char[][] qualification = new char[last][];
        System.arraycopy(compoundName, 0, qualification, 0, last);
        return this.pattern.matchesName(declaringQualification, CharOperation.concatWith(qualification, '.'));
    }

    private void addToResult(char[][] compoundName) {
        int resultLength = this.result.length;
        int i = 0;
        while (i < resultLength) {
            if (CharOperation.equals(this.result[i], compoundName)) {
                return;
            }
            ++i;
        }
        if (resultLength == this.resultIndex) {
            this.result = new char[resultLength * 2][][];
            System.arraycopy(this.result, 0, this.result, 0, resultLength);
        }
        this.result[this.resultIndex++] = compoundName;
    }

    protected void collectSuperTypeNames(ReferenceBinding type) {
        ReferenceBinding[] interfaces;
        ReferenceBinding superclass = type.superclass();
        if (superclass != null) {
            this.addToResult(superclass.compoundName);
            this.collectSuperTypeNames(superclass);
        }
        if ((interfaces = type.superInterfaces()) != null) {
            int i = 0;
            while (i < interfaces.length) {
                ReferenceBinding interfase = interfaces[i];
                this.addToResult(interfase.compoundName);
                this.collectSuperTypeNames(interfase);
                ++i;
            }
        }
    }

    private String[] getPathsOfDeclaringType() {
        char[] declaringQualification = this.pattern.declaringQualification;
        char[] declaringSimpleName = this.pattern.declaringSimpleName;
        if (declaringQualification != null || declaringSimpleName != null) {
            final PathCollector pathCollector = new PathCollector();
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            int detailLevel = 2;
            TypeDeclarationPattern searchPattern = new TypeDeclarationPattern(declaringSimpleName != null ? null : declaringQualification, null, declaringSimpleName, '\u0000', this.pattern.matchMode, true);
            IndexSearchAdapter searchRequestor = new IndexSearchAdapter(){

                public void acceptClassDeclaration(String resourcePath, char[] simpleTypeName, char[][] enclosingTypeNames, char[] packageName) {
                    if (enclosingTypeNames != IIndexConstants.ONE_ZERO_CHAR) {
                        pathCollector.acceptClassDeclaration(resourcePath, simpleTypeName, enclosingTypeNames, packageName);
                    }
                }

                public void acceptInterfaceDeclaration(String resourcePath, char[] simpleTypeName, char[][] enclosingTypeNames, char[] packageName) {
                    if (enclosingTypeNames != IIndexConstants.ONE_ZERO_CHAR) {
                        pathCollector.acceptInterfaceDeclaration(resourcePath, simpleTypeName, enclosingTypeNames, packageName);
                    }
                }
            };
            indexManager.performConcurrentJob(new PatternSearchJob(searchPattern, scope, detailLevel, searchRequestor, indexManager), 3, (IProgressMonitor)(this.progressMonitor == null ? null : new SubProgressMonitor(this.progressMonitor, 100)));
            return pathCollector.getPaths();
        }
        return null;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        this.locator.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
    }

    public void accept(ICompilationUnit sourceUnit) {
        this.locator.lookupEnvironment.problemReporter.abortDueToInternalError(org.eclipse.jdt.internal.compiler.util.Util.bind("accept.cannot") + sourceUnit.getFileName());
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, 0);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, false, true, false, this.locator.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.locator.lookupEnvironment.buildTypeBindings(unit);
            this.locator.lookupEnvironment.completeTypeBindings(unit, false);
        }
    }

    public class TypeDeclarationVisitor
    extends AbstractSyntaxTreeVisitorAdapter {
        public boolean visit(LocalTypeDeclaration typeDeclaration, BlockScope scope) {
            SourceTypeBinding type = typeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(type)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(type);
            }
            return true;
        }

        public boolean visit(AnonymousLocalTypeDeclaration typeDeclaration, BlockScope scope) {
            SourceTypeBinding type = typeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(type)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(type);
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
            SourceTypeBinding type = typeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(type)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(type);
            }
            return true;
        }

        public boolean visit(MemberTypeDeclaration memberTypeDeclaration, ClassScope scope) {
            SourceTypeBinding type = memberTypeDeclaration.binding;
            if (SuperTypeNamesCollector.this.matches(type)) {
                SuperTypeNamesCollector.this.collectSuperTypeNames(type);
            }
            return true;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            return false;
        }

        public boolean visit(Initializer initializer, MethodScope scope) {
            return false;
        }

        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            return false;
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            return false;
        }
    }
}

