/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayQualifiedTypeReference
extends QualifiedTypeReference {
    int dimensions;

    public ArrayQualifiedTypeReference(char[][] sources, int dim, long[] poss) {
        super(sources, poss);
        this.dimensions = dim;
    }

    public ArrayQualifiedTypeReference(char[][] sources, TypeBinding tb, int dim, long[] poss) {
        super(sources, tb, poss);
        this.dimensions = dim;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        return scope.createArray(scope.getType(this.tokens), this.dimensions);
    }

    public String toStringExpression(int tab) {
        String s = super.toStringExpression(tab);
        if (this.dimensions == 1) {
            return String.valueOf(s) + "[]";
        }
        int i = 1;
        while (i <= this.dimensions) {
            s = String.valueOf(s) + "[]";
            ++i;
        }
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, ClassScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

