/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ResetStateForCodeGenerationVisitor;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public abstract class AbstractMethodDeclaration
extends AstNode
implements ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    public char[] selector;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public int modifiersSourceStart;
    public Argument[] arguments;
    public TypeReference[] thrownExceptions;
    public Statement[] statements;
    public int explicitDeclarations;
    public MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public boolean needFreeReturn = false;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int abortLevel) {
        if (this.scope == null) {
            throw new AbortCompilation();
        }
        CompilationResult compilationResult = this.scope.referenceCompilationUnit().compilationResult;
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(compilationResult);
            }
            case 4: {
                throw new AbortCompilationUnit(compilationResult);
            }
            case 8: {
                throw new AbortType(compilationResult);
            }
        }
        throw new AbortMethod(compilationResult);
    }

    public abstract void analyseCode(ClassScope var1, InitializationFlowContext var2, FlowInfo var3);

    public void bindArguments() {
        if (this.arguments != null) {
            boolean used = this.binding == null || this.binding.isAbstract() || this.binding.isNative();
            int length = this.arguments.length;
            int i = 0;
            while (i < length) {
                TypeBinding argType = this.binding == null ? null : this.binding.parameters[i];
                this.arguments[i].bind(this.scope, argType, used);
                ++i;
            }
        }
    }

    public void bindThrownExceptions() {
        block8: {
            if (this.thrownExceptions == null || this.binding == null || this.binding.thrownExceptions == null) break block8;
            int length = this.binding.thrownExceptions.length;
            int thrownExceptionLength = this.thrownExceptions.length;
            if (length == thrownExceptionLength) {
                int i = 0;
                while (i < length) {
                    this.thrownExceptions[i].resolvedType = this.binding.thrownExceptions[i];
                    ++i;
                }
            } else {
                int bindingIndex = 0;
                int i = 0;
                while (i < thrownExceptionLength && bindingIndex < length) {
                    TypeReference thrownException = this.thrownExceptions[i];
                    ReferenceBinding thrownExceptionBinding = this.binding.thrownExceptions[bindingIndex];
                    char[][] bindingCompoundName = thrownExceptionBinding.compoundName;
                    if (thrownException instanceof SingleTypeReference) {
                        int lengthName = bindingCompoundName.length;
                        char[] thrownExceptionTypeName = thrownException.getTypeName()[0];
                        if (CharOperation.equals(thrownExceptionTypeName, bindingCompoundName[lengthName - 1])) {
                            thrownException.resolvedType = thrownExceptionBinding;
                            ++bindingIndex;
                        }
                    } else if (CharOperation.equals(thrownException.getTypeName(), bindingCompoundName)) {
                        thrownException.resolvedType = thrownExceptionBinding;
                        ++bindingIndex;
                    }
                    ++i;
                }
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int problemResetPC = 0;
        classFile.codeStream.wideMode = false;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            IProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int problemsLength = problems.length;
            IProblem[] problemsCopy = new IProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemMethod(this, this.binding, problemsCopy);
            return;
        }
        try {
            problemResetPC = classFile.contentsOffset;
            this.generateCode(classFile);
        }
        catch (AbortMethod e) {
            if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    this.traverse((IAbstractSyntaxTreeVisitor)new ResetStateForCodeGenerationVisitor(), classScope);
                    classFile.contentsOffset = problemResetPC;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.generateCode(classFile);
                }
                catch (AbortMethod abortMethod) {
                    IProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
                    int problemsLength = problems.length;
                    IProblem[] problemsCopy = new IProblem[problemsLength];
                    System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
                    classFile.addProblemMethod(this, this.binding, problemsCopy, problemResetPC);
                }
            }
            IProblem[] problems = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int problemsLength = problems.length;
            IProblem[] problemsCopy = new IProblem[problemsLength];
            System.arraycopy(problems, 0, problemsCopy, 0, problemsLength);
            classFile.addProblemMethod(this, this.binding, problemsCopy, problemResetPC);
        }
    }

    private void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttribute(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int max;
            int i;
            int codeAttributeOffset = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            this.scope.computeLocalVariablePositions(this.binding.isStatic() ? 0 : 1, codeStream);
            if (this.arguments != null) {
                i = 0;
                max = this.arguments.length;
                while (i < max) {
                    LocalVariableBinding argBinding = this.arguments[i].binding;
                    codeStream.addVisibleLocalVariable(argBinding);
                    argBinding.recordInitializationStartPC(0);
                    ++i;
                }
            }
            if (this.statements != null) {
                i = 0;
                max = this.statements.length;
                while (i < max) {
                    this.statements[i].generateCode(this.scope, codeStream);
                    ++i;
                }
            }
            if (this.needFreeReturn) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.declarationSourceEnd);
            classFile.completeCodeAttribute(codeAttributeOffset);
            ++attributeNumber;
        } else {
            this.checkArgumentsSize();
        }
        classFile.completeMethodInfo(methodAttributeOffset, attributeNumber);
        if (this.ignoreFurtherInvestigation) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult);
        }
    }

    private void checkArgumentsSize() {
        TypeBinding[] parameters = this.binding.parameters;
        int size = 1;
        int i = 0;
        int max = parameters.length;
        while (i < max) {
            TypeBinding parameter = parameters[i];
            size = parameter == BaseTypes.LongBinding || parameter == BaseTypes.DoubleBinding ? (size += 2) : ++size;
            if (size > 255) {
                this.scope.problemReporter().noMoreAvailableSpaceForArgument(this.scope.locals[i], this.scope.locals[i].declaration);
            }
            ++i;
        }
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isNative() {
        if (this.binding != null) {
            return this.binding.isNative();
        }
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    public void resolve(ClassScope upperScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            this.bindArguments();
            this.bindThrownExceptions();
            this.resolveStatements();
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i++].resolve(this.scope);
            }
        }
    }

    public String returnTypeToString(int tab) {
        return "";
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public String toString(int tab) {
        int i;
        String s = AstNode.tabString(tab);
        if (this.modifiers != 0) {
            s = String.valueOf(s) + AstNode.modifiersString(this.modifiers);
        }
        s = String.valueOf(s) + this.returnTypeToString(0);
        s = String.valueOf(s) + new String(this.selector) + "(";
        if (this.arguments != null) {
            i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + this.arguments[i].toString(0);
                if (i != this.arguments.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + ")";
        if (this.thrownExceptions != null) {
            s = String.valueOf(s) + " throws ";
            i = 0;
            while (i < this.thrownExceptions.length) {
                s = String.valueOf(s) + this.thrownExceptions[i].toString(0);
                if (i != this.thrownExceptions.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + this.toStringStatements(tab + 1);
        return s;
    }

    public String toStringStatements(int tab) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return ";";
        }
        String s = " {";
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                s = String.valueOf(s) + "\n" + this.statements[i].toString(tab);
                if (!(this.statements[i] instanceof Block)) {
                    s = String.valueOf(s) + ";";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "\n" + AstNode.tabString(tab == 0 ? 0 : tab - 1) + "}";
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, ClassScope classScope) {
    }
}

