/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.fop.layout.hyphenation.HyphenationException;
import org.apache.fop.layout.hyphenation.HyphenationTree;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class SerializeHyphPattern
extends MatchingTask {
    private File sourceDir;
    private File targetDir;
    private boolean errorDump = false;

    public void execute() throws BuildException {
        DirectoryScanner ds = this.getDirectoryScanner(this.sourceDir);
        String[] files = ds.getIncludedFiles();
        int i = 0;
        while (i < files.length) {
            this.processFile(files[i].substring(0, files[i].length() - 4));
            ++i;
        }
    }

    public void setSourceDir(String sourceDir) {
        File dir = new File(sourceDir);
        if (!dir.exists()) {
            System.err.println("Fatal Error: source directory " + sourceDir + " for hyphenation files doesn't exist.");
            System.exit(1);
        }
        this.sourceDir = dir;
    }

    public void setTargetDir(String targetDir) {
        File dir;
        this.targetDir = dir = new File(targetDir);
    }

    public void setErrorDump(boolean errorDump) {
        this.errorDump = errorDump;
    }

    private void processFile(String filename) {
        File infile = new File(this.sourceDir, filename + ".xml");
        File outfile = new File(this.targetDir, filename + ".hyp");
        long outfileLastModified = outfile.lastModified();
        boolean startProcess = true;
        startProcess = this.rebuild(infile, outfile);
        if (startProcess) {
            this.buildPatternFile(infile, outfile);
        }
    }

    private void buildPatternFile(File infile, File outfile) {
        HyphenationTree hTree;
        block5: {
            System.out.println("Processing " + infile);
            hTree = new HyphenationTree();
            try {
                hTree.loadPatterns(infile.toString());
                if (this.errorDump) {
                    System.out.println("Stats: ");
                    hTree.printStats();
                }
            }
            catch (HyphenationException ex) {
                System.err.println("Can't load patterns from xml file " + infile + " - Maybe hyphenation.dtd is missing?");
                if (!this.errorDump) break block5;
                System.err.println(ex.toString());
            }
        }
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outfile));
            out.writeObject(hTree);
            out.close();
        }
        catch (IOException ioe) {
            System.err.println("Can't write compiled pattern file: " + outfile);
            System.err.println(ioe);
        }
    }

    private boolean rebuild(File infile, File outfile) {
        if (outfile.exists()) {
            return outfile.lastModified() < infile.lastModified();
        }
        return true;
    }
}

