/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class VariablePointer
extends NodePointer {
    private Variables variables;
    private QName name;
    private NodePointer valuePointer;
    private boolean actual;

    public VariablePointer(Variables variables, QName name) {
        super(null);
        this.variables = variables;
        this.name = name;
        this.actual = true;
    }

    public VariablePointer(QName name) {
        super(null);
        this.name = name;
        this.actual = false;
    }

    public boolean isContainer() {
        return true;
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        if (!this.actual) {
            throw new JXPathException("Undefined variable: " + this.name);
        }
        return this.variables.getVariable(this.name.toString());
    }

    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    public Object getImmediateNode() {
        Object value = this.getBaseValue();
        if (this.index != Integer.MIN_VALUE) {
            return ValueUtils.getValue(value, this.index);
        }
        return value;
    }

    public void setValue(Object value) {
        if (!this.actual) {
            throw new JXPathException("Cannot set undefined variable: " + this.name);
        }
        this.valuePointer = null;
        if (this.index != Integer.MIN_VALUE) {
            Object collection = this.getBaseValue();
            ValueUtils.setValue(collection, this.index, value);
        } else {
            this.variables.declareVariable(this.name.toString(), value);
        }
    }

    public boolean isActual() {
        return this.actual;
    }

    public void setIndex(int index) {
        super.setIndex(index);
        this.valuePointer = null;
    }

    public NodePointer getImmediateValuePointer() {
        if (this.valuePointer == null) {
            Object value = null;
            if (this.actual) {
                value = this.getImmediateNode();
                this.valuePointer = NodePointer.newChildNodePointer(this, null, value);
            } else {
                return new NullPointer(this, this.getName()){

                    public Object getImmediateNode() {
                        throw new JXPathException("Undefined variable: " + VariablePointer.this.name);
                    }
                };
            }
        }
        return this.valuePointer;
    }

    public int getLength() {
        if (this.actual) {
            Object value = this.getBaseValue();
            if (value == null) {
                return 1;
            }
            return ValueUtils.getLength(value);
        }
        return 0;
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.actual) {
            this.setValue(value);
            return this;
        }
        NodePointer ptr = this.createPath(context);
        ptr.setValue(value);
        return ptr;
    }

    public NodePointer createPath(JXPathContext context) {
        if (!this.actual) {
            AbstractFactory factory = this.getAbstractFactory(context);
            if (!factory.declareVariable(context, this.name.toString())) {
                throw new JXPathException("Factory cannot define variable '" + this.name + "' for path: " + this.asPath());
            }
            this.findVariables(context);
        }
        return this;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        Object collection = this.createCollection(context, index);
        if (!this.isActual() || index != 0 && index != Integer.MIN_VALUE) {
            AbstractFactory factory = this.getAbstractFactory(context);
            boolean success = factory.createObject(context, this, collection, this.getName().toString(), index);
            if (!success) {
                throw new JXPathException("Factory could not create object path: " + this.asPath());
            }
            NodePointer cln = (NodePointer)this.clone();
            cln.setIndex(index);
            return cln;
        }
        return this;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        Object collection = this.createCollection(context, index);
        ValueUtils.setValue(collection, index, value);
        NodePointer cl = (NodePointer)this.clone();
        cl.setIndex(index);
        return cl;
    }

    private Object createCollection(JXPathContext context, int index) {
        this.createPath(context);
        Object collection = this.getBaseValue();
        if (collection == null) {
            throw new JXPathException("Factory did not assign a collection to variable '" + this.name + "' for path: " + this.asPath());
        }
        if (index == Integer.MIN_VALUE) {
            index = 0;
        } else if (index < 0) {
            throw new JXPathException("Index is less than 1: " + this.asPath());
        }
        if (index >= this.getLength()) {
            collection = ValueUtils.expandCollection(collection, index + 1);
            this.variables.declareVariable(this.name.toString(), collection);
        }
        return collection;
    }

    public void remove() {
        if (this.actual) {
            if (this.index == Integer.MIN_VALUE) {
                this.variables.undeclareVariable(this.name.toString());
            } else {
                if (this.index < 0) {
                    throw new JXPathException("Index is less than 1: " + this.asPath());
                }
                Object collection = this.getBaseValue();
                if (collection != null && this.index < this.getLength()) {
                    collection = ValueUtils.remove(collection, this.index);
                    this.variables.declareVariable(this.name.toString(), collection);
                }
            }
        }
    }

    protected void findVariables(JXPathContext context) {
        this.valuePointer = null;
        JXPathContext varCtx = context;
        while (varCtx != null) {
            this.variables = varCtx.getVariables();
            if (this.variables.isDeclaredVariable(this.name.toString())) {
                this.actual = true;
                break;
            }
            varCtx = varCtx.getParentContext();
            this.variables = null;
        }
    }

    public int hashCode() {
        return (this.actual ? System.identityHashCode(this.variables) : 0) + this.name.hashCode() + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VariablePointer)) {
            return false;
        }
        VariablePointer other = (VariablePointer)object;
        return this.variables == other.variables && this.name.equals(other.name) && this.index == other.index;
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('$');
        buffer.append(this.name);
        if (!this.actual) {
            if (this.index != Integer.MIN_VALUE) {
                buffer.append('[').append(this.index + 1).append(']');
            }
        } else if (this.index != Integer.MIN_VALUE && (this.getNode() == null || this.isCollection())) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return this.getValuePointer().childIterator(test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return this.getValuePointer().attributeIterator(name);
    }

    public NodeIterator namespaceIterator() {
        return this.getValuePointer().namespaceIterator();
    }

    public NodePointer namespacePointer(String name) {
        return this.getValuePointer().namespacePointer(name);
    }

    public boolean testNode(NodeTest nodeTest) {
        return this.getValuePointer().testNode(nodeTest);
    }

    private AbstractFactory getAbstractFactory(JXPathContext context) {
        AbstractFactory factory = context.getFactory();
        if (factory == null) {
            throw new JXPathException("Factory is not set on the JXPathContext - cannot create path: " + this.asPath());
        }
        return factory;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return pointer1.getIndex() - pointer2.getIndex();
    }
}

