/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.jxpath.JXPathBeanInfo;

public class JXPathBasicBeanInfo
implements JXPathBeanInfo {
    private boolean atomic = false;
    private Class clazz;
    private PropertyDescriptor[] propertyDescriptors;
    private String[] propertyNames;
    private Class dynamicPropertyHandlerClass;
    static /* synthetic */ Class class$java$lang$Object;

    public JXPathBasicBeanInfo(Class clazz) {
        this.clazz = clazz;
    }

    public JXPathBasicBeanInfo(Class clazz, boolean atomic) {
        this.clazz = clazz;
        this.atomic = atomic;
    }

    public JXPathBasicBeanInfo(Class clazz, Class dynamicPropertyHandlerClass) {
        this.clazz = clazz;
        this.atomic = false;
        this.dynamicPropertyHandlerClass = dynamicPropertyHandlerClass;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public boolean isDynamic() {
        return this.dynamicPropertyHandlerClass != null;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            try {
                BeanInfo bi = null;
                bi = this.clazz.isInterface() ? Introspector.getBeanInfo(this.clazz) : Introspector.getBeanInfo(this.clazz, class$java$lang$Object == null ? (class$java$lang$Object = JXPathBasicBeanInfo.class$("java.lang.Object")) : class$java$lang$Object);
                PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                this.propertyDescriptors = new PropertyDescriptor[pds.length];
                System.arraycopy(pds, 0, this.propertyDescriptors, 0, pds.length);
                Arrays.sort(this.propertyDescriptors, new Comparator(){

                    public int compare(Object left, Object right) {
                        return ((PropertyDescriptor)left).getName().compareTo(((PropertyDescriptor)right).getName());
                    }
                });
            }
            catch (IntrospectionException ex) {
                ex.printStackTrace();
            }
        }
        return this.propertyDescriptors;
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        int i;
        if (this.propertyNames == null) {
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            this.propertyNames = new String[pds.length];
            i = 0;
            while (i < pds.length) {
                this.propertyNames[i] = pds[i].getName();
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < this.propertyNames.length) {
            if (this.propertyNames[i2] == propertyName) {
                return this.propertyDescriptors[i2];
            }
            ++i2;
        }
        i = 0;
        while (i < this.propertyNames.length) {
            if (this.propertyNames[i].equals(propertyName)) {
                return this.propertyDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    public Class getDynamicPropertyHandlerClass() {
        return this.dynamicPropertyHandlerClass;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BeanInfo [class = ");
        buffer.append(this.clazz.getName());
        buffer.append(", properties = ");
        PropertyDescriptor[] jpds = this.getPropertyDescriptors();
        int i = 0;
        while (i < jpds.length) {
            buffer.append("\n    ");
            buffer.append(jpds[i].getPropertyType());
            buffer.append(": ");
            buffer.append(jpds[i].getName());
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

