/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;
import org.apache.batik.apps.svgbrowser.Resources;
import org.apache.batik.apps.svgbrowser.SquiggleInputHandler;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.svg.SVGDocument;

public class XMLInputHandler
implements SquiggleInputHandler {
    public static final String[] XVG_MIME_TYPES = new String[]{"image/xml+xsl+svg"};
    public static final String[] XVG_FILE_EXTENSIONS = new String[]{".xml", ".xsl"};
    public static final String ERROR_NO_XML_STYLESHEET_PROCESSING_INSTRUCTION = "XMLInputHandler.error.no.xml.stylesheet.processing.instruction";
    public static final String ERROR_TRANSFORM_OUTPUT_NOT_SVG = "XMLInputHandler.error.transform.output.not.svg";
    public static final String ERROR_TRANSFORM_PRODUCED_NO_CONTENT = "XMLInputHandler.error.transform.produced.no.content";
    public static final String ERROR_TRANSFORM_OUTPUT_WRONG_NS = "XMLInputHandler.error.transform.output.wrong.ns";
    public static final String ERROR_RESULT_GENERATED_EXCEPTION = "XMLInputHandler.error.result.generated.exception";
    public static final String XSL_PROCESSING_INSTRUCTION_TYPE = "text/xsl";
    public static final String PSEUDO_ATTRIBUTE_TYPE = "type";
    public static final String PSEUDO_ATTRIBUTE_HREF = "href";

    public String[] getHandledMimeTypes() {
        return XVG_MIME_TYPES;
    }

    public String[] getHandledExtensions() {
        return XVG_FILE_EXTENSIONS;
    }

    public String getDescription() {
        return "";
    }

    public boolean accept(File file) {
        return file.isFile() && this.accept(file.getPath());
    }

    public boolean accept(ParsedURL parsedURL) {
        if (parsedURL == null) {
            return false;
        }
        String string = parsedURL.getPath();
        return this.accept(string);
    }

    public boolean accept(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < XVG_FILE_EXTENSIONS.length; ++i) {
            if (!string.endsWith(XVG_FILE_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }

    public void handle(ParsedURL parsedURL, JSVGViewerFrame jSVGViewerFrame) throws Exception {
        String string = parsedURL.toString();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(string);
        String string2 = this.extractXSLProcessingInstruction(document);
        if (string2 == null) {
            string2 = string;
        }
        ParsedURL parsedURL2 = new ParsedURL(string, string2);
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(parsedURL2.toString()));
        transformer.setURIResolver(new DocumentURIResolver(parsedURL2.toString()));
        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        String string3 = "http://www.w3.org/2000/svg";
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(new DOMSource(document), streamResult);
        stringWriter.flush();
        stringWriter.close();
        String string4 = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(string4);
        SVGDocument sVGDocument = null;
        try {
            sVGDocument = sAXSVGDocumentFactory.createSVGDocument(string, new StringReader(stringWriter.toString()));
        }
        catch (Exception exception) {
            System.err.println("======================================");
            System.err.println(stringWriter.toString());
            System.err.println("======================================");
            throw new IllegalArgumentException(Resources.getString(ERROR_RESULT_GENERATED_EXCEPTION));
        }
        jSVGViewerFrame.getJSVGCanvas().setSVGDocument(sVGDocument);
        jSVGViewerFrame.setSVGDocument(sVGDocument, string, sVGDocument.getTitle());
    }

    protected void checkAndPatch(Document document) {
        Element element = document.getDocumentElement();
        Node node = element.getFirstChild();
        String string = "http://www.w3.org/2000/svg";
        if (node == null) {
            throw new IllegalArgumentException(Resources.getString(ERROR_TRANSFORM_PRODUCED_NO_CONTENT));
        }
        if (node.getNodeType() != 1 || !"svg".equals(node.getLocalName())) {
            throw new IllegalArgumentException(Resources.getString(ERROR_TRANSFORM_OUTPUT_NOT_SVG));
        }
        if (!string.equals(node.getNamespaceURI())) {
            throw new IllegalArgumentException(Resources.getString(ERROR_TRANSFORM_OUTPUT_WRONG_NS));
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            element.appendChild(node2);
            node2 = node.getFirstChild();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            element.setAttributeNode((Attr)namedNodeMap.item(i));
        }
        element.removeChild(node);
    }

    protected String extractXSLProcessingInstruction(Document document) {
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 7) continue;
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            HashTable hashTable = new HashTable();
            DOMUtilities.parseStyleSheetPIData(processingInstruction.getData(), hashTable);
            Object object = hashTable.get(PSEUDO_ATTRIBUTE_TYPE);
            if (!XSL_PROCESSING_INSTRUCTION_TYPE.equals(object)) continue;
            Object object2 = hashTable.get(PSEUDO_ATTRIBUTE_HREF);
            if (object2 != null) {
                return object2.toString();
            }
            return null;
        }
        return null;
    }

    public class DocumentURIResolver
    implements URIResolver {
        String documentURI;

        public DocumentURIResolver(String string) {
            this.documentURI = string;
        }

        public Source resolve(String string, String string2) {
            if (string2 == null || "".equals(string2)) {
                string2 = this.documentURI;
            }
            ParsedURL parsedURL = new ParsedURL(string2, string);
            return new StreamSource(parsedURL.toString());
        }
    }
}

