/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import org.apache.avalon.excalibur.component.AbstractDualLogEnabled;
import org.apache.avalon.excalibur.component.ComponentProxyGenerator;
import org.apache.avalon.excalibur.component.LogkitLoggerManager;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.service.WrapperServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.collections.StaticBucketMap;
import org.apache.excalibur.instrument.InstrumentManageable;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.Instrumentable;

public class DefaultComponentFactory
extends AbstractDualLogEnabled
implements ObjectFactory,
Disposable,
ThreadSafe {
    private Class m_componentClass;
    private Context m_context;
    private ComponentManager m_componentManager;
    private WrapperServiceManager m_serviceManager;
    private Configuration m_configuration;
    private RoleManager m_roles;
    private LogkitLoggerManager m_loggerManager;
    private final StaticBucketMap m_componentProxies = new StaticBucketMap();
    private InstrumentManager m_instrumentManager;
    private String m_instrumentableName;
    private ComponentProxyGenerator m_proxyGenerator;
    private String m_role;

    public DefaultComponentFactory(String role, Class componentClass, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roles, LogkitLoggerManager loggerManager) {
        this(role, componentClass, configuration, componentManager, context, roles, loggerManager, null, "N/A");
    }

    public DefaultComponentFactory(String role, Class componentClass, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roles, LogkitLoggerManager loggerManager, InstrumentManager instrumentManager, String instrumentableName) {
        this.m_role = role;
        this.m_componentClass = componentClass;
        this.m_configuration = configuration;
        this.m_componentManager = componentManager;
        this.m_context = context;
        this.m_roles = roles;
        this.m_loggerManager = loggerManager;
        this.m_instrumentManager = instrumentManager;
        this.m_instrumentableName = instrumentableName;
        this.m_proxyGenerator = new ComponentProxyGenerator(this.m_componentClass.getClassLoader());
        this.m_serviceManager = new WrapperServiceManager(this.m_componentManager);
    }

    public Object newInstance() throws Exception {
        Component returnableComponent;
        String logger;
        Object component = this.m_componentClass.newInstance();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ComponentFactory creating new instance of " + this.m_componentClass.getName() + ".");
        }
        if (component instanceof LogEnabled) {
            if (null == this.m_loggerManager || null == this.m_configuration) {
                ContainerUtil.enableLogging(component, (Logger)this.getLogger());
            } else {
                logger = this.m_configuration.getAttribute("logger", null);
                if (null == logger) {
                    this.getLogger().debug("no logger attribute available, using standard logger");
                    ContainerUtil.enableLogging(component, (Logger)this.getLogger());
                } else {
                    this.getLogger().debug("logger attribute is " + logger);
                    ContainerUtil.enableLogging(component, (Logger)this.m_loggerManager.getLoggerForCategory(logger));
                }
            }
        } else if (component instanceof Loggable) {
            if (null == this.m_loggerManager || null == this.m_configuration) {
                ((Loggable)component).setLogger(this.getLogkitLogger());
            } else {
                logger = this.m_configuration.getAttribute("logger", null);
                if (null == logger) {
                    this.getLogger().debug("no logger attribute available, using standard logger");
                    ((Loggable)component).setLogger(this.getLogkitLogger());
                } else {
                    this.getLogger().debug("logger attribute is " + logger);
                    ((Loggable)component).setLogger(this.m_loggerManager.getLogKitLoggerForCategory(logger));
                }
            }
        }
        if (component instanceof Instrumentable) {
            Instrumentable instrumentable = (Instrumentable)component;
            instrumentable.setInstrumentableName(this.m_instrumentableName);
        }
        if (component instanceof InstrumentManageable && this.m_instrumentManager != null) {
            ((InstrumentManageable)component).setInstrumentManager(this.m_instrumentManager);
        }
        if (component instanceof Contextualizable) {
            ContainerUtil.contextualize(component, (Context)this.m_context);
        }
        if (component instanceof Composable) {
            ContainerUtil.compose(component, (ComponentManager)this.m_componentManager);
        }
        if (component instanceof Serviceable) {
            ContainerUtil.service(component, (ServiceManager)this.m_serviceManager);
        }
        if (component instanceof RoleManageable) {
            ((RoleManageable)component).setRoleManager(this.m_roles);
        }
        if (component instanceof LogKitManageable) {
            ((LogKitManageable)component).setLogKitManager(this.m_loggerManager.getLogKitManager());
        }
        ContainerUtil.configure(component, (Configuration)this.m_configuration);
        if (component instanceof Parameterizable) {
            Parameters parameters = Parameters.fromConfiguration((Configuration)this.m_configuration);
            ContainerUtil.parameterize(component, (Parameters)parameters);
        }
        ContainerUtil.initialize(component);
        if (component instanceof Instrumentable && this.m_instrumentManager != null) {
            this.m_instrumentManager.registerInstrumentable((Instrumentable)component, this.m_instrumentableName);
        }
        ContainerUtil.start(component);
        if (!(component instanceof Component)) {
            returnableComponent = this.m_proxyGenerator.getCompatibleProxy(component);
            this.m_componentProxies.put((Object)returnableComponent, component);
        } else {
            returnableComponent = (Component)component;
        }
        return returnableComponent;
    }

    public Class getCreatedClass() {
        return this.m_componentClass;
    }

    public void decommission(Object component) throws Exception {
        Object decommissionComponent;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ComponentFactory decommissioning instance of " + this.m_componentClass.getName() + ".");
        }
        if (null == (decommissionComponent = this.m_componentProxies.remove(component))) {
            decommissionComponent = component;
        }
        ContainerUtil.stop((Object)decommissionComponent);
        ContainerUtil.dispose((Object)decommissionComponent);
    }

    public void dispose() {
    }
}

