/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.sax;

import java.util.ArrayList;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public final class XMLByteStreamInterpreter
extends AbstractXMLProducer
implements XMLDeserializer,
Recyclable {
    private static final int START_DOCUMENT = 0;
    private static final int END_DOCUMENT = 1;
    private static final int START_PREFIX_MAPPING = 2;
    private static final int END_PREFIX_MAPPING = 3;
    private static final int START_ELEMENT = 4;
    private static final int END_ELEMENT = 5;
    private static final int CHARACTERS = 6;
    private static final int IGNORABLE_WHITESPACE = 7;
    private static final int PROCESSING_INSTRUCTION = 8;
    private static final int COMMENT = 9;
    private static final int LOCATOR = 10;
    private static final int START_DTD = 11;
    private static final int END_DTD = 12;
    private static final int START_CDATA = 13;
    private static final int END_CDATA = 14;
    private static final int SKIPPED_ENTITY = 15;
    private static final int START_ENTITY = 16;
    private static final int END_ENTITY = 17;
    private ArrayList list = new ArrayList();
    private byte[] input;
    private int currentPos;

    public void recycle() {
        super.recycle();
        this.list.clear();
        this.input = null;
    }

    public void deserialize(Object saxFragment) throws SAXException {
        if (!(saxFragment instanceof byte[])) {
            throw new SAXException("XMLDeserializer needs byte array for deserialization.");
        }
        this.list.clear();
        this.input = (byte[])saxFragment;
        this.currentPos = 0;
        this.checkProlog();
        this.parse();
    }

    private void parse() throws SAXException {
        block20: while (this.currentPos < this.input.length) {
            switch (this.readEvent()) {
                case 0: {
                    this.contentHandler.startDocument();
                    continue block20;
                }
                case 1: {
                    this.contentHandler.endDocument();
                    continue block20;
                }
                case 2: {
                    this.contentHandler.startPrefixMapping(this.readString(), this.readString());
                    continue block20;
                }
                case 3: {
                    this.contentHandler.endPrefixMapping(this.readString());
                    continue block20;
                }
                case 4: {
                    int attributes = this.readAttributes();
                    AttributesImpl atts = new AttributesImpl();
                    for (int i = 0; i < attributes; ++i) {
                        atts.addAttribute(this.readString(), this.readString(), this.readString(), this.readString(), this.readString());
                    }
                    this.contentHandler.startElement(this.readString(), this.readString(), this.readString(), atts);
                    continue block20;
                }
                case 5: {
                    this.contentHandler.endElement(this.readString(), this.readString(), this.readString());
                    continue block20;
                }
                case 6: {
                    int len;
                    char[] chars = this.readChars();
                    for (len = chars.length; len > 0 && chars[len - 1] == '\u0000'; --len) {
                    }
                    if (len <= 0) continue block20;
                    this.contentHandler.characters(chars, 0, len);
                    continue block20;
                }
                case 7: {
                    int len;
                    char[] spaces = this.readChars();
                    for (len = spaces.length; len > 0 && spaces[len - 1] == '\u0000'; --len) {
                    }
                    if (len <= 0) continue block20;
                    this.contentHandler.characters(spaces, 0, len);
                    continue block20;
                }
                case 8: {
                    this.contentHandler.processingInstruction(this.readString(), this.readString());
                    continue block20;
                }
                case 9: {
                    int len;
                    char[] chars = this.readChars();
                    if (this.lexicalHandler == null) continue block20;
                    for (len = chars.length; len > 0 && chars[len - 1] == '\u0000'; --len) {
                    }
                    if (len <= 0) continue block20;
                    this.lexicalHandler.comment(chars, 0, len);
                    continue block20;
                }
                case 10: {
                    String publicId = this.readString();
                    String systemId = this.readString();
                    int lineNumber = this.read();
                    int columnNumber = this.read();
                    LocatorImpl locator = new LocatorImpl();
                    locator.setPublicId(publicId);
                    locator.setSystemId(systemId);
                    locator.setLineNumber(lineNumber);
                    locator.setColumnNumber(columnNumber);
                    this.contentHandler.setDocumentLocator(locator);
                    continue block20;
                }
                case 11: {
                    this.lexicalHandler.startDTD(this.readString(), this.readString(), this.readString());
                    continue block20;
                }
                case 12: {
                    this.lexicalHandler.endDTD();
                    continue block20;
                }
                case 13: {
                    this.lexicalHandler.startCDATA();
                    continue block20;
                }
                case 14: {
                    this.lexicalHandler.endCDATA();
                    continue block20;
                }
                case 15: {
                    this.contentHandler.skippedEntity(this.readString());
                    continue block20;
                }
                case 16: {
                    this.lexicalHandler.startEntity(this.readString());
                    continue block20;
                }
                case 17: {
                    this.lexicalHandler.endEntity(this.readString());
                    continue block20;
                }
            }
            throw new SAXException("parsing error: event not supported.");
        }
    }

    private void checkProlog() throws SAXException {
        int valid = 0;
        if (this.read() == 67) {
            ++valid;
        }
        if (this.read() == 88) {
            ++valid;
        }
        if (this.read() == 77) {
            ++valid;
        }
        if (this.read() == 76) {
            ++valid;
        }
        if (this.read() == 1) {
            ++valid;
        }
        if (this.read() == 0) {
            ++valid;
        }
        if (valid != 6) {
            throw new SAXException("Unrecognized file format.");
        }
    }

    protected int readEvent() throws SAXException {
        return this.read();
    }

    private int readAttributes() throws SAXException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }

    private String readString() throws SAXException {
        int length = this.readLength();
        int index = length & Short.MAX_VALUE;
        if (length >= 32768) {
            return (String)this.list.get(index);
        }
        char[] chars = this.readChars(index);
        int len = chars.length;
        if (len > 0) {
            while (chars[len - 1] == '\u0000') {
                --len;
            }
        }
        String str = len == 0 ? "" : new String(chars, 0, len);
        this.list.add(str);
        return str;
    }

    private char[] readChars() throws SAXException {
        return this.readChars(this.readLength());
    }

    private int read() throws SAXException {
        if (this.currentPos >= this.input.length) {
            throw new SAXException("Reached end of input.");
        }
        return this.input[this.currentPos++] & 0xFF;
    }

    private char[] readChars(int len) throws SAXException {
        char[] str = new char[len];
        byte[] bytearr = new byte[len];
        int count = 0;
        int i = 0;
        this.readBytes(bytearr);
        block5: while (count < len) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[i++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte char2 = bytearr[(count += 2) - 1];
                    str[i++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    byte char2 = bytearr[(count += 3) - 2];
                    byte char3 = bytearr[count - 1];
                    str[i++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new SAXException("UTFDataFormatException");
        }
        return str;
    }

    private void readBytes(byte[] b) throws SAXException {
        if (this.currentPos + b.length > this.input.length) {
            throw new SAXException("End of input reached.");
        }
        System.arraycopy(this.input, this.currentPos, b, 0, b.length);
        this.currentPos += b.length;
    }

    private int readLength() throws SAXException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }
}

