/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.caching.ComponentCacheKey;

public final class PipelineCacheKey
implements Serializable {
    private List keys;
    private int hashCode = 0;
    private String toString;

    public PipelineCacheKey() {
        this.keys = new ArrayList(6);
    }

    public PipelineCacheKey(int size) {
        this.keys = new ArrayList(size);
    }

    public void addKey(ComponentCacheKey key) {
        this.keys.add(key);
        this.hashCode = 0;
        this.toString = null;
    }

    public void removeLastKey() {
        this.keys.remove(this.keys.size() - 1);
        this.hashCode = 0;
        this.toString = null;
    }

    public void removeUntilCachePoint() {
        this.hashCode = 0;
        this.toString = null;
        for (int keyCount = this.keys.size(); keyCount > 0; --keyCount) {
            if (((ComponentCacheKey)this.keys.get(keyCount - 1)).isCachePoint()) {
                this.keys.remove(keyCount - 1);
                return;
            }
            this.keys.remove(keyCount - 1);
        }
    }

    public int size() {
        return this.keys.size();
    }

    public boolean equals(Object object) {
        if (object instanceof PipelineCacheKey) {
            PipelineCacheKey pck = (PipelineCacheKey)object;
            int len = this.keys.size();
            if (pck.keys.size() == len) {
                boolean cont = true;
                for (int i = 0; i < len && cont; ++i) {
                    cont = this.keys.get(i).equals(pck.keys.get(i));
                }
                return cont;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int len = this.keys.size();
            for (int i = 0; i < len; ++i) {
                this.hashCode += this.keys.get(i).hashCode();
            }
            if (len % 2 == 0) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public PipelineCacheKey copy() {
        int len = this.keys.size();
        PipelineCacheKey pck = new PipelineCacheKey(len);
        for (int i = 0; i < len; ++i) {
            pck.keys.add(this.keys.get(i));
        }
        return pck;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("PK");
            int len = this.keys.size();
            for (int i = 0; i < len; ++i) {
                buffer.append('_').append(this.keys.get(i).toString());
            }
            this.toString = buffer.toString();
        }
        return this.toString;
    }
}

