/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import jstyle.JSBeautifier;
import jstyle.JSFormatter;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.language.programming.CodeFormatter;

public class JstyleFormatter
extends AbstractLogEnabled
implements CodeFormatter {
    protected static final int PREFERRED_LINE_LENGTH = 72;
    protected static final int LINE_LENGTH_DEVIATION = 8;
    protected static final int SPACE_INDENTATION = 2;

    public String format(String code, String encoding) {
        try {
            JSFormatter formatter = new JSFormatter();
            formatter.setPreferredLineLength(72);
            formatter.setLineLengthDeviation(8);
            ByteArrayOutputStream out = new ByteArrayOutputStream(code.length());
            formatter.format(new BufferedReader(new StringReader(code)), new PrintWriter(out, true));
            JSBeautifier beautifier = new JSBeautifier();
            code = this.getString(out, encoding);
            out = new ByteArrayOutputStream(code.length());
            beautifier.setSpaceIndentation(2);
            beautifier.beautifyReader(new BufferedReader(new StringReader(code)), new PrintWriter(out, true));
            return this.getString(out, encoding);
        }
        catch (Exception e) {
            this.getLogger().debug("JstyleFormatter.format()", (Throwable)e);
            return code;
        }
    }

    protected String getString(ByteArrayOutputStream out, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return out.toString();
        }
        return out.toString(encoding);
    }
}

