/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import java.util.Vector;
import javax.mail.URLName;
import net.jatec.ironmailer.model.MailFolderHeader;
import org.apache.log4j.Logger;

public class MailboxOverview {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$MailboxOverview == null ? (class$net$jatec$ironmailer$model$MailboxOverview = MailboxOverview.class$((String)"net.jatec.ironmailer.model.MailboxOverview")) : class$net$jatec$ironmailer$model$MailboxOverview));
    private URLName url;
    private String user;
    private Vector mailFolderHeaders;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$MailboxOverview;

    public MailboxOverview(URLName uRLName, Vector vector) throws IllegalArgumentException {
        if (uRLName == null) {
            throw new IllegalArgumentException("mailboxUrl may not be null");
        }
        this.url = uRLName;
        this.user = this.url.getUsername();
        this.mailFolderHeaders = vector;
    }

    public URLName getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public Vector getMailFolderHeaders() {
        return this.mailFolderHeaders;
    }

    public MailFolderHeader getMailFolderHeader(int n) {
        return (MailFolderHeader)this.mailFolderHeaders.get(n);
    }

    public int[] getOtherSelectableFolderIndices(int n) {
        this.log.debug((Object)("getOtherFolderIndices() called with nr " + n));
        if (n < 0 || n > this.mailFolderHeaders.size() - 1) {
            this.log.warn((Object)("getOtherFolderIndices() called with nr " + n + " but this number is not in range, returning empty list"));
            return new int[0];
        }
        Vector<Integer> vector = new Vector<Integer>(this.mailFolderHeaders.size() - 1);
        for (int i = 0; i < this.mailFolderHeaders.size(); ++i) {
            MailFolderHeader mailFolderHeader;
            if (i == n || !(mailFolderHeader = this.getMailFolderHeader(i)).isSelectable()) continue;
            vector.add(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public int[] getOtherFolderIndices(int n) {
        this.log.debug((Object)("getOtherFolderIndices() called with nr " + n));
        if (n < 0 || n > this.mailFolderHeaders.size() - 1) {
            this.log.warn((Object)("getOtherFolderIndices() called with nr " + n + " but this number is not in range, returning empty list"));
            return new int[0];
        }
        int[] nArray = new int[this.mailFolderHeaders.size() - 1];
        int n2 = 0;
        for (int i = 0; i < this.mailFolderHeaders.size(); ++i) {
            if (i == n) {
                ++n2;
                continue;
            }
            nArray[i - n2] = i;
        }
        return nArray;
    }

    public int getFolderIndex(String string) {
        int n = -1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getFolderIndex() called for " + string));
        }
        if (string != null && !string.equals("")) {
            for (int i = 0; i < this.mailFolderHeaders.size(); ++i) {
                MailFolderHeader mailFolderHeader = (MailFolderHeader)this.mailFolderHeaders.get(i);
                if (!string.equals(mailFolderHeader.getName())) continue;
                n = i;
                break;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getFolderIndex() returning " + n));
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Mailbox for " + this.url.getUsername() + " at " + this.url.getHost() + " has " + this.mailFolderHeaders.size() + " folders.\n");
        for (int i = 0; i < this.mailFolderHeaders.size(); ++i) {
            MailFolderHeader mailFolderHeader = (MailFolderHeader)this.mailFolderHeaders.get(i);
            stringBuffer.append("\t" + mailFolderHeader.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

