/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import java.util.Vector;
import javax.mail.URLName;
import net.jatec.ironmailer.model.MailFolderHeader;
import org.apache.log4j.Logger;

public class MailboxOverview {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$MailboxOverview == null ? (class$net$jatec$ironmailer$model$MailboxOverview = MailboxOverview.class$((String)"net.jatec.ironmailer.model.MailboxOverview")) : class$net$jatec$ironmailer$model$MailboxOverview));
    private URLName url;
    private String user;
    private Vector mailFolderHeaders;
    private Vector flatMailFolderHeaders;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$MailboxOverview;

    public MailboxOverview(URLName uRLName, Vector vector) throws IllegalArgumentException {
        int n;
        if (uRLName == null) {
            throw new IllegalArgumentException("mailboxUrl may not be null");
        }
        this.url = uRLName;
        this.user = this.url.getUsername();
        this.mailFolderHeaders = vector;
        this.flatMailFolderHeaders = new Vector();
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                MailFolderHeader mailFolderHeader = (MailFolderHeader)vector.get(n);
                this.flatMailFolderHeaders.add(mailFolderHeader);
                MailFolderHeader[] mailFolderHeaderArray = mailFolderHeader.getSubfolders();
                if (mailFolderHeaderArray == null || mailFolderHeaderArray.length <= 0) continue;
                this.addToFlat(mailFolderHeaderArray);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("MailboxOverview() constructed with mailboxUrl " + uRLName));
            if (vector != null) {
                for (n = 0; n < vector.size(); ++n) {
                    this.log.debug((Object)("MailboxOverview() mailFolderHeader nb " + (n + 1) + " contains: " + vector.get(n).toString()));
                }
            }
        }
    }

    private void addToFlat(MailFolderHeader[] mailFolderHeaderArray) {
        for (int i = 0; i < mailFolderHeaderArray.length; ++i) {
            MailFolderHeader mailFolderHeader = mailFolderHeaderArray[i];
            this.flatMailFolderHeaders.add(mailFolderHeader);
            MailFolderHeader[] mailFolderHeaderArray2 = mailFolderHeader.getSubfolders();
            if (mailFolderHeaderArray2 != null && mailFolderHeaderArray2.length > 0) {
                this.addToFlat(mailFolderHeader.getSubfolders());
                continue;
            }
            if (i != mailFolderHeaderArray.length - 1) continue;
            mailFolderHeaderArray[i].setLastLeaf(true);
        }
        mailFolderHeaderArray[mailFolderHeaderArray.length - 1].setLastLeaf(true);
    }

    public URLName getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public Vector getMailFolderHeaders() {
        return this.flatMailFolderHeaders;
    }

    public Vector getFolderTree() {
        return this.mailFolderHeaders;
    }

    public MailFolderHeader getMailFolderHeader(int n) {
        return (MailFolderHeader)this.flatMailFolderHeaders.get(n);
    }

    public boolean isNextFolderDeeper(int n) {
        if (n < 0 || n >= this.flatMailFolderHeaders.size()) {
            throw new IllegalArgumentException("illegal folder number " + n);
        }
        if (n == this.flatMailFolderHeaders.size() - 1) {
            return false;
        }
        return ((MailFolderHeader)this.flatMailFolderHeaders.get(n)).getLevel() < ((MailFolderHeader)this.flatMailFolderHeaders.get(n + 1)).getLevel();
    }

    public int[] getOtherSelectableFolderIndices(int n) {
        this.log.debug((Object)("getOtherFolderIndices() called with nr " + n));
        if (n < 0 || n > this.flatMailFolderHeaders.size() - 1) {
            this.log.warn((Object)("getOtherFolderIndices() called with nr " + n + " but this number is not in range, returning empty list"));
            return new int[0];
        }
        Vector<Integer> vector = new Vector<Integer>(this.flatMailFolderHeaders.size() - 1);
        for (int i = 0; i < this.flatMailFolderHeaders.size(); ++i) {
            MailFolderHeader mailFolderHeader;
            if (i == n || !(mailFolderHeader = this.getMailFolderHeader(i)).isSelectable()) continue;
            vector.add(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public int[] getOtherFolderIndices(int n) {
        this.log.debug((Object)("getOtherFolderIndices() called with nr " + n));
        if (n < 0 || n > this.flatMailFolderHeaders.size() - 1) {
            this.log.warn((Object)("getOtherFolderIndices() called with nr " + n + " but this number is not in range, returning empty list"));
            return new int[0];
        }
        int[] nArray = new int[this.flatMailFolderHeaders.size() - 1];
        int n2 = 0;
        for (int i = 0; i < this.flatMailFolderHeaders.size(); ++i) {
            if (i == n) {
                ++n2;
                continue;
            }
            nArray[i - n2] = i;
        }
        return nArray;
    }

    public int getFolderIndex(String string) {
        int n = -1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getFolderIndex() called for " + string));
        }
        if (string != null && !string.equals("")) {
            for (int i = 0; i < this.flatMailFolderHeaders.size(); ++i) {
                MailFolderHeader mailFolderHeader = (MailFolderHeader)this.flatMailFolderHeaders.get(i);
                if (!string.equals(mailFolderHeader.getName())) continue;
                n = i;
                break;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getFolderIndex() returning " + n));
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Mailbox for " + this.url.getUsername() + " at " + this.url.getHost() + " has " + this.flatMailFolderHeaders.size() + " folders.\n");
        for (int i = 0; i < this.flatMailFolderHeaders.size(); ++i) {
            MailFolderHeader mailFolderHeader = (MailFolderHeader)this.flatMailFolderHeaders.get(i);
            stringBuffer.append("\t" + mailFolderHeader.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

