/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.ServerConnection;
import net.jatec.ironmailer.framework.MailTools;
import net.jatec.ironmailer.model.ApplicationConfiguration;
import net.jatec.ironmailer.model.AttachmentHolder;
import net.jatec.ironmailer.model.ComposeInfo;
import net.jatec.ironmailer.model.ComposeReference;
import net.jatec.ironmailer.model.SendInfo;
import org.apache.log4j.Logger;

public class MailSender {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$MailSender == null ? (class$net$jatec$ironmailer$controller$MailSender = MailSender.class$((String)"net.jatec.ironmailer.controller.MailSender")) : class$net$jatec$ironmailer$controller$MailSender));
    private Session session;
    private Properties sessionProps = new Properties();
    private boolean isDemoUser;
    private InternetAddress defaultFromUser;
    private ApplicationConfiguration applConf;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$MailSender;

    public MailSender(ServerConnection serverConnection, ApplicationConfiguration applicationConfiguration) throws MessagingException {
        this.sessionProps.put("mail.smtp.host", serverConnection.getHost());
        String string = serverConnection.getUser();
        String string2 = applicationConfiguration.getHost();
        String string3 = string + "@" + string2;
        try {
            this.defaultFromUser = new InternetAddress(string3);
        }
        catch (AddressException addressException) {
            throw new MessagingException("invalid from address, could not initialize sender; from address is " + string3 + ", exception is " + addressException.toString());
        }
        this.applConf = applicationConfiguration;
        this.isDemoUser = string.equals(applicationConfiguration.getDemoUser());
        this.log.debug((Object)("MailSender() successful initialization, using default from-address " + string3));
    }

    private Session getSession() {
        if (this.session == null) {
            this.session = Session.getDefaultInstance((Properties)this.sessionProps);
        }
        return this.session;
    }

    public InternetAddress getDefaultFromUser() {
        return this.defaultFromUser;
    }

    public SendInfo send(ComposeInfo composeInfo) throws MessagingException, ControllerException {
        this.log.debug((Object)"send() called");
        if (composeInfo == null) {
            throw new ControllerException("internal error, ComposeInfo parameter is null");
        }
        SendInfo sendInfo = null;
        Session session = this.getSession();
        MimeMessage mimeMessage = new MimeMessage(session);
        try {
            boolean bl;
            AttachmentHolder attachmentHolder;
            InternetAddress internetAddress = composeInfo.getFrom();
            if (internetAddress == null) {
                throw new ControllerException("internal error, from address is null");
            }
            mimeMessage.setFrom((Address)internetAddress);
            String string = composeInfo.getReplyTo();
            if (string != null && !string.equals("")) {
                attachmentHolder = new AttachmentHolder[]{new InternetAddress(string)};
                this.log.debug((Object)("send() set reply to " + attachmentHolder[0].toString()));
                mimeMessage.setReplyTo((Address[])attachmentHolder);
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, composeInfo.getTo());
            if (composeInfo.getCc() != null) {
                mimeMessage.setRecipients(Message.RecipientType.CC, composeInfo.getCc());
            }
            if (composeInfo.getBcc() != null) {
                mimeMessage.setRecipients(Message.RecipientType.BCC, composeInfo.getBcc());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("send() setting subject to " + composeInfo.getSubject()));
            }
            mimeMessage.setSubject(composeInfo.getSubject(), this.applConf.getEncoding());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("send() subject in MimeMessage is now " + mimeMessage.getSubject()));
            }
            attachmentHolder = composeInfo.getAttachmentHolder();
            int n = attachmentHolder.getNbAttachments();
            ComposeReference composeReference = composeInfo.getReference();
            this.log.debug((Object)("send() is ComposeReference null ? " + (composeReference == null)));
            boolean bl2 = composeReference != null && composeReference.isForwardAsAttachment();
            boolean bl3 = bl = n > 0 || bl2;
            if (!bl) {
                mimeMessage.setText(composeInfo.getBody(), this.applConf.getEncoding());
            } else {
                this.log.debug((Object)("send() need to attach " + n + " files"));
                MimeMultipart mimeMultipart = new MimeMultipart();
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText(composeInfo.getBody(), this.applConf.getEncoding());
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                if (bl2) {
                    MimeMessage mimeMessage2 = composeReference.getReference().getMessageHeader().getMessage();
                    this.log.debug((Object)"send() forwarding, got reference");
                    try {
                        MimeBodyPart[] mimeBodyPartArray = MailTools.toMimeBodyParts((MimeMessage)mimeMessage2, (String)this.applConf.getEncoding());
                        for (int i = 0; i < mimeBodyPartArray.length; ++i) {
                            mimeMultipart.addBodyPart((BodyPart)mimeBodyPartArray[i]);
                        }
                    }
                    catch (Exception exception) {
                        throw new ControllerException("could not read message to forward", (Throwable)exception);
                    }
                    this.log.debug((Object)"send() forwarding, added referenced message as body part");
                }
                for (int i = 0; i < n; ++i) {
                    mimeBodyPart = attachmentHolder.getAttachment(i);
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                }
                mimeMessage.setContent((Multipart)mimeMultipart);
            }
            this.log.debug((Object)"send() trying to send...");
            this.checkAuthorized(mimeMessage);
            Transport.send((Message)mimeMessage);
            sendInfo = new SendInfo(mimeMessage, null);
        }
        catch (SendFailedException sendFailedException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"send() handling SendFailedException");
            }
            sendInfo = new SendInfo(mimeMessage, (MessagingException)((Object)sendFailedException));
        }
        catch (AddressException addressException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"send() handling AddressException");
            }
            sendInfo = new SendInfo(mimeMessage, (MessagingException)((Object)addressException));
        }
        this.log.debug((Object)"send() done.");
        return sendInfo;
    }

    private void checkAuthorized(MimeMessage mimeMessage) throws SendFailedException {
        if (this.isDemoUser) {
            this.log.debug((Object)"checkAuthorized() for demo, checking addresses");
            try {
                this.checkDemoAddresses(mimeMessage.getRecipients(Message.RecipientType.TO));
                this.checkDemoAddresses(mimeMessage.getRecipients(Message.RecipientType.CC));
                this.checkDemoAddresses(mimeMessage.getRecipients(Message.RecipientType.BCC));
            }
            catch (SendFailedException sendFailedException) {
                throw sendFailedException;
            }
            catch (MessagingException messagingException) {
                throw new SendFailedException("there was something fishy checking addresses for demo user, aborting", (Exception)((Object)messagingException));
            }
        }
    }

    private void checkDemoAddresses(Address[] addressArray) throws SendFailedException {
        if (addressArray != null) {
            for (int i = 0; i < addressArray.length; ++i) {
                InternetAddress internetAddress = (InternetAddress)addressArray[i];
                if (this.defaultFromUser.getAddress().equals(internetAddress.getAddress())) continue;
                throw new SendFailedException("security check for demo user failed: this user may only send mails to himself, that is to " + this.defaultFromUser.getAddress() + " (you are trying to send to " + internetAddress.getAddress() + ")");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

