<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template match="page/setupuser">
 <content>

   <xsl:variable name="update_action"
       select="'userdata.xsl?act=userdata'"/>
   <xsl:variable name="behavior_link" 
  select="'userbehavior.xsl?act=userbehavior'"/>
	  
   <!-- Header stuff -->
   <table cellpadding="4" cellspacing="2" border="0" width="100%">
      <!-- Header row 1 -->
      <tr>
	<td class="simpletext" height="22">
		<img align="middle" hspace="5" src="images/gnome/configuration-32.png"/>
		<i18n:text>setupuser_headertext1</i18n:text>
	</td>
	<td class="simpletext" align="right">
	 <xsl:choose>
	  <xsl:when test="isUpdateOK">
	       <img align="middle" border="0" src="images/gnome/dialog-info.png" />
	       &#160;<i18n:text>general_update_ok</i18n:text>
	  </xsl:when>
	  <xsl:otherwise>
		<span class="infotext">
	          <xsl:choose>
		    <xsl:when test="userpreferencesstate/isAvailable">
		       <i18n:text>setupuser_available</i18n:text>
		    </xsl:when>
		    <xsl:when test="userpreferencesstate/isEmpty">
		       <i18n:text>setupuser_empty</i18n:text>
		    </xsl:when>
		    <xsl:otherwise>
		       <i18n:text>setupuser_notavailable</i18n:text>
		    </xsl:otherwise>
		  </xsl:choose>
		</span>
	  </xsl:otherwise>
	 </xsl:choose>
	</td>

      </tr>
   </table>

	<form method="post">
	   <xsl:attribute name="action">
	      <xsl:value-of select="$update_action"/>
	   </xsl:attribute>
	   <table cellpadding="4" cellspacing="2" border="0" width="100%">

		<!-- signature stuff -->
		<tr class="field_light_bg" width="13%">
			<td class="simpletext" align="center">
				<i18n:text>setupuser_signatureheader</i18n:text>
			</td>

			<td class="simpletext" width="64%">
				<textarea wrap="physical" class="simpletext" rows="5" cols="80" name="signature">
					<!-- don't use normalize-spaces here !! -->
					<xsl:if test="signature">
						<xsl:value-of select="signature" />
				        </xsl:if>
				</textarea>
			</td>
			<td class="simpletext" align="left" width="23%">
			   <i18n:text>setupuser_signaturehelp</i18n:text>	
			</td>
		</tr>
	   </table>
	
	   <br />
	   <table cellpadding="4" cellspacing="2" border="0" width="100%">

		<!-- fromAddress stuff -->
		<tr class="field_middle_bg">
			<td class="simpletext" align="center">
			   <i18n:text>setupuser_fromAddressheader</i18n:text>
			</td>
			<!-- second column for from address: use a table for
		formatting 
			  -->
			<td class="simpletext">
     			  <table cellpadding="4" cellspacing="2" border="0" width="100%">
			    <tr class="simpletext">
				<td>
			          <i18n:text>setupuser_fromAddressheaderName</i18n:text>
				</td>
				<td>
				  <input class="simpletext" type="text" size="30" name="fromAddressName">
				   <!-- don't use normalize-spaces here !! -->
				   <xsl:if test="fromAddress">
					<xsl:attribute name="value">
						<xsl:value-of select="fromAddress/name" />
					</xsl:attribute>
			           </xsl:if>
				  </input>
				</td>
			    </tr>
			    <tr class="simpletext">
			    	<td>
			    	  <i18n:text>setupuser_fromAddressheaderAddress</i18n:text>
				</td>
				<td>
				  <input class="simpletext" type="text" size="30" name="fromAddressAddress">
					<xsl:attribute name="value">
					   <!-- don't use normalize-spaces here !! -->
					   <xsl:if test="fromAddress">
						<xsl:value-of select="fromAddress/address" />
				           </xsl:if>
					</xsl:attribute>
				  </input>
				</td>
			     </tr>
			   </table>
			   <!-- end formatting table for second column
			        of from address -->
			</td>
			<td class="simpletext" align="left">
			   <i18n:text>setupuser_fromAddresshelp</i18n:text>
			</td>
		<!-- end "from address" row -->
		</tr>

		<!-- reply separator option -->
		<tr class="field_light_bg">
		   <td class="simpletext" align="center">
		       <i18n:text>setupuser_replyseparator_header</i18n:text>
		   </td>
		   <td class="simpletext">
		      <textarea wrap="physical" class="simpletext" rows="2" cols="40" name="replyseparator">
		           <!-- don't use normalize-spaces here !! -->
			   <xsl:if test="replyseparator">
				<xsl:value-of select="replyseparator" />
			   </xsl:if>
		      </textarea>
		   </td>
		   <td class="simpletext" align="left">
		      <i18n:text>setupuser_replyseparator_help</i18n:text>
		   </td>
		</tr>

		<!-- forward separator option -->
		<tr class="field_middle_bg">
		   <td class="simpletext" align="center">
		       <i18n:text>setupuser_forwardseparator_header</i18n:text>
		   </td>
		   <td class="simpletext">
		      <textarea wrap="physical" class="simpletext" rows="2" cols="40" name="forwardseparator">
		           <!-- don't use normalize-spaces here !! -->
			   <xsl:if test="forwardseparator">
				<xsl:value-of select="forwardseparator" />
			   </xsl:if>
		      </textarea>
		   </td>
		   <td class="simpletext" align="left">
			<i18n:text>setupuser_forwardseparator_help</i18n:text>
		   </td>
		</tr>

	   </table>

	   <p class="simpletext" align="center">
		<input name="store" class="simpletext" type="submit" i18n:attr="value">
			<xsl:attribute name="value">general_store_action_text</xsl:attribute>
		</input>
	   </p>

	</form>

	<p class="simpletext">
            <a>
		<xsl:attribute name="href" >
		     <xsl:value-of select="$behavior_link"/>
		</xsl:attribute>
		<img class="image_icon" src="images/gnome/forward_blue.png" />
		<i18n:text>setupuser_nextstep_text</i18n:text>
	    </a>
	</p>


	<!-- <xsl:comment> 
		<xsl:value-of select="setupuser" />
	</xsl:comment> -->

  </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
