<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template match="page/setupfolders">
<content>

<xsl:variable name="deletelink_prefix"
  select="'setupfolders.xsl?act=setupfolders&amp;delete=true&amp;folderNr='"/>
<xsl:variable name="add_action"
  select="'setupfolders.xsl?act=setupfolders&amp;add=true'"/>

   <!-- Header stuff -->
   <table cellpadding="4" cellspacing="2" border="0" width="100%">
      <!-- Header row 1 -->
      <tr>
	<td class="simpletext" height="22">
		<img align="middle" hspace="5" src="images/gnome/foldersetup-32.png"/>
		<i18n:text>setupfolders_headertext1</i18n:text>&#160;<xsl:value-of select="normalize-space(username)" />
	</td>
      </tr>
   </table>

   <!-- Error handling -->
   <xsl:if test="error">
      <hr/>
      <table>
	 <tr>
	    <td rowspan="2">
	       <img align="middle" border="0" src="images/gnome/dialog-error.png" />
            </td>
            <td class="bold_red">
               <i18n:text>setupfolders_error_prefixtext</i18n:text>
	       "<xsl:value-of select="error/folderName"/>"
	       <i18n:text>setupfolders_error_suffixtext</i18n:text>
	    </td>
	 </tr>
	 <tr>
	    <td class="simpletext">
	       <span class="bold_red"><i18n:text>setupfolders_error_content_label</i18n:text>:&#160;</span>
	       <xsl:value-of select="error/content"/>
	    </td>
	 </tr>
      </table>
      <hr/>
      <xsl:comment>Error content: <xsl:value-of select="error/content"/></xsl:comment>
      <xsl:comment>Error stack: <xsl:value-of select="error/stack"/></xsl:comment>
   </xsl:if>

		
   <!-- Folder table -->
   <table cellpadding="3" cellspacing="0" border="0" width="100%">
      <!-- Header row with user name -->
      <tr class="bg_for_invert">
	 <td class="white_text" height="22" colspan="3">
	    <i18n:text>setupfolders_loginheader</i18n:text>:&#160;<xsl:value-of select="normalize-space(username)" />
	 </td>
      </tr>
      <!-- header row with host information -->
      <tr class="field_dark_bg">
         <td class="infotext" colspan="3">
		<span class="bold">
			<i18n:text>setupfolders_hostheader</i18n:text>&#160;<xsl:value-of select="normalize-space(host)" />	
		</span>
	 </td>
      </tr>

      <!-- List of folders -->
      <xsl:for-each select="folder">
	  <tr>
	    <xsl:attribute name="class">
	      <xsl:choose>
	        <xsl:when test="position() mod 2">field_light_bg</xsl:when>
	        <xsl:otherwise>field_middle_bg</xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
	    <td align="left">&#160;</td>
	    <td>
	      <!-- seem to need a table to format correctly icon + text -->
	      <table>
	        <tr>
  	           <td>
                      <xsl:for-each select="level">&#160;&#160;&#160;</xsl:for-each>
	           </td>
                   <td>
		      <xsl:choose>
		        <xsl:when test="isselectable">
		         <img src="images/gnome/folder-open.png"/>
		        </xsl:when>
		        <xsl:otherwise>
		         <img src="images/gnome/directory.png"/>
		        </xsl:otherwise>
		      </xsl:choose>
	           </td>
	           <td class="simpletext">
		      <xsl:value-of select="normalize-space(name)"/>
	           </td>
		</tr>
	      </table>
	    </td>
	    <td class="simpletext">
		<xsl:choose>
		   <xsl:when test="isdeleteable">
			<a>
			   <xsl:attribute name="href"><xsl:value-of
			   select="concat($deletelink_prefix,normalize-space(nr))"/>
                           </xsl:attribute>
			   <img src="images/gnome/flag-deleted.png"
			   border="0"/>&#160;
                           <i18n:text>setupfolders_actiontext1</i18n:text>
                        </a>
		   </xsl:when>
		   <xsl:otherwise>
			<i18n:text>setupfolders_actionnote1</i18n:text>
		   </xsl:otherwise>
		</xsl:choose>
	    </td>
	 </tr>
	</xsl:for-each>

	<!-- Warning about deleting folders -->
	<tr class="simpletext">
           <td colspan="3">
	      <span class="bold_red"><i18n:text>setupfolders_warningheader</i18n:text></span>&#160;<i18n:text>setupfolders_warningcontent</i18n:text>
	   </td>
	</tr>

     </table>
     <hr />

     <!-- "add folder" -->
     <form method="post">
        <xsl:attribute name="action">
	   <xsl:value-of select="$add_action"/>
	</xsl:attribute>
	<table class="field_dark_bg" width="100%">
	   <tr>
		<td class="link_text" align="right" width="15%">
		   <i18n:text>setupfolders_addheader</i18n:text>
		</td>
		<td class="simpletext" align="center" width="40%">
		   <input class="simpletext" size="40" name="name" type="text">
			<xsl:attribute name="value"></xsl:attribute>
		   </input>
		</td>
		<td class="simpletext" align="center" width="10%">
		   <input name="add" class="simpletext" type="submit" i18n:attr="value">
			<xsl:attribute name="value">setupfolders_addaction</xsl:attribute>
		   </input>
		</td>
	        <td class="simpletext" width="35%">
		   <input class="simpletext" name="messagefolder" value="true" type="checkbox">
		      <xsl:attribute name="checked">checked</xsl:attribute>
		   </input>
	           <i18n:text>setupfolders_addoption</i18n:text>
	        </td>

	    </tr>
      </table>
    </form>	
		
    <!-- for testing -->
    <!-- <xsl:copy-of select="setupfolders" /> -->

 </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
