<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template match="page/send">
 <content>

   <xsl:variable name="compose_link" 
      select="'compose.xsl?act=compose&amp;continue=true'"/>
   <xsl:variable name="message_link_prefix" 
      select="'message.xsl?act=message&amp;folderNr='"/>
   <xsl:variable name="folder_link_prefix" 
      select="'folder.xsl?act=folder&amp;folderNr='"/>


	<table cellpadding="4" cellspacing="2" border="0" width="100%">
        	<tbody>
        		<tr>
		                <td class="simpletext" height="22"><img align="middle" border="0" hspace="5" src="images/gnome/composer.png" />
		               		<i18n:text>send_headertext1</i18n:text>
				</td>
			</tr>
			<tr class="bg_for_invert">
		                <td class="white_text" height="22">
		               		<i18n:text>send_datetext</i18n:text>&#160;
					<i18n:date-time src-pattern="short" src-locale="en_US" pattern="full">
						<xsl:value-of select="normalize-space(date)" />
					</i18n:date-time>
		               	</td>
			</tr>
			<tr class="field_dark_bg">
		                <td class="link_text">
		                		<i18n:text>send_headertext2</i18n:text><br/>
		                		<i18n:text>send_subjecttext</i18n:text>&#160;<span class="simpletext"><xsl:value-of select="normalize-space(subject)" /></span><br/>
		                		<i18n:text>send_recipientstext</i18n:text>:&#160;<span class="simpletext"><xsl:value-of select="normalize-space(recipients)" /></span><br/>
				</td>
			</tr>
			<!-- Status row -->
			<tr class="field_middle_bg">
				<td class="link_text">
					<xsl:choose>
						<xsl:when test="not(senderror)">
							<i18n:text>send_statusheader</i18n:text>&#160;<span class="simpletext"><i18n:text>send_statustext1</i18n:text></span>
							<img align="middle" border="0" hspace="5" src="images/gnome/dialog-info.png" />
						</xsl:when>
						<xsl:otherwise>
							<span class="bold_red"><i18n:text>send_statusheader</i18n:text>&#160;<i18n:text>send_statustext2</i18n:text></span>
							<img align="middle" border="0" hspace="5" src="images/gnome/dialog-warning.png" />
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			
			<xsl:apply-templates select="senderror" />
            
            		<!-- action row (with back button) -->
            		<tr>
            			<td class="bg_for_invert">
            				<table cellspacing="0" cellpadding="0" border="0">
            				<tbody><tr>
            					<td><a href="compose?act=compose&amp;continue=true">
            						<img border="0" hspace="5" src="images/gnome/arrow_back.png" /></a></td>
            					<td><a>
						      <xsl:attribute
            		name="href"><xsl:value-of select="$compose_link"/></xsl:attribute>
            						<span class="white_text"><i18n:text>send_footertext1</i18n:text></span></a>
            					</td>
            				</tr></tbody>
            				</table>
            			</td>
            		</tr>

			<!-- if the message was a reply/forward, provide a "back to message" button -->
			<xsl:if test="origin">
			    <xsl:variable name="link_to_message" select="concat($message_link_prefix,normalize-space(origin/folderNr),'&amp;messageNr=',normalize-space(origin/messageNr))" />

			    <tr>
            			<td class="bg_for_invert">
            				<table cellspacing="0" cellpadding="0" border="0">
            				<tbody><tr>					
            					<td>
			                            <a>
						        <xsl:attribute name="href"><xsl:value-of select="$link_to_message"/></xsl:attribute>
            						<img border="0" hspace="5" src="images/gnome/arrow_back.png" />
						    </a>
                                                </td>
            					<td>
						    <a>
						        <xsl:attribute name="href"><xsl:value-of select="$link_to_message"/></xsl:attribute>
            						<span class="white_text"><i18n:text>send_footertext2</i18n:text></span>
						    </a>
            					</td>
            				</tr></tbody>
            				</table>
            			</td>
			    </tr>

			    <!-- provide a link to the message overview
			    (folder contents)
			    -->
			    <xsl:variable name="link_to_folder" select="concat($folder_link_prefix,normalize-space(origin/folderNr))" />
			    <tr>
            			<td class="bg_for_invert">
            				<table cellspacing="0" cellpadding="0" border="0">
            				<tbody><tr>					
            					<td>
			                            <a>
						        <xsl:attribute name="href"><xsl:value-of select="$link_to_folder"/></xsl:attribute>
            						<img border="0" hspace="5" src="images/gnome/arrow_home.png" />
						    </a>
                                                </td>
            					<td>
						    <a>
						        <xsl:attribute name="href"><xsl:value-of select="$link_to_folder"/></xsl:attribute>
            						<span class="white_text"><i18n:text>send_continueoverview</i18n:text></span>
						    </a>
            					</td>
            				</tr></tbody>
            				</table>
            			</td>
			    </tr>

			</xsl:if>

            	</tbody></table>


		<!-- for testing -->
	  	<!-- <xsl:comment><xsl:copy-of select="send" /></xsl:comment>  -->

   </content>
</xsl:template>
	
<xsl:template match="senderror">

	<xsl:if test="not(normalize-space(validsent)='')">
		<tr class="field_middle_bg">
			<td class="link_text">
				<span class="bold_red"><i18n:text>send_validsenttext</i18n:text>&#160;<xsl:value-of select="normalize-space(validsent)" /></span>
			</td>
		</tr>
	</xsl:if>
	
	<xsl:if test="not(normalize-space(validunsent)='')">
		<tr class="field_middle_bg">
			<td class="link_text">
				<span class="bold_red"><i18n:text>send_validunsenttext</i18n:text>&#160;<xsl:value-of select="normalize-space(validunsent)" /></span>
			</td>
		</tr>
	</xsl:if>
	
	<xsl:if test="not(normalize-space(invalid)='')">
		<tr class="field_middle_bg">
			<td class="link_text">
				<span class="bold_red"><i18n:text>send_invalidtext</i18n:text>&#160;<xsl:value-of select="normalize-space(invalid)" /></span>
			</td>
		</tr>
	</xsl:if>

	<tr class="field_light_bg">
		<td class="link_text">
			<span class="simpletext"><i18n:text>send_servicemessagetext</i18n:text>&#160;<xsl:value-of select="normalize-space(servicemessage)" /></span>
		</td>
	</tr>

</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>


</xsl:stylesheet>
