<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2004-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:variable name="message_link_prefix"
  select="'message.xsl?act=message&amp;fromSearch=true&amp;folderNr='"/>
<xsl:variable name="message_link_prefix2"
  select="'&amp;messageNr='"/>
<xsl:variable name="action_link"
  select="'search.xsl?act=search&amp;dosearch=true'"/>

   <xsl:template match="page/search">
      <content>


	<!-- header table -->
        <table width="100%">
	   <tr>
	      <td class="simpletext">
  		<img src="images/gnome/search-32.png" class="image_icon" />    
		<i18n:text>search_title</i18n:text>
	      </td>
	   </tr>
        </table>

	<!-- search criteria -->
       <form method="post" name="searchform">
          <xsl:attribute name="action">
             <xsl:value-of select="$action_link"/>
          </xsl:attribute>
          <table width="100%">
	     <tr class="field_light_bg">
 	        <td class="link_text">
		    <i18n:text>search_subjectcriteriatext</i18n:text>
                </td>
	        <td class="simpletext">
		    <input class="simpletext" size="40" name="subject" type="text">
			<xsl:attribute name="value">
				<xsl:value-of select="normalize-space(criteria/subject/content)" />
			</xsl:attribute>
		    </input>
	        </td>
	     </tr>
	     <tr class="field_middle_bg">
 	        <td class="link_text">
		    <i18n:text>search_bodycriteriatext</i18n:text>
                </td>
	        <td class="simpletext">
		    <input class="simpletext" size="40" name="body" type="text">
			<xsl:attribute name="value">
				<xsl:value-of select="normalize-space(criteria/body/content)" />
			</xsl:attribute>
		    </input>
	        </td>
	     </tr>
	     <tr class="field_light_bg">
 	        <td class="link_text">
		    <i18n:text>search_fromaddresscriteriatext</i18n:text>
                </td>
	        <td class="simpletext">
		    <input class="simpletext" size="40" name="fromaddress" type="text">
			<xsl:attribute name="value">
				<xsl:value-of select="normalize-space(criteria/fromaddress/content)" />
			</xsl:attribute>
		    </input>
	        </td>
	     </tr>
	     <tr class="field_middle_bg">
 	        <td class="link_text">
		    <i18n:text>search_recipientaddresscriteriatext</i18n:text>
                </td>
	        <td class="simpletext">
		    <input class="simpletext" size="40" name="recipientaddress" type="text">
			<xsl:attribute name="value">
				<xsl:value-of select="normalize-space(criteria/recipientaddress/content)" />
			</xsl:attribute>
		    </input>
	        </td>
	     </tr>
	     <tr>
	        <td class="simpletext">
                  <!-- submit button -->
	             <input name="send" class="simpletext" type="submit" i18n:attr="value">
		        <xsl:attribute name="value">search_actiontext</xsl:attribute>
	             </input>
		</td>
             </tr>

	  </table>
       </form>


       <xsl:if test="warning">
	<p class="simpletext"> 
            <span class="bold">
            	<i18n:text><xsl:value-of select="warning/userTag"/></i18n:text>.
	    </span>
	</p>
	<xsl:comment>Warning content: <xsl:value-of select="warning/content"/></xsl:comment>
 	</xsl:if>
		

       <!--
       <xsl:copy-of select="results"/>
       -->
       <xsl:if test="not(isNew)">
        <!-- results -->
        <xsl:choose>
	   <xsl:when test="results">
	      <table cellpadding="2" cellspacing="1" border="0" width="100%">
		<xsl:for-each select="results/result">
		  <tr>
		    <xsl:attribute name="class">
		      <xsl:choose>
		        <xsl:when test="position() mod 2">field_light_bg</xsl:when>
		        <xsl:otherwise>field_middle_bg</xsl:otherwise>
		      </xsl:choose>
		    </xsl:attribute>
		    <td class="simpletext">
                    	<xsl:value-of select="normalize-space(folder/name)" />
		    </td>
		    <td class="simpletext">
		        <i18n:translate>
			   <i18n:text>search_nbtext</i18n:text>
			   <i18n:param><xsl:value-of select="normalize-space(nbMatches)"/></i18n:param>
			</i18n:translate>
                    	
		    </td>
		    <td class="simpletext">
		      <!-- messages that were matched in this folder -->
		      <table class="simpletext">
		       <xsl:for-each select="message">
		        <tr>
		         <td>
 		          <a>
	                     <xsl:attribute name="href">
		                <xsl:value-of select="concat($message_link_prefix,normalize-space(../folder/nr),$message_link_prefix2,normalize-space(nr))"/>
		             </xsl:attribute> 
			     <i18n:translate>
				 <i18n:text>search_messagematchtext</i18n:text>
				 <i18n:param><xsl:value-of select="normalize-space(nr)"/></i18n:param>
				 <i18n:param><xsl:value-of select="normalize-space(from)"/></i18n:param>
				 <i18n:param><xsl:value-of select="normalize-space(subject)"/></i18n:param>
			     </i18n:translate>
                          </a>
			 </td>
			</tr>
		       </xsl:for-each>
		       <xsl:if test="error">
			 <tr>
			  <td>
			   <i18n:text>search_resulterror</i18n:text>
			   <xsl:comment>
			     <xsl:copy-of select="error"/>
			   </xsl:comment>
			  </td>
			 </tr>
		       </xsl:if>
		      </table>
		    </td>
		  </tr>
		</xsl:for-each>
	      </table>
	   </xsl:when>
	   <xsl:otherwise>
	      <p class="simpletext">
                 <i18n:text>search_noresultstext</i18n:text>
	      </p>
	   </xsl:otherwise>
        </xsl:choose>
       </xsl:if>


      </content>
   </xsl:template>
	
   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>

</xsl:stylesheet>
