<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template match="page/menu">

<xsl:variable name="refreshlink" 
  select="'folder.xsl?act=folder&amp;folderNr=0&amp;refresh=true&amp;refreshAll=true'"/>
<xsl:variable name="composelink"
  select="'compose.xsl?act=compose'"/>
<xsl:variable name="addresseslink"
  select="'addresses.xsl?act=addresses'"/>
<xsl:variable name="setupfolderslink"
  select="'setupfolders.xsl?act=setupfolders'"/>
<xsl:variable name="setupuserlink"
  select="'userdata.xsl?act=userdata'"/>
<xsl:variable name="searchlink"
  select="'search.xsl?act=search&amp;new=true'"/>
<xsl:variable name="helplink"
  select="'doc/index.html'"/>
<xsl:variable name="mainwindowlink"
  select="'entry.xsl'"/>
<xsl:variable name="logoutlink"
  select="'logout'"/>

 <menu>

   <!-- outer table used for formatting
    -->
   <table cellpadding="0" cellspacing="0" width="100%">
     <tr>
       <td>

        <table cellpadding="0" cellspacing="0" width="100%">
	 <tr>
	   <td>
		<a href="http://ironmailer.org">
		   <img alt="Product logo" src="images/ironmailer_logo_titlebar.png" border="0"/>
		</a>
	   </td>


	   <!-- Column for navigation button table -->
	   <td>
	     <table cellpadding="0" cellspacing="0">
	      <!-- Row with pictures -->
               <tr>
		   <!-- Refresher -->
		   <td align="center">
                	<a>
			  <xsl:attribute name="href" >
			     <xsl:value-of select="$refreshlink"/>
			  </xsl:attribute>
			  <xsl:attribute name="onmouseover">
			     self.status='<xsl:value-of select="refresh_text"/>';
                          </xsl:attribute>
                	  <img src="images/gnome/refresh-32.png" class="image_nav" i18n:attr="alt">
				<xsl:attribute name="alt">general_refresh_buttonlabel</xsl:attribute>
                	  </img>
                	</a>
		    </td>

		    <!-- Composer -->
		    <td align="center">
                	<a>
			   <xsl:attribute name="href">
			      <xsl:value-of select="$composelink"/>
		           </xsl:attribute>
			   <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="composerhelp"/>';
			   </xsl:attribute>
                	   <img src="images/gnome/composer-32.png" class="image_nav" i18n:attr="alt">
				<xsl:attribute name="alt">navbar_composer</xsl:attribute>
                	   </img>
                	</a>
		    </td>

		    <!-- Addresses -->
		    <td align="center">
                	<a>
			  <xsl:attribute name="href" >
			    <xsl:value-of select="$addresseslink"/>
			  </xsl:attribute>
			  <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="addresshelp"/>';
			  </xsl:attribute>
                	  <img src="images/gnome/addresses-32.png" class="image_nav" i18n:attr="alt">
				<xsl:attribute name="alt">navbar_addresses</xsl:attribute>
                	  </img>
                	</a>
		    </td>
       
		    <!-- Folder Setup -->            
		    <td align="center">
                	<a>
			  <xsl:attribute name="href" >
			    <xsl:value-of select="$setupfolderslink"/>
			  </xsl:attribute>
			  <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="foldersetuphelp"/>';
			  </xsl:attribute>
                	  <img src="images/gnome/foldersetup-32.png" class="image_nav" i18n:attr="alt">
				<xsl:attribute name="alt">navbar_foldersetup</xsl:attribute>
                	  </img>
                	</a>
		    </td>

		    <!-- User Setup -->            
		    <td align="center">
                	<a>
			  <xsl:attribute name="href" >
			    <xsl:value-of select="$setupuserlink"/>
			  </xsl:attribute>
			  <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="usersetuphelp"/>';
			  </xsl:attribute>
                	  <img src="images/gnome/configuration-32.png" class="image_nav" i18n:attr="alt">
				<xsl:attribute name="alt">navbar_usersetup</xsl:attribute>
                	  </img>
                	</a>
		    </td>

		    <!-- Search -->            
		    <td align="center">
                	<a>
			  <xsl:attribute name="href" >
			    <xsl:value-of select="$searchlink"/>
			  </xsl:attribute>
			  <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="searchhelp"/>';
			  </xsl:attribute>
                	  <img src="images/gnome/search-32.png" class="image_nav" i18n:attr="alt">
				<xsl:attribute name="alt">navbar_search</xsl:attribute>
                	  </img>
                	</a>
		    </td>

		    <!-- Help -->            
		    <td align="center">
                	<a target="new">
			  <xsl:attribute name="href" >
			    <xsl:value-of select="$helplink"/>
			  </xsl:attribute>
			  <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="helphelp"/>';
			  </xsl:attribute>
                	  <img src="images/gnome/help-32.png" class="image_nav" i18n:attr="alt">
				<xsl:attribute name="alt">navbar_help</xsl:attribute>
                	  </img>
                	</a>
		    </td>

		    <!-- link to entry window -->
		    <td align="center">
                	<a>
			  <xsl:attribute name="href" i18n:attr="alt">
			    <xsl:value-of select="$mainwindowlink"/>
			  </xsl:attribute>
			  <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="mainwindowhelp"/>';
			  </xsl:attribute>
                	  <img src="images/gnome/home-32.png" class="image_nav">
				<xsl:attribute name="alt">navbar_mainwindow</xsl:attribute>
                	  </img>
                	</a>
		    </td>
			
               </tr>

               <!-- Row with labels -->
               <tr>
	        
		<td align="center">
               	  <a>
		     <xsl:attribute name="href" >
			<xsl:value-of select="$refreshlink"/>
		     </xsl:attribute>
		     <xsl:attribute name="onmouseover">
			self.status='<xsl:value-of select="refresh_text"/>';
		     </xsl:attribute>
		     <p class="navigation"><i18n:text>general_refresh_buttonlabel</i18n:text><br /><i18n:text>general_refresh_shorttext</i18n:text><br /></p>
		  </a>
		</td>
		
		<td align="center">
                   <a>
		      <xsl:attribute name="href" >
			    <xsl:value-of select="$composelink"/>
		      </xsl:attribute>
		      <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="composerhelp"/>';
		      </xsl:attribute>
		      <p class="navigation"><i18n:text>navbar_composer</i18n:text><br /><i18n:text>navbar_composer2</i18n:text><br /></p>
		   </a>
		</td>

		<td align="center">
                   <a>
		      <xsl:attribute name="href" >
			    <xsl:value-of select="$addresseslink"/>
		      </xsl:attribute>
		      <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="addresseshelp"/>';
		      </xsl:attribute>
		      <p class="navigation"><i18n:text>navbar_addresses</i18n:text><br /><i18n:text>navbar_addresses2</i18n:text><br /></p>
		   </a>
		</td>

		<td align="center">
                   <a>
		      <xsl:attribute name="href" >
			    <xsl:value-of select="$setupfolderslink"/>
		      </xsl:attribute>
		      <xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="foldersetuphelp"/>';
		      </xsl:attribute>
		      <p class="navigation"><i18n:text>navbar_foldersetup</i18n:text><br /><i18n:text>navbar_foldersetup2</i18n:text><br /></p>
		   </a>
		</td>

		<td align="center">
                   <a>
			<xsl:attribute name="href" >
			    <xsl:value-of select="$setupuserlink"/>
			</xsl:attribute>
			<xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="usersetuphelp"/>';
			</xsl:attribute>
			<p class="navigation"><i18n:text>navbar_usersetup</i18n:text><br /><i18n:text>navbar_usersetup2</i18n:text><br /></p>
		   </a>
		</td>

		<td align="center">
                   <a>
		     <xsl:attribute name="href" >
			<xsl:value-of select="$searchlink"/>
		     </xsl:attribute>
		     <xsl:attribute name="onmouseover">
			self.status='<xsl:value-of select="searchhelp"/>';
		     </xsl:attribute>
		     <p class="navigation"><i18n:text>navbar_search</i18n:text><br /><i18n:text>navbar_search2</i18n:text><br /></p>
		   </a>
		</td>

		<td align="center">
                   <a target="new">
		      <xsl:attribute name="href" >
			    <xsl:value-of select="$helplink"/>
		      </xsl:attribute>
		      <xsl:attribute name="onmouseover">
			self.status='<xsl:value-of select="helphelp"/>';
		      </xsl:attribute>
		      <p class="navigation"><i18n:text>navbar_help</i18n:text><br /><i18n:text>navbar_help2</i18n:text><br /></p>
		   </a>
		</td>

                <td align="center">
                   <a>
		      <xsl:attribute name="href" >
		         <xsl:value-of select="$mainwindowlink"/>
		      </xsl:attribute>
		      <xsl:attribute name="onmouseover">
			self.status='<xsl:value-of select="mainwindowhelp"/>';
		      </xsl:attribute>
                      <p class="navigation"><i18n:text>navbar_mainwindow</i18n:text><br /><i18n:text>navbar_mainwindow2</i18n:text><br /></p>
                   </a>
                </td>
	       </tr>
	     <!-- end of table for navigation buttons -->
	     </table>
	    </td>


	   <!-- Column for right hand button table -->
	   <td align="right" border="0">
	     <table cellpadding="0" cellspacing="0" border="0">
	       <tr>
		  <!-- Logout -->            
		  <td align="center">
                     <a>
		        <xsl:attribute name = "href">
			    <xsl:value-of select="$logoutlink"/>
			</xsl:attribute>
			<xsl:attribute name="onmouseover">
			   self.status='<xsl:value-of select="logouthelp"/>';
			</xsl:attribute>
                	<img border="0" src="images/gnome/exit-32.png" class="image_nav" i18n:attr="alt">
				<xsl:attribute name="alt">navbar_logout</xsl:attribute>
                	</img>
                     </a>
		  </td>
	       </tr>
	       <tr>
		  <td align="center">
                     <a>
			<xsl:attribute name = "href">
			    <xsl:value-of select="$logoutlink"/>
			</xsl:attribute>
			<xsl:attribute name="onmouseover">
				self.status='<xsl:value-of select="logouthelp"/>';
			</xsl:attribute>
			<p class="navigation"><i18n:text>navbar_logout</i18n:text><br /><i18n:text>navbar_logout2</i18n:text><br /></p>
		     </a>
		  </td>
	       </tr>

	     <!-- end of table for navigation buttons -->
	     </table>
	    </td>

	   </tr>

        </table>

	<!-- now end outer, formatting table -->
          </td></tr>
        </table>

  </menu>
</xsl:template>	



  <!-- pass the rest through -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>


</xsl:stylesheet>
