<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "my";
include "inc/header.inc.php";

if (!isset($me['user_id']) || $me['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'my_common.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');


//setup Wiki
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');


if (isset($_REQUEST['edit_profile'])) {
	$user->user_id = $me['user_id'];
	$output_user = $user->getUser();
	unset($user->user_id);
	
	$output_profile = $user->selProfile($_REQUEST['profile_id']);
	
	//check that the profile is ours
	if (isset($output_profile) && $output_profile['user_id'] == $me['user_id']) {
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
		$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
		$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif
		
		$file->user_id = $me['user_id'];
		$output_images = $file->getFiles();//get images for default image selections
	
		$display = "edit_profile";
	}
	else {
		header("Location: my_profile.php?". strip_tags(SID));
		exit;
	}
}
elseif (isset($frmdata['save']) || isset($frmdata['save_go'])) {
	$user->user_id = $me['user_id'];
	
	$user->updateProfile($frmdata);
	
	if (empty($GLOBALS['igloo_error_log'])) {
		if (isset($frmdata['save_go'])) {
			header("Location: my_profile.php?profile_id=" . $frmdata['profile_id'] . "&". strip_tags(SID));
			exit;
		}
		else {
			header("Location: my_profile.php?profile_id=" . $frmdata['profile_id'] . "&edit_profile=1&". strip_tags(SID));
			exit;
		}
	}
	else {
		$output_profile = $frmdata;
		$display = "edit_profile";
	}

}
elseif (isset($frmdata['preview'])) {
		$frmdata['profile_summary'] = stripslashes($frmdata['profile_summary']);
		$frmdata['profile_summary_preview'] = $wiki->transform($frmdata['profile_summary'], 'Xhtml');

		$output_profile = $frmdata;

		$display = "edit_profile";
	}
elseif (isset($_REQUEST['profile_id'])) {
	unset($user->user_id);
	$output_profile = $user->selProfile($_REQUEST['profile_id']);
	
	//SECURITY - check that the profile is mine - TC
	if (isset($output_profile['user_id']) && $output_profile['user_id'] == $me['user_id']) {
		$output_profile['profile_summary_display'] = $wiki->transform($output_profile['profile_summary'], 'Xhtml');
		
		$user->user_id = $me['user_id'];
		$output_user = $user->getUser();
	
		$display = "view_profile";
	}
	else {
		header("Location: my_profile.php?". strip_tags(SID));
		exit;
	}
}
else {
	//setup file
	$user->user_id = $me['user_id'];
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$user->file = $file;
	$output_profiles = $user->selProfiles();
}

//setup file
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];

if (isset($output_profile['file_id'])) {
	$file->file_id = $output_profile['file_id'];
	$output_profile['image'] = $file->getFileRecord();
}
elseif (isset($output_profile)) {
	$output_profile['image']['file_title'] = "";
	$output_profile['image']['file'] = $file->noimage;
}



//move to template
if (!empty($output_user)) {
   $body->set('user', $output_user);
}

if (!empty($display)) {
   $body->set('display', $display);
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

if (!empty($output_profiles)) {
   $body->set('profiles', $output_profiles);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
}

include "inc/footer.inc.php";

?>
