/**CFile*******************************************************************
  PackageName [strucval]
  Synopsis    [Structure-driven validation of hardware and software systems]

  FileName    [strucvalStubLib.c]
  Revision    [$Revision: 76 $]
  Date        [$Date: 2013-04-26 14:26:09 +0200 (pet, 26 apr 2013) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [Adapted from http://wiki.tcl.tk/3358]
  SeeAlso     [strucval.h, strucval.decls, strucvalDecls.h, strucvalStubInit.c]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2013
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#include "strucval.h"
#include "strucvalDecls.h"

#include <tcl.h>

#ifdef ESTWIN32
#  undef TCL_STORAGE_CLASS
#  define TCL_STORAGE_CLASS DLLEXPORT
#endif

#if TCL_MAJOR_VERSION < 8
#  error "We need Tcl 8.1 or greater to build this"
#elif defined(USE_TCL_STUBS) && TCL_MAJOR_VERSION == 8 && \
   (TCL_MINOR_VERSION == 0 || \
   (TCL_MINOR_VERSION == 1 && TCL_RELEASE_LEVEL != TCL_FINAL_RELEASE))
#   error "Stubs interface doesn't work in 8.0 and alpha/beta 8.1"
#endif

const StrucvalStubs *strucvalStubsPtr;

CONST char *
Strucval_InitStubs (Tcl_Interp *interp, char *version, int exact)
{
  CONST char *actualVersion;
  ClientData clientData = NULL;

  actualVersion = Tcl_PkgRequireEx(interp, "est2ed-strucval", version, exact, (ClientData*) &clientData);
  strucvalStubsPtr = (StrucvalStubs *) clientData;

  if (!actualVersion) {
    return NULL;
  }

  if (!strucvalStubsPtr) {
    Tcl_SetResult(interp, "This implementation of est2ed-strucval does not support stubs", TCL_STATIC);
    return NULL;
  }

  return actualVersion;
}
