# Use genStubs.tcl (/tools in TCL source package) to generate
# paDecls.h and paStubInit.c from this file.
#
# Procedure:
# touch paDecls.h
# touch paStubInit.c
# ./genStubs.tcl . pa.decls
#
# Problem: if there are no arguments, you have to add parenthesis and
# remove some '*' in generated file paDecls.h, moreover you have to
# remove '&' in generated file paStubInit.c.

library pa
interface pa
declare 0 generic {
  int pa_status
}
declare 1 generic {
  int pa_variables
}
declare 2 generic {
  int pa_sorts
}
declare 3 generic {
  int pa_processes
}
declare 4 generic {
  int pa_compositions
}
declare 5 generic {
  Pa_Variable *pa_variableTable
}
declare 6 generic {
  Pa_Sort *pa_sortTable
}
declare 7 generic {
  Pa_Process *pa_processTable
}
declare 8 generic {
  Pa_Composition *pa_compositionTable
}
declare 9 generic {
  void Pa_InitPkg()
}
declare 10 generic {
  void Pa_ExitPkg()
}
declare 11 generic {
  void Pa_AboutPkg()
}
declare 12 generic {
  void Pa_InitVariable(int i)
}
declare 13 generic {
  int Pa_AddNewSort(Est_String name)
}
declare 14 generic {
  int Pa_FindSort(Est_String name)
}
declare 15 generic {
  int Pa_FOASortAction(Pa_Sort *sort, Est_String name)
}
declare 16 generic {
  int Pa_FindSortAction(Pa_Sort *sort, Est_String name)
}
declare 17 generic {
  int Pa_AddNewProcess(Est_String name)
}
declare 18 generic {
  int Pa_FindProcess(Est_String name)
}
declare 19 generic {
  void Pa_RenameProcess(Est_String old, Est_String new)
}
declare 20 generic {
  int Pa_CopyProcess(Est_String name, Est_String copy, Est_String copysort, Est_String old, Est_String new)
}
declare 21 generic {
  Est_Boolean Pa_IsGate(Est_String name)
}
declare 22 generic {
  int Pa_FOAStateProcess(Pa_Process *proc, Est_String name)
}
declare 23 generic {
  int Pa_FOAGateProcess(Pa_Process *proc, Est_String name)
}
declare 24 generic {
  int Pa_FOAComposedStateProcess(Pa_Process *proc, Bdd_Edge F, Est_String prefix)
}
declare 25 generic {
  int Pa_FindStateProcess(Pa_Process *proc, Est_String name)
}
declare 26 generic {
  int Pa_AddStateProcess(Pa_Process *proc, Est_String name)
}
declare 27 generic {
  int Pa_FOANextStateProcess(Pa_Process *proc, Est_String prefix)
}
declare 28 generic {
  int Pa_NumberStateProcess(Pa_Process *proc)
}
declare 29 generic {
  int Pa_FOATransition(Pa_Process *proc, int state1, int action, int type, int state2)
}
declare 30 generic {
  int Pa_AddNewComposition(Est_String name, int type, int numP, int numA)
}
declare 31 generic {
  void Pa_DeleteStateProcess(Pa_Process *proc, int num)
}
declare 32 generic {
  void Pa_DeleteSort(int num)
}
declare 33 generic {
  void Pa_RemoveDeletedSorts()
}
declare 34 generic {
  void Pa_DeleteProcess(int num)
}
declare 35 generic {
  void Pa_RemoveDeletedProcesses()
}
declare 36 generic {
  void Pa_RemoveComposition(int num)
}
declare 37 generic {
  int Pa_FindComposition(Est_String name)
}
declare 38 generic {
  int Pa_FindProcessComp(Pa_Composition *c, Est_String name)
}
declare 39 generic {
  Bdd_Edge Pa_AddStab(Bdd_Edge d, Est_String name)
}
declare 40 generic {
  void PaSaveSortActions(Pa_Sort *s)
}
declare 41 generic {
  void PaSaveProcStates(Pa_Process *p)
}
declare 42 generic {
  void Pa_EncodeSort(Est_String name)
}
declare 43 generic {
  void Pa_EncodeProcess(Est_String name)
}
declare 44 generic {
  void Pa_EncodeMultiProcesses(Est_String plist)
}
declare 45 generic {
  int Pa_ExpandGates(Pa_Process *p)
}
declare 46 generic {
  int Pa_Process2Composition(Est_String name)
}
declare 47 generic {
  int Pa_Composition2Process(Est_String name, Est_Boolean full)
}
declare 48 generic {
  int Pa_DecodeSortActions(Pa_Sort *s, Bdd_Edge F, Est_Boolean write)
}
declare 49 generic {
  Est_String Pa_DecodeSortActions1(Pa_Sort *s, Bdd_Edge F, Est_Boolean write)
}
declare 50 generic {
  void Pa_DecodeProcess(Est_String name, Est_Boolean write)
}
declare 51 generic {
  int Pa_DecodeProcessStates(Pa_Process *p, Bdd_Edge F, Est_Boolean write)
}
declare 52 generic {
  int Pa_DecodeProcessTR(Pa_Process *p, Bdd_Edge F, Est_Boolean write)
}
declare 53 generic {
  void Pa_DecodeComposition(Est_String name, Est_Boolean write)
}
declare 54 generic {
  int Pa_DecodeCompStates(Pa_Composition *c, Bdd_Edge F, Est_Boolean write)
}
declare 55 generic {
  int Pa_DecodeCompTR(Pa_Composition *c, Bdd_Edge F, Est_Boolean write)
}
declare 56 generic {
  int Pa_DecodeProcProcPair(Pa_Process *p1, Pa_Process *p2, Bdd_Edge F, Est_Boolean write)
}
declare 57 generic {
  int Pa_DecodeCompProcPair(Pa_Composition *c, Pa_Process *p, Bdd_Edge F, Est_Boolean write)
}
declare 58 generic {
  int Pa_DecodeCompCompPair(Pa_Composition *c1, Pa_Composition *c2, Bdd_Edge F, Est_Boolean write)
}
declare 59 generic {
  Bdd_Edge Pa_ExtractProcTransition(Pa_Process *p, Bdd_Edge f)
}
declare 60 generic {
  Bdd_Edge Pa_ExtractCompTransition(Pa_Composition *c, Bdd_Edge f)
}
declare 61 generic {
  Bdd_Edge Pa_ExtractProcState(Pa_Process *p, Bdd_Edge f)
}
declare 62 generic {
  int Pa_EnumerateProcState(Pa_Process *p, Bdd_Edge f)
}
declare 63 generic {
  Bdd_Edge Pa_ExtractCompState(Pa_Composition *c, Bdd_Edge f)
}
declare 64 generic {
  Bdd_Edge Pa_ExtractSortAction(Pa_Sort *s, Bdd_Edge f)
}
declare 65 generic {
  int Pa_EnumerateSortAction(Pa_Sort *s, Bdd_Edge f)
}
declare 66 generic {
  void Pa_WriteKnownSorts()
}
declare 67 generic {
  void Pa_WriteSort(Est_String name)
}
declare 68 generic {
  void Pa_WriteKnownProcesses()
}
declare 69 generic {
  void Pa_WriteProcess(Est_String name, char type)
}
declare 70 generic {
  void Pa_WriteKnownCompositions()
}
declare 71 generic {
  void Pa_WriteProcessCCS(Est_String name, char type)
}
declare 72 generic {
  int Pa_ParseSortProcess(Est_String ime)
}
declare 73 generic {
  void Pa_WriteProcessFSP(Est_String name, char type)
}
