/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.compiler.IPackager;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerFactory;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.compressor.PackCompressor;
import com.izforge.izpack.installer.InstallerRequirement;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
extends Thread {
    public static final String IZPACK_VERSION = "4.3.3";
    public static String IZPACK_HOME = ".";
    protected String basedir;
    protected String kind;
    protected String output;
    private IPackager packager = null;
    private boolean compileFailed = true;
    private Properties properties;
    private VariableSubstitutor propertySubstitutor;
    private String compr_format;
    private int compr_level;
    private PackagerListener packagerlistener;

    public static void setIzpackHome(String string) {
        IZPACK_HOME = string;
    }

    public Compiler(String string, String string2, String string3) throws CompilerException {
        this(string, string2, string3, "default");
    }

    public Compiler(String string, String string2, String string3, String string4) throws CompilerException {
        this(string, string2, string3, string4, -1);
    }

    public Compiler(String string, String string2, String string3, String string4, int n) throws CompilerException {
        this.basedir = string;
        this.kind = string2;
        this.output = string3;
        this.properties = new Properties(System.getProperties());
        this.propertySubstitutor = new VariableSubstitutor(this.properties);
        this.setProperty("izpack.version", IZPACK_VERSION);
        this.setProperty("basedir", string);
        this.compr_format = string4;
        this.compr_level = n;
    }

    public void initPackager(String string) throws CompilerException {
        try {
            this.packager = PackagerFactory.getPackager(string);
            this.packager.initPackCompressor(this.compr_format, this.compr_level);
            PackCompressor packCompressor = this.packager.getCompressor();
            if (packCompressor != null) {
                packCompressor.setCompiler(this);
            }
            if (this.packagerlistener != null) {
                this.packager.setPackagerListener(this.packagerlistener);
            }
        }
        catch (Exception exception) {
            Debug.trace(exception);
            throw new CompilerException("Error loading packager class: " + string);
        }
    }

    public PackagerListener getPackagerListener() {
        return this.packager.getPackagerListener();
    }

    public void setPackagerListener(PackagerListener packagerListener) {
        if (this.packager != null) {
            this.packager.setPackagerListener(packagerListener);
        } else {
            this.packagerlistener = packagerListener;
        }
    }

    public String getKind() {
        return this.kind;
    }

    public Properties getVariables() {
        return this.packager.getVariables();
    }

    public void compile() {
        this.start();
    }

    @Override
    public void run() {
        try {
            this.createInstaller();
        }
        catch (CompilerException compilerException) {
            System.out.println(compilerException.getMessage() + "\n");
        }
        catch (Exception exception) {
            if (Debug.stackTracing()) {
                exception.printStackTrace();
            }
            System.out.println("ERROR: " + exception.getMessage());
        }
    }

    public void createInstaller() throws Exception {
        if (this.packager.getCompressor().getContainerPaths() != null) {
            String[] stringArray = this.packager.getCompressor().getContainerPaths();
            String[][] stringArray2 = this.packager.getCompressor().getDecoderClassNames();
            for (int i = 0; i < stringArray.length; ++i) {
                URL uRL = null;
                if (stringArray[i] != null) {
                    uRL = this.findIzPackResource(stringArray[i], "pack compression Jar file");
                }
                if (stringArray2[i] == null || stringArray2[i].length <= 0) continue;
                this.addJarContent(uRL, Arrays.asList(stringArray2[i]));
            }
        }
        this.packager.createInstaller(new File(this.output));
        this.compileFailed = false;
    }

    public boolean wasSuccessful() {
        return !this.compileFailed;
    }

    public String replaceProperties(String string) {
        return this.propertySubstitutor.substitute(string, "at");
    }

    public void setGUIPrefs(GUIPrefs gUIPrefs) {
        this.packager.setGUIPrefs(gUIPrefs);
    }

    public void setInfo(Info info) throws Exception {
        this.packager.setInfo(info);
    }

    public IPackager getPackager() {
        return this.packager;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public boolean setProperty(String string, String string2) {
        if (System.getProperties().containsKey(string)) {
            return false;
        }
        this.properties.put(string, string2);
        return true;
    }

    public boolean addProperty(String string, String string2) {
        String string3 = this.properties.getProperty(string);
        if (string3 == null) {
            this.properties.put(string, string2);
            return true;
        }
        return false;
    }

    public void addJarContent(URL uRL) {
        this.packager.addJarContent(uRL);
    }

    public void addJarContent(URL uRL, List<String> list) {
        this.packager.addJarContent(uRL, list);
    }

    public void addCustomJar(CustomData customData, URL uRL) {
        this.packager.addCustomJar(customData, uRL);
    }

    public void addInstallerRequirement(List<InstallerRequirement> list) {
        this.packager.addInstallerRequirements(list);
    }

    public void addLangPack(String string, URL uRL, URL uRL2) {
        this.packager.addLangPack(string, uRL, uRL2);
    }

    public void addNativeLibrary(String string, URL uRL) throws Exception {
        this.packager.addNativeLibrary(string, uRL);
    }

    public void addNativeUninstallerLibrary(CustomData customData) {
        this.packager.addNativeUninstallerLibrary(customData);
    }

    public void addPack(PackInfo packInfo) {
        this.packager.addPack(packInfo);
    }

    public void addPanelJar(Panel panel, URL uRL) {
        this.packager.addPanelJar(panel, uRL);
    }

    public void addResource(String string, URL uRL) {
        this.packager.addResource(string, uRL);
    }

    public void checkDependencies() throws CompilerException {
        this.checkDependencies(this.packager.getPacksList());
    }

    public void checkExcludes() throws CompilerException {
        this.checkExcludes(this.packager.getPacksList());
    }

    public void checkExcludes(List<PackInfo> list) throws CompilerException {
        for (int i = 0; i < list.size(); ++i) {
            PackInfo packInfo = list.get(i);
            Pack pack = packInfo.getPack();
            for (int j = 0; j < i; ++j) {
                PackInfo packInfo2 = list.get(j);
                Pack pack2 = packInfo2.getPack();
                if (pack.excludeGroup == null || pack2.excludeGroup == null || !pack.excludeGroup.equals(pack2.excludeGroup) || !pack.preselected || !pack2.preselected) continue;
                this.parseError("Packs " + pack.name + " and " + pack2.name + " belong to the same excludeGroup " + pack.excludeGroup + " and are both preselected. This is not allowed.");
            }
        }
    }

    public void checkDependencies(List<PackInfo> list) throws CompilerException {
        HashMap<String, PackInfo> hashMap = new HashMap<String, PackInfo>();
        for (PackInfo packInfo : list) {
            hashMap.put(packInfo.getPack().name, packInfo);
        }
        int n = this.dfs(list, hashMap);
        if (n == -2) {
            this.parseError("Circular dependency detected");
        } else if (n == -1) {
            this.parseError("A dependency doesn't exist");
        }
    }

    private int dfs(List<PackInfo> list, Map<String, PackInfo> map) {
        HashMap<Edge, Integer> hashMap = new HashMap<Edge, Integer>();
        for (PackInfo packInfo : list) {
            if (packInfo.colour != 0 || this.dfsVisit(packInfo, map, hashMap) == 0) continue;
            return -1;
        }
        return this.checkBackEdges(hashMap);
    }

    private int checkBackEdges(Map<Edge, Integer> map) {
        Set<Edge> set = map.keySet();
        for (Edge edge : set) {
            int n = map.get(edge);
            if (n != 1) continue;
            return -2;
        }
        return 0;
    }

    private int dfsVisit(PackInfo packInfo, Map<String, PackInfo> map, Map<Edge, Integer> map2) {
        packInfo.colour = 1;
        List<String> list = packInfo.getDependencies();
        if (list != null) {
            for (String string : list) {
                int n;
                PackInfo packInfo2 = map.get(string);
                if (packInfo2 == null) {
                    System.out.println("Failed to find dependency: " + string);
                    return -1;
                }
                Edge edge = new Edge(packInfo, packInfo2);
                if (map2.get(edge) == null) {
                    map2.put(edge, packInfo2.colour);
                }
                if (packInfo2.colour != 0 || (n = this.dfsVisit(packInfo2, map, map2)) == 0) continue;
                return n;
            }
        }
        packInfo.colour = 2;
        return 0;
    }

    public URL findIzPackResource(String string, String string2) throws CompilerException {
        return this.findIzPackResource(string, string2, false);
    }

    public URL findIzPackResource(String string, String string2, boolean bl) throws CompilerException {
        URL uRL = this.getClass().getResource("/" + string);
        if (uRL == null) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(IZPACK_HOME, string);
            }
            if (!file.exists()) {
                if (bl) {
                    this.parseWarn(string2 + " not found: " + file);
                } else {
                    this.parseError(string2 + " not found: " + file);
                }
            } else {
                try {
                    uRL = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    this.parseError(string2 + "(" + file + ")", malformedURLException);
                }
            }
        }
        return uRL;
    }

    private void parseWarn(String string) {
        System.out.println("Warning: " + string);
    }

    public void parseError(String string) throws CompilerException {
        this.compileFailed = true;
        throw new CompilerException(string);
    }

    public void parseError(String string, Throwable throwable) throws CompilerException {
        this.compileFailed = true;
        throw new CompilerException(string, throwable);
    }

    public static void main(String[] stringArray) {
        CompilerConfig.main(stringArray);
    }

    public void addCustomListener(int n, String string, String string2, List<OsConstraint> list) throws Exception {
        string2 = this.replaceProperties(string2);
        String string3 = string;
        List<String> list2 = null;
        URL uRL = this.findIzPackResource(string2, "CustomAction jar file", true);
        if (uRL != null) {
            string3 = this.getFullClassName(uRL, string);
            if (string3 == null) {
                throw new CompilerException("CustomListener class '" + string + "' not found in '" + uRL + "'. The class and listener name must match");
            }
            list2 = this.getContainedFilePaths(uRL);
        }
        CustomData customData = new CustomData(string3, list2, list, n);
        this.packager.addCustomJar(customData, uRL);
    }

    private List<String> getContainedFilePaths(URL uRL) throws Exception {
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
        ZipEntry zipEntry = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (zipEntry.isDirectory()) continue;
            arrayList.add(string);
        }
        jarInputStream.close();
        return arrayList;
    }

    private String getFullClassName(URL uRL, String string) throws Exception {
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
        ZipEntry zipEntry = null;
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            int n = string2.lastIndexOf(".class");
            if (n < 0) continue;
            string2 = string2.replace('/', '.');
            int n2 = -1;
            if (string == null || (n2 = string2.indexOf(string)) < 0 || string2.length() != n2 + string.length() + 6) continue;
            jarInputStream.close();
            return string2.substring(0, n);
        }
        jarInputStream.close();
        return null;
    }

    public Map<String, Condition> getConditions() {
        return this.packager.getRules();
    }

    public void setConditions(Map<String, Condition> map) {
        this.packager.setRules(map);
    }

    public Map<String, List<DynamicVariable>> getDynamicVariables() {
        return this.packager.getDynamicVariables();
    }

    public void setDynamicVariables(Map<String, List<DynamicVariable>> map) {
        this.packager.setDynamicVariables(map);
    }

    static class CmdlinePackagerListener
    implements PackagerListener {
        CmdlinePackagerListener() {
        }

        public void packagerMsg(String string) {
            this.packagerMsg(string, 2);
        }

        public void packagerMsg(String string, int n) {
            String string2;
            switch (n) {
                case 0: {
                    string2 = "[ DEBUG ] ";
                    break;
                }
                case 1: {
                    string2 = "[ ERROR ] ";
                    break;
                }
                case 4: {
                    string2 = "[ WARNING ] ";
                    break;
                }
                default: {
                    string2 = "";
                }
            }
            System.out.println(string2 + string);
        }

        public void packagerStart() {
            System.out.println("[ Begin ]");
            System.out.println();
        }

        public void packagerStop() {
            System.out.println();
            System.out.println("[ End ]");
        }
    }

    private class Edge {
        PackInfo u;
        PackInfo v;

        Edge(PackInfo packInfo, PackInfo packInfo2) {
            this.u = packInfo;
            this.v = packInfo2;
        }
    }
}

