<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


/*
A long term average rating is held against the item
The last 24hr ratings are held in a temporary page
A cron job removes 25 hour old ratings and adjusts the long term average accordingly
*/

class Comment {

	// the constructor
	// Tom Calthrop, 20th March 2007
	//
	function Comment($db) {
		$this->db = $db;
	} //EO Rate

	
	// Selects ratings (rating, your vote this month)
	// Tom Calthrop, 20th March 2007
	//
	function selComment($plugin, $item_id) {

		$rating['total'] = 0;
		$rating['votes'] = 0;
		$rating['average'] = 0;
		
		// select average 
		$query = "
			SELECT sum(rate_value) as total 
			FROM " . $this->db->prefix . "_rate 
			WHERE
			webspace_id=" . $_SESSION['webspace_id'] . " AND 
			plugin_name=" . $this->db->qstr($plugin, get_magic_quotes_gpc()) . " AND
			plugin_item_id=" . $item_id
		;
		
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$rating['total'] = $result->fields['total'];
		}

		// select total 
		$query = "
			SELECT count(rate_value) as total
			FROM " . $this->db->prefix . "_rate 
			WHERE
			webspace_id=" . $_SESSION['webspace_id'] . " AND 
			plugin_name=" . $this->db->qstr($plugin, get_magic_quotes_gpc()) . " AND
			plugin_item_id=" . $item_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$rating['votes'] = $result->fields['total'];
		}

		if ($rating['total'] > 0 && $rating['votes'] > 0) {
			$rating['average'] = round($rating['total'] / $rating['votes']);
		}
		

		// select my vote
		if (isset($_SESSION['connection_id'])) {
			$query = "
				SELECT rate_value as total
				FROM " . $this->db->prefix . "_rate 
				WHERE
				webspace_id=" . $_SESSION['webspace_id'] . " AND 
				plugin_name=" . $this->db->qstr($plugin, get_magic_quotes_gpc()) . " AND
				plugin_item_id=" . $item_id . " AND
				connection_id=" . $_SESSION['connection_id']
			;
			
			$result = $this->db->SelectLimit($query, 1);
	
			if (isset($result->fields)) {
				$rating['vote'] = $result->fields['total'];
			}
		}

		return $rating;

		
	}//EO selRating
}

?>