<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('core', 'edit_webpages', $_SESSION['connection_permission'])) {

	require_once($language_path . 'admin_blocks.lang.php');
	
	
	if (isset($_POST['update_webblock'])) {
		if (!empty($_POST['webblock_id'])) { // we update the block
		
			$query = "
				UPDATE " . $db->prefix . "_webblock
				SET
				webblock_body=" . $db->qstr($_POST['webblock_body']) . " 
				WHERE webblock_id=" . $_POST['webblock_id']
			;
			
			$result = $db->Execute($query);
		}
		else { // we insert
			// check the tag (only [A-Z allowed])
			$_POST['webblock_tag'] = trim(strtoupper($_POST['webblock_tag']));
	
			if (strlen($_POST['webblock_tag']) < 3) {
				$GLOBALS['am_error_log'][] = array($lang['error']['tag_too_short']);
			}
			
			$pattern = '/^[A-Z]*$/';
			
			if (!preg_match($pattern, $_POST['webblock_tag'], $matches)) {
				$GLOBALS['am_error_log'][] = array($lang['error']['tag_only_uppercase']);
			}
	
			if (empty($GLOBALS['am_error_log'])) {
	
				$rec = array();
				$rec['webblock_tag'] = $_POST['webblock_tag'];
				$rec['webblock_body'] = $_POST['webblock_body'];
				$rec['webspace_id'] = $_SESSION['webspace_id'];
		
				$table = $db->prefix . "_webblock";
				
				$db->insertDb($rec, $table);
	
				$_REQUEST['webblock_id'] = $db->insertID();
			}
			else {
				$output_webblock['webblock_proposed_tag'] = $_POST['webblock_tag'];
				$output_webblock['webblock_body'] = $_POST['webblock_body'];
				$body->set('webblock', $output_webblock);
			}
		}
	}
	
	// SELECT WEBBLOCK ------------------------------------------------------------
	if (isset($_REQUEST['webblock_id'])) { // we are editing a page
		$query = "
			SELECT *
			FROM " . $db->prefix . "_webblock 
			WHERE webblock_id=" . $_REQUEST['webblock_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result)) {
			$body->set('webblock', $result);
		}
	}
	
	
	// SELECT WEBBLOCKS -----------------------------------------------------------
	$query = "
		SELECT webblock_id, webblock_tag, webblock_body 
		FROM " . $db->prefix . "_webblock
		WHERE
		webspace_id=" . $_SESSION['webspace_id'] . "
		ORDER BY webblock_tag desc"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$output_webblocks = $result;
	
		foreach($output_webblocks as $key => $i):
			if (isset($_REQUEST['webblock_id']) && $i['webblock_id'] == $_REQUEST['webblock_id']) {
				$body->set('webblock', $i);
			}
		endforeach;
	
		if (!empty($output_webblocks)) {
			$body->set('webblocks', $output_webblocks);
			$tpl->set('webblocks', $output_webblocks);
		}
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}

?>