<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";

if (!isset($_SESSION['md5'])) {
	header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . strip_tags(SID));
	exit;
}


// 	SELECT IDENTITIES WITH SEARCH CRITERIA SET -----------------------
$query = "
	SELECT identity_id  
	FROM " . $db->prefix . "_user_identity 
	WHERE 
	user_id=" . $_SESSION['user_id'] . " AND 
	identity_search=1"
;

$result = $db->SelectLimit($query, 1); //returns last 1 rows

if (isset($result->fields['identity_id'])) {
	
	$body->set('display_allow_search', 1);
	
	
	// SELECT MY METADATA --------------------------------------
	$query = "
		SELECT identity_metadata 
		FROM " . $db->prefix . "_user_identity 
		WHERE 
		user_id=" . $_SESSION['user_id'] . " AND 
		identity_search=1"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
	
		$output_my_metadata = array();
		
		while (!$result->EOF) {
			$temp = $result->fields;
			$temp_arr = explode(',', $temp['identity_metadata']);
			
			$output_my_metadata = array_merge($output_my_metadata, $temp_arr);
			
			$result->MoveNext();
		}
		
		$output_my_metadata = array_unique($output_my_metadata);
		sort($output_my_metadata);
		
		$body->set('my_metadata', $output_my_metadata);
		
	}
	
	
	// SELECT USER METADATA ------------------
	$query = "
		SELECT identity_metadata 
		FROM " . $db->prefix . "_user_identity 
		WHERE 
		user_id!=" . $_SESSION['user_id'] . " AND 
		identity_search=1"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result->fields)) {
	
		$output_user_metadata = array();
	
		while (!$result->EOF) {
			$temp1 = $result->fields['identity_metadata'];
			if (!empty($temp1)) {
				$temp_arr = explode(',', $temp1);
				
				$output_user_metadata = array_merge($output_user_metadata, $temp_arr);
			}
			
			$result->MoveNext();
		}
		
		$result->Close();
		
		$output_user_metadata = array_unique($output_user_metadata);
		sort($output_user_metadata);
		
		$body->set('user_metadata', $output_user_metadata);
		
	}
		
	// SELECT LOCATIONS ------------------
	$output_locations = $user->selLocations($_SESSION['language_id']);
	$body->set('locations', $output_locations);
	
	
	// SELECT IDENTITY CUSTOM FIELDS ------------------
	if (!empty($core_config['user']['identity']['custom_searchable'])) {
		include_once($language_path . 'inc/identity_common.inc.php');
		$output_custom_fields = array();
		
		foreach($core_config['user']['identity']['custom_searchable'] as $key => $i):
			$output_custom_fields[$core_config['user']['identity']['custom_searchable'][$key]] = $lang['identity']['custom'][$i];
		endforeach;
		
		$body->set('custom_fields', $output_custom_fields);
	}
	
	// COUNT SEARCHABLE USERS -------------------------------------------
	$query = "
		SELECT count(user_id) as total 
		FROM " . $db->prefix . "_user_identity 
		WHERE 
		identity_search=1"
	;
					
	$result = $db->Execute($query);
	
	$output_count_searchable_users = "0";
	
	if (isset($result->fields)) {
		if (!empty($result->fields['total'])) {
			$output_count_searchable_users = $result->fields['total'];
		}
	}	
	
	$lang['txt_searchable_users'] = str_replace("SYS_KEYWORD_COUNT", $output_count_searchable_users, $lang['txt_searchable_users']);
	
	
	// GET MY TAGS
	require_once('class/Tag.class.php');
	$tag = new Tag($db, null, $core_config['tag']['core']['network']);
	$tag->user_id = $_SESSION['user_id'];
	
	$output_tags = $tag->selTags(1);
	
	if (!empty($output_tags)) {
		$body->set('tags', $output_tags);
	}
	
	// BUILD SEARCH QUERY -----------------------------------------------
	if (isset($_POST['search']) || !empty($_REQUEST['meta'])) {
		// if no search criteria is filled we error
		if(empty($_REQUEST['meta']) && empty($_POST['search_text']) && empty($_POST['tag_body']) && empty($_POST['location_id']) && empty($_POST['custom_fields_id'])) {
			$GLOBALS['am_error_log'][] = array('empty_search');
		}
		elseif (!empty($_REQUEST['meta'])) {
			$query = "
				SELECT u.user_id, i.identity_nic, i.identity_metadata, l.location_name, 
				u.user_create_datetime, u.location_id, i.identity_id
				FROM " . $db->prefix . "_user u
				INNER JOIN " . $db->prefix . "_user_location l
				ON u.location_id=l.location_id
				INNER JOIN " . $db->prefix . "_user_identity i
				ON (u.user_id=i.user_id AND i.identity_search=1)
				WHERE i.identity_metadata like " . $db->qstr("%" . $_REQUEST['meta'] . "%", get_magic_quotes_gpc()) . " AND 
				1=1 
				ORDER BY 
				i.identity_nic"
			;
			
			// we need to exclude users who have blocked you - TC
			$result = $db->Execute($query);
			
			$output_search_results = array();
			
			if (isset($result->fields)) {
				while (!$result->EOF) {
					$temp1 = $result->fields;
					array_push($output_search_results, $temp1);
					$result->MoveNext();
				}
			}
			
			$body->set('search_results', $output_search_results);
			
		}
		else {
		
			if (isset($_POST['search_text'])) {
				$search_text = "'%" . $_POST['search_text'] . "%'";
			}
		
			$query = "
				SELECT u.user_id, i.identity_nic, i.identity_metadata, l.location_name, 
				u.user_create_datetime, u.location_id, i.identity_id
				FROM " . $db->prefix . "_user u
				INNER JOIN " . $db->prefix . "_user_location l
				ON u.location_id=l.location_id
				INNER JOIN " . $db->prefix . "_user_identity i
				ON (u.user_id=i.user_id AND i.identity_search=1)
				WHERE "
			;
			
			$query .= "(";
			
			if (!empty($_POST['search_text'])) {
				$query .= "i.identity_nic like " . $search_text . " OR ";
			}
			
			if (!empty($_REQUEST['meta'])) {
				$query .= "i.identity_metadata like " . $db->qstr("%" . $_REQUEST['meta'] . "%", get_magic_quotes_gpc()) . " OR ";
			}
			elseif (!empty($_POST['search_text'])) {
				$query .= "i.identity_metadata like " . $search_text . " OR ";
			}
			
			if (!empty($query_custom_field)) {
				$query .= $query_custom_field . " OR ";
			}
			
			if (!empty($_POST['location_id'])) {
				$query .= "u.location_id=" . $_POST['location_id'] . " OR ";
			}
			
			if (!empty($_POST['tag_body'])) {
				$query .= "
					(u.user_id=t.item_id AND 
					t.tag_type=" . $core_config['tag']['core']['network'] . " AND
					t.tag_body like " . $db->qstr("%" . $_POST['tag_body'] . "%", get_magic_quotes_gpc()) . ") OR "
				;
			}
			
			//remove last OR
			$query = substr($query, 0, -3);
			$query .= ") AND ";
			
			$query .= "1=1 ";
			
			$query .= "ORDER BY " . $_POST['sort_by'];
		
			// we need to exclude users who have blocked you
			$result = $db->Execute($query);
			
			$output_search_results = array();
			
			if (isset($result->fields)) {
				while (!$result->EOF) {
					$temp1 = $result->fields;
					array_push($output_search_results, $temp1);
					$result->MoveNext();
				}
			}
			
			$body->set('search_text', $_POST['search_text']);
			$body->set('search_results', $output_search_results);
		}
		
		$body->set('search_performed', 1);
	}
	
}
	
?>