<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

if (!empty($_POST['group_id'])) { // page under group section
    //setup group
	$group_id = $_REQUEST['group_id'];
	include "inc/header_group.inc.php";
	require_once($languagePath . 'g_common.lang.php');
}

// SETUP TAGS
require_once($c_node['dir']['class_path'] . 'Tag.class.php');
$tag = new Tag($db, null);
if (isset($group_id)) {
	$tag->group_id = $group_id;
	$output_group_tags = $tag->selTags();
}
else {
	$tag->rsp_item_type_id = $c_node['rsp']['item_type']['network'];
	$output_network_tags = $tag->selTags('network');
	$tag->user_id = $me['user_id'];
	$output_my_tags = $tag->selTags();
}


// setup images
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


if ((isset($frmdata['search_text']) && strlen(trim($frmdata['search_text'])) >= 3) || !empty($_REQUEST['tag'])) {
	
	if (isset($frmdata['search_text'])) {
		$search_text = trim($frmdata['search_text']);
	}
	else {
		$search_text = null;
	}
	
	
	// GROUP SEARCH --------------------------------------------------
	if (!isset($group_id) && isset($search_text)) {
		require_once($languageArrayPath . 'arr_category.lang.php');
		require_once($languageArrayPath . 'arr_group.lang.php');
		require_once($c_node['dir']['class_path'] . 'Group.class.php');
		$group = new Group($db, $date, $file);
		$group->registration_types = $c_node['group']['registration_type'];
		$group->group_visibility = 1;
		$output_groups = $group->getGroups($search_text);
	}
	
	
	//get blogs -----------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Blog.class.php');
	$blog = new Blog($db, null, $date, null);
	$blog->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$blog->rsp_status_id = $c_node['rsp']['status']['live'];
	$blog->item_types = $c_node['rsp']['item_type'];
	$blog->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$blog->tag = $_REQUEST['tag'];
	}
	
	if (isset($frmdata['degree_friend'])) {
		$blog->degree_id = $degree_id;
		$blog->rsp_item_type_ids = $c_node['rsp']['rsp_level']['degree'];
		$blog->user_ids = $user->user_ids;
	}
	
	if (!empty($group_id)) { // search under group section
		$blog->group_id = $group_id;
	}
	else {
		$blog->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
	}
	
	$output_blogs = $blog->selBlogs($search_text);
	
	//get the tags for each item
	if (!empty($output_blogs)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		foreach ($output_blogs as $key => $i):
			$tag->item_id = $i['blog_id'];
			$output_blogs[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	//get library items -----------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Library.class.php');
	$library = new Library($db, null, $date, null);
	$library->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$library->rsp_status_id = $c_node['rsp']['status']['live'];
	$library->item_types = $c_node['rsp']['item_type'];
	$library->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$library->tag = $_REQUEST['tag'];
	}
	
	if (isset($frmdata['degree_friend'])) {
		$library->degree_id = $degree_id;
		$library->rsp_item_type_ids = $c_node['rsp']['rsp_level']['degree'];
		$library->user_ids = $user->user_ids;
	}
	
	if (!empty($group_id)) { // search under group section
		$library->group_id = $group_id;
	}
	else {
		$library->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
	}
	
	$output_library_items = $library->selLibraryItems($search_text);
	
	//get the tags for each item
	if (!empty($output_library_items)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		foreach ($output_library_items as $key => $i):
			$tag->item_id = $i['library_id'];
			$output_library_items[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	//get polls  -----------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Poll.class.php');
	$poll = new Poll($db, null, $date);
	$poll->order_by = "p.poll_start_datetime desc";
	$poll->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$poll->rsp_status_id = $c_node['rsp']['status']['live'];
	$poll->item_types = $c_node['rsp']['item_type'];
	$poll->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$poll->tag = $_REQUEST['tag'];
	}
	
	if (isset($frmdata['degree_friend'])) {
		$poll->degree_id = $degree_id;
		$poll->rsp_item_type_ids = $c_node['rsp']['rsp_level']['degree'];
		$poll->user_ids = $user->user_ids;
	}
	
	if (!empty($group_id)) { // search under group section
		$poll->group_id = $group_id;
	}
	else {
		$poll->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
	}
	
	$output_polls = $poll->selPolls($search_text);
	
	//get the tags for each item
	if (!empty($output_polls)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
		foreach ($output_polls as $key => $i):
			$tag->item_id = $i['poll_id'];
			$output_polls[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	//get subjects  -----------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Forum.class.php');
	$forum = new Forum($db, null, $date, null);
	$forum->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$forum->rsp_status_id = $c_node['rsp']['status']['live'];
	$forum->item_types = $c_node['rsp']['item_type'];
	$forum->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$forum->tag = $_REQUEST['tag'];
	}
	
	if (isset($frmdata['degree_friend'])) {
		$forum->degree_id = $degree_id;
		$forum->rsp_item_type_ids = $c_node['rsp']['rsp_level']['degree'];
		$forum->user_ids = $user->user_ids;
	}
	
	if (!empty($group_id)) { // search under group section
		$forum->group_id = $group_id;
	}
	else {
		$forum->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
	}
	
	$output_subjects = $forum->selSubjects($search_text);
	
	//get the tags for each item
	if (!empty($output_subjects)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
		foreach ($output_subjects as $key => $i):
			$tag->item_id = $i['subject_id'];
			$output_subjects[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	// ACTIVITY SEARCH --------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Schedule.class.php');
	require_once($languageArrayPath . 'arr_schedule.lang.php');
	$schedule = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
	$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
	$schedule->item_types = $c_node['rsp']['item_type'];
	$schedule->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$schedule->tag = $_REQUEST['tag'];
	}
	
	if (isset($frmdata['degree_friend'])) {
		$schedule->degree_id = $degree_id;
		$schedule->rsp_item_type_ids = $c_node['rsp']['rsp_level']['degree'];
		$schedule->user_ids = $user->user_ids;
	}
	
	if (!empty($group_id)) { // search under group section
		$schedule->group_id = $group_id;
	}
	else {
		$schedule->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
	}
	
	$schedule->schedule_type_id = $c_node['schedule']['type']['event'];
	$output_activities = $schedule->selScheduleItems($search_text);;
	$schedule->schedule_type_id = $c_node['schedule']['type']['task'];
	$output_tasks = $schedule->selScheduleItems($search_text);
	
	//get the tags for each item
	if (!empty($output_activities)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		foreach ($output_activities as $key => $i):
			$tag->item_id = $i['schedule_id'];
			$output_activities[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	if (!empty($output_tasks)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		foreach ($output_tasks as $key => $i):
			$tag->item_id = $i['schedule_id'];
			$output_tasks[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
}
elseif (isset($data['search_text']) && strlen(trim($data['search_text'])) < 3) {
	$GLOBALS['am_error_log'][] = array(41, null, null);
}
else {
	//ERROR NO SEARCH TEXT
}






//move to template
if (!empty($_REQUEST['tag'])) {
	$body->set('tag', $_REQUEST['tag']);
}
elseif (!empty($search_text)) {
	$body->set('tag', $search_text);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_group_tags)) {
	$body->set('group_tags', $output_group_tags);
}

if (!empty($output_network_tags)) {
	$body->set('network_tags', $output_network_tags);
}

if (!empty($output_subjects)) {
    $body->set('subjects', $output_subjects);
}

if (!empty($output_activities)) {
	$body->set('activities', $output_activities);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
}

if (!empty($output_blogs)) {
    $body->set('blogs', $output_blogs);
}

if (!empty($output_groups)) {
    $body->set('groups', $output_groups);
}

if (!empty($output_library_items)) {
    $body->set('library_items', $output_library_items);
}

if (!empty($output_polls)) {
    $body->set('polls', $output_polls);
}


if (!empty($output_friends)) {
    $body->set('users', $output_friends);
}



if (!empty($search_text)) {
    $body->set('search_text', $search_text);
	$lang['txt_search_results'] = str_replace("SEARCHTEXT", "\"" . $search_text . "\"", $lang['txt_search_results']);
}

$template_pageLink = $lang['txt_search'];
include "inc/footer.inc.php";

?>
