/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ByteVector;
import gnu.lists.IntSequence;
import gnu.math.UByte;

public class U8Vector
extends ByteVector<UByte> {
    public U8Vector() {
        this.data = empty;
    }

    public U8Vector(int size, byte value) {
        byte[] array = new byte[size];
        this.data = array;
        if (value != 0) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public U8Vector(int size) {
        this(new byte[size]);
    }

    public U8Vector(byte[] data) {
        this.data = data;
    }

    public U8Vector(byte[] data, IntSequence indexes) {
        this.data = data;
        this.indexes = indexes;
    }

    public U8Vector(byte[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index] & 0xFF;
    }

    @Override
    public final UByte get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return UByte.valueOf(this.data[index]);
    }

    @Override
    public final UByte getBuffer(int index) {
        return UByte.valueOf(this.data[index]);
    }

    @Override
    public final void setBuffer(int index, UByte value) {
        this.data[index] = value.byteValue();
    }

    protected U8Vector withIndexes(IntSequence ind) {
        return new U8Vector(this.data, ind);
    }

    @Override
    public U8Vector subList(int fromIx, int toIx) {
        return new U8Vector(this.data, this.indexesSubList(fromIx, toIx));
    }

    public int getElementKind() {
        return 17;
    }

    @Override
    public String getTag() {
        return "u8";
    }

    public int compareTo(Object obj) {
        return U8Vector.compareToInt(this, (U8Vector)obj);
    }
}

