/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.Consumer;
import gnu.text.CharMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class Char
implements Comparable,
Externalizable {
    int value;
    static Char[] ascii;
    static CharMap hashTable;
    static char[] charNameValues;
    static String[] charNames;

    public Char() {
    }

    Char(int ch) {
        this.value = ch;
    }

    public void print(Consumer out) {
        Char.print(this.value, out);
    }

    public static void print(int i, Appendable out) {
        try {
            Char.append(i, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void append(int i, Appendable out) throws IOException {
        if (i >= 65536) {
            out.append((char)((i - 65536 >> 10) + 55296));
            out.append((char)((i & 0x3FF) + 56320));
        } else {
            out.append((char)i);
        }
    }

    public final char charValue() {
        return (char)this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Char make(int ch) {
        if (ch < 128) {
            return ascii[ch];
        }
        CharMap charMap = hashTable;
        synchronized (charMap) {
            return hashTable.get(ch);
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Char && ((Char)obj).intValue() == this.value;
    }

    public static int nameToChar(String name) {
        char ch;
        int i = charNames.length;
        while (--i >= 0) {
            if (!charNames[i].equals(name)) continue;
            return charNameValues[i];
        }
        i = charNames.length;
        while (--i >= 0) {
            if (!charNames[i].equalsIgnoreCase(name)) continue;
            return charNameValues[i];
        }
        int len = name.length();
        if (len > 1 && name.charAt(0) == 'u') {
            int value = 0;
            int pos = 1;
            while (true) {
                if (pos == len) {
                    return value;
                }
                int dig = Character.digit(name.charAt(pos), 16);
                if (dig < 0) break;
                value = (value << 4) + dig;
                ++pos;
            }
        }
        if (len == 3 && name.charAt(1) == '-' && ((ch = name.charAt(0)) == 'c' || ch == 'C')) {
            ch = name.charAt(2);
            return ch & 0x1F;
        }
        return -1;
    }

    public String toString() {
        return Char.toString(this.value);
    }

    public static String toString(int value) {
        StringBuffer buf = new StringBuffer();
        buf.append('\'');
        if (value >= 32 && value < 127 && value != 39) {
            buf.append((char)value);
        } else {
            buf.append('\\');
            if (value == 39) {
                buf.append('\'');
            } else if (value == 10) {
                buf.append('n');
            } else if (value == 13) {
                buf.append('r');
            } else if (value == 9) {
                buf.append('t');
            } else if (value < 256) {
                String str = Integer.toOctalString(value);
                int i = 3 - str.length();
                while (--i >= 0) {
                    buf.append('0');
                }
                buf.append(str);
            } else {
                buf.append('u');
                String str = Integer.toHexString(value);
                int i = 4 - str.length();
                while (--i >= 0) {
                    buf.append('0');
                }
                buf.append(str);
            }
        }
        buf.append('\'');
        return buf.toString();
    }

    public static String toScmReadableString(int ch) {
        StringBuffer sbuf = new StringBuffer(20);
        sbuf.append("#\\");
        for (int i = 0; i < charNameValues.length; ++i) {
            if ((char)ch != charNameValues[i]) continue;
            sbuf.append(charNames[i]);
            return sbuf.toString();
        }
        if (ch < 32 || ch > 127) {
            sbuf.append('x');
            sbuf.append(Integer.toString(ch, 16));
        } else {
            sbuf.append((char)ch);
        }
        return sbuf.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.value > 55296) {
            if (this.value > 65535) {
                out.writeChar((this.value - 65536 >> 10) + 55296);
                this.value = (this.value & 0x3FF) + 56320;
            } else if (this.value <= 56319) {
                out.writeChar(this.value);
                this.value = 0;
            }
        }
        out.writeChar(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        char next;
        this.value = in.readChar();
        if (this.value >= 55296 && this.value < 56319 && (next = in.readChar()) >= '\udc00' && next <= '\udfff') {
            this.value = (this.value - 55296 << 10) + (next - 56320) + 65536;
        }
    }

    public Object readResolve() throws ObjectStreamException {
        return Char.make(this.value);
    }

    public int compareTo(Object o) {
        return this.value - ((Char)o).value;
    }

    static {
        hashTable = new CharMap();
        ascii = new Char[128];
        int i = 128;
        while (--i >= 0) {
            Char.ascii[i] = new Char(i);
        }
        charNameValues = new char[]{' ', '\t', '\n', '\n', '\r', '\f', '\b', '\u001b', '\u007f', '\u007f', '\u007f', '\u0007', '\u0007', '\u000b', '\u0000'};
        charNames = new String[]{"space", "tab", "newline", "linefeed", "return", "page", "backspace", "esc", "delete", "del", "rubout", "alarm", "bel", "vtab", "nul"};
    }
}

