/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.tool.user.KeyBindingManager;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.KeyBindings;
import com.sun.electric.tool.user.ui.KeyStrokePair;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.EtchedBorder;

public class EditKeyBinding
extends EDialog {
    private EMenuItem menuItem;
    private EMenuBar menuBar;
    private KeyStroke key1;
    private KeyStroke key2;
    private JButton addButton;
    private JButton cancelButton;
    private JLabel conflictsLabel;
    private JList conflictsList;
    private JLabel header;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel optionalLabel;
    private JTextField stroke1Input;
    private JLabel stroke1Label;
    private JTextField stroke2Input;
    private JLabel stroke2Label;

    public EditKeyBinding(EMenuItem item, EMenuBar menuBar) {
        super((Frame)null, true);
        this.menuItem = item;
        this.menuBar = menuBar;
        this.key1 = null;
        this.key2 = null;
        this.initComponents();
        this.initDialog();
        this.finishInitialization();
    }

    private void initComponents() {
        this.header = new JLabel();
        this.stroke1Label = new JLabel();
        this.stroke1Input = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.optionalLabel = new JLabel();
        this.stroke2Label = new JLabel();
        this.stroke2Input = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.conflictsLabel = new JLabel();
        this.conflictsList = new JList();
        this.jSeparator3 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditKeyBinding.this.closeDialog(evt);
            }
        });
        this.header.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.header, gridBagConstraints);
        this.stroke1Label.setText("First stroke:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.stroke1Label, gridBagConstraints);
        this.stroke1Input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditKeyBinding.this.stroke1InputKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                EditKeyBinding.this.stroke1InputKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                EditKeyBinding.this.stroke1InputKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 7, 2, 7);
        this.getContentPane().add((Component)this.stroke1Input, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.optionalLabel.setText("(Optional):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.optionalLabel, gridBagConstraints);
        this.stroke2Label.setText("Second stroke:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.stroke2Label, gridBagConstraints);
        this.stroke2Input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditKeyBinding.this.stroke2InputKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                EditKeyBinding.this.stroke2InputKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                EditKeyBinding.this.stroke2InputKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.stroke2Input, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.conflictsLabel.setText("Conflicts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.conflictsLabel, gridBagConstraints);
        this.conflictsList.setBorder(new EtchedBorder());
        this.conflictsList.setPreferredSize(new Dimension(220, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.conflictsList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditKeyBinding.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this.addButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditKeyBinding.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void initDialog() {
        String description = this.menuItem.getDescription();
        this.header.setText("Add Key Binding for:  " + description);
        this.pack();
    }

    private void stroke2InputKeyTyped(KeyEvent evt) {
        evt.consume();
    }

    private void stroke2InputKeyReleased(KeyEvent evt) {
        evt.consume();
    }

    private void stroke2InputKeyPressed(KeyEvent evt) {
        if (!KeyBindingManager.validKeyEvent(evt)) {
            return;
        }
        this.key2 = KeyStroke.getKeyStrokeForEvent(evt);
        this.stroke2Input.setText(KeyStrokePair.keyStrokeToString(this.key2));
        this.updateConflicts();
        evt.consume();
    }

    private void stroke1InputKeyTyped(KeyEvent evt) {
        evt.consume();
    }

    private void stroke1InputKeyReleased(KeyEvent evt) {
        evt.consume();
    }

    private void stroke1InputKeyPressed(KeyEvent evt) {
        if (!KeyBindingManager.validKeyEvent(evt)) {
            return;
        }
        this.key1 = KeyStroke.getKeyStrokeForEvent(evt);
        this.stroke1Input.setText(KeyStrokePair.keyStrokeToString(this.key1));
        this.addButton.setEnabled(this.updateConflicts());
        evt.consume();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        KeyStroke prefixStroke = this.getStroke(this.stroke1Input);
        KeyStroke stroke = this.getStroke(this.stroke2Input);
        if (prefixStroke == null) {
            this.dialogBadInput();
            return;
        }
        ListModel model = this.conflictsList.getModel();
        int removeConflicts = 1;
        if (model.getSize() != 0) {
            removeConflicts = this.removeConflictsDialog(model);
        }
        if (removeConflicts == 2) {
            return;
        }
        if (removeConflicts == 0) {
            List<KeyBindings> conflicts = this.getConflicts();
            for (KeyBindings k : conflicts) {
                Iterator<KeyStrokePair> kit = k.getKeyStrokePairs();
                while (kit.hasNext()) {
                    KeyStrokePair pair2 = kit.next();
                    this.menuBar.removeKeyBinding(k.getActionDesc(), pair2);
                }
            }
        }
        if (stroke == null) {
            stroke = prefixStroke;
            prefixStroke = null;
        }
        this.menuBar.addUserKeyBinding(this.menuItem, stroke, prefixStroke);
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
    }

    private boolean updateConflicts() {
        List<KeyBindings> conflicts = this.getConflicts();
        if (conflicts != null && conflicts.size() != 0) {
            String[] objects = new String[conflicts.size()];
            for (int i = 0; i < conflicts.size(); ++i) {
                String s;
                KeyBindings k = conflicts.get(i);
                objects[i] = s = k.getActionDesc() + "  [ " + k.bindingsToString() + " ]";
            }
            this.conflictsList.setListData(objects);
            return true;
        }
        this.clearConflictsList();
        if ((this.key1.getModifiers() & 8) != 0) {
            TopLevel top = TopLevel.getCurrentJFrame();
            EMenuBar menuBar = top.getEMenuBar();
            for (EMenuItem menu : menuBar.getItems()) {
                KeyStroke ksRes;
                char reservedAlt = menu.getMnemonicChar();
                if (reservedAlt == '\u0000' || (ksRes = KeyStroke.getKeyStroke((int)reservedAlt, 8)) != this.key1) continue;
                String[] objects = new String[]{"Pulldown menu: " + menu.getText()};
                System.out.println("Stroke is pre-reserved for \"" + objects[0] + "\" and it can't be modified.");
                this.conflictsList.setListData(objects);
                return false;
            }
        }
        return true;
    }

    private void clearConflictsList() {
        this.conflictsList.setListData(new Object[0]);
    }

    private List<KeyBindings> getConflicts() {
        KeyStroke key1 = this.getStroke(this.stroke1Input);
        if (key1 == null) {
            this.clearConflictsList();
            return null;
        }
        KeyStroke key2 = this.getStroke(this.stroke2Input);
        KeyStroke prefixStroke = key1;
        KeyStroke stroke = key2;
        if (key2 == null) {
            stroke = key1;
            prefixStroke = null;
        }
        KeyStrokePair pair2 = KeyStrokePair.getKeyStrokePair(prefixStroke, stroke);
        return KeyBindingManager.getConflictsAllManagers(pair2);
    }

    private KeyStroke getStroke(JTextField field2) {
        String str = field2.getText();
        return KeyStrokePair.stringToKeyStroke(str);
    }

    private int removeConflictsDialog(ListModel model) {
        StringBuffer buf = new StringBuffer();
        buf.append("The following conflicts exists. Would you like to remove them?\n");
        for (int i = 0; i < model.getSize(); ++i) {
            buf.append(model.getElementAt(i).toString() + "\n");
        }
        Object[] options = new Object[]{"Remove All", "Leave All", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, buf.toString(), "Conflicts Exist", -1, 2, null, options, options[2]);
        return n;
    }

    private void dialogBadInput() {
        JOptionPane.showMessageDialog(null, "I cannot bind to the First Stroke key you have specified.  Sorry", "Invalid Input", 2);
    }
}

