/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

class ExecProcess
extends Thread {
    private final String command;
    private final String[] exec;
    private final String[] envVars;
    private final File dir;
    private final OutputStream outStreamRedir;
    private final OutputStream errStreamRedir;
    private PrintWriter processWriter;
    private ExecProcessReader outReader;
    private ExecProcessReader errReader;
    private Process p = null;

    public ExecProcess(String command, String[] envVars, File dir, OutputStream outStreamRedir, OutputStream errStreamRedir) {
        this.command = command;
        this.exec = null;
        this.envVars = envVars;
        this.dir = dir;
        this.outStreamRedir = outStreamRedir;
        this.errStreamRedir = errStreamRedir;
        this.processWriter = null;
        this.setName(command);
    }

    public ExecProcess(String[] exec, String[] envVars, File dir, OutputStream outStreamRedir, OutputStream errStreamRedir) {
        this.command = null;
        this.exec = exec;
        this.envVars = envVars;
        this.dir = dir;
        this.outStreamRedir = outStreamRedir;
        this.errStreamRedir = errStreamRedir;
        this.processWriter = null;
        this.setName(exec[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Runtime rt = Runtime.getRuntime();
            this.outReader = null;
            this.errReader = null;
            ExecProcess execProcess = this;
            synchronized (execProcess) {
                this.p = this.command != null ? rt.exec(this.command, this.envVars, this.dir) : rt.exec(this.exec, this.envVars, this.dir);
                this.outReader = new ExecProcessReader(this.p.getInputStream(), this.outStreamRedir);
                this.errReader = new ExecProcessReader(this.p.getErrorStream(), this.errStreamRedir);
                this.outReader.start();
                this.errReader.start();
                BufferedOutputStream bufout = new BufferedOutputStream(this.p.getOutputStream());
                this.processWriter = new PrintWriter(bufout);
            }
            int exitVal = this.p.waitFor();
            if (this.outStreamRedir != null) {
                this.outReader.join();
            }
            if (this.errStreamRedir != null) {
                this.errReader.join();
            }
            StringBuffer com = new StringBuffer();
            if (this.command != null) {
                com.append(this.command);
            } else {
                for (int i = 0; i < this.exec.length; ++i) {
                    com.append(this.exec[i] + " ");
                }
            }
            System.out.println("Process finished [exit: " + exitVal + "]: " + com.toString());
            ExecProcess execProcess2 = this;
            synchronized (execProcess2) {
                if (this.processWriter != null) {
                    this.processWriter.close();
                    this.processWriter = null;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String line) {
        ExecProcess execProcess = this;
        synchronized (execProcess) {
            if (this.processWriter == null) {
                System.out.println("No process to write to: " + line);
                return;
            }
            this.processWriter.println(line);
            this.processWriter.flush();
        }
    }

    public synchronized void destroyProcess() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public static class ExecProcessReader
    extends Thread {
        private InputStream in;
        private OutputStream redirect;

        public ExecProcessReader(InputStream in) {
            this(in, null);
            this.setDaemon(true);
        }

        public ExecProcessReader(InputStream in, OutputStream redirect) {
            this.in = in;
            this.redirect = redirect;
            this.setName("ExecProcessReader");
        }

        @Override
        public void run() {
            try {
                PrintWriter pw = null;
                if (this.redirect != null) {
                    pw = new PrintWriter(this.redirect);
                }
                InputStreamReader input2 = new InputStreamReader(this.in);
                BufferedReader reader = new BufferedReader(input2);
                Object line = null;
                char[] cbuf = new char[256];
                int read2 = 0;
                while ((read2 = reader.read(cbuf, 0, 256)) > -1) {
                    if (pw == null) continue;
                    pw.write(cbuf, 0, read2);
                    pw.flush();
                }
                reader.close();
                input2.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

