/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IDEStructure;
import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.datastructures.IWorkStealing;
import com.sun.electric.tool.util.concurrent.datastructures.UnboundedDEQueue;
import com.sun.electric.tool.util.concurrent.debug.Debug;
import com.sun.electric.tool.util.concurrent.debug.StealTracker;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.MultiThreadedRandomizer;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkStealingStructure<T>
extends IStructure<T>
implements IWorkStealing {
    protected Map<Long, IDEStructure<T>> dataQueues = ConcurrentCollectionFactory.createConcurrentHashMap();
    protected Map<Long, Long> dataQueuesMapping = ConcurrentCollectionFactory.createConcurrentHashMap();
    private List<Long> freeInternalIds = ConcurrentCollectionFactory.createConcurrentList();
    protected MultiThreadedRandomizer randomizer;
    private StealTracker stealTracker;
    private boolean debug;

    public WorkStealingStructure(int numOfThreads) {
        this(numOfThreads, false);
    }

    public WorkStealingStructure(int numOfThreads, boolean debug) {
        this.randomizer = new MultiThreadedRandomizer(numOfThreads);
        this.stealTracker = StealTracker.getInstance();
        for (long i = 0L; i < (long)numOfThreads; ++i) {
            this.freeInternalIds.add(i);
            this.dataQueues.put(i, new UnboundedDEQueue(4));
        }
        this.debug = debug;
    }

    @Override
    public void add(T item) {
        this.add(item, -1);
    }

    @Override
    public void add(T item, int i) {
        Long osThreadId = this.getThreadId();
        Long localQueueId = this.dataQueuesMapping.get(osThreadId);
        if (i == -1) {
            IDEStructure<T> ownQueue;
            if (localQueueId != null && (ownQueue = this.dataQueues.get(localQueueId)) != null) {
                ownQueue.add(item);
                return;
            }
            int foreignQueue = this.randomizer.getRandomizer().nextInt(this.dataQueues.size());
            this.dataQueues.get(foreignQueue).add(item);
        } else {
            this.dataQueues.get(i).add(item);
        }
    }

    protected Long getThreadId() {
        return Thread.currentThread().getId();
    }

    @Override
    public boolean isEmpty() {
        IDEStructure<T> ownQueue = this.dataQueues.get(this.getThreadId());
        if (ownQueue != null) {
            return ownQueue.isEmpty();
        }
        return false;
    }

    @Override
    public T remove() {
        Long osThreadId = this.getThreadId();
        Long localQueueId = this.dataQueuesMapping.get(osThreadId);
        if (localQueueId == null) {
            throw new Error("Thread not registered");
        }
        T result2 = null;
        IDEStructure<T> ownQueue = this.dataQueues.get(localQueueId);
        if (ownQueue != null) {
            result2 = ownQueue.remove();
        }
        for (int i = 1; result2 == null && i < this.dataQueues.size(); ++i) {
            result2 = this.dataQueues.get(Long.valueOf((long)i + localQueueId) % (long)this.dataQueues.size()).getFromTop();
            if (result2 == null) {
                int foreigner = this.randomizer.getRandomizer().nextInt(this.dataQueues.size());
                result2 = this.dataQueues.get(foreigner).getFromTop();
            }
            if (result2 == null || !this.debug) continue;
            this.stealTracker.countSteal();
        }
        return result2;
    }

    @Override
    public synchronized void registerThread() {
        if (this.freeInternalIds.size() > 0) {
            Long myId = this.freeInternalIds.remove(0);
            this.dataQueuesMapping.put(this.getThreadId(), myId);
        }
    }

    public static WorkStealingStructure<PTask> createForThreadPool(int numOfThreads) {
        return new WorkStealingStructure<PTask>(numOfThreads, Debug.isDebug());
    }
}

