/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.user.ui.KeyStrokePair;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBindings
implements ActionListener {
    private String actionDesc;
    private List<KeyStrokePair> keyStrokePairs;
    private List<KeyStrokePair> defaultKeyStrokePairs;
    private List<ActionListener> actionListeners;
    private Object eventSource;
    private boolean usingDefaultKeys;
    private boolean enabled;
    private static final String sep = "; ";

    public KeyBindings(String actionDesc) {
        this.actionDesc = actionDesc;
        this.keyStrokePairs = new ArrayList<KeyStrokePair>();
        this.defaultKeyStrokePairs = new ArrayList<KeyStrokePair>();
        this.actionListeners = new ArrayList<ActionListener>();
        this.eventSource = null;
        this.usingDefaultKeys = true;
        this.enabled = true;
    }

    public void addKeyBinding(KeyStroke prefixStroke, KeyStroke stroke) {
        KeyStrokePair k = KeyStrokePair.getKeyStrokePair(prefixStroke, stroke);
        this.keyStrokePairs.add(k);
    }

    public void addKeyBinding(KeyStrokePair k) {
        this.keyStrokePairs.add(k);
    }

    public void addKeyBindings(String str) {
        String[] pairs = str.split(sep);
        for (int i = 0; i < pairs.length; ++i) {
            String pair2 = pairs[i];
            KeyStrokePair k = KeyStrokePair.getKeyStrokePair(pair2);
            if (k == null) continue;
            this.keyStrokePairs.add(k);
        }
    }

    public void removeKeyBinding(KeyStrokePair k) {
        this.keyStrokePairs.remove(k);
    }

    public void addDefaultKeyBinding(KeyStroke prefixStroke, KeyStroke stroke) {
        KeyStrokePair k = KeyStrokePair.getKeyStrokePair(prefixStroke, stroke);
        this.defaultKeyStrokePairs.add(k);
    }

    public void addDefaultKeyBinding(KeyStrokePair k) {
        this.defaultKeyStrokePairs.add(k);
    }

    public void clearKeyBindings() {
        this.keyStrokePairs.clear();
    }

    public void addActionListener(ActionListener a) {
        this.actionListeners.add(a);
    }

    public void removeActionListener(ActionListener a) {
        this.actionListeners.remove(a);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.enabled) {
            return;
        }
        if (this.eventSource != null) {
            e.setSource(this.eventSource);
        }
        for (ActionListener action : this.actionListeners) {
            action.actionPerformed(e);
        }
    }

    public String bindingsToString() {
        StringBuffer buf = new StringBuffer("");
        Iterator<KeyStrokePair> it = this.keyStrokePairs.iterator();
        while (it.hasNext()) {
            KeyStrokePair k = it.next();
            buf.append(k.toString());
            if (!it.hasNext()) continue;
            buf.append(sep);
        }
        return buf.toString();
    }

    public String describe() {
        return "KeyBindings for '" + this.actionDesc + "': [ " + this.bindingsToString() + " ]";
    }

    public String getActionDesc() {
        return this.actionDesc;
    }

    public Iterator<ActionListener> getActionListeners() {
        return this.actionListeners.iterator();
    }

    public Iterator<KeyStrokePair> getKeyStrokePairs() {
        return this.keyStrokePairs.iterator();
    }

    public Iterator<KeyStrokePair> getDefaultKeyStrokePairs() {
        return this.defaultKeyStrokePairs.iterator();
    }

    public void setEventSource(Object source) {
        this.eventSource = source;
    }

    public void setUsingDefaultKeys(boolean b) {
        this.usingDefaultKeys = b;
    }

    public boolean getUsingDefaultKeys() {
        return this.usingDefaultKeys;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean getEnabled() {
        return this.enabled;
    }
}

