/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.Users;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ProjectManagementTab
extends PreferencePanel {
    private String initialRepository;
    private String initialUserName;
    private JList userList;
    private DefaultListModel userModel;
    private boolean authorized;
    private JButton addButton;
    private JButton authorizeButton;
    private JButton browseButton;
    private JLabel currentUserLabel;
    private JButton deleteButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JButton loginButton;
    private JLabel midWarning;
    private JButton passwordButton;
    private JPanel projectManagement;
    private JPanel repositoryPanel;
    private JTextArea repositoryTextArea;
    private JScrollPane userListPane;
    private JTextField userName;
    private JPanel usersPanelLowSecurity;
    private JPanel usersPanelMidSecurity;

    public ProjectManagementTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.projectManagement.remove(this.usersPanelMidSecurity);
        this.repositoryPanel.remove(this.midWarning);
        this.pack();
    }

    public JPanel getUserPreferencesPanel() {
        return this.projectManagement;
    }

    public String getName() {
        return "Project Management";
    }

    public void init() {
        this.initialRepository = Project.getRepositoryLocation();
        this.repositoryTextArea.setText(this.initialRepository);
        this.initialUserName = Project.getCurrentUserName();
        if (this.initialUserName.length() == 0) {
            this.initialUserName = System.getProperty("user.name");
        }
        this.userName.setText(this.initialUserName);
    }

    public void term() {
        String uName;
        String currRepository = this.repositoryTextArea.getText();
        if (!currRepository.equals(this.initialRepository)) {
            Project.setRepositoryLocation(currRepository);
        }
        if (!(uName = this.userName.getText()).equals(this.initialUserName)) {
            Project.setCurrentUserName(uName);
        }
    }

    public void reset() {
        if (!Project.getFactoryRepositoryLocation().equals(Project.getRepositoryLocation())) {
            Project.setRepositoryLocation(Project.getFactoryRepositoryLocation());
        }
        if (!Project.getFactoryCurrentUserName().equals(Project.getCurrentUserName())) {
            Project.setCurrentUserName(Project.getFactoryCurrentUserName());
        }
    }

    private void reloadUsers() {
        this.userModel.clear();
        Iterator<String> it = Users.getUsers();
        while (it.hasNext()) {
            String userName = it.next();
            this.userModel.addElement(userName);
        }
    }

    private void initComponents() {
        this.projectManagement = new JPanel();
        this.repositoryPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.browseButton = new JButton();
        this.repositoryTextArea = new JTextArea();
        this.midWarning = new JLabel();
        this.usersPanelMidSecurity = new JPanel();
        this.currentUserLabel = new JLabel();
        this.userListPane = new JScrollPane();
        this.jLabel5 = new JLabel();
        this.jPanel1 = new JPanel();
        this.deleteButton = new JButton();
        this.addButton = new JButton();
        this.authorizeButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.loginButton = new JButton();
        this.passwordButton = new JButton();
        this.usersPanelLowSecurity = new JPanel();
        this.jLabel3 = new JLabel();
        this.userName = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Project Management");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ProjectManagementTab.this.closeDialog(evt);
            }
        });
        this.projectManagement.setLayout(new GridBagLayout());
        this.repositoryPanel.setLayout(new GridBagLayout());
        this.repositoryPanel.setBorder(new TitledBorder("Repository"));
        this.jLabel1.setText("The repository contains the latest version of your circuit,");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.repositoryPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel4.setText("Currently:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.repositoryPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel6.setText("a history of changes to each cell, and the user database.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.repositoryPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("It must be a directory that everyone can access (on a network).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.repositoryPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagementTab.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.repositoryPanel.add((Component)this.browseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.repositoryPanel.add((Component)this.repositoryTextArea, gridBagConstraints);
        this.midWarning.setText("When changing the repository location, restart the dialog to see users.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.repositoryPanel.add((Component)this.midWarning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        this.projectManagement.add((Component)this.repositoryPanel, gridBagConstraints);
        this.usersPanelMidSecurity.setLayout(new GridBagLayout());
        this.currentUserLabel.setText("Logged-in user:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.usersPanelMidSecurity.add((Component)this.currentUserLabel, gridBagConstraints);
        this.userListPane.setPreferredSize(new Dimension(100, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.usersPanelMidSecurity.add((Component)this.userListPane, gridBagConstraints);
        this.jLabel5.setText("Users:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.usersPanelMidSecurity.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Administration"));
        this.deleteButton.setText("Delete User");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagementTab.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.deleteButton, gridBagConstraints);
        this.addButton.setText("Add User...");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagementTab.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.addButton, gridBagConstraints);
        this.authorizeButton.setText("Authorize...");
        this.authorizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagementTab.this.authorizeButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.authorizeButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.usersPanelMidSecurity.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.usersPanelMidSecurity.add((Component)this.jSeparator1, gridBagConstraints);
        this.loginButton.setText("Login");
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagementTab.this.loginButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.usersPanelMidSecurity.add((Component)this.loginButton, gridBagConstraints);
        this.passwordButton.setText("Change Password");
        this.passwordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectManagementTab.this.passwordButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.usersPanelMidSecurity.add((Component)this.passwordButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.75;
        this.projectManagement.add((Component)this.usersPanelMidSecurity, gridBagConstraints);
        this.usersPanelLowSecurity.setLayout(new GridBagLayout());
        this.jLabel3.setText("User Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.usersPanelLowSecurity.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.usersPanelLowSecurity.add((Component)this.userName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.projectManagement.add((Component)this.usersPanelLowSecurity, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.projectManagement, gridBagConstraints);
        this.pack();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (!this.authorized) {
            JOptionPane.showMessageDialog(this, "You must be authorized to delete users.  Click the 'Authorize' button.", "Not Authorized", 0);
            return;
        }
        int index2 = this.userList.getSelectedIndex();
        if (index2 < 0) {
            JOptionPane.showMessageDialog(this, "Select a user before clicking 'delete'", "Nothing Selected", 0);
            return;
        }
        String user = (String)this.userModel.getElementAt(index2);
        PasswordDialog pwd = new PasswordDialog(4, user);
        if (pwd.cancelled()) {
            return;
        }
        Users.deleteUser(user);
        this.reloadUsers();
    }

    private void authorizeButtonActionPerformed(ActionEvent evt) {
        if (this.authorized) {
            PasswordDialog pwd = new PasswordDialog(6, null);
            if (pwd.cancelled()) {
                return;
            }
            String pass = pwd.getPassword();
            Project.setAuthorizationPassword(pass);
        } else {
            PasswordDialog pwd = new PasswordDialog(5, null);
            if (pwd.cancelled()) {
                return;
            }
            this.authorized = true;
            this.deleteButton.setEnabled(true);
            this.addButton.setEnabled(true);
            this.authorizeButton.setText("Change Authorization...");
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String fileName = OpenFile.chooseDirectory(null);
        if (fileName == null) {
            return;
        }
        this.repositoryTextArea.setText(fileName);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if (!this.authorized) {
            JOptionPane.showMessageDialog(this, "You must be authorized to add users.  Click the 'Authorize' button.", "Not Authorized", 0);
            return;
        }
        PasswordDialog pwd = new PasswordDialog(1, null);
        if (pwd.cancelled()) {
            return;
        }
        String userName = pwd.getUserName();
        String encryptedPassword = Users.encryptPassword(pwd.getPassword());
        Users.addUser(userName, encryptedPassword);
        this.reloadUsers();
    }

    private void passwordButtonActionPerformed(ActionEvent evt) {
        int index2 = this.userList.getSelectedIndex();
        if (index2 < 0) {
            JOptionPane.showMessageDialog(this, "Select a user before changing their password", "Nothing Selected", 0);
            return;
        }
        String userName = (String)this.userModel.getElementAt(index2);
        PasswordDialog pwd = new PasswordDialog(2, userName);
        if (pwd.cancelled()) {
            return;
        }
        String encryptedPassword = Users.encryptPassword(pwd.getPassword());
        Users.changeEncryptedPassword(userName, encryptedPassword);
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        int index2 = this.userList.getSelectedIndex();
        if (index2 < 0) {
            JOptionPane.showMessageDialog(this, "Select a user before clicking 'login'", "Nothing Selected", 0);
            return;
        }
        String userName = (String)this.userModel.getElementAt(index2);
        PasswordDialog pwd = new PasswordDialog(3, userName);
        if (pwd.cancelled()) {
            return;
        }
        Project.setCurrentUserName(userName);
        this.currentUserLabel.setText("Logged-in user: " + userName);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class PasswordDialog
    extends EDialog {
        private static final int NEWUSER = 1;
        private static final int CHANGEPASSWORD = 2;
        private static final int LOGINUSER = 3;
        private static final int DELETEUSER = 4;
        private static final int AUTHORIZE = 5;
        private static final int RENAMEAUTHPASS = 6;
        private int operation;
        private String userName;
        private JTextField userNameField;
        private JPasswordField password;
        private JPasswordField confirm;
        private JPasswordField oldPassword;
        private boolean didCancel;

        private PasswordDialog(int operation, String userName) {
            super((Frame)null, true);
            this.operation = operation;
            this.userName = userName;
            this.initComponents();
            this.setVisible(true);
        }

        public boolean cancelled() {
            return this.didCancel;
        }

        public String getUserName() {
            return this.userNameField.getText();
        }

        public String getPassword() {
            return new String(this.password.getPassword());
        }

        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            boolean bl = this.didCancel = !goodButton;
            if (goodButton) {
                switch (this.operation) {
                    case 1: {
                        String conf;
                        String name = this.userNameField.getText().trim();
                        if (name.length() == 0) {
                            JOptionPane.showMessageDialog(this, "You must type a user name", "Blank User Name", 0);
                            this.userNameField.selectAll();
                            return;
                        }
                        if (Users.isExistingUser(name)) {
                            JOptionPane.showMessageDialog(this, "User " + name + " already exists.  Choose another name", "User Name Exists", 0);
                            this.userNameField.selectAll();
                            return;
                        }
                        String pass = new String(this.password.getPassword());
                        if (pass.equals(conf = new String(this.confirm.getPassword()))) break;
                        JOptionPane.showMessageDialog(this, "Confirmed password does not match original password", "Confirmation Error", 0);
                        this.confirm.selectAll();
                        return;
                    }
                    case 2: {
                        String conf;
                        String givenPassword = new String(this.oldPassword.getPassword()).trim();
                        String encryptedPassword = Users.getEncryptedPassword(this.userName);
                        String encryptedGivenPassword = Users.encryptPassword(givenPassword);
                        if (!encryptedGivenPassword.equals(encryptedPassword)) {
                            JOptionPane.showMessageDialog(this, "Incorrect password given for user " + this.userName, "Invalid Password", 0);
                            this.oldPassword.selectAll();
                            return;
                        }
                        String pass = new String(this.password.getPassword());
                        if (pass.equals(conf = new String(this.confirm.getPassword()))) break;
                        JOptionPane.showMessageDialog(this, "Confirmed password does not match new password", "Confirmation Error", 0);
                        this.confirm.selectAll();
                        return;
                    }
                    case 3: {
                        String givenPassword = new String(this.password.getPassword()).trim();
                        String encryptedPassword = Users.getEncryptedPassword(this.userName);
                        String encryptedGivenPassword = Users.encryptPassword(givenPassword);
                        if (encryptedGivenPassword.equals(encryptedPassword)) break;
                        JOptionPane.showMessageDialog(this, "Incorrect password given for user " + this.userName, "Invalid Password", 0);
                        this.password.selectAll();
                        return;
                    }
                    case 5: {
                        String givenPassword = new String(this.password.getPassword()).trim();
                        String encryptedPassword = Project.getAuthorizationPassword();
                        if (givenPassword.equals(encryptedPassword)) break;
                        JOptionPane.showMessageDialog(this, "Incorrect administrator password", "Invalid Password", 0);
                        this.password.selectAll();
                        return;
                    }
                    case 6: {
                        String conf;
                        String givenPassword = new String(this.oldPassword.getPassword()).trim();
                        String encryptedPassword = Project.getAuthorizationPassword();
                        if (!givenPassword.equals(encryptedPassword)) {
                            JOptionPane.showMessageDialog(this, "Incorrect administrator password", "Invalid Password", 0);
                            this.oldPassword.selectAll();
                            return;
                        }
                        String pass = new String(this.password.getPassword());
                        if (pass.equals(conf = new String(this.confirm.getPassword()))) break;
                        JOptionPane.showMessageDialog(this, "Confirmed password does not match new password", "Confirmation Error", 0);
                        this.confirm.selectAll();
                        return;
                    }
                }
            }
            this.setVisible(false);
            this.dispose();
        }

        private void initComponents() {
            GridBagConstraints gbc;
            this.getContentPane().setLayout(new GridBagLayout());
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    PasswordDialog.this.exit(false);
                }
            });
            switch (this.operation) {
                case 1: {
                    this.setTitle("Create New User");
                    JLabel lab1 = new JLabel("User name:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab1, gbc);
                    this.userNameField = new JTextField("");
                    this.userNameField.setColumns(20);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 0;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.userNameField, gbc);
                    JLabel lab2 = new JLabel("Password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 1;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab2, gbc);
                    this.password = new JPasswordField("");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 1;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.password, gbc);
                    JLabel lab3 = new JLabel("Confirm password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 2;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab3, gbc);
                    this.confirm = new JPasswordField("");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 2;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.confirm, gbc);
                    break;
                }
                case 2: {
                    this.setTitle("Change Password");
                    JLabel lab1 = new JLabel("Old Password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab1, gbc);
                    this.oldPassword = new JPasswordField("");
                    this.oldPassword.setColumns(20);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 0;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.oldPassword, gbc);
                    JLabel lab2 = new JLabel("New Password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 1;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab2, gbc);
                    this.password = new JPasswordField("");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 1;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.password, gbc);
                    JLabel lab3 = new JLabel("Confirm new password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 2;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab3, gbc);
                    this.confirm = new JPasswordField("");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 2;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.confirm, gbc);
                    break;
                }
                case 3: {
                    this.setTitle("Login");
                    JLabel lab1 = new JLabel("User name:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab1, gbc);
                    JLabel lab2 = new JLabel(this.userName);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 0;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab2, gbc);
                    JLabel lab3 = new JLabel("Password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 1;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab3, gbc);
                    this.password = new JPasswordField("");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 1;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.password, gbc);
                    break;
                }
                case 4: {
                    this.setTitle("Delete User");
                    JLabel lab1 = new JLabel("Click OK to delete user: \"" + this.userName + "\"");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    gbc.gridwidth = 2;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab1, gbc);
                    break;
                }
                case 5: {
                    this.setTitle("Authorize");
                    JLabel lab3 = new JLabel("Administrator password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab3, gbc);
                    this.password = new JPasswordField("");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 0;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.password, gbc);
                    break;
                }
                case 6: {
                    this.setTitle("Change Authorization Password");
                    JLabel lab1 = new JLabel("Old Authorization Password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab1, gbc);
                    this.oldPassword = new JPasswordField("");
                    this.oldPassword.setColumns(20);
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 0;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.oldPassword, gbc);
                    JLabel lab2 = new JLabel("New Authorization Password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 1;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab2, gbc);
                    this.password = new JPasswordField("");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 1;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.password, gbc);
                    JLabel lab3 = new JLabel("Confirm new password:");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 2;
                    gbc.anchor = 17;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)lab3, gbc);
                    this.confirm = new JPasswordField("");
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = 2;
                    gbc.anchor = 10;
                    gbc.fill = 2;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(4, 4, 4, 4);
                    this.getContentPane().add((Component)this.confirm, gbc);
                }
            }
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PasswordDialog.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PasswordDialog.this.exit(true);
                }
            });
            this.getRootPane().setDefaultButton(ok);
            this.pack();
        }
    }
}

