/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PlacementTab
extends PreferencePanel {
    private PreferencesFrame parent;
    private Map<PlacementFrame.PlacementParameter, JTextField> currentParameters;
    private Placement.PlacementPreferences placementOptions;
    private JPanel frame;
    private JLabel jLabel15;
    private JPanel parametersPanel;
    private JComboBox placementAlgorithm;

    public PlacementTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.initComponents();
    }

    public JPanel getUserPreferencesPanel() {
        return this.frame;
    }

    public String getName() {
        return "Placement";
    }

    public void init() {
        PlacementFrame[] algorithms;
        for (PlacementFrame an : algorithms = PlacementAdapter.getPlacementAlgorithms()) {
            this.placementAlgorithm.addItem(an.getAlgorithmName());
        }
        this.placementOptions = new Placement.PlacementPreferences(false);
        this.placementAlgorithm.setSelectedItem(this.placementOptions.placementAlgorithm);
        this.placementAlgorithm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlacementTab.this.getAlgorithmParameters();
                PlacementTab.this.setupForAlgorithm();
            }
        });
        this.setupForAlgorithm();
    }

    public void term() {
        this.placementOptions.placementAlgorithm = (String)this.placementAlgorithm.getSelectedItem();
        this.getAlgorithmParameters();
        this.putPrefs(this.placementOptions);
    }

    public void reset() {
        this.putPrefs(new Placement.PlacementPreferences(true));
    }

    private void getAlgorithmParameters() {
        if (this.currentParameters == null) {
            return;
        }
        for (PlacementFrame.PlacementParameter pp : this.currentParameters.keySet()) {
            Object value2;
            JTextField txt = this.currentParameters.get(pp);
            switch (pp.getType()) {
                case 1: {
                    value2 = TextUtils.atoi(txt.getText());
                    break;
                }
                case 2: {
                    value2 = String.valueOf(txt.getText());
                    break;
                }
                case 3: {
                    value2 = TextUtils.atof(txt.getText());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.placementOptions.setParameter(pp, value2);
        }
    }

    private void setupForAlgorithm() {
        List<PlacementFrame.PlacementParameter> allParams;
        this.parametersPanel.removeAll();
        this.parametersPanel.updateUI();
        this.currentParameters = new HashMap<PlacementFrame.PlacementParameter, JTextField>();
        String algName = (String)this.placementAlgorithm.getSelectedItem();
        PlacementFrame[] algorithms = PlacementAdapter.getPlacementAlgorithms();
        PlacementFrame whichOne = null;
        for (PlacementFrame an : algorithms) {
            if (!algName.equals(an.getAlgorithmName())) continue;
            whichOne = an;
            break;
        }
        if (whichOne != null && (allParams = whichOne.getParameters()) != null) {
            int yPos = 0;
            for (PlacementFrame.PlacementParameter pp : allParams) {
                Object value2 = this.placementOptions.getParameter(pp);
                JLabel lab = new JLabel(pp.getName());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = yPos;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.parametersPanel.add((Component)lab, gbc);
                String init2 = null;
                if (pp.getType() == 1) {
                    init2 = value2.toString();
                } else if (pp.getType() == 2) {
                    init2 = value2.toString();
                } else if (pp.getType() == 3) {
                    init2 = TextUtils.formatDouble((Double)value2);
                }
                JTextField txt = new JTextField(init2);
                txt.setColumns(init2.length() * 2);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = yPos++;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.parametersPanel.add((Component)txt, gbc);
                this.currentParameters.put(pp, txt);
            }
        }
        this.parent.pack();
    }

    private void initComponents() {
        this.frame = new JPanel();
        this.jLabel15 = new JLabel();
        this.placementAlgorithm = new JComboBox();
        this.parametersPanel = new JPanel();
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PlacementTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.frame.setLayout(new GridBagLayout());
        this.jLabel15.setText("Placement algorithm:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.frame.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.frame.add((Component)this.placementAlgorithm, gridBagConstraints);
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.parametersPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.frame.add((Component)this.parametersPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.frame, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

