/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.BussedIO;
import com.sun.electric.tool.simulation.test.ChipModel;
import com.sun.electric.tool.simulation.test.ExecProcess;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.LogicSettable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class SimulationModel
implements ChipModel {
    private static boolean inUse = false;
    private static List models = new ArrayList();
    protected final String simulatorName;
    protected final String quitCommand;
    protected final String errorFlag;
    private String outputPrompt;
    private ExecProcess process;
    private PrintWriter logfile;
    private String logfileName = null;
    private BufferedReader processReader;
    private StringBuffer lastCommandOutput;
    private int currentCommand;
    private long startTime;
    private String additionalCommandLineArgs = "";
    private boolean optimizedDirectReadsWrites = false;
    private boolean suppressErrorMsgs = false;
    private int numIssueCommandErrors = 0;
    private boolean assertionFailed = false;
    private boolean bypassScanning = false;
    private static final boolean DEBUGPROCESS = false;
    private static final boolean DEBUGOUTPUT = false;
    private final int bufsize = 0x100000;
    private char[] cbuf = new char[0x100000];

    public SimulationModel(String simulatorName, String quitCommand, String errorFlag, String outputPrompt) {
        this.simulatorName = simulatorName;
        this.quitCommand = quitCommand;
        this.errorFlag = errorFlag;
        this.outputPrompt = outputPrompt;
        this.process = null;
        this.logfile = null;
        this.logfileName = null;
        this.processReader = null;
        this.currentCommand = 1;
        this.lastCommandOutput = null;
        SimulationModel.setInUse(true);
        models.add(this);
        this.startTime = System.currentTimeMillis();
    }

    public abstract JtagTester createJtagTester(String var1, String var2, String var3, String var4, String var5);

    public JtagTester createJtagTester() {
        return this.createJtagTester("TCK", "TMS", "TRSTb", "TDI", "TDOb");
    }

    public abstract JtagTester createJtagSubchainTester(String var1, String var2);

    public abstract JtagTester createJtagSubchainTester(String var1, String var2, String var3, String var4, String var5, String var6);

    public abstract LogicSettable createLogicSettable(String var1);

    public abstract LogicSettable createLogicSettable(List var1);

    public abstract void setNodeState(String var1, int var2);

    public abstract int getNodeState(String var1);

    public abstract void releaseNodes(List var1);

    protected abstract double getVdd();

    protected abstract double getSimulationTime();

    public void setNodeState(BussedIO bus, BitVector state) {
        for (int i = 0; i < bus.getWidth(); ++i) {
            this.setNodeState(bus.getSignal(i), state.get(i) ? 1 : 0);
        }
    }

    public BitVector getNodeState(BussedIO bus) {
        BitVector state = new BitVector(bus.getWidth(), bus.getName());
        for (int i = 0; i < bus.getWidth(); ++i) {
            int b = this.getNodeState(bus.getSignal(i));
            if (b == 1) {
                state.set(i);
            }
            if (b != 0) continue;
            state.clear(i);
        }
        return state;
    }

    public void assertNodeState(String node, int expectedState) {
        this.assertNodeState(node, expectedState, "");
    }

    public void assertNodeState(String node, int expectedState, String errMsg) {
        int value2 = this.getNodeState(node);
        if (value2 != expectedState) {
            System.out.println("Assertion failed for node \"" + node + "\", state was " + value2 + " (expected: " + expectedState + ") " + errMsg);
            this.assertionFailed = true;
        }
    }

    public void setAdditionalCommandLineArgs(String args) {
        this.additionalCommandLineArgs = args;
    }

    public void start(String command, String simFile, int recordSim) {
        this.start(command, simFile, recordSim, false);
    }

    public void start(String command, String simFile, int recordSim, boolean bypassScanning) {
        this.bypassScanning = bypassScanning;
        if (!this.start_(command, simFile, recordSim)) {
            Infrastructure.exit(1);
        }
    }

    abstract boolean start_(String var1, String var2, int var3);

    public abstract void wait(float var1);

    public abstract void waitNS(double var1);

    public abstract void waitPS(double var1);

    public abstract double getTimeNS();

    public abstract void disableNode(String var1);

    public abstract void enableNode(String var1);

    public void setBypassScanning(boolean enabled) {
        this.bypassScanning = enabled;
    }

    public void setOptimizedDirectReadsWrites(boolean enabled) {
        this.optimizedDirectReadsWrites = enabled;
    }

    public boolean getOptimizedDirectReadsWrites() {
        return this.optimizedDirectReadsWrites;
    }

    public boolean isBypassScanning() {
        return this.bypassScanning;
    }

    public static boolean waitSeconds(float seconds) {
        if (!SimulationModel.isInUse()) {
            return false;
        }
        for (SimulationModel cm : models) {
            cm.wait(seconds);
        }
        return true;
    }

    public void finish() {
        long time = System.currentTimeMillis() - this.startTime;
        System.out.println("Simulation took " + SimulationModel.getElapsedTime(time));
        this.issueCommand(this.quitCommand);
        if (this.assertionFailed) {
            Infrastructure.exit(1);
        }
    }

    public static void finishAll() {
        for (SimulationModel cm : models) {
            cm.finish();
        }
    }

    private static synchronized void setInUse(boolean e) {
        inUse = e;
    }

    static synchronized boolean isInUse() {
        return inUse;
    }

    public static String getElapsedTime(long milliseconds) {
        int minutes;
        int hours;
        int days;
        if (milliseconds < 60000L) {
            return (double)milliseconds / 1000.0 + " secs";
        }
        StringBuffer buf = new StringBuffer();
        int seconds = (int)milliseconds / 1000;
        if (seconds < 0) {
            seconds = 0;
        }
        if ((days = seconds / 86400) > 0) {
            buf.append(days + " days, ");
        }
        if ((hours = (seconds -= days * 86400) / 3600) > 0) {
            buf.append(hours + " hrs, ");
        }
        if ((minutes = (seconds -= hours * 3600) / 60) > 0) {
            buf.append(minutes + " mins, ");
        }
        buf.append((seconds -= minutes * 60) + " secs");
        return buf.toString();
    }

    protected boolean startProcess(String command, String[] envVars, File dir, String logfileName) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(logfileName, false);
            this.logfile = new PrintWriter(fout);
            this.logfileName = logfileName;
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            this.suppressErrorMsgs = true;
            return false;
        }
        PipedOutputStream ostream = new PipedOutputStream();
        try {
            PipedInputStream istream = new PipedInputStream(ostream);
            this.processReader = new BufferedReader(new InputStreamReader(istream));
        }
        catch (IOException e) {
            System.out.println("Unable to create pipe to process output: " + e.getMessage());
            this.suppressErrorMsgs = true;
            return false;
        }
        if (this.additionalCommandLineArgs.length() > 0) {
            command = command + " " + this.additionalCommandLineArgs;
        }
        this.process = new ExecProcess(command, null, null, (OutputStream)ostream, (OutputStream)ostream);
        System.out.println("  Starting process: " + command);
        if (this.process == null) {
            this.suppressErrorMsgs = true;
            return false;
        }
        long startTime = System.currentTimeMillis();
        this.process.start();
        if (!this.readProcessOutputUntilReady()) {
            this.process = null;
            return false;
        }
        long duration = System.currentTimeMillis() - startTime;
        if (duration > 60000L) {
            System.out.println("  external process is ready, took " + Infrastructure.getElapsedTime(duration));
        }
        return true;
    }

    protected boolean isProcessRunning() {
        return this.process != null;
    }

    protected void setPrompt(String prompt) {
        this.outputPrompt = prompt;
    }

    protected void issueCommand(String command) {
        this.issueCommand(command, true);
    }

    protected void issueCommand(String command, boolean incrPrompt) {
        if (!incrPrompt) {
            --this.currentCommand;
        }
        if (this.process == null) {
            if (!this.suppressErrorMsgs) {
                System.out.println("Error: command " + command + " issue when no " + this.simulatorName + " process running!");
                ++this.numIssueCommandErrors;
                if (this.numIssueCommandErrors > 5) {
                    System.out.println("Warning: too many command issue errors, suppressing all remaining errors");
                    this.suppressErrorMsgs = true;
                }
            }
            return;
        }
        if (command == null) {
            return;
        }
        this.process.writeln(command);
        if (this.logfile != null) {
            this.logfile.println(command);
            this.logfile.flush();
        }
        if (command.equals(this.quitCommand)) {
            this.readProcessOutputUntilReady();
            this.process = null;
            return;
        }
        if (!this.readProcessOutputUntilReady()) {
            this.process.writeln(this.quitCommand);
            this.readProcessOutputUntilReady();
            Infrastructure.exit(1);
        }
    }

    StringBuffer getLastCommandOutput() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.lastCommandOutput);
        return buf;
    }

    private boolean readProcessOutputUntilReady() {
        if (this.processReader == null) {
            return false;
        }
        boolean ready = true;
        int offset = 0;
        int len = 0x100000;
        int read2 = 0;
        StringBuffer lastString = new StringBuffer();
        this.lastCommandOutput = new StringBuffer();
        try {
            while ((read2 = this.processReader.read(this.cbuf, offset, len)) > 0) {
                if (this.logfile != null) {
                    this.logfile.write(this.cbuf, offset, read2);
                    this.logfile.flush();
                }
                this.lastCommandOutput.append(this.cbuf, offset, read2);
                if (read2 > 0) {
                    int i;
                    for (i = read2 - 1; i >= 0; --i) {
                        if (this.cbuf[i] != '\n') continue;
                        lastString = new StringBuffer();
                        lastString.append(this.cbuf, ++i, read2 - i);
                        break;
                    }
                    if (i < 0) {
                        lastString.append(this.cbuf, 0, read2);
                    }
                }
                StringBuffer errbuf = new StringBuffer();
                errbuf.append(this.cbuf, 0, read2);
                if (errbuf.indexOf(this.errorFlag) != -1 || lastString.indexOf(this.errorFlag) != -1) {
                    System.out.println("Error in " + this.simulatorName + " simulation, aborting. Please check log file " + this.logfileName);
                    ready = false;
                    if (this.currentCommand > 1) {
                        --this.currentCommand;
                    }
                }
                String prompt = this.getPrompt();
                if (lastString.toString().indexOf(prompt) != -1) {
                    ++this.currentCommand;
                    return ready;
                }
                if (this.lastCommandOutput.toString().indexOf(prompt) == -1) continue;
                ++this.currentCommand;
                return ready;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return false;
    }

    private String getPrompt() {
        return this.outputPrompt.replaceAll("%%", String.valueOf(this.currentCommand));
    }
}

