/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore2.DetailedRouterWorker;
import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RoutingFrameLeeMoore;
import com.sun.electric.tool.routing.experimentalLeeMoore2.SegPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DetailedRouter {
    private final int numThreads;
    private long timeout;
    private GlobalRouterV3.RegionToRoute[] regions;
    private DetailedRoutingSolution solutions;
    private List<Integer> unrouted;
    private List<DetailedRouterWorker> workers;

    public DetailedRouter(int numThreads, RoutingFrame.RoutingLayer[] metalLayers, GlobalRouterV3.RegionToRoute[] regions, double tileSize, boolean debug) {
        this.numThreads = numThreads;
        this.unrouted = new ArrayList<Integer>();
        this.workers = new ArrayList<DetailedRouterWorker>(regions.length);
        this.solutions = new DetailedRoutingSolution();
        for (int i = 0; i < regions.length; ++i) {
            DetailedRouterWorker d = new DetailedRouterWorker(regions[i], metalLayers, tileSize);
            if (debug) {
                d.enableOutput();
            }
            this.workers.add(d);
        }
    }

    public void start() {
        this.unrouted.clear();
        for (int i = 0; i < this.regions.length; ++i) {
            this.workers.get(i).setRegion(this.regions[i]);
        }
        ExecutorService es = Executors.newFixedThreadPool(this.numThreads);
        for (DetailedRouterWorker w : this.workers) {
            es.submit(w);
        }
        es.shutdown();
        try {
            es.awaitTermination(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (DetailedRouterWorker w : this.workers) {
            if (!w.isDone()) continue;
            this.solutions.putAll(w.getSolution());
        }
        for (GlobalRouterV3.RegionToRoute region : this.regions) {
            for (SegPart segment : region.segments_to_route) {
                if (this.solutions.containsKey(segment) || this.unrouted.contains(segment.id)) continue;
                this.unrouted.add(segment.id);
            }
        }
        for (DetailedRouterWorker w : this.workers) {
            w.removeSolutions(this.unrouted);
        }
        Iterator it = this.solutions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry s = it.next();
            if (!this.unrouted.contains(((SegPart)s.getKey()).id)) continue;
            it.remove();
        }
        for (GlobalRouterV3.RegionToRoute region : this.regions) {
            Iterator<SegPart> itr = region.segments_to_route.iterator();
            while (itr.hasNext()) {
                SegPart segment;
                segment = itr.next();
                if (!this.unrouted.contains(segment.id)) continue;
                itr.remove();
            }
        }
    }

    public void setTimeout(long seconds) {
        this.timeout = seconds;
    }

    public void setRegions(GlobalRouterV3.RegionToRoute[] regions) {
        this.regions = regions;
    }

    public List<Integer> getUnroutables() {
        return this.unrouted;
    }

    public void writeSolution() {
        for (Map.Entry s : this.solutions.entrySet()) {
            SegPart toRoute = (SegPart)s.getKey();
            List routed = (List)s.getValue();
            if (routed.size() <= 2 || toRoute.segment_part.size() > 2) continue;
            toRoute.segment_part.addAll(1, routed);
        }
        this.solutions.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DetailedRoutingSolution
    extends HashMap<SegPart, List<RoutingFrameLeeMoore.Coordinate>> {
        private static final long serialVersionUID = -3806453821768987428L;

        @Override
        public DetailedRoutingSolution clone() {
            return (DetailedRoutingSolution)super.clone();
        }
    }
}

