/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.PlacementMinCut;
import com.sun.electric.tool.placement.PlacementRandom;
import com.sun.electric.tool.placement.PlacementSimple;
import com.sun.electric.tool.placement.forceDirected1.PlacementForceDirectedTeam5;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import com.sun.electric.tool.placement.genetic2.PlacementGenetic;
import com.sun.electric.tool.placement.simulatedAnnealing1.SimulatedAnnealing;
import com.sun.electric.tool.placement.simulatedAnnealing2.PlacementSimulatedAnnealing;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementAdapter {
    private static final boolean specialDebugFlag = false;
    static PlacementFrame[] placementAlgorithms = new PlacementFrame[]{new SimulatedAnnealing(), new PlacementSimulatedAnnealing(), new GeneticPlacement(), new PlacementGenetic(), new PlacementForceDirectedTeam5(), new PlacementForceDirectedStaged(), new PlacementMinCut(), new PlacementSimple(), new PlacementRandom()};

    public static PlacementFrame[] getPlacementAlgorithms() {
        return placementAlgorithms;
    }

    public static Cell doPlacement(PlacementFrame pla, Library lib, String cellName, List<PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementExport> exportsToPlace, NodeProto iconToPlace, Placement.PlacementPreferences prefs) {
        ElapseTimer timer = ElapseTimer.createInstance().start();
        System.out.println("Running placement on cell '" + cellName + "' using the '" + pla.getAlgorithmName() + "' algorithm");
        for (PlacementFrame.PlacementParameter par2 : pla.getParameters()) {
            par2.setValue(prefs.getParameter(par2));
        }
        ArrayList<PlacementFrame.PlacementNode> nodesToPlaceCopy = new ArrayList<PlacementFrame.PlacementNode>(nodesToPlace);
        pla.runPlacement(nodesToPlaceCopy, allNetworks, cellName);
        if (Job.getDebug()) {
            // empty if block
        }
        Cell newCell = Cell.makeInstance(lib, cellName);
        HashMap<PlacementNode, NodeInst> placedNodes = new HashMap<PlacementNode, NodeInst>();
        for (PlacementNode plNode : nodesToPlace) {
            NodeInst ni;
            double xPos = plNode.getPlacementX();
            double yPos = plNode.getPlacementY();
            Orientation orient = plNode.getPlacementOrientation();
            NodeProto np = plNode.getType();
            if (np instanceof Cell) {
                Cell placementCell = (Cell)np;
                ERectangle bounds = placementCell.getBounds();
                Point2D.Double centerOffset = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                orient.pureRotate().transform(centerOffset, centerOffset);
                xPos -= ((Point2D)centerOffset).getX();
                yPos -= ((Point2D)centerOffset).getY();
            }
            if ((ni = NodeInst.makeInstance(np, (Point2D)new Point2D.Double(xPos, yPos), np.getDefWidth(), np.getDefHeight(), newCell, orient, plNode.nodeName, plNode.getTechBits())) == null) {
                System.out.println("Placement failed to create node");
            } else {
                if (plNode.isTerminal()) {
                    ni.setLocked();
                }
                placedNodes.put(plNode, ni);
            }
            if (plNode.addedVariables == null) continue;
            for (String varName : plNode.addedVariables.keySet()) {
                Object value2 = plNode.addedVariables.get(varName);
                Variable.Key key = Variable.newKey(varName);
                Variable var = ni.newDisplayVar(key, value2);
                if (key == Schematics.SCHEM_RESISTANCE) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(0.0, 0.5).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                if (key == Schematics.ATTR_WIDTH) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(0.5, -1.0).withRelSize(1.0).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                if (key == Schematics.ATTR_LENGTH) {
                    ni.setTextDescriptor(key, var.getTextDescriptor().withOff(-0.5, -1.0).withRelSize(0.5).withDispPart(AbstractTextDescriptor.DispPos.VALUE));
                    continue;
                }
                ni.setTextDescriptor(key, var.getTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.VALUE));
            }
        }
        if (iconToPlace != null) {
            ERectangle bounds = newCell.getBounds();
            EPoint center = new EPoint(bounds.getMaxX() + iconToPlace.getDefWidth(), bounds.getMaxY() + iconToPlace.getDefHeight());
            NodeInst.makeInstance(iconToPlace, center, iconToPlace.getDefWidth(), iconToPlace.getDefHeight(), newCell);
        }
        for (PlacementExport plExport : exportsToPlace) {
            PlacementPort plPort = plExport.getPort();
            String exportName = plExport.getName();
            PlacementNode plNode = (PlacementNode)plPort.getPlacementNode();
            NodeInst newNI = (NodeInst)placedNodes.get(plNode);
            if (newNI == null) continue;
            PortInst portToExport = newNI.findPortInstFromProto(plPort.getPortProto());
            Export.newInstance(newCell, portToExport, exportName, plExport.getCharacteristic());
        }
        ImmutableArcInst a = Generic.tech().unrouted_arc.getDefaultInst(newCell.getEditingPreferences());
        long gridExtend = a.getGridExtendOverMin();
        for (PlacementFrame.PlacementNetwork plNet : allNetworks) {
            PlacementPort lastPp = null;
            PortInst lastPi = null;
            EPoint lastPt = null;
            for (PlacementFrame.PlacementPort plPort : plNet.getPortsOnNet()) {
                PlacementNode plNode = (PlacementNode)plPort.getPlacementNode();
                NodeInst newNi = (NodeInst)placedNodes.get(plNode);
                if (newNi == null) continue;
                PlacementPort thisPp = (PlacementPort)plPort;
                PortInst thisPi = newNi.findPortInstFromProto(thisPp.getPortProto());
                EPoint thisPt = new EPoint(plNode.getPlacementX() + plPort.getRotatedOffX(), plNode.getPlacementY() + plPort.getRotatedOffY());
                if (lastPp != null) {
                    ArcInst.newInstance(newCell, Generic.tech().unrouted_arc, null, null, lastPi, thisPi, lastPt, thisPt, gridExtend, -1, a.flags);
                }
                lastPp = thisPp;
                lastPi = thisPi;
                lastPt = thisPt;
            }
        }
        timer.end();
        System.out.println("\t(took " + timer + ")");
        return newCell;
    }

    public static class PlacementExport {
        private PlacementPort portToExport;
        private String exportName;
        private PortCharacteristic characteristic;

        public PlacementExport(PlacementPort port, String name, PortCharacteristic chr) {
            this.portToExport = port;
            this.exportName = name;
            this.characteristic = chr;
        }

        PlacementPort getPort() {
            return this.portToExport;
        }

        String getName() {
            return this.exportName;
        }

        PortCharacteristic getCharacteristic() {
            return this.characteristic;
        }
    }

    public static class PlacementPort
    extends PlacementFrame.PlacementPort {
        private PortProto proto;

        public PlacementPort(double x, double y, PortProto pp) {
            super(x, y);
            this.proto = pp;
        }

        PortProto getPortProto() {
            return this.proto;
        }

        public String toString() {
            return this.proto.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlacementNode
    extends PlacementFrame.PlacementNode {
        private final NodeProto original;
        private final String nodeName;
        private final int techBits;
        private final double width;
        private final double height;
        private final List<PlacementFrame.PlacementPort> ports;
        private Map<String, Object> addedVariables;
        private final boolean terminal;

        public PlacementNode(NodeProto type, String name, int tBits, double wid, double hei, List<PlacementPort> pps, boolean terminal) {
            this.original = type;
            this.nodeName = name;
            this.techBits = tBits;
            this.width = wid;
            this.height = hei;
            this.ports = new ArrayList<PlacementPort>(pps);
            this.terminal = terminal;
        }

        public void addVariable(String name, Object value2) {
            if (this.addedVariables == null) {
                this.addedVariables = new HashMap<String, Object>();
            }
            this.addedVariables.put(name, value2);
        }

        public NodeProto getType() {
            return this.original;
        }

        @Override
        public String getTypeName() {
            return this.original.getName();
        }

        @Override
        public List<PlacementFrame.PlacementPort> getPorts() {
            return this.ports;
        }

        public int getTechBits() {
            return this.techBits;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public String toString() {
            String name = this.original.describe(false);
            if (this.nodeName != null) {
                name = name + "[" + this.nodeName + "]";
            }
            if (this.getTechBits() != 0) {
                name = name + "(" + this.getTechBits() + ")";
            }
            return name;
        }
    }
}

