/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.erc.wellcheck.ConnectionCheck;
import com.sun.electric.tool.erc.wellcheck.DRCCheck;
import com.sun.electric.tool.erc.wellcheck.DistanceCheck;
import com.sun.electric.tool.erc.wellcheck.NetValues;
import com.sun.electric.tool.erc.wellcheck.OnRailCheck;
import com.sun.electric.tool.erc.wellcheck.ShortCircuitCheck;
import com.sun.electric.tool.erc.wellcheck.Utils;
import com.sun.electric.tool.erc.wellcheck.WellCheckAnalysisStrategy;
import com.sun.electric.tool.erc.wellcheck.WellCon;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.util.concurrent.Parallel;
import com.sun.electric.tool.util.concurrent.patterns.PForTask;
import com.sun.electric.tool.util.concurrent.patterns.PJob;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.IThreadPool;
import com.sun.electric.tool.util.concurrent.utils.BlockedRange1D;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.config.Configuration;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ERCWellCheck {
    private Cell cell;
    private Set<Object> possiblePrimitives;
    private List<WellCon> wellCons = new ArrayList<WellCon>();
    private Iterator<WellCon>[] wellConIterator;
    private List<WellCon>[] wellConLists;
    private RTNode pWellRoot;
    private RTNode nWellRoot;
    private Layer pWellLayer;
    private Layer nWellLayer;
    private ErrorLogger errorLogger;
    private WellCheckJob job;
    private double worstPWellDist;
    private Point2D worstPWellCon;
    private Point2D worstPWellEdge;
    private double worstNWellDist;
    private Point2D worstNWellCon;
    private Point2D worstNWellEdge;
    private WellCheckPreferences wellPrefs;
    private Map<Integer, List<Transistor>> transistors;
    private Set<Integer> networkExportAvailable;
    private boolean hasPCon;
    private boolean hasNCon;
    private IThreadPool threadPool;
    private static final Layer.Function[] ercLayersArray = new Layer.Function[]{Layer.Function.WELLP, Layer.Function.WELL, Layer.Function.WELLN, Layer.Function.SUBSTRATE, Layer.Function.IMPLANTP, Layer.Function.IMPLANT, Layer.Function.IMPLANTN};
    private static final Layer.Function.Set ercLayers = new Layer.Function.Set(ercLayersArray);

    @Deprecated
    public static void analyzeCurCell(GeometryHandler.GHMode newAlgorithm) {
        UserInterface ui = Job.getUserInterface();
        Cell curCell = ui.needCurrentCell();
        if (curCell == null) {
            return;
        }
        View view = curCell.getView();
        if (view.isTextView() || view == View.SCHEMATIC || view == View.ICON) {
            System.out.println("Sorry, Well checking runs only on layout cells");
            return;
        }
        new WellCheckJob(curCell, newAlgorithm, new WellCheckPreferences(false));
    }

    public static void analyzeCurCell() {
        UserInterface ui = Job.getUserInterface();
        Cell curCell = ui.needCurrentCell();
        if (curCell == null) {
            return;
        }
        View view = curCell.getView();
        if (view.isTextView() || view == View.SCHEMATIC || view == View.ICON) {
            System.out.println("Sorry, Well checking runs only on layout cells");
            return;
        }
        new WellCheckJob(curCell, new WellCheckPreferences(false));
    }

    @Deprecated
    public static int checkERCWell(Cell cell, GeometryHandler.GHMode newAlgorithm, WellCheckPreferences wellPrefs) {
        ERCWellCheck check2 = new ERCWellCheck(cell, null, newAlgorithm, wellPrefs);
        return check2.runNow();
    }

    public static int checkERCWell(Cell cell, WellCheckPreferences wellPrefs) {
        ERCWellCheck check2 = new ERCWellCheck(cell, null, wellPrefs);
        return check2.runNow();
    }

    @Deprecated
    private ERCWellCheck(Cell cell, WellCheckJob job, GeometryHandler.GHMode newAlgorithm, WellCheckPreferences wellPrefs) {
        this.job = job;
        this.cell = cell;
        this.wellPrefs = wellPrefs;
        this.transistors = new HashMap<Integer, List<Transistor>>();
    }

    private ERCWellCheck(Cell cell, WellCheckJob job, WellCheckPreferences wellPrefs) {
        this.job = job;
        this.cell = cell;
        this.wellPrefs = wellPrefs;
        this.transistors = new HashMap<Integer, List<Transistor>>();
    }

    private int runNow() {
        System.out.println("Checking Wells and Substrates in '" + this.cell.libDescribe() + "' ...");
        ElapseTimer timer = ElapseTimer.createInstance().start();
        this.errorLogger = ErrorLogger.newInstance("ERC Well Check ");
        this.initStatistics();
        this.possiblePrimitives = new HashSet<Object>();
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Comparable<PrimitiveNode>> pIt = tech.getNodes();
            block1: while (pIt.hasNext()) {
                PrimitiveNode pn = pIt.next();
                Technology.NodeLayer[] nl = pn.getNodeLayers();
                for (int i = 0; i < nl.length; ++i) {
                    Layer lay = nl[i].getLayer();
                    if (!lay.getFunction().isSubstrate()) continue;
                    this.possiblePrimitives.add(pn);
                    continue block1;
                }
            }
            pIt = tech.getArcs();
            block3: while (pIt.hasNext()) {
                ArcProto ap = (ArcProto)pIt.next();
                for (int i = 0; i < ap.getNumArcLayers(); ++i) {
                    Layer lay = ap.getLayer(i);
                    if (!lay.getFunction().isSubstrate()) continue;
                    if (lay.getFunction().isWell()) {
                        this.pWellLayer = lay;
                    } else {
                        this.nWellLayer = lay;
                    }
                    this.possiblePrimitives.add(ap);
                    continue block3;
                }
            }
        }
        int errorCount = this.doNewWay();
        this.showStatistics();
        timer.end();
        if (errorCount == 0) {
            System.out.println("No Well errors found (took " + timer + ")");
        } else {
            System.out.println("FOUND " + errorCount + " WELL ERRORS (took " + timer + ")");
        }
        return errorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WellCon getNextWellCon(int threadIndex) {
        List<WellCon> list2 = this.wellConLists[threadIndex];
        synchronized (list2) {
            while (this.wellConIterator[threadIndex].hasNext()) {
                WellCon wc = this.wellConIterator[threadIndex].next();
                if (wc.getWellNum() != null) continue;
                return wc;
            }
        }
        int numLists = this.wellConIterator.length;
        for (int i = 1; i < numLists; ++i) {
            int otherList = (threadIndex + i) % numLists;
            List<WellCon> list3 = this.wellConLists[otherList];
            synchronized (list3) {
                while (this.wellConIterator[otherList].hasNext()) {
                    WellCon wc = this.wellConIterator[otherList].next();
                    if (wc.getWellNum() != null) continue;
                    return wc;
                }
                continue;
            }
        }
        return null;
    }

    private void spreadSeeds(int threadIndex) {
        WellCon wc;
        while ((wc = this.getNextWellCon(threadIndex)) != null) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(wc.getCtr().getX(), wc.getCtr().getY(), 0.0, 0.0);
            RTNode topSearch = this.nWellRoot;
            if (Utils.canBeSubstrateTap(wc.getFun())) {
                topSearch = this.pWellRoot;
            }
            boolean geomFound = false;
            RTNode.Search sea = new RTNode.Search(searchArea, topSearch, true);
            while (sea.hasNext()) {
                WellBound wb = (WellBound)sea.next();
                geomFound = true;
                wc.setWellNum(wb.netID);
                if (wc.getWellNum() == null) continue;
                break;
            }
            if (wc.getWellNum() != null) continue;
            wc.setWellNum(new NetValues());
            if (!geomFound) {
                String errorMsg = "N-Well contact is floating";
                if (Utils.canBeSubstrateTap(wc.getFun())) {
                    errorMsg = "P-Well contact is floating";
                }
                this.errorLogger.logError(errorMsg, new EPoint(wc.getCtr().getX(), wc.getCtr().getY()), this.cell, 0);
                continue;
            }
            Utils.spreadWellSeed(wc.getCtr().getX(), wc.getCtr().getY(), wc.getWellNum(), topSearch, threadIndex);
        }
    }

    private int doNewWay() {
        int maxProc;
        int numberOfThreads = 1;
        if (this.wellPrefs.parallelWellAnalysis) {
            numberOfThreads = Runtime.getRuntime().availableProcessors();
        }
        if (numberOfThreads > 1 && (maxProc = this.wellPrefs.maxProc) > 0) {
            numberOfThreads = maxProc;
        }
        this.hasNCon = false;
        this.hasPCon = false;
        NetValues.numberOfMerges = 0;
        this.pWellRoot = RTNode.makeTopLevel();
        this.nWellRoot = RTNode.makeTopLevel();
        ElapseTimer timer = ElapseTimer.createInstance().start();
        WellCheckVisitor wcVisitor = new WellCheckVisitor();
        HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)wcVisitor);
        int numPRects = this.getTreeSize(this.pWellRoot);
        int numNRects = this.getTreeSize(this.nWellRoot);
        timer.end();
        System.out.println("   Geometry collection found " + (numPRects + numNRects) + " well pieces, took " + timer);
        wcVisitor.clear();
        wcVisitor = null;
        if (numberOfThreads == 0) {
            numberOfThreads = Runtime.getRuntime().availableProcessors();
        }
        IThreadPool.NUM_THREADS = numberOfThreads;
        this.threadPool = Configuration.lookup(IThreadPool.class, new Object[0]);
        timer.start();
        try {
            this.assignWellContacts(numberOfThreads);
            if (Job.getDebug()) {
                timer.end();
                System.out.println("   Assign well contacts took: " + timer);
                timer.start();
            }
            NetValues.reset();
            if (numberOfThreads <= 1) {
                this.spreadSeeds(0);
            } else {
                PJob spreadJob = new PJob(this.threadPool);
                for (int i = 0; i < numberOfThreads; ++i) {
                    spreadJob.add(new SpreadInThread(spreadJob, i));
                }
                spreadJob.execute();
            }
            timer.end();
            String msg = "   Geometry analysis ";
            if (numberOfThreads > 1) {
                msg = msg + "used " + numberOfThreads + " threads and ";
            }
            msg = msg + "took ";
            System.out.println(msg + timer);
            try {
                this.threadPool.shutdown();
                this.threadPool.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            timer.start();
            if (Job.getDebug()) {
                System.out.println("   Amount of merges: " + NetValues.numberOfMerges);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        StrategyParameter parameter = new StrategyParameter(this.wellCons, this.wellPrefs, this.cell, this.errorLogger);
        ArrayList<WellCheckAnalysisStrategy> analysisParts = CollectionFactory.createArrayList();
        analysisParts.add(new ShortCircuitCheck(parameter));
        analysisParts.add(new OnRailCheck(parameter, this.networkExportAvailable, this.transistors));
        analysisParts.add(new ConnectionCheck(parameter, this.hasPCon, this.hasNCon, this.pWellRoot, this.nWellRoot));
        analysisParts.add(new DRCCheck(parameter, this.pWellLayer, this.nWellLayer, this.pWellRoot, this.nWellRoot));
        analysisParts.add(new DistanceCheck(parameter, this.worstPWellDist, this.worstPWellCon, this.worstPWellEdge, this.worstNWellDist, this.worstNWellCon, this.worstNWellEdge, this.pWellRoot, this.nWellRoot));
        for (WellCheckAnalysisStrategy strategy : analysisParts) {
            strategy.execute();
        }
        timer.end();
        System.out.println("   Additional analysis took " + timer);
        this.errorLogger.termLogging(true);
        int errorCount = this.errorLogger.getNumErrors();
        return errorCount;
    }

    private void assignWellContacts(int numberOfThreads) {
        this.wellConIterator = new Iterator[numberOfThreads];
        this.wellConLists = new List[numberOfThreads];
        if (numberOfThreads == 1) {
            this.wellConLists[0] = this.wellCons;
        } else {
            int i;
            for (i = 0; i < numberOfThreads; ++i) {
                this.wellConLists[i] = new ArrayList<WellCon>();
            }
            if (Utils.WORKDISTRIBUTION == Utils.WorkDistributionStrategy.cluster) {
                ERectangle cellBounds = this.cell.getBounds();
                Point2D.Double ctr = new Point2D.Double(cellBounds.getCenterX(), cellBounds.getCenterY());
                Point2D[] farPoints = new Point2D[numberOfThreads];
                for (int i2 = 0; i2 < numberOfThreads; ++i2) {
                    double farthest = 0.0;
                    farPoints[i2] = new Point2D.Double(0.0, 0.0);
                    for (WellCon wc : this.wellCons) {
                        double dist = 0.0;
                        if (i2 == 0) {
                            dist += wc.getCtr().distance(ctr);
                        } else {
                            for (int j = 0; j < i2; ++j) {
                                dist += wc.getCtr().distance(farPoints[j]);
                            }
                        }
                        if (!(dist > farthest)) continue;
                        farthest = dist;
                        farPoints[i2].setLocation(wc.getCtr());
                    }
                }
                for (WellCon wc : this.wellCons) {
                    double minDist = Double.MAX_VALUE;
                    int threadNum = 0;
                    for (int j = 0; j < numberOfThreads; ++j) {
                        double dist = wc.getCtr().distance(farPoints[j]);
                        if (!(dist < minDist)) continue;
                        minDist = dist;
                        threadNum = j;
                    }
                    this.wellConLists[threadNum].add(wc);
                }
            } else if (Utils.WORKDISTRIBUTION == Utils.WorkDistributionStrategy.random) {
                for (i = 0; i < this.wellCons.size(); ++i) {
                    this.wellConLists[i % numberOfThreads].add(this.wellCons.get(i));
                }
            } else if (Utils.WORKDISTRIBUTION == Utils.WorkDistributionStrategy.bucket) {
                GridDim dim = this.calculateGridDim(numberOfThreads);
                double sizeCellX = this.cell.getDefWidth() / (double)dim.xDim;
                double sizeCellY = this.cell.getDefHeight() / (double)dim.yDim;
                int stepWidth = this.wellCons.size() < numberOfThreads ? this.wellCons.size() : this.wellCons.size() / numberOfThreads;
                Parallel.For(new BlockedRange1D(0, this.wellCons.size(), stepWidth), new WorkDistributionTask(sizeCellX, sizeCellY, dim), this.threadPool);
            }
        }
        for (int i = 0; i < numberOfThreads; ++i) {
            this.wellConIterator[i] = this.wellConLists[i].iterator();
        }
    }

    private GridDim calculateBucket(WellCon con, double sizeX, double sizeY) {
        GridDim result2 = new GridDim();
        result2.xDim = (int)((con.getCtr().getX() - this.cell.getBounds().getMinX()) / sizeX);
        result2.yDim = (int)((con.getCtr().getY() - this.cell.getBounds().getMinY()) / sizeY);
        return result2;
    }

    private GridDim calculateGridDim(int numberOfThreads) {
        GridDim result2 = new GridDim();
        for (int i = (int)Math.sqrt(numberOfThreads); i >= 1; --i) {
            if (i * (numberOfThreads / i) != numberOfThreads) continue;
            result2.xDim = i;
            result2.yDim = numberOfThreads / i;
            return result2;
        }
        return null;
    }

    private int getTreeSize(RTNode rtree) {
        int total = 0;
        if (rtree.getFlag()) {
            total += rtree.getTotal();
        } else {
            for (int j = 0; j < rtree.getTotal(); ++j) {
                RTNode child = (RTNode)rtree.getChild(j);
                total += this.getTreeSize(child);
            }
        }
        return total;
    }

    private static WellType getWellLayerType(Layer layer) {
        Layer.Function fun = layer.getFunction();
        if (layer.isPseudoLayer()) {
            return WellType.none;
        }
        if (fun == Layer.Function.WELLP) {
            return WellType.pwell;
        }
        if (fun == Layer.Function.WELL || fun == Layer.Function.WELLN) {
            return WellType.nwell;
        }
        return WellType.none;
    }

    private void initStatistics() {
    }

    private void showStatistics() {
    }

    private class ShowWellBoundOrder
    extends EModelessDialog {
        private Timer vcrTimer;
        private long vcrLastAdvance;
        private int wbIndex;
        private int speed;
        private JTextField tf;
        private Highlighter h;
        private Color[] hColors;

        public ShowWellBoundOrder() {
            super(TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame() : null);
            this.hColors = new Color[]{Color.WHITE, Color.RED, Color.GREEN, Color.BLUE};
            this.initComponents();
            this.finishInitialization();
            this.setVisible(true);
            this.wbIndex = 0;
            EditWindow wnd = EditWindow.getCurrent();
            this.h = wnd.getHighlighter();
            this.h.clear();
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Show ERC Progress");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ShowWellBoundOrder.this.closeDialog();
                }
            });
            JButton go = new JButton("Go");
            go.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowWellBoundOrder.this.goNow();
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)go, gridBagConstraints);
            JButton stop = new JButton("Stop");
            stop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowWellBoundOrder.this.stopNow();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)stop, gridBagConstraints);
            JLabel lab = new JLabel("Speed:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab, gridBagConstraints);
            this.speed = 1;
            this.tf = new JTextField(Integer.toString(this.speed));
            this.tf.getDocument().addDocumentListener(new BoundsPlayerDocumentListener());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.tf, gridBagConstraints);
            this.pack();
        }

        private void updateSpeed() {
            this.speed = TextUtils.atoi(this.tf.getText());
            if (this.vcrTimer != null) {
                this.vcrTimer.setDelay(this.speed);
            }
        }

        private void goNow() {
            if (this.vcrTimer == null) {
                ActionListener taskPerformer = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        ShowWellBoundOrder.this.tick();
                    }
                };
                this.vcrTimer = new Timer(this.speed, taskPerformer);
                this.vcrLastAdvance = System.currentTimeMillis();
                this.vcrTimer.start();
            }
        }

        private void stopNow() {
            if (this.vcrTimer == null) {
                return;
            }
            this.vcrTimer.stop();
            this.vcrTimer = null;
        }

        private void tick() {
            long curtime = System.currentTimeMillis();
            if (curtime - this.vcrLastAdvance < (long)this.speed) {
                return;
            }
            this.vcrLastAdvance = curtime;
            if (this.wbIndex >= Utils.wellBoundSearchOrder.size()) {
                this.stopNow();
            } else {
                WellBoundRecord wbr = Utils.wellBoundSearchOrder.get(this.wbIndex++);
                this.h.addPoly(new Poly(wbr.wb.bound), ERCWellCheck.this.cell, this.hColors[wbr.processor]);
                this.h.finished();
            }
        }

        private class BoundsPlayerDocumentListener
        implements DocumentListener {
            BoundsPlayerDocumentListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                ShowWellBoundOrder.this.updateSpeed();
            }

            public void insertUpdate(DocumentEvent e) {
                ShowWellBoundOrder.this.updateSpeed();
            }

            public void removeUpdate(DocumentEvent e) {
                ShowWellBoundOrder.this.updateSpeed();
            }
        }
    }

    public static class WellBoundRecord {
        private WellBound wb;
        private int processor;

        public WellBoundRecord(WellBound w, int p) {
            this.wb = w;
            this.processor = p;
        }

        public WellBound getWb() {
            return this.wb;
        }

        public void setWb(WellBound wb) {
            this.wb = wb;
        }

        public int getProcessor() {
            return this.processor;
        }

        public void setProcessor(int processor) {
            this.processor = processor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WellCheckVisitor
    extends HierarchyEnumerator.Visitor {
        private Map<Cell, List<Rectangle2D>> essentialPWell = new HashMap<Cell, List<Rectangle2D>>();
        private Map<Cell, List<Rectangle2D>> essentialNWell = new HashMap<Cell, List<Rectangle2D>>();
        private Map<Network, NetRails> networkCache = new HashMap<Network, NetRails>();
        private Map<Integer, Transistor> neighborCache;

        public WellCheckVisitor() {
            ERCWellCheck.this.networkExportAvailable = new HashSet();
            this.neighborCache = new HashMap<Integer, Transistor>();
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (ERCWellCheck.this.job != null && ERCWellCheck.this.job.checkAbort()) {
                return false;
            }
            Cell cell = info.getCell();
            this.ensureCellCached(cell);
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Rectangle2D.Double bounds;
            if (ERCWellCheck.this.job != null && ERCWellCheck.this.job.checkAbort()) {
                return;
            }
            Cell cell = info.getCell();
            List<Rectangle2D> pWellsInCell = this.essentialPWell.get(cell);
            List<Rectangle2D> nWellsInCell = this.essentialNWell.get(cell);
            for (Rectangle2D b : pWellsInCell) {
                bounds = new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
                DBMath.transformRect(bounds, info.getTransformToRoot());
                ERCWellCheck.this.pWellRoot = RTNode.linkGeom(null, ERCWellCheck.this.pWellRoot, new WellBound(bounds));
            }
            for (Rectangle2D b : nWellsInCell) {
                bounds = new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
                DBMath.transformRect(bounds, info.getTransformToRoot());
                ERCWellCheck.this.nWellRoot = RTNode.linkGeom(null, ERCWellCheck.this.nWellRoot, new WellBound(bounds));
            }
        }

        private void addNetwork(Network net, AtomicInteger netNum, HierarchyEnumerator.CellInfo cinfo, Transistor trans) {
            if (net != null) {
                Integer num = cinfo.getNetID(net);
                netNum.set(num);
                if (!ERCWellCheck.this.transistors.containsKey(num)) {
                    LinkedList tmpList = new LinkedList();
                    ERCWellCheck.this.transistors.put(num, tmpList);
                }
                ((List)ERCWellCheck.this.transistors.get(num)).add(trans);
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            PrimitiveNode.Function fun = ni.getFunction();
            Netlist netList = info.getNetlist();
            if (fun.isNTypeTransistor() || fun.isPTypeTransistor()) {
                Transistor trans = new Transistor();
                this.addNetwork(netList.getNetwork(ni.getTransistorDrainPort()), trans.drainNet, info, trans);
                this.addNetwork(netList.getNetwork(ni.getTransistorSourcePort()), trans.sourceNet, info, trans);
            } else if (Utils.canBeSubstrateTap(fun) || Utils.canBeWellTap(fun)) {
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    Network net = netList.getNetwork(pi);
                    int tmpNetNum = 0;
                    tmpNetNum = net == null ? -1 : info.getNetID(net);
                    WellCon wc = new WellCon(ni.getTrueCenter(), tmpNetNum, null, false, false, fun, ni);
                    AffineTransform trans = ni.rotateOut();
                    trans.transform(wc.getCtr(), wc.getCtr());
                    info.getTransformToRoot().transform(wc.getCtr(), wc.getCtr());
                    if (net != null) {
                        Network parentNet = net;
                        HierarchyEnumerator.CellInfo cinfo = info;
                        while (cinfo.getParentInst() != null) {
                            parentNet = cinfo.getNetworkInParent(parentNet);
                            cinfo = cinfo.getParentInfo();
                        }
                        if (parentNet != null) {
                            NetRails nr = this.networkCache.get(parentNet);
                            if (nr == null) {
                                nr = new NetRails();
                                this.networkCache.put(parentNet, nr);
                                Iterator<Export> it = parentNet.getExports();
                                while (it.hasNext()) {
                                    Export exp = it.next();
                                    ERCWellCheck.this.networkExportAvailable.add(parentNet.getNetIndex());
                                    if (exp.isGround()) {
                                        nr.onGround = true;
                                    }
                                    if (exp.isPower()) {
                                        nr.onPower = true;
                                    }
                                    nr.onExport = true;
                                }
                            }
                            boolean searchWell = Utils.canBeSubstrateTap(fun);
                            if (Utils.canBeSubstrateTap(wc.getFun())) {
                                ERCWellCheck.this.hasPCon = true;
                            } else {
                                ERCWellCheck.this.hasNCon = true;
                            }
                            if (searchWell) {
                                ERCWellCheck.this.hasPCon = true;
                            } else {
                                ERCWellCheck.this.hasNCon = true;
                            }
                            if (searchWell && nr.onGround || !searchWell && nr.onPower) {
                                wc.setOnProperRail(true);
                            }
                            if (nr.onExport) {
                                wc.setOnRail(true);
                            }
                        }
                    }
                    ERCWellCheck.this.wellCons.add(wc);
                }
            }
            return true;
        }

        private void ensureCellCached(Cell cell) {
            List<Rectangle2D> pWellsInCell = this.essentialPWell.get(cell);
            List<Rectangle2D> nWellsInCell = this.essentialNWell.get(cell);
            if (pWellsInCell == null) {
                Layer layer;
                pWellsInCell = new ArrayList<Rectangle2D>();
                nWellsInCell = new ArrayList<Rectangle2D>();
                Iterator<Geometric> it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (ni.isCellInstance()) continue;
                    PrimitiveNode pn = (PrimitiveNode)ni.getProto();
                    if (!ERCWellCheck.this.possiblePrimitives.contains(pn)) continue;
                    for (Poly poly : pn.getTechnology().getShapeOfNode(ni, true, true, ercLayers)) {
                        layer = poly.getLayer();
                        AffineTransform trans = ni.rotateOut();
                        poly.transform(trans);
                        Rectangle2D bound = poly.getBounds2D();
                        WellType wellType = ERCWellCheck.getWellLayerType(layer);
                        if (wellType == WellType.pwell) {
                            pWellsInCell.add(bound);
                            continue;
                        }
                        if (wellType != WellType.nwell) continue;
                        nWellsInCell.add(bound);
                    }
                }
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    ArcProto ap = ai.getProto();
                    if (!ERCWellCheck.this.possiblePrimitives.contains(ap)) continue;
                    for (Poly poly : ap.getTechnology().getShapeOfArc(ai, ercLayers)) {
                        layer = poly.getLayer();
                        Rectangle2D bound = poly.getBounds2D();
                        WellType wellType = ERCWellCheck.getWellLayerType(layer);
                        if (wellType == WellType.pwell) {
                            pWellsInCell.add(bound);
                            continue;
                        }
                        if (wellType != WellType.nwell) continue;
                        nWellsInCell.add(bound);
                    }
                }
                this.eliminateDuplicates(pWellsInCell);
                this.eliminateDuplicates(nWellsInCell);
                this.essentialPWell.put(cell, pWellsInCell);
                this.essentialNWell.put(cell, nWellsInCell);
            }
        }

        private void eliminateDuplicates(List<Rectangle2D> wbList) {
            Collections.sort(wbList, new RectangleBySize());
            block0: for (int i = 0; i < wbList.size(); ++i) {
                Rectangle2D b = wbList.get(i);
                for (int j = 0; j < i; ++j) {
                    Rectangle2D prevB = wbList.get(j);
                    if (!prevB.contains(b)) continue;
                    wbList.remove(i);
                    --i;
                    continue block0;
                }
            }
        }

        public void clear() {
            this.neighborCache.clear();
            this.networkCache.clear();
            this.neighborCache = null;
            this.networkCache = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RectangleBySize
    implements Comparator<Rectangle2D> {
        private RectangleBySize() {
        }

        @Override
        public int compare(Rectangle2D b1, Rectangle2D b2) {
            double s2;
            double s1 = b1.getWidth() * b1.getHeight();
            if (s1 > (s2 = b2.getWidth() * b2.getHeight())) {
                return -1;
            }
            if (s1 < s2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WellNet {
        private List<Point2D> pointsOnNet;
        private List<WellCon> contactsOnNet;
        private PrimitiveNode.Function fun;

        public WellNet(List<Point2D> pointsOnNet, List<WellCon> contactsOnNet, PrimitiveNode.Function fun) {
            this.pointsOnNet = pointsOnNet;
            this.contactsOnNet = contactsOnNet;
            this.fun = fun;
        }

        public List<Point2D> getPointsOnNet() {
            return this.pointsOnNet;
        }

        public void setPointsOnNet(List<Point2D> pointsOnNet) {
            this.pointsOnNet = pointsOnNet;
        }

        public List<WellCon> getContactsOnNet() {
            return this.contactsOnNet;
        }

        public void setContactsOnNet(List<WellCon> contactsOnNet) {
            this.contactsOnNet = contactsOnNet;
        }

        public PrimitiveNode.Function getFun() {
            return this.fun;
        }

        public void setFun(PrimitiveNode.Function fun) {
            this.fun = fun;
        }
    }

    private static class NetRails {
        boolean onGround;
        boolean onPower;
        boolean onExport;

        private NetRails() {
        }
    }

    public static class WellBound
    implements RTBounds {
        private Rectangle2D bound;
        private NetValues netID;

        WellBound(Rectangle2D bound) {
            this.bound = bound;
            this.netID = null;
        }

        public Rectangle2D getBounds() {
            return this.bound;
        }

        public NetValues getNetID() {
            return this.netID;
        }

        public void setNetID(NetValues netNum) {
            this.netID = netNum;
        }

        public String toString() {
            return "Well Bound on net " + this.netID.getIndex();
        }
    }

    public static class Transistor {
        private AtomicInteger drainNet = new AtomicInteger();
        private AtomicInteger sourceNet = new AtomicInteger();

        public AtomicInteger getDrainNet() {
            return this.drainNet;
        }

        public void setDrainNet(AtomicInteger drainNet) {
            this.drainNet = drainNet;
        }

        public AtomicInteger getSourceNet() {
            return this.sourceNet;
        }

        public void setSourceNet(AtomicInteger sourceNet) {
            this.sourceNet = sourceNet;
        }
    }

    private static class GridDim {
        private int xDim;
        private int yDim;

        private GridDim() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WorkDistributionTask
    extends PForTask<BlockedRange1D> {
        private double sizeX;
        private double sizeY;
        private GridDim dim;

        public WorkDistributionTask(double sizeX, double sizeY, GridDim dim) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.dim = dim;
        }

        @Override
        public void execute() {
            for (int i = ((BlockedRange1D)this.range).start(); i < ((BlockedRange1D)this.range).end(); ++i) {
                WellCon con = (WellCon)ERCWellCheck.this.wellCons.get(i);
                GridDim tmpDim = ERCWellCheck.this.calculateBucket(con, this.sizeX, this.sizeY);
                int threadId = tmpDim.xDim + tmpDim.yDim * this.dim.xDim;
                CollectionFactory.threadSafeListAdd(con, ERCWellCheck.this.wellConLists[threadId]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StrategyParameter {
        private final List<WellCon> wellCons;
        private final WellCheckPreferences wellPrefs;
        private final Cell cell;
        private final ErrorLogger errorLogger;

        public StrategyParameter(List<WellCon> wellCons, WellCheckPreferences wellPrefs, Cell cell, ErrorLogger errorLogger) {
            this.wellCons = wellCons;
            this.wellPrefs = wellPrefs;
            this.cell = cell;
            this.errorLogger = errorLogger;
        }

        public List<WellCon> getWellCons() {
            return this.wellCons;
        }

        public WellCheckPreferences getWellPrefs() {
            return this.wellPrefs;
        }

        public Cell getCell() {
            return this.cell;
        }

        private Rectangle2D placedWellCon(WellCon wc) {
            Rectangle2D orig = wc.getNi().getBounds();
            return new Rectangle2D.Double(wc.getCtr().getX() - orig.getWidth() / 2.0, wc.getCtr().getY() - orig.getHeight() / 2.0, orig.getWidth(), orig.getHeight());
        }

        public void logError(String message) {
            this.errorLogger.logError(message, this.cell, 0);
        }

        public void logError(String message, Object ... wblist) {
            ArrayList<Rectangle2D> list2 = new ArrayList<Rectangle2D>();
            for (Object w : wblist) {
                if (w instanceof WellBound) {
                    list2.add(((WellBound)w).getBounds());
                    continue;
                }
                if (!(w instanceof WellCon)) continue;
                list2.add(this.placedWellCon((WellCon)w));
            }
            this.errorLogger.logMessage(message, list2, this.cell, 0, true);
        }
    }

    public class SpreadInThread
    extends PTask {
        private int threadIndex;

        public SpreadInThread(PJob job, int index2) {
            super(job);
            this.threadIndex = index2;
        }

        public void execute() {
            ERCWellCheck.this.spreadSeeds(this.threadIndex);
        }
    }

    private static class WellCheckJob
    extends Job {
        private Cell cell;
        private double worstPWellDist;
        private double worstNWellDist;
        private EPoint worstPWellCon;
        private EPoint worstPWellEdge;
        private EPoint worstNWellCon;
        private EPoint worstNWellEdge;
        private WellCheckPreferences wellPrefs;

        @Deprecated
        private WellCheckJob(Cell cell, GeometryHandler.GHMode newAlgorithm, WellCheckPreferences wellPrefs) {
            super("ERC Well Check on " + cell, ERC.tool, Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.wellPrefs = wellPrefs;
            this.startJob();
        }

        private WellCheckJob(Cell cell, WellCheckPreferences wellPrefs) {
            super("ERC Well Check on " + cell, ERC.tool, Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.wellPrefs = wellPrefs;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            ERCWellCheck check2 = new ERCWellCheck(this.cell, this, this.wellPrefs);
            check2.runNow();
            this.worstPWellDist = check2.worstPWellDist;
            this.fieldVariableChanged("worstPWellDist");
            this.worstNWellDist = check2.worstNWellDist;
            this.fieldVariableChanged("worstNWellDist");
            if (check2.worstPWellCon != null) {
                this.worstPWellCon = new EPoint(check2.worstPWellCon.getX(), check2.worstPWellCon.getY());
                this.fieldVariableChanged("worstPWellCon");
            }
            if (check2.worstPWellEdge != null) {
                this.worstPWellEdge = new EPoint(check2.worstPWellEdge.getX(), check2.worstPWellEdge.getY());
                this.fieldVariableChanged("worstPWellEdge");
            }
            if (check2.worstNWellCon != null) {
                this.worstNWellCon = new EPoint(check2.worstNWellCon.getX(), check2.worstNWellCon.getY());
                this.fieldVariableChanged("worstNWellCon");
            }
            if (check2.worstNWellEdge != null) {
                this.worstNWellEdge = new EPoint(check2.worstNWellEdge.getX(), check2.worstNWellEdge.getY());
                this.fieldVariableChanged("worstNWellEdge");
            }
            return true;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd != null && (this.worstPWellDist > 0.0 || this.worstNWellDist > 0.0)) {
                wnd.clearHighlighting();
                if (this.worstPWellDist > 0.0) {
                    wnd.addHighlightLine(this.worstPWellCon, this.worstPWellEdge, this.cell, false, false);
                    System.out.println("Farthest distance from a P-Well contact is " + this.worstPWellDist);
                }
                if (this.worstNWellDist > 0.0) {
                    wnd.addHighlightLine(this.worstNWellCon, this.worstNWellEdge, this.cell, false, false);
                    System.out.println("Farthest distance from an N-Well contact is " + this.worstNWellDist);
                }
                wnd.finishedHighlighting();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WellType {
        none("none"),
        nwell("N"),
        pwell("P");

        private String name;

        private WellType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class WellCheckPreferences
    extends PrefPackage {
        private static final String PREF_NODE = "tool/erc";
        @PrefPackage.BooleanPref(node="tool/erc", key="ParallelWellAnalysis", factory=true)
        public boolean parallelWellAnalysis;
        @PrefPackage.IntegerPref(node="tool/erc", key="WellAnalysisNumProc", factory=0)
        public int maxProc;
        @PrefPackage.BooleanPref(node="tool/erc", key="MustConnectPWellToGround", factory=true)
        public boolean mustConnectPWellToGround;
        @PrefPackage.BooleanPref(node="tool/erc", key="MustConnectNWellToPower", factory=true)
        public boolean mustConnectNWellToPower;
        @PrefPackage.IntegerPref(node="tool/erc", key="PWellCheck", factory=0)
        public int pWellCheck;
        @PrefPackage.IntegerPref(node="tool/erc", key="NWellCheck", factory=0)
        public int nWellCheck;
        @PrefPackage.BooleanPref(node="tool/erc", key="DRCCheckInERC", factory=false)
        public boolean drcCheck;
        @PrefPackage.BooleanPref(node="tool/erc", key="FindWorstCaseWell", factory=false)
        public boolean findWorstCaseWell;

        public WellCheckPreferences(boolean factory) {
            super(factory);
        }
    }
}

