/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.Main;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.UserInterfaceInitial;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class Regression {
    public static boolean runScript(Process process, String script) {
        Pref.forbidPreferences();
        IdReader reader = null;
        Snapshot currentSnapshot = IdManager.stdIdManager.getInitialSnapshot();
        System.out.println("Running " + script);
        try {
            InputStream inStream = process.getInputStream();
            OutputStream outStream = process.getOutputStream();
            InputStream errStream = process.getErrorStream();
            new ExecProcessReader(errStream).start();
            reader = new IdReader(new DataInputStream(new BufferedInputStream(inStream)), IdManager.stdIdManager);
            int protocolVersion = reader.readInt();
            if (protocolVersion != 20) {
                System.out.println("Client's protocol version 20 is incompatible with Server's protocol version " + protocolVersion);
                for (int i = 0; i < 100; ++i) {
                    System.out.print((char)reader.readByte());
                }
                System.out.println();
                return false;
            }
            int connectionId = reader.readInt();
            System.out.format("%1$tT.%1$tL ", Calendar.getInstance());
            System.out.println("Connected id=" + connectionId);
            DataOutputStream clientOutputStream = new DataOutputStream(new BufferedOutputStream(outStream));
            Regression.writeServerJobs(clientOutputStream, connectionId, script);
            clientOutputStream.close();
            int curJobId = -1;
            Main.UserInterfaceDummy ui = new Main.UserInterfaceDummy();
            ui.patchConnectionId(connectionId);
            boolean passed = true;
            while (true) {
                byte tag = reader.readByte();
                long timeStamp = reader.readLong();
                if (tag == 1) {
                    currentSnapshot = Snapshot.readSnapshot(reader, currentSnapshot);
                    System.out.println("Snapshot received " + currentSnapshot.snapshotId);
                    continue;
                }
                Client.ServerEvent serverEvent = Client.read(reader, tag, timeStamp, ui, currentSnapshot);
                if (serverEvent instanceof Client.EJobEvent) {
                    Client.EJobEvent e = (Client.EJobEvent)serverEvent;
                    int jobId = e.jobKey.jobId;
                    assert (e.newState == EJob.State.SERVER_DONE);
                    if (jobId > 0) {
                        if (e.doItOk) continue;
                        System.out.println("Job " + e.jobName + " failed");
                        passed = false;
                        continue;
                    }
                    assert (jobId == curJobId);
                    if (!e.doItOk) {
                        System.out.println("Job " + e.jobName + " exception");
                        passed = false;
                    } else {
                        System.out.println("Job " + jobId + " ok");
                    }
                    switch (jobId) {
                        case -1: {
                            curJobId = -2;
                            break;
                        }
                        case -2: {
                            curJobId = -3;
                            break;
                        }
                    }
                    continue;
                }
                serverEvent.show(ui);
                if (serverEvent instanceof Client.ShutdownEvent) break;
            }
            assert (curJobId == -3);
            ui.saveMessages(null);
            return passed;
        }
        catch (IOException e) {
            reader = null;
            System.out.println("END OF FILE reading from server");
            try {
                Thread.sleep(1000L);
                System.out.println("Server exit code=" + process.exitValue());
                process.getOutputStream().close();
            }
            catch (Exception e1) {
                e1.printStackTrace(System.out);
            }
            return false;
        }
    }

    private static void printErrorStream(Process process) {
        try {
            int c;
            BufferedInputStream errStream = new BufferedInputStream(process.getErrorStream());
            System.out.println("<StdErr>");
            while (((InputStream)errStream).available() != 0 && (c = ((InputStream)errStream).read()) >= 0) {
                System.out.print((char)c);
            }
            System.out.println("</StdErr>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Regression.makeCrashInput(args[0]);
    }

    private static void makeCrashInput(String fileName) {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            Regression.writeServerJobs(out, 0, "CRASH");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeServerJobs(DataOutputStream clientOutputStream, int connectionId, String script) throws IOException {
        EDatabase database = new EDatabase(IdManager.stdIdManager.getInitialEnvironment());
        Job.setUserInterface(new UserInterfaceInitial(database));
        InitJob job1 = new InitJob();
        job1.ejob.jobKey = new Job.Key(connectionId, -1, true);
        Job job2 = script.equals("CRASH") ? new CrashJob() : EvalJavaBsh.runScriptJob(script);
        job2.ejob.jobKey = new Job.Key(connectionId, -2, true);
        QuitJob job3 = new QuitJob();
        job3.ejob.jobKey = new Job.Key(connectionId, -3, true);
        Regression.writeEditingPreferences(clientOutputStream, database);
        Regression.writeJob(clientOutputStream, job1);
        Regression.writeJob(clientOutputStream, job2);
        Regression.writeJob(clientOutputStream, job3);
    }

    private static void writeEditingPreferences(DataOutputStream clientOutputStream, EDatabase database) throws IOException {
        byte[] serializedEp;
        EditingPreferences ep = new EditingPreferences(true, database.getTechPool());
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            out.writeObject(ep);
            out.flush();
            serializedEp = byteStream.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        clientOutputStream.writeByte(2);
        clientOutputStream.writeInt(serializedEp.length);
        clientOutputStream.write(serializedEp);
    }

    private static void writeJob(DataOutputStream clientOutputStream, Job job) throws IOException {
        EJob ejob = job.ejob;
        ejob.serialize(EDatabase.clientDatabase());
        clientOutputStream.writeByte(1);
        clientOutputStream.writeInt(ejob.jobKey.jobId);
        clientOutputStream.writeUTF(ejob.jobType.toString());
        clientOutputStream.writeUTF(ejob.jobName);
        clientOutputStream.writeInt(ejob.serializedJob.length);
        clientOutputStream.write(ejob.serializedJob);
        clientOutputStream.flush();
    }

    public static class ExecProcessReader
    extends Thread {
        private InputStream in;
        private char[] buf;

        public ExecProcessReader(InputStream in) {
            this.in = in;
            this.buf = new char[256];
            this.setName("ExecProcessReader");
        }

        public void run() {
            try {
                InputStreamReader reader = new InputStreamReader(this.in);
                int read2 = 0;
                while ((read2 = reader.read(this.buf)) >= 0) {
                    String s = new String(this.buf, 0, read2);
                    Calendar c = Calendar.getInstance();
                    System.err.print(s);
                    System.out.format("%1$tT.%1$tL <err> %2$s </err>\n", c, s);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                e.printStackTrace(System.out);
            }
        }
    }

    private static class QuitJob
    extends Job {
        private QuitJob() {
            super("QuitJob", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        }

        public boolean doIt() throws JobException {
            Client.fireServerEvent(new Client.ShutdownEvent());
            return true;
        }
    }

    private static class CrashJob
    extends Job {
        protected CrashJob() {
            super("CrashTest", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        }

        public boolean doIt() throws JobException {
            String regressionname = "qFourP2-electric-final-jelib";
            String libname = "qFourP2.jelib";
            String cellname = "qFourP1top";
            String rootPath = "../../";
            boolean caching = true;
            String logname = "output/" + libname + "_" + cellname + "_LE_" + (caching ? "C" : "NC") + "-" + Version.getVersion() + ".log";
            MessagesStream.getMessagesStream().save(logname);
            Library rootLib = LayoutLib.openLibForRead(rootPath + "data/" + regressionname + "/" + libname);
            ErrorLogger repairLogger = ErrorLogger.newInstance("Repair Libraries");
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                lib.checkAndRepair(true, repairLogger);
            }
            System.out.println("Repair Libraries: " + repairLogger.getNumErrors() + " errors," + repairLogger.getNumWarnings() + " warnings");
            Cell lay = rootLib.findNodeProto(cellname + "{sch}");
            System.out.println("Cell = " + lay);
            return true;
        }
    }

    private static class InitJob
    extends Job {
        private InitJob() {
            super("InitJob", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
        }

        public boolean doIt() throws JobException {
            this.database.setToolSettings((Setting.RootGroup)ToolSettings.getToolSettings(""));
            assert (this.database.getGeneric() == null);
            Generic generic = Generic.newInstance(this.database.getIdManager());
            this.database.addTech(generic);
            for (TechFactory techFactory : TechFactory.getKnownTechs().values()) {
                Map<TechFactory.Param, Object> paramValues;
                Technology tech = techFactory.newInstance(generic, paramValues = Collections.emptyMap());
                if (tech == null) continue;
                this.database.addTech(tech);
            }
            return true;
        }
    }
}

