/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.merge;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.bool.UnloadPolys;
import com.sun.electric.database.geometry.bool.VectorCache;
import com.sun.electric.database.geometry.merge.LayoutMergerScalaImpl;
import com.sun.electric.database.geometry.merge.Main$;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.util.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric$IntIsIntegral$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main$
implements ScalaObject {
    public static final Main$ MODULE$;

    static {
        new Main$();
    }

    public void initElectric() {
        TextDescriptor.cacheSize();
        Tool.initAllTools();
        Pref.lockCreation();
        EDatabase database = new EDatabase(IdManager.stdIdManager.getInitialSnapshot(), "serverDB");
        Job.setUserInterface(new anon.1());
        EDatabase.setServerDatabase(database);
        database.lock(true);
        Technology.initPreinstalledTechnologies(database, Technology.getParamValuesByXmlPath());
    }

    public Library loadLibrary(String libPath) {
        EDatabase database = EDatabase.serverDatabase();
        database.lowLevelBeginChanging(null);
        Library exceptionResult1 = null;
        try {
            URL libUrl = TextUtils.makeURLToFile(libPath);
            String libName = TextUtils.getFileNameWithoutExtension(libUrl);
            FileType fileType = libPath.endsWith(".delib") ? FileType.DELIB : FileType.JELIB;
            exceptionResult1 = LibraryFiles.readLibrary(libUrl, libName, fileType, true);
            return exceptionResult1;
        }
        finally {
            database.backup();
            database.lowLevelEndChanging();
        }
    }

    public Cell loadCell(String libFile, String cellName) {
        return this.loadLibrary(libFile).findNodeProto(cellName);
    }

    public int countHier(CellTree top, Function1<CellTree, Integer> localCount) {
        return BoxesRunTime.unboxToInt(((TraversableOnce)this.downTop(top).map(localCount, Seq$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
    }

    public Function1<CellId, Integer> countFlat(CellTree top, Function1<CellTree, Integer> localCount$1) {
        Seq<CellTree> cells = this.downTop(top);
        LinkedHashMap result$1 = (LinkedHashMap)LinkedHashMap$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        cells.foreach(new anonfun.countFlat.1(localCount$1, result$1));
        return result$1;
    }

    public Seq<CellTree> downTop(CellTree top) {
        LinkedHashSet result$2 = (LinkedHashSet)LinkedHashSet$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new CellTree[0]));
        this.downTop$1(top, result$2);
        return result$2.toSeq();
    }

    public Iterable<PolyBase.PolyBaseTree> byteArray2tree(byte[] ba) {
        DataInputStream inpS = new DataInputStream(new ByteArrayInputStream(ba));
        UnloadPolys up2 = new UnloadPolys();
        java.lang.Iterable<PolyBase.PolyBaseTree> trees = up2.loop(inpS, false);
        inpS.close();
        return JavaConversions$.MODULE$.asIterable(trees);
    }

    public int treesSize(Iterable<PolyBase.PolyBaseTree> ts, Function1<PolyBase, Integer> localCount$2) {
        return BoxesRunTime.unboxToInt(((TraversableOnce)ts.map(new anonfun.treesSize.1(localCount$2), Iterable$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
    }

    public boolean hugeFile() {
        File file = File.createTempFile("Electric", "DRC", new File("."));
        file.deleteOnExit();
        FileOutputStream out$1 = new FileOutputStream(file);
        byte[] b$1 = new byte[0x100000];
        Predef$.MODULE$.intWrapper(0).until(8000).foreach$mVc$sp(new anonfun.hugeFile.1(out$1, b$1));
        out$1.close();
        return file.delete();
    }

    public void main(String[] args) {
        Seq<CellTree> dt$1;
        this.initElectric();
        String libPath = args[0];
        String topCellName = args[1];
        Cell topCell$1 = this.loadCell(libPath, topCellName);
        LayoutMergerScalaImpl layoutMerger$1 = new LayoutMergerScalaImpl(topCell$1);
        Seq<CellTree> seq2 = dt$1 = this.downTop(topCell$1.tree());
        Seq<CellTree> seq3 = layoutMerger$1.downTop(topCell$1.tree());
        Predef$.MODULE$.assert(!(seq2 != null ? !seq2.equals(seq3) : seq3 != null));
        Predef$.MODULE$.println(new StringBuilder().append((Object)"downTop ").append(BoxesRunTime.boxToInteger(dt$1.size())).toString());
        dt$1.foreach(new anonfun.main.1());
        VectorCache vectorCache$1 = layoutMerger$1.vectorCache();
        Predef$.MODULE$.println(new StringBuilder().append(this.countHier$1(new anonfun.main.2(), topCell$1)).append((Object)" cells").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countHier$1(new anonfun.main.3(vectorCache$1), topCell$1)).append((Object)" subCells").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countHier$1(new anonfun.main.4(), topCell$1)).append((Object)" nodes").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countHier$1(new anonfun.main.5(), topCell$1)).append((Object)" arcs").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countHier$1(new anonfun.main.6(), topCell$1)).append((Object)" exports").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countFlat$1(new anonfun.main.7(), topCell$1)).append((Object)" cell insts").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countFlat$1(new anonfun.main.8(vectorCache$1), topCell$1)).append((Object)" subCells").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countFlat$1(new anonfun.main.9(), topCell$1)).append((Object)" node insts").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countFlat$1(new anonfun.main.10(), topCell$1)).append((Object)" arc insts").toString());
        Predef$.MODULE$.println(new StringBuilder().append(this.countFlat$1(new anonfun.main.11(), topCell$1)).append((Object)" export insts").toString());
        vectorCache$1.scanLayers(topCell$1.getId());
        Iterable<Layer> layers = JavaConversions$.MODULE$.asIterable(vectorCache$1.getLayers());
        layers.foreach(new anonfun.main.12(topCell$1, layoutMerger$1, dt$1, vectorCache$1));
    }

    public final void downTop$1(CellTree t, LinkedHashSet linkedHashSet) {
        if (!linkedHashSet.contains(t)) {
            Predef$.MODULE$.refArrayOps((Object[])t.getSubTrees()).foreach(new anonfun.downTop.1.1(linkedHashSet));
            linkedHashSet.add(t);
        }
    }

    public final int treeSize$1(PolyBase.PolyBaseTree t, Function1 function1) {
        java.lang.Iterable<PolyBase.PolyBaseTree> l = t.getSons();
        int sonCount = this.treesSize(JavaConversions$.MODULE$.asIterable(l), function1);
        return BoxesRunTime.unboxToInt(function1.apply(t.getPoly())) + sonCount;
    }

    public final int countHier$1(Function1 localCount$3, Cell cell) {
        return this.countHier(cell.tree(), new anonfun.countHier.1.1(localCount$3));
    }

    public final int countFlat$1(Function1 localCount$4, Cell cell) {
        return BoxesRunTime.unboxToInt(this.countFlat(cell.tree(), new anonfun.countFlat.1.1(localCount$4)).apply(cell.getId()));
    }

    private Main$() {
        MODULE$ = this;
    }
}

