/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolySweepMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.HeadConnection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.topology.TailConnection;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.extract.Extract;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connectivity {
    private static final boolean ENFORCEMINIMUMSIZE = false;
    private static final boolean DEBUGCENTERLINES = false;
    private static final boolean DEBUGSTEPS = false;
    private static final boolean DEBUGCONTACTS = false;
    private static final double SCALEFACTOR = 400.0;
    private Technology tech;
    private Map<Layer.Function, Layer> layerForFunction;
    private Layer polyLayer;
    private Layer tempLayer1;
    private Layer activeLayer;
    private Layer pActiveLayer;
    private Layer nActiveLayer;
    private Layer pSelectLayer;
    private Layer nSelectLayer;
    private Layer realPActiveLayer;
    private Layer realNActiveLayer;
    private Layer wellLayer;
    private Layer substrateLayer;
    private Map<Layer, ArcProto> arcsForLayer;
    private Map<Cell, Cell> convertedCells;
    private Map<Layer, CutInfo> allCutLayers;
    private Set<PrimitiveNode> ignoreNodes;
    private Set<PrimitiveNode> bogusContacts;
    private PrimitiveNode diffNode;
    private PrimitiveNode pDiffNode;
    private PrimitiveNode nDiffNode;
    private List<Export> exportsToRestore;
    private List<Export> generatedExports;
    private boolean pSubstrateProcess;
    private boolean nSubstrateProcess;
    private boolean hasWell;
    private boolean hasPWell;
    private boolean hasNWell;
    private boolean unifyActive;
    private boolean haveNActive;
    private boolean havePActive;
    private boolean ignoreActiveSelectWell;
    private boolean gridAlignExtraction;
    private boolean approximateCuts;
    private boolean recursive;
    private double smallestPoly;
    private List<ERectangle> addedRectangles;
    private List<ERectangle> addedLines;
    private List<ExportedPin> pinsForLater;
    private ErrorLogger errorLogger;
    private int totalCells;
    private int cellsExtracted;
    private Job job;
    private Dimension2D alignment;
    private static final double CLOSEDIST = 8.0;

    public static void extractCurCell(boolean recursive) {
        Cell curCell = Job.getUserInterface().needCurrentCell();
        if (curCell == null) {
            System.out.println("Must be editing a cell with pure layer nodes.");
            return;
        }
        new ExtractJob(curCell, recursive);
    }

    private Connectivity(Cell cell, Job j, ErrorLogger eLog, double smallestPolygonSize, int activeHandling, boolean gridAlignExtraction, boolean approximateCuts, boolean recursive, Pattern pat) {
        Layer.Function fun;
        Layer layer;
        this.approximateCuts = approximateCuts;
        this.recursive = recursive;
        this.tech = cell.getTechnology();
        this.convertedCells = new HashMap<Cell, Cell>();
        this.smallestPoly = 160000.0 * smallestPolygonSize;
        this.bogusContacts = new HashSet<PrimitiveNode>();
        this.errorLogger = eLog;
        this.job = j;
        this.gridAlignExtraction = gridAlignExtraction;
        double scaledResolution = this.tech.getFactoryScaledResolution();
        this.alignment = new Dimension2D.Double(scaledResolution, scaledResolution);
        this.nDiffNode = null;
        this.pDiffNode = null;
        this.diffNode = null;
        this.ignoreNodes = new HashSet<PrimitiveNode>();
        Iterator<PrimitiveNode> pIt = this.tech.getNodes();
        while (pIt.hasNext()) {
            Layer layer2;
            PrimitiveNode np = pIt.next();
            if (np.getFunction() != PrimitiveNode.Function.NODE) continue;
            Technology.NodeLayer[] nLays = np.getNodeLayers();
            boolean validLayers = false;
            for (int i = 0; i < nLays.length; ++i) {
                Technology.NodeLayer nLay = nLays[i];
                Layer.Function fun2 = nLay.getLayer().getFunction();
                if (fun2 == Layer.Function.UNKNOWN || fun2 == Layer.Function.OVERGLASS || fun2 == Layer.Function.GUARD || fun2 == Layer.Function.ISOLATION || fun2 == Layer.Function.BUS || fun2 == Layer.Function.ART || fun2 == Layer.Function.CONTROL || fun2 == Layer.Function.TILENOT) continue;
                validLayers = true;
            }
            if (!validLayers) {
                this.ignoreNodes.add(np);
            }
            if ((layer2 = np.getLayerIterator().next()).getFunction() == Layer.Function.DIFF) {
                this.diffNode = np;
            }
            if (layer2.getFunction() == Layer.Function.DIFFN) {
                this.nDiffNode = np;
            }
            if (layer2.getFunction() != Layer.Function.DIFFP) continue;
            this.pDiffNode = np;
        }
        this.findMissingWells(cell, recursive, pat, activeHandling);
        this.polyLayer = null;
        this.nActiveLayer = null;
        this.pActiveLayer = null;
        this.activeLayer = null;
        this.realNActiveLayer = null;
        this.realPActiveLayer = null;
        this.nSelectLayer = null;
        this.pSelectLayer = null;
        this.substrateLayer = null;
        this.wellLayer = null;
        Iterator<Layer> it = this.tech.getLayers();
        while (it.hasNext()) {
            layer = it.next();
            fun = layer.getFunction();
            if (this.polyLayer == null && fun == Layer.Function.POLY1) {
                this.polyLayer = layer;
            }
            if (this.activeLayer == null && fun == Layer.Function.DIFF) {
                this.activeLayer = layer;
            }
            if (this.pActiveLayer == null && fun == Layer.Function.DIFFP) {
                this.pActiveLayer = layer;
            }
            if (this.nActiveLayer == null && fun == Layer.Function.DIFFN) {
                this.nActiveLayer = layer;
            }
            if (this.realPActiveLayer == null && fun == Layer.Function.DIFFP) {
                this.realPActiveLayer = layer;
            }
            if (this.realNActiveLayer == null && fun == Layer.Function.DIFFN) {
                this.realNActiveLayer = layer;
            }
            if (this.pSelectLayer == null && fun == Layer.Function.IMPLANTP) {
                this.pSelectLayer = layer;
            }
            if (this.nSelectLayer == null && fun == Layer.Function.IMPLANTN) {
                this.nSelectLayer = layer;
            }
            if (this.pSubstrateProcess) {
                if (this.wellLayer == null && fun == Layer.Function.WELLN) {
                    this.wellLayer = layer;
                }
                if (this.substrateLayer == null && fun == Layer.Function.WELLP) {
                    this.substrateLayer = layer;
                }
            }
            if (!this.nSubstrateProcess) continue;
            if (this.wellLayer == null && fun == Layer.Function.WELLP) {
                this.wellLayer = layer;
            }
            if (this.substrateLayer != null || fun != Layer.Function.WELLN) continue;
            this.substrateLayer = layer;
        }
        this.polyLayer = this.polyLayer.getNonPseudoLayer();
        if (this.polyLayer != null) {
            this.tempLayer1 = this.polyLayer.getPseudoLayer();
        }
        if (this.pActiveLayer == null || this.nActiveLayer == null && this.activeLayer != null) {
            this.unifyActive = true;
            this.pActiveLayer = this.nActiveLayer = this.activeLayer;
        } else {
            this.unifyActive = false;
            this.pActiveLayer = this.pActiveLayer.getNonPseudoLayer();
            this.nActiveLayer = this.nActiveLayer.getNonPseudoLayer();
        }
        this.arcsForLayer = new HashMap<Layer, ArcProto>();
        it = this.tech.getLayers();
        while (it.hasNext()) {
            layer = it.next();
            fun = layer.getFunction();
            if (!fun.isDiff() && !fun.isPoly() && !fun.isMetal()) continue;
            ArcProto.Function oFun = null;
            if (fun.isMetal()) {
                oFun = ArcProto.Function.getMetal(fun.getLevel());
            }
            if (fun.isPoly()) {
                oFun = ArcProto.Function.getPoly(fun.getLevel());
            }
            if (oFun == null) continue;
            ArcProto type = null;
            Iterator<ArcProto> aIt = this.tech.getArcs();
            while (aIt.hasNext()) {
                ArcProto ap = aIt.next();
                if (ap.getFunction() != oFun) continue;
                type = ap;
                break;
            }
            if (type == null) continue;
            this.arcsForLayer.put(layer, type);
        }
        this.layerForFunction = new HashMap<Layer.Function, Layer>();
        it = this.tech.getLayers();
        while (it.hasNext()) {
            layer = it.next();
            fun = layer.getFunction();
            if (this.unifyActive && (fun == Layer.Function.DIFFP || fun == Layer.Function.DIFFN)) {
                fun = Layer.Function.DIFF;
            }
            if (this.layerForFunction.get((Object)fun) != null) continue;
            this.layerForFunction.put(fun, layer);
        }
    }

    private void addErrorLog(Cell cell, String msg, EPoint ... pList) {
        ArrayList<EPoint> pointList = new ArrayList<EPoint>();
        for (EPoint p : pList) {
            pointList.add(p);
        }
        this.errorLogger.logMessage(msg, pointList, cell, -1, true);
        System.out.println(msg);
    }

    private int countExtracted(Cell oldCell, Pattern pat, boolean flattenPcells) {
        int numExtracted = 1;
        Iterator<NodeInst> it = oldCell.getNodes();
        while (it.hasNext()) {
            Cell convertedCell;
            Cell subCell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || this.isCellFlattened(subCell = (Cell)ni.getProto(), pat, flattenPcells) || (convertedCell = this.convertedCells.get(subCell)) != null) continue;
            numExtracted += this.countExtracted(subCell, pat, flattenPcells);
        }
        return numExtracted;
    }

    private boolean isCellFlattened(Cell cell, Pattern pat, boolean flattenPcells) {
        String cellName;
        int twoDollar;
        Matcher mat;
        if (pat != null && (mat = pat.matcher(cell.noLibDescribe())).find()) {
            return true;
        }
        if (flattenPcells && (twoDollar = (cellName = cell.noLibDescribe()).lastIndexOf("$$")) > 0) {
            char ch;
            String endPart = cellName.substring(twoDollar + 2);
            for (int i = 0; i < endPart.length() && (ch = endPart.charAt(i)) != '{'; ++i) {
                if (TextUtils.isDigit(ch)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Cell doExtract(Cell oldCell, boolean recursive, Pattern pat, boolean flattenPcells, boolean top, Job job, List<List<ERectangle>> addedBatchRectangles, List<List<ERectangle>> addedBatchLines, List<String> addedBatchNames) {
        if (recursive) {
            Iterator<NodeInst> it = oldCell.getNodes();
            while (it.hasNext()) {
                Cell result;
                Cell convertedCell;
                Cell subCell;
                NodeInst ni = it.next();
                if (!ni.isCellInstance() || this.isCellFlattened(subCell = (Cell)ni.getProto(), pat, flattenPcells) || (convertedCell = this.convertedCells.get(subCell)) != null || (result = this.doExtract(subCell, recursive, pat, flattenPcells, false, job, addedBatchRectangles, addedBatchLines, addedBatchNames)) != null) continue;
                System.out.println("ERROR: Extraction of cell " + subCell.describe(false) + " failed");
            }
        }
        String newCellName = oldCell.getName() + oldCell.getView().getAbbreviationExtension();
        Cell newCell = Cell.makeInstance(oldCell.getLibrary(), newCellName);
        if (newCell == null) {
            System.out.println("Cannot create new cell: " + newCellName);
            return null;
        }
        this.convertedCells.put(oldCell, newCell);
        PolyMerge merge = new PolyMerge();
        PolyMerge selectMerge = new PolyMerge();
        if (!this.startSection(oldCell, "Gathering geometry in " + oldCell + "...")) {
            return null;
        }
        HashSet<Cell> expandedCells = new HashSet<Cell>();
        this.exportsToRestore = new ArrayList<Export>();
        this.generatedExports = new ArrayList<Export>();
        this.pinsForLater = new ArrayList<ExportedPin>();
        this.allCutLayers = new TreeMap<Layer, CutInfo>();
        this.extractCell(oldCell, newCell, pat, flattenPcells, expandedCells, merge, selectMerge, GenMath.MATID, Orientation.IDENT);
        if (expandedCells.size() > 0) {
            System.out.print("These cells were expanded:");
            for (Cell c : expandedCells) {
                System.out.print(" " + c.describe(false));
            }
            System.out.println();
        }
        PolyMerge originalMerge = new PolyMerge();
        originalMerge.addMerge(merge, new AffineTransform());
        this.initDebugging();
        if (!this.startSection(oldCell, "Extracting vias...")) {
            return null;
        }
        if (!this.extractVias(merge, originalMerge, oldCell, newCell)) {
            return null;
        }
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Vias");
        this.initDebugging();
        if (!this.startSection(oldCell, "Extracting transistors...")) {
            return null;
        }
        this.extractTransistors(merge, originalMerge, newCell);
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Transistors");
        if (Extract.isUsePureLayerNodes()) {
            if (!this.startSection(oldCell, "Adding in original routing layers...")) {
                return null;
            }
            this.addInRoutingLayers(oldCell, newCell, merge, originalMerge);
        } else {
            this.initDebugging();
            if (!this.startSection(oldCell, "Extracting wires...")) {
                return null;
            }
            if (this.makeWires(merge, originalMerge, newCell)) {
                return newCell;
            }
            this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Wires");
            this.initDebugging();
            if (!this.startSection(oldCell, "Extracting connections...")) {
                return null;
            }
            this.extendGeometry(merge, originalMerge, newCell, false);
            this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Bridges");
        }
        this.initDebugging();
        if (!this.startSection(oldCell, "Extracting leftover geometry...")) {
            return null;
        }
        this.convertAllGeometry(merge, originalMerge, newCell);
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Pures");
        if (!this.startSection(oldCell, "Adding connecting wires...")) {
            return null;
        }
        this.cleanupExports(oldCell, newCell);
        PolyMerge originalUnscaledMerge = new PolyMerge();
        double shrinkage = 0.0025;
        AffineTransform shrink = new AffineTransform(shrinkage, 0.0, 0.0, shrinkage, 0.0, 0.0);
        originalUnscaledMerge.addMerge(originalMerge, shrink);
        HashSet<ArcInst> allArcs = null;
        allArcs = new HashSet<ArcInst>();
        Iterator<ArcInst> it = newCell.getArcs();
        while (it.hasNext()) {
            allArcs.add(it.next());
        }
        if (User.getUserTool().getCurrentArcProto() == Generic.tech().universal_arc) {
            User.getUserTool().setCurrentArcProto(newCell.getTechnology().getArcs().next());
        }
        AutoStitch.AutoOptions prefs = new AutoStitch.AutoOptions();
        prefs.createExports = true;
        AutoStitch.runAutoStitch(newCell, null, null, job, originalUnscaledMerge, null, false, true, prefs, !recursive, this.alignment);
        if (this.alignment != null && (this.alignment.getWidth() > 0.0 || this.alignment.getHeight() > 0.0)) {
            Iterator<ArcInst> it2 = newCell.getArcs();
            while (it2.hasNext()) {
                Rectangle2D bounds;
                ArcInst ai = it2.next();
                if (allArcs.contains(ai) || (bounds = ai.getBounds()).getMinX() % this.alignment.getWidth() == 0.0 && bounds.getMinY() % this.alignment.getHeight() == 0.0 && bounds.getMaxX() % this.alignment.getWidth() == 0.0 && bounds.getMaxY() % this.alignment.getHeight() == 0.0) continue;
                HeadConnection head = ai.getHead();
                TailConnection tail = ai.getTail();
                ArcInst newAi = ArcInst.makeInstanceBase(Generic.tech().universal_arc, 0.0, ((Connection)head).getPortInst(), ((Connection)tail).getPortInst(), ((Connection)head).getLocation(), ((Connection)tail).getLocation(), null);
                if (newAi == null) continue;
                newAi.setHeadExtended(false);
                newAi.setTailExtended(false);
                ai.kill();
            }
        }
        System.out.println("Extraction done.");
        ++this.cellsExtracted;
        if (recursive) {
            Job.getUserInterface().setProgressValue(this.cellsExtracted * 100 / this.totalCells);
        }
        return newCell;
    }

    private boolean startSection(Cell cell, String msg) {
        System.out.println(msg);
        if (this.job.checkAbort()) {
            return false;
        }
        if (this.recursive) {
            msg = cell.getName() + " - " + msg;
        }
        Job.getUserInterface().setProgressNote(msg);
        if (!this.recursive) {
            Job.getUserInterface().setProgressValue(0);
        }
        return true;
    }

    private void initDebugging() {
    }

    private void termDebugging(List<List<ERectangle>> addedBatchRectangles, List<List<ERectangle>> addedBatchLines, List<String> addedBatchNames, String descr) {
    }

    private void extractCell(Cell oldCell, Cell newCell, Pattern pat, boolean flattenPcells, Set<Cell> expandedCells, PolyMerge merge, PolyMerge selectMerge, AffineTransform prevTrans, Orientation orient) {
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        int totalNodes = oldCell.getNumNodes();
        Dimension2D alignementToGrid = newCell.getEditingPreferences().getAlignmentToGrid();
        if (!this.unifyActive && !this.ignoreActiveSelectWell) {
            Iterator<NodeInst> nIt = oldCell.getNodes();
            while (nIt.hasNext()) {
                NodeInst ni = nIt.next();
                if (ni.isCellInstance()) continue;
                Poly[] polys = this.tech.getShapeOfNode(ni);
                for (int j = 0; j < polys.length; ++j) {
                    Poly poly = polys[j];
                    Layer layer = poly.getLayer();
                    if (layer == null || (layer = this.geometricLayer(layer)).getFunction() != Layer.Function.IMPLANTN && layer.getFunction() != Layer.Function.IMPLANTP) continue;
                    AffineTransform trans = ni.rotateOut(prevTrans);
                    poly.transform(trans);
                    selectMerge.add(layer, poly);
                }
            }
        }
        int soFar = 0;
        Iterator<NodeInst> nIt = oldCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            if (!this.recursive && ++soFar % 100 == 0) {
                Job.getUserInterface().setProgressValue(soFar * 100 / totalNodes);
            }
            if (ni.getProto() == Generic.tech().cellCenterNode) continue;
            NodeProto copyType = null;
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)ni.getProto();
                boolean flatIt = this.isCellFlattened(subCell, pat, flattenPcells);
                if (flatIt) {
                    expandedCells.add(subCell);
                    AffineTransform subTrans = ni.translateOut(ni.rotateOut(prevTrans));
                    Orientation or = orient.concatenate(ni.getOrient());
                    this.extractCell(subCell, newCell, pat, flattenPcells, expandedCells, merge, selectMerge, subTrans, or);
                    continue;
                }
                copyType = this.convertedCells.get(subCell);
                if (copyType == null) {
                    copyType = subCell;
                }
            } else {
                PrimitiveNode np = (PrimitiveNode)ni.getProto();
                if (np.getFunction().isPin() && ni.hasExports() && !ni.hasConnections()) {
                    ExportedPin ep = new ExportedPin(ni, ni.getTrueCenter(), prevTrans);
                    this.pinsForLater.add(ep);
                    continue;
                }
                if (np.getFunction() != PrimitiveNode.Function.NODE) {
                    copyType = ni.getProto();
                } else if (this.ignoreNodes.contains(np)) {
                    copyType = ni.getProto();
                }
            }
            if (copyType != null) {
                NodeInst newNi;
                double sX = ni.getXSize();
                double sY = ni.getYSize();
                if (copyType instanceof Cell) {
                    ERectangle cellBounds = ((Cell)copyType).getBounds();
                    sX = ((RectangularShape)cellBounds).getWidth();
                    sY = ((RectangularShape)cellBounds).getHeight();
                }
                Point2D.Double instanceAnchor = new Point2D.Double(0.0, 0.0);
                prevTrans.transform(ni.getAnchorCenter(), instanceAnchor);
                String name = null;
                Name nameKey = ni.getNameKey();
                if (!nameKey.isTempname()) {
                    name = ni.getName();
                }
                Orientation or = orient.concatenate(ni.getOrient());
                if (name != null && newCell.findNode(name) != null) {
                    name = null;
                }
                if ((newNi = NodeInst.makeInstance(copyType, (Point2D)instanceAnchor, sX, sY, newCell, or, name, ni.getTechSpecific())) == null) {
                    this.addErrorLog(newCell, "Problem creating new instance of " + ni.getProto(), new EPoint(sX, sY));
                    continue;
                }
                newNodes.put(ni, newNi);
                Iterator<Export> it = ni.getExports();
                while (it.hasNext()) {
                    Export e = it.next();
                    PortInst pi = newNi.findPortInstFromProto(e.getOriginalPort().getPortProto());
                    Export.newInstance(newCell, pi, e.getName());
                }
                continue;
            }
            boolean growABit = false;
            if ((int)(ni.getXSize() * 400.0) % 2 != 0 || (int)(ni.getYSize() * 400.0) % 2 != 0) {
                growABit = true;
            }
            AffineTransform trans = ni.rotateOut(prevTrans);
            Poly[] polys = this.tech.getShapeOfNode(ni);
            for (int j = 0; j < polys.length; ++j) {
                Poly poly = polys[j];
                Layer layer = poly.getLayer();
                if (layer == null) continue;
                layer = this.geometricLayer(layer);
                poly.transform(trans);
                Point2D[] points = poly.getPoints();
                if (this.gridAlignExtraction) {
                    Point2D.Double hold = new Point2D.Double();
                    for (int i = 0; i < points.length; ++i) {
                        hold.setLocation(points[i]);
                        DBMath.gridAlign(hold, alignementToGrid);
                        poly.setPoint(i, ((Point2D)hold).getX(), ((Point2D)hold).getY());
                    }
                } else if (growABit) {
                    double growth = DBMath.getEpsilon() / 2.0;
                    EPoint polyCtr = poly.getCenter();
                    for (int i = 0; i < points.length; ++i) {
                        double x = points[i].getX();
                        double y = points[i].getY();
                        x = x < ((Point2D)polyCtr).getX() ? (x -= growth) : (x += growth);
                        y = y < ((Point2D)polyCtr).getY() ? (y -= growth) : (y += growth);
                        poly.setPoint(i, x, y);
                    }
                }
                if (layer.getFunction() == Layer.Function.DIFFN && selectMerge.contains(this.pSelectLayer, poly)) {
                    layer = this.pActiveLayer;
                }
                if (layer.getFunction() == Layer.Function.DIFFP && selectMerge.contains(this.nSelectLayer, poly)) {
                    layer = this.nActiveLayer;
                }
                for (int i = 0; i < points.length; ++i) {
                    poly.setPoint(i, this.scaleUp(points[i].getX()), this.scaleUp(points[i].getY()));
                }
                if (layer.getFunction().isContact()) {
                    CutInfo cInfo = this.allCutLayers.get(layer);
                    if (cInfo == null) {
                        cInfo = new CutInfo();
                        this.allCutLayers.put(layer, cInfo);
                    }
                    boolean found = false;
                    RTNode.Search sea = new RTNode.Search(poly.getBounds2D(), cInfo.getRTree(), true);
                    while (sea.hasNext()) {
                        CutBound cBound = (CutBound)sea.next();
                        if (!cBound.getBounds().equals(poly.getBounds2D())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    cInfo.addCut(poly);
                    continue;
                }
                Rectangle2D box = poly.getBox();
                if (box == null) {
                    merge.addPolygon(layer, poly);
                    continue;
                }
                if (!(box.getWidth() > 0.0) || !(box.getHeight() > 0.0)) continue;
                if (layer.getName().equals("DeviceMark")) {
                    System.out.println("DEVICE MARK IS " + box.getWidth() + "x" + box.getHeight());
                }
                merge.addRectangle(layer, box);
            }
            Iterator<Export> it = ni.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                this.exportsToRestore.add(e);
            }
        }
        Iterator<ArcInst> aIt = oldCell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = aIt.next();
            NodeInst end1 = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
            NodeInst end2 = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
            if (end1 == null || end2 == null) continue;
            PortInst pi1 = end1.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
            PortInst pi2 = end2.findPortInstFromProto(ai.getTailPortInst().getPortProto());
            Point2D.Double headLocation = new Point2D.Double(0.0, 0.0);
            Point2D.Double tailLocation = new Point2D.Double(0.0, 0.0);
            prevTrans.transform(ai.getHeadLocation(), headLocation);
            prevTrans.transform(ai.getTailLocation(), tailLocation);
            ArcInst.makeInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), pi1, pi2, headLocation, tailLocation, ai.getName());
        }
        Iterator<Variable> vIt = oldCell.getParametersAndVariables();
        while (vIt.hasNext()) {
            Variable var = vIt.next();
            Variable newVar = Variable.newInstance(var.getKey(), var.getObject(), var.getTextDescriptor());
            if (var.getTextDescriptor().isParam()) {
                newCell.getCellGroup().addParam(newVar);
            } else {
                newCell.addVar(newVar);
            }
            new DisplayedText(newCell, var.getKey());
        }
    }

    private void findMissingWells(Cell cell, boolean recursive, Pattern pat, int activeHandling) {
        this.hasNWell = false;
        this.hasPWell = false;
        this.hasWell = false;
        this.havePActive = false;
        this.haveNActive = false;
        this.recurseMissingWells(cell, recursive, pat);
        if (!this.hasPWell) {
            this.pSubstrateProcess = true;
            System.out.println("Presuming a P-substrate process");
        } else if (!this.hasNWell && !this.hasWell) {
            this.nSubstrateProcess = true;
            System.out.println("Presuming an N-substrate process");
        }
        this.ignoreActiveSelectWell = activeHandling == 2;
    }

    private void recurseMissingWells(Cell cell, boolean recursive, Pattern pat) {
        this.examineCellForMissingWells(cell);
        if (recursive) {
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                Cell convertedCell;
                Matcher mat;
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                Cell subCell = (Cell)ni.getProto();
                if (pat != null && (mat = pat.matcher(subCell.noLibDescribe())).find() || (convertedCell = this.convertedCells.get(subCell)) != null) continue;
                this.recurseMissingWells(subCell, recursive, pat);
            }
        }
    }

    private void examineCellForMissingWells(Cell cell) {
        NodeInst ni;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            if (ni.isCellInstance()) continue;
            Poly[] polys = ni.getProto().getTechnology().getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Layer layer = polys[i].getLayer();
                if (layer == null || !layer.getFunction().isDiff()) continue;
                if (layer.getFunction() == Layer.Function.DIFFN) {
                    this.haveNActive = true;
                }
                if (layer.getFunction() != Layer.Function.DIFFP) continue;
                this.havePActive = true;
            }
            if (!this.haveNActive || !this.havePActive) continue;
            break;
        }
        Iterator<NodeInst> nIt = cell.getNodes();
        while (nIt.hasNext()) {
            PrimitiveNode np;
            ni = nIt.next();
            if (ni.isCellInstance() || (np = (PrimitiveNode)ni.getProto()) == Generic.tech().cellCenterNode) continue;
            PrimitiveNode copyType = null;
            if (np.getFunction() != PrimitiveNode.Function.NODE) {
                copyType = np;
            } else if (this.ignoreNodes.contains(np)) {
                copyType = np;
            }
            if (copyType == null) continue;
            Technology.NodeLayer[] nLayers = copyType.getNodeLayers();
            for (int i = 0; i < nLayers.length; ++i) {
                Technology.NodeLayer nLay = nLayers[i];
                Layer layer = nLay.getLayer();
                Layer.Function fun = layer.getFunction();
                if (fun == Layer.Function.WELL) {
                    this.hasWell = true;
                }
                if (fun == Layer.Function.WELLP) {
                    this.hasPWell = true;
                }
                if (fun == Layer.Function.WELLN) {
                    this.hasNWell = true;
                }
                if (!layer.getFunction().isDiff()) continue;
                if (layer.getFunction() == Layer.Function.DIFFN) {
                    this.haveNActive = true;
                }
                if (layer.getFunction() != Layer.Function.DIFFP) continue;
                this.havePActive = true;
            }
        }
        Iterator<ArcInst> aIt = cell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = aIt.next();
            for (int i = 0; i < ai.getProto().getNumArcLayers(); ++i) {
                Layer layer = ai.getProto().getLayer(i);
                Layer.Function fun = layer.getFunction();
                if (fun == Layer.Function.WELL) {
                    this.hasWell = true;
                }
                if (fun == Layer.Function.WELLP) {
                    this.hasPWell = true;
                }
                if (fun == Layer.Function.WELLN) {
                    this.hasNWell = true;
                }
                if (!layer.getFunction().isDiff()) continue;
                if (layer.getFunction() == Layer.Function.DIFFN) {
                    this.haveNActive = true;
                }
                if (layer.getFunction() != Layer.Function.DIFFP) continue;
                this.havePActive = true;
            }
        }
    }

    private boolean isOnGrid(double value, double grid) {
        if (grid == 0.0) {
            return true;
        }
        long x = Math.round(value / grid);
        return (double)x * grid == value;
    }

    private boolean makeWires(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        ArcProto ap;
        List<PolyBase> polyList;
        int totPolys = 0;
        TreeMap<Layer, List<PolyBase>> geomToWire = new TreeMap<Layer, List<PolyBase>>();
        for (Layer layer : merge.getKeySet()) {
            Layer.Function fun = layer.getFunction();
            if (!fun.isDiff() && !fun.isPoly() && !fun.isMetal()) continue;
            List<PolyBase> polyList2 = this.getMergePolys(merge, layer, null);
            totPolys += polyList2.size();
            geomToWire.put(layer, polyList2);
        }
        int soFar = 0;
        Set allLayers = geomToWire.keySet();
        for (Layer layer : allLayers) {
            polyList = (List<PolyBase>)geomToWire.get(layer);
            for (PolyBase poly : polyList) {
                if (!this.recursive) {
                    Job.getUserInterface().setProgressValue(soFar * 100 / totPolys);
                }
                ++soFar;
                ap = this.findArcProtoForPoly(layer, poly, originalMerge);
                if (ap == null) continue;
                double minWidth = 1.0;
                List<Centerline> lines = this.findCenterlines(poly, layer, minWidth, merge, originalMerge);
                for (Centerline cl : lines) {
                    ArcInst ai;
                    double wid;
                    double halfWidth;
                    ap = this.findArcProtoForPoly(layer, poly, originalMerge);
                    Point2D.Double loc1Unscaled = new Point2D.Double();
                    Point2D.Double loc2Unscaled = new Point2D.Double();
                    PortInst pi1 = this.locatePortOnCenterline(cl, loc1Unscaled, layer, ap, true, newCell);
                    Point2D.Double loc1 = new Point2D.Double(this.scaleUp(((Point2D)loc1Unscaled).getX()), this.scaleUp(((Point2D)loc1Unscaled).getY()));
                    PortInst pi2 = this.locatePortOnCenterline(cl, loc2Unscaled, layer, ap, false, newCell);
                    Point2D.Double loc2 = new Point2D.Double(this.scaleUp(((Point2D)loc2Unscaled).getX()), this.scaleUp(((Point2D)loc2Unscaled).getY()));
                    GenMath.MutableBoolean headExtend = new GenMath.MutableBoolean(true);
                    GenMath.MutableBoolean tailExtend = new GenMath.MutableBoolean(true);
                    if (((Point2D)loc1).getX() == ((Point2D)loc2).getX()) {
                        double loc1Y = ((Point2D)loc1Unscaled).getY();
                        double loc2Y = ((Point2D)loc2Unscaled).getY();
                        halfWidth = cl.width / 2.0 / 400.0;
                        double loc1YExtend = loc1Y + (loc1Y < loc2Y ? -halfWidth : halfWidth);
                        double loc2YExtend = loc2Y + (loc2Y < loc1Y ? -halfWidth : halfWidth);
                        if (!this.isOnGrid(loc1YExtend, this.alignment.getHeight()) && this.isOnGrid(loc1Y, this.alignment.getHeight())) {
                            headExtend.setValue(false);
                        }
                        if (!this.isOnGrid(loc2YExtend, this.alignment.getHeight()) && this.isOnGrid(loc2Y, this.alignment.getHeight())) {
                            tailExtend.setValue(false);
                        }
                    } else if (((Point2D)loc1).getY() == ((Point2D)loc2).getY()) {
                        double loc1X = ((Point2D)loc1Unscaled).getX();
                        double loc2X = ((Point2D)loc2Unscaled).getX();
                        halfWidth = cl.width / 2.0 / 400.0;
                        double loc1XExtend = loc1X + (loc1X < loc2X ? -halfWidth : halfWidth);
                        double loc2XExtend = loc2X + (loc2X < loc1X ? -halfWidth : halfWidth);
                        if (!this.isOnGrid(loc1XExtend, this.alignment.getWidth()) && this.isOnGrid(loc1X, this.alignment.getWidth())) {
                            headExtend.setValue(false);
                        }
                        if (!this.isOnGrid(loc2XExtend, this.alignment.getWidth()) && this.isOnGrid(loc2X, this.alignment.getWidth())) {
                            tailExtend.setValue(false);
                        }
                    }
                    boolean fits = originalMerge.arcPolyFits(layer, loc1, loc2, cl.width, headExtend, tailExtend);
                    if (!fits) {
                        wid = cl.width / 400.0;
                        long x = Math.round(wid / this.alignment.getWidth());
                        double gridWid = (double)x * this.alignment.getWidth();
                        if (gridWid < wid) {
                            cl.width = this.scaleUp(gridWid);
                            fits = originalMerge.arcPolyFits(layer, loc1, loc2, cl.width, headExtend, tailExtend);
                        } else {
                            cl.width -= 1.0;
                            fits = originalMerge.arcPolyFits(layer, loc1, loc2, cl.width, headExtend, tailExtend);
                        }
                    }
                    while (!fits && !((wid = cl.width - 400.0) < 0.0)) {
                        cl.width = wid;
                        fits = originalMerge.arcPolyFits(layer, loc1, loc2, cl.width, headExtend, tailExtend);
                    }
                    if (!fits || loc1Unscaled.distance(loc2Unscaled) == 0.0 && !headExtend.booleanValue() && !tailExtend.booleanValue()) {
                        cl.width = 0.0;
                        ap = Generic.tech().universal_arc;
                    }
                    if (loc1Unscaled.distance(loc2Unscaled) != 0.0 || headExtend.booleanValue() || !tailExtend.booleanValue()) {
                        // empty if block
                    }
                    if ((ai = this.realizeArc(ap, pi1, pi2, loc1Unscaled, loc2Unscaled, cl.width / 400.0, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge)) != null) continue;
                    String msg = "Cell " + newCell.describe(false) + ": Failed to run arc " + ap.getName() + " from (" + ((Point2D)loc1Unscaled).getX() + "," + ((Point2D)loc1Unscaled).getY() + ") on node " + pi1.getNodeInst().describe(false) + " to (" + ((Point2D)loc2Unscaled).getX() + "," + ((Point2D)loc2Unscaled).getY() + ") on node " + pi2.getNodeInst().describe(false);
                    this.addErrorLog(newCell, msg, new EPoint(((Point2D)loc1Unscaled).getX(), ((Point2D)loc1Unscaled).getY()), new EPoint(((Point2D)loc2Unscaled).getX(), ((Point2D)loc2Unscaled).getY()));
                }
            }
        }
        for (Layer layer : allLayers) {
            polyList = this.getMergePolys(merge, layer, null);
            for (PolyBase poly : polyList) {
                ap = this.findArcProtoForPoly(layer, poly, originalMerge);
                if (ap == null) continue;
                PrimitiveNode pin = ap.findPinProto();
                List<NodeInst> niList = this.makePureLayerNodeFromPoly(poly, newCell, merge);
                merge.subtract(layer, poly);
                for (NodeInst ni : niList) {
                    PortInst fPi = ni.getOnlyPortInst();
                    Rectangle2D polyBounds = ni.getBounds();
                    Rectangle2D.Double searchBound = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
                    Iterator<RTBounds> it = newCell.searchIterator(searchBound);
                    while (it.hasNext()) {
                        NodeInst oNi;
                        RTBounds geom = it.next();
                        if (!(geom instanceof NodeInst) || (oNi = (NodeInst)geom) == ni || oNi.getProto() != pin || !DBMath.pointInsideRect(oNi.getAnchorCenter(), searchBound)) continue;
                        Iterator<Connection> cit = oNi.getConnections();
                        while (cit.hasNext()) {
                            ArcInst newAi;
                            Connection oConn;
                            Connection conn = cit.next();
                            ArcInst ai = conn.getArc();
                            if (ai.getProto() == Generic.tech().universal_arc) continue;
                            if (conn instanceof HeadConnection) {
                                oConn = ai.getTail();
                                newAi = ArcInst.makeInstanceBase(ap, ai.getLambdaBaseWidth(), fPi, oConn.getPortInst(), conn.getLocation(), oConn.getLocation(), null);
                            } else {
                                oConn = ai.getHead();
                                newAi = ArcInst.makeInstanceBase(ap, ai.getLambdaBaseWidth(), oConn.getPortInst(), fPi, oConn.getLocation(), conn.getLocation(), null);
                            }
                            if (newAi != null) {
                                newAi.setHeadExtended(ai.isHeadExtended());
                                newAi.setTailExtended(ai.isTailExtended());
                                if (newAi.getLambdaLength() == 0.0) {
                                    System.out.println("arc inst of zero length connecting pure layer nodes");
                                }
                                ai.kill();
                                continue;
                            }
                            String msg = "Cell " + newCell.describe(false) + ": Failed to replace arc " + ap.getName() + " from (" + conn.getLocation().getX() + "," + conn.getLocation().getY() + ") on node " + ni.describe(false) + " to (" + oConn.getLocation().getX() + "," + oConn.getLocation().getY() + ")";
                            this.addErrorLog(newCell, msg, new EPoint(conn.getLocation().getX(), conn.getLocation().getY()), new EPoint(oConn.getLocation().getX(), oConn.getLocation().getY()));
                        }
                    }
                }
            }
        }
        return false;
    }

    private void fixActiveNodes(Cell cell) {
        NodeInst ni;
        if (this.unifyActive) {
            return;
        }
        if (this.ignoreActiveSelectWell) {
            return;
        }
        PrimitiveNode pDiffNode = null;
        PrimitiveNode nDiffNode = null;
        Iterator<PrimitiveNode> it = cell.getTechnology().getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (pn.getFunction() != PrimitiveNode.Function.NODE) continue;
            Layer layer = pn.getLayerIterator().next();
            if (layer.getFunction() == Layer.Function.DIFFN) {
                nDiffNode = pn;
            }
            if (layer.getFunction() != Layer.Function.DIFFP) continue;
            pDiffNode = pn;
        }
        PolyMerge merge = new PolyMerge();
        Iterator<NodeInst> it2 = cell.getNodes();
        while (it2.hasNext()) {
            ni = it2.next();
            if (ni.isCellInstance()) continue;
            Poly[] polys = this.tech.getShapeOfNode(ni);
            for (int j = 0; j < polys.length; ++j) {
                Poly poly = polys[j];
                Layer layer = poly.getLayer();
                if (layer == null || (layer = this.geometricLayer(layer)).getFunction() != Layer.Function.IMPLANTN && layer.getFunction() != Layer.Function.IMPLANTP) continue;
                merge.add(layer, poly);
            }
        }
        it2 = cell.getNodes();
        while (it2.hasNext()) {
            Poly[] polys;
            PrimitiveNode pn;
            ni = it2.next();
            if (ni.isCellInstance() || (pn = (PrimitiveNode)ni.getProto()).getFunction() != PrimitiveNode.Function.NODE) continue;
            Layer nodeLayer = pn.getLayerIterator().next();
            PrimitiveNode newType = null;
            if (nodeLayer.getFunction() == Layer.Function.DIFFN) {
                for (Poly poly : polys = this.tech.getShapeOfNode(ni)) {
                    if (!merge.contains(this.pSelectLayer, poly)) continue;
                    newType = pDiffNode;
                    break;
                }
            }
            if (nodeLayer.getFunction() == Layer.Function.DIFFP) {
                for (Poly poly : polys = this.tech.getShapeOfNode(ni)) {
                    if (!merge.contains(this.nSelectLayer, poly)) continue;
                    newType = nDiffNode;
                    break;
                }
            }
            if (newType == null) continue;
            NodeInst newNi = NodeInst.newInstance(newType, ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), cell);
            if (ni.getTrace() != null && ni.getTrace().length > 0) {
                EPoint[] origPoints = ni.getTrace();
                Point2D[] points = new Point2D[origPoints.length];
                for (int i = 0; i < origPoints.length; ++i) {
                    points[i] = new Point2D.Double(origPoints[i].getX() + ni.getAnchorCenterX(), origPoints[i].getY() + ni.getAnchorCenterY());
                }
                newNi.setTrace(points);
            }
            ni.kill();
        }
    }

    private ArcProto findArcProtoForPoly(Layer layer, PolyBase poly, PolyMerge originalMerge) {
        Layer.Function fun = layer.getFunction();
        if (fun.isPoly() || fun.isMetal()) {
            return this.arcsForLayer.get(layer);
        }
        if (!fun.isDiff()) {
            return null;
        }
        ArrayList<Layer> requiredLayers = new ArrayList<Layer>();
        ArrayList<Layer> requiredAbsentLayers = new ArrayList<Layer>();
        Layer wellP = null;
        Layer wellN = null;
        Object selectP = null;
        Object selectN = null;
        for (Layer l : originalMerge.getKeySet()) {
            if (l.getFunction() == Layer.Function.WELLP) {
                wellP = l;
            }
            if (l.getFunction() != Layer.Function.WELLN) continue;
            wellN = l;
        }
        if (this.pSelectLayer != null && originalMerge.intersects(this.pSelectLayer, poly)) {
            if (this.unifyActive) {
                requiredLayers.add(this.activeLayer);
            } else {
                requiredLayers.add(this.realPActiveLayer);
            }
            requiredLayers.add(this.pSelectLayer);
        }
        if (this.nSelectLayer != null && originalMerge.intersects(this.nSelectLayer, poly)) {
            if (this.unifyActive) {
                requiredLayers.add(this.activeLayer);
            } else {
                requiredLayers.add(this.realNActiveLayer);
            }
            requiredLayers.add(this.nSelectLayer);
        }
        if (wellN == null || !originalMerge.intersects(wellN, poly)) {
            requiredAbsentLayers.add(wellN);
        }
        if (wellN != null && originalMerge.intersects(wellN, poly)) {
            requiredLayers.add(wellN);
        }
        if (wellP == null || !originalMerge.intersects(wellP, poly)) {
            requiredAbsentLayers.add(wellP);
        }
        if (wellP != null && originalMerge.intersects(wellP, poly)) {
            requiredLayers.add(wellP);
        }
        Iterator<ArcProto> aIt = this.tech.getArcs();
        while (aIt.hasNext()) {
            ArcProto ap = aIt.next();
            ArrayList<Layer> apLayers = new ArrayList<Layer>();
            Iterator<Layer> layit = ap.getLayerIterator();
            while (layit.hasNext()) {
                apLayers.add(layit.next());
            }
            boolean failed = false;
            for (Layer l : requiredLayers) {
                if (apLayers.contains(l)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            for (Layer l : requiredAbsentLayers) {
                if (!apLayers.contains(l)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            return ap;
        }
        return null;
    }

    private PortInst wantConnectingNodeAt(Point2D pt, ArcProto ap, double size, Cell newCell) {
        Rectangle2D.Double bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator<RTBounds> it = newCell.searchIterator(bounds);
        while (it.hasNext()) {
            RTBounds geom = it.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)geom;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                Poly poly;
                PortInst pi = pIt.next();
                PortProto pp = pi.getPortProto();
                if (!pp.connectsTo(ap) || !(poly = pi.getPoly()).contains(pt)) continue;
                return pi;
            }
        }
        NodeInst ni = this.createNode(ap.findPinProto(), pt, size, size, null, newCell);
        return ni.getOnlyPortInst();
    }

    private NodeInst wantNodeAt(Point2D pt, NodeProto pin, double size, Cell newCell) {
        Rectangle2D.Double bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator<RTBounds> it = newCell.searchIterator(bounds);
        while (it.hasNext()) {
            NodeInst ni;
            RTBounds geom = it.next();
            if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getProto() != pin || !ni.getAnchorCenter().equals(pt)) continue;
            return ni;
        }
        NodeInst ni = this.createNode(pin, pt, size, size, null, newCell);
        return ni;
    }

    private PortInst findPortInstClosestToPoly(NodeInst ni, PrimitivePort pp, Point2D pt) {
        PortInst touchingPi = ni.findPortInstFromProto(pp);
        PrimitiveNode pnp = (PrimitiveNode)ni.getProto();
        Poly touchingPoly = touchingPi.getPoly();
        double bestDist = pt.distance(new Point2D.Double(touchingPoly.getCenterX(), touchingPoly.getCenterY()));
        Iterator<PortProto> pIt = pnp.getPorts();
        while (pIt.hasNext()) {
            PortInst testPi;
            Poly testPoly;
            double dist;
            PrimitivePort prP = (PrimitivePort)pIt.next();
            if (prP.getTopology() != pp.getTopology() || !((dist = pt.distance(new Point2D.Double((testPoly = (testPi = ni.findPortInstFromProto(prP)).getPoly()).getCenterX(), testPoly.getCenterY()))) < bestDist)) continue;
            bestDist = dist;
            touchingPi = testPi;
        }
        return touchingPi;
    }

    private PortInst locatePortOnCenterline(Centerline cl, Point2D loc1, Layer layer, ArcProto ap, boolean startSide, Cell newCell) {
        PortInst piRet = null;
        boolean isHub = cl.endHub;
        this.gridAlignCenterline(cl, startSide);
        EPoint startPoint = cl.endUnscaled;
        if (startSide) {
            isHub = cl.startHub;
            startPoint = cl.startUnscaled;
        }
        if (!isHub) {
            List<PortInst> possiblePorts = this.findPortInstsTouchingPoint(startPoint, layer, newCell, ap);
            for (PortInst pi : possiblePorts) {
                Poly portPoly = pi.getPoly();
                Point2D[] points = portPoly.getPoints();
                if (points.length == 1) {
                    Point2D iPt = GenMath.intersect(cl.startUnscaled, cl.angle, points[0], (cl.angle + 900) % 3600);
                    if (iPt == null) continue;
                    loc1.setLocation(iPt.getX(), iPt.getY());
                    piRet = pi;
                    break;
                }
                if (portPoly.contains(startPoint)) {
                    loc1.setLocation(startPoint);
                    piRet = pi;
                    break;
                }
                for (int i = 0; i < points.length; ++i) {
                    int last = i - 1;
                    if (last < 0) {
                        last = points.length - 1;
                    }
                    Point2D portLineFrom = points[last];
                    Point2D portLineTo = points[i];
                    Point2D interPt = null;
                    if (portLineFrom.equals(portLineTo)) {
                        interPt = GenMath.intersect(cl.startUnscaled, cl.angle, portLineFrom, (cl.angle + 900) % 3600);
                    } else {
                        int angPortLine = GenMath.figureAngle(portLineFrom, portLineTo);
                        interPt = GenMath.intersect(portLineFrom, angPortLine, cl.startUnscaled, cl.angle);
                        if (interPt != null && (interPt.getX() < Math.min(portLineFrom.getX(), portLineTo.getX()) || interPt.getX() > Math.max(portLineFrom.getX(), portLineTo.getX()) || interPt.getY() < Math.min(portLineFrom.getY(), portLineTo.getY()) || interPt.getY() > Math.max(portLineFrom.getY(), portLineTo.getY()))) {
                            interPt = null;
                        }
                    }
                    if (interPt == null) continue;
                    loc1.setLocation(interPt.getX(), interPt.getY());
                    if (!portPoly.contains(loc1)) continue;
                    piRet = pi;
                    break;
                }
                if (piRet == null) continue;
                break;
            }
        }
        if (piRet == null) {
            PrimitiveNode pin = ap.findPinProto();
            int ang = GenMath.figureAngle(cl.start, cl.end);
            double xOff = GenMath.cos(ang) * cl.width / 2.0;
            double yOff = GenMath.sin(ang) * cl.width / 2.0;
            if (startSide) {
                if (!isHub && cl.start.distance(cl.end) > cl.width) {
                    if (xOff > 0.0 && xOff % this.scaleUp(this.alignment.getWidth()) != 0.0) {
                        xOff = 0.0;
                    }
                    if (yOff > 0.0 && yOff % this.scaleUp(this.alignment.getHeight()) != 0.0) {
                        yOff = 0.0;
                    }
                    cl.setStart(cl.start.getX() + xOff, cl.start.getY() + yOff);
                }
                double size = pin.getFactoryDefaultLambdaBaseWidth();
                NodeInst ni = this.wantNodeAt(cl.startUnscaled, pin, size, newCell);
                loc1.setLocation(cl.startUnscaled.getX(), cl.startUnscaled.getY());
                piRet = ni.getOnlyPortInst();
            } else {
                if (!isHub && cl.start.distance(cl.end) > cl.width) {
                    if (xOff > 0.0 && xOff % this.scaleUp(this.alignment.getWidth()) != 0.0) {
                        xOff = 0.0;
                    }
                    if (yOff > 0.0 && yOff % this.scaleUp(this.alignment.getHeight()) != 0.0) {
                        yOff = 0.0;
                    }
                    cl.setEnd(cl.end.getX() - xOff, cl.end.getY() - yOff);
                }
                NodeInst ni = this.wantNodeAt(cl.endUnscaled, pin, cl.width / 400.0, newCell);
                loc1.setLocation(cl.endUnscaled.getX(), cl.endUnscaled.getY());
                piRet = ni.getOnlyPortInst();
            }
        }
        return piRet;
    }

    private void gridAlignCenterline(Centerline cl, boolean startSide) {
    }

    private List<PortInst> findPortInstsTouchingPoint(Point2D pt, Layer layer, Cell newCell, ArcProto ap) {
        PortInst pi;
        ArrayList<PortInst> touchingNodes = new ArrayList<PortInst>();
        boolean mightCreateExports = false;
        Rectangle2D.Double checkBounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator<RTBounds> it = newCell.searchIterator(checkBounds);
        block0: while (it.hasNext()) {
            RTBounds geom = it.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)geom;
            if (ni.isCellInstance()) {
                boolean found = false;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi2 = pIt.next();
                    Poly portPoly = pi2.getPoly();
                    if (!portPoly.contains(pt)) continue;
                    touchingNodes.add(pi2);
                    found = true;
                    break;
                }
                if (found) continue;
                mightCreateExports = true;
                continue;
            }
            if (ni.getFunction().isPin()) {
                if (!ni.getOnlyPortInst().getPortProto().connectsTo(ap) || !ni.getAnchorCenter().equals(pt)) continue;
                touchingNodes.add(ni.getOnlyPortInst());
                continue;
            }
            Poly[] polys = this.tech.getShapeOfNode(ni, true, true, null);
            AffineTransform trans = ni.rotateOut();
            for (int i = 0; i < polys.length; ++i) {
                Poly oPoly = polys[i];
                Layer oLayer = this.geometricLayer(oPoly.getLayer());
                if (layer != oLayer) continue;
                oPoly.transform(trans);
                if (!oPoly.contains(pt)) continue;
                PortInst touchingPi = this.findPortInstClosestToPoly(ni, (PrimitivePort)oPoly.getPort(), pt);
                if (touchingPi == null) {
                    this.addErrorLog(newCell, "Can't find port for " + ni + " and " + oPoly.getPort(), new EPoint(pt.getX(), pt.getY()));
                    continue;
                }
                touchingNodes.add(touchingPi);
                continue block0;
            }
        }
        if (touchingNodes.size() == 0 && mightCreateExports && (pi = this.makePort(newCell, layer, pt)) != null) {
            touchingNodes.add(pi);
        }
        return touchingNodes;
    }

    private PortInst makePort(Cell cell, Layer layer, Point2D pt) {
        NodeInst subNi;
        RTBounds geom;
        Rectangle2D.Double checkBounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator<RTBounds> it = cell.searchIterator(checkBounds);
        while (it.hasNext()) {
            geom = it.next();
            if (!(geom instanceof NodeInst) || (subNi = (NodeInst)geom).isCellInstance()) continue;
            Technology tech = subNi.getProto().getTechnology();
            AffineTransform trans = subNi.rotateOut();
            Poly[] polyList = tech.getShapeOfNode(subNi, true, true, null);
            for (int i = 0; i < polyList.length; ++i) {
                PortInst foundPi;
                Poly poly = polyList[i];
                if (poly.getPort() == null || this.geometricLayer(poly.getLayer()) != layer) continue;
                poly.transform(trans);
                if (!poly.contains(pt) || (foundPi = this.findPortInstClosestToPoly(subNi, (PrimitivePort)poly.getPort(), pt)) == null) continue;
                return foundPi;
            }
        }
        it = cell.searchIterator(checkBounds);
        while (it.hasNext()) {
            boolean genFakeName;
            geom = it.next();
            if (!(geom instanceof NodeInst)) continue;
            subNi = (NodeInst)geom;
            PortInst foundPi = null;
            if (!subNi.isCellInstance()) continue;
            AffineTransform transIn = subNi.rotateIn(subNi.translateIn());
            Point2D.Double inside = new Point2D.Double();
            transIn.transform(pt, inside);
            Cell subCell = (Cell)subNi.getProto();
            PortInst pi = this.makePort(subCell, layer, inside);
            if (pi == null) continue;
            Iterator<Export> eIt = pi.getNodeInst().getExports();
            while (eIt.hasNext()) {
                Export e = eIt.next();
                if (e.getOriginalPort() != pi) continue;
                foundPi = subNi.findPortInstFromProto(e);
                return foundPi;
            }
            if (foundPi != null) continue;
            Netlist nl = subCell.acquireUserNetlist();
            Network net = nl.getNetwork(pi);
            String exportName = null;
            Iterator<String> nIt = net.getExportedNames();
            while (nIt.hasNext()) {
                String eName = nIt.next();
                if (eName.startsWith("E")) {
                    boolean isFake = false;
                    for (Export e : this.generatedExports) {
                        if (e.getParent() != subCell || !e.getName().equals(eName)) continue;
                        isFake = true;
                        break;
                    }
                    if (isFake) continue;
                }
                if (exportName != null && exportName.length() >= eName.length()) continue;
                exportName = eName;
            }
            boolean bl = genFakeName = exportName == null;
            if (genFakeName) {
                exportName = "E";
            }
            exportName = ElectricObject.uniqueObjectName(exportName, subCell, PortProto.class, true, true);
            Export e = Export.newInstance(subCell, pi, exportName);
            if (genFakeName) {
                this.generatedExports.add(e);
            }
            foundPi = subNi.findPortInstFromProto(e);
            return foundPi;
        }
        return null;
    }

    private boolean extractVias(PolyMerge merge, PolyMerge originalMerge, Cell oldCell, Cell newCell) {
        int totalCuts = 0;
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer layer : this.allCutLayers.keySet()) {
            layers.add(layer);
            CutInfo cInfo = this.allCutLayers.get(layer);
            totalCuts += cInfo.getNumCuts();
        }
        ArrayList<NodeInst> contactNodes = new ArrayList<NodeInst>();
        EditingPreferences ep = oldCell.getEditingPreferences();
        int soFar = 0;
        for (Layer layer : layers) {
            List<PossibleVia> possibleVias = this.findPossibleVias(layer, ep);
            TreeSet<Layer> layersToExamine = new TreeSet<Layer>();
            for (PossibleVia pv : possibleVias) {
                for (int i = 0; i < pv.layers.length; ++i) {
                    layersToExamine.add(pv.layers[i]);
                }
            }
            CutInfo cInfo = this.allCutLayers.get(layer);
            cInfo.sortCuts();
            ArrayList<PolyBase> cutsNotExtracted = new ArrayList<PolyBase>();
            while (cInfo.getNumCuts() > 0) {
                Rectangle2D cutBox;
                PolyBase cut = cInfo.getFirstCut();
                if (!this.recursive && ++soFar % 100 == 0) {
                    Job.getUserInterface().setProgressValue(soFar * 100 / totalCuts);
                }
                if ((cutBox = cut.getBox()) == null) {
                    cutBox = cut.getBounds2D();
                    double centerX = cutBox.getCenterX() / 400.0;
                    double centerY = cutBox.getCenterY() / 400.0;
                    String msg = "Cannot extract nonManhattan contact cut at (" + TextUtils.formatDistance(centerX) + "," + TextUtils.formatDistance(centerY) + ")";
                    this.addErrorLog(newCell, msg, new EPoint(centerX, centerY));
                    cInfo.removeCut(cut);
                    cutsNotExtracted.add(cut);
                    continue;
                }
                Point2D.Double ctr = new Point2D.Double(cutBox.getCenterX(), cutBox.getCenterY());
                TreeSet<Layer> layersPresent = new TreeSet<Layer>();
                for (Layer l : layersToExamine) {
                    boolean layerAtPoint = originalMerge.contains(l, ctr);
                    if (!layerAtPoint) continue;
                    layersPresent.add(this.geometricLayer(l));
                }
                boolean ignorePWell = false;
                boolean ignoreNWell = false;
                if (this.pSubstrateProcess) {
                    boolean foundNWell = false;
                    for (Layer l : layersPresent) {
                        if (l.getFunction() != Layer.Function.WELLN) continue;
                        foundNWell = true;
                        break;
                    }
                    if (!foundNWell) {
                        ignorePWell = true;
                    }
                }
                if (this.nSubstrateProcess) {
                    boolean foundPWell = false;
                    for (Layer l : layersPresent) {
                        if (l.getFunction() != Layer.Function.WELLP) continue;
                        foundPWell = true;
                        break;
                    }
                    if (!foundPWell) {
                        ignoreNWell = true;
                    }
                }
                boolean foundCut = false;
                String reason = null;
                for (PossibleVia pv : possibleVias) {
                    Rectangle2D bound;
                    ArrayList<Layer> missingLayers = null;
                    for (int i = 0; i < pv.layers.length; ++i) {
                        if (layersPresent.contains(pv.layers[i]) || ignorePWell && pv.layers[i].getFunction() == Layer.Function.WELLP || ignoreNWell && pv.layers[i].getFunction() == Layer.Function.WELLN) continue;
                        if (missingLayers == null) {
                            missingLayers = new ArrayList<Layer>();
                        }
                        missingLayers.add(pv.layers[i]);
                        break;
                    }
                    if (missingLayers != null) {
                        reason = "layers are missing:";
                        for (Layer l : missingLayers) {
                            reason = reason + " " + l.getName();
                        }
                        continue;
                    }
                    boolean activeCut = false;
                    boolean polyCut = false;
                    Technology.NodeLayer[] primLayers = pv.pNp.getNodeLayers();
                    for (int i = 0; i < primLayers.length; ++i) {
                        if (primLayers[i].getLayer().getFunction().isDiff()) {
                            activeCut = true;
                        }
                        if (!primLayers[i].getLayer().getFunction().isPoly()) continue;
                        polyCut = true;
                    }
                    if (activeCut && polyCut) {
                        polyCut = false;
                        activeCut = false;
                    }
                    HashSet<PolyBase> cutsInArea = new HashSet<PolyBase>();
                    cutsInArea.add(cut);
                    Rectangle2D multiCutBounds = (Rectangle2D)cutBox.clone();
                    double cutLimit = Math.ceil(Math.max(pv.multicutSep1D, pv.multicutSep2D) + Math.max(pv.multicutSizeX, pv.multicutSizeY)) * 400.0;
                    boolean foundMore = true;
                    double xspacing = 0.0;
                    double yspacing = 0.0;
                    while (foundMore) {
                        foundMore = false;
                        Rectangle2D.Double searchArea = new Rectangle2D.Double(multiCutBounds.getMinX() - cutLimit, multiCutBounds.getMinY() - cutLimit, multiCutBounds.getWidth() + cutLimit * 2.0, multiCutBounds.getHeight() + cutLimit * 2.0);
                        RTNode.Search sea = new RTNode.Search(searchArea, cInfo.getRTree(), true);
                        while (sea.hasNext()) {
                            CutBound cBound = (CutBound)sea.next();
                            if (cutsInArea.contains(cBound.cut) || !searchArea.contains((bound = cBound.getBounds()).getCenterX(), bound.getCenterY())) continue;
                            double distX = cut.getCenterX() - bound.getCenterX();
                            double distY = cut.getCenterY() - bound.getCenterY();
                            if (xspacing == 0.0) {
                                xspacing = distX;
                            } else if (distX % xspacing != 0.0) continue;
                            if (yspacing == 0.0) {
                                yspacing = distY;
                            } else if (distY % yspacing != 0.0) continue;
                            double lX = Math.min(multiCutBounds.getMinX(), bound.getMinX());
                            double hX = Math.max(multiCutBounds.getMaxX(), bound.getMaxX());
                            double lY = Math.min(multiCutBounds.getMinY(), bound.getMinY());
                            double hY = Math.max(multiCutBounds.getMaxY(), bound.getMaxY());
                            Rectangle2D.Double newMultiCutBounds = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                            boolean fits = true;
                            PolyBase layerPoly = new PolyBase(newMultiCutBounds);
                            for (int i = 0; i < pv.layers.length; ++i) {
                                Layer lay = pv.layers[i];
                                if (!lay.getFunction().isMetal() || originalMerge.contains(lay, layerPoly)) continue;
                                fits = false;
                                break;
                            }
                            if (!fits) continue;
                            multiCutBounds = newMultiCutBounds;
                            cutsInArea.add(cBound.cut);
                            foundMore = true;
                        }
                    }
                    if (xspacing == 0.0) {
                        xspacing = cutLimit;
                    }
                    if (yspacing == 0.0) {
                        yspacing = cutLimit;
                    }
                    Set<PolyBase> rectVias = this.getLargestRectangleOfVias(cutsInArea, cut, xspacing, yspacing, multiCutBounds);
                    cutsInArea.clear();
                    cutsInArea.addAll(rectVias);
                    multiCutBounds = (Rectangle2D)cutBox.clone();
                    for (PolyBase via : rectVias) {
                        bound = via.getBounds2D();
                        double lX = Math.min(multiCutBounds.getMinX(), bound.getMinX());
                        double hX = Math.max(multiCutBounds.getMaxX(), bound.getMaxX());
                        double lY = Math.min(multiCutBounds.getMinY(), bound.getMinY());
                        double hY = Math.max(multiCutBounds.getMaxY(), bound.getMaxY());
                        multiCutBounds = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                    }
                    double trueWidth = pv.minWidth;
                    double trueHeight = pv.minHeight;
                    if (pv.rotation == 90 || pv.rotation == 270) {
                        trueWidth = pv.minHeight;
                        trueHeight = pv.minWidth;
                    }
                    double lX = cutBox.getCenterX();
                    double hX = cutBox.getCenterX();
                    double lY = cutBox.getCenterY();
                    double hY = cutBox.getCenterY();
                    for (PolyBase cutBound : cutsInArea) {
                        if (cutBound.getCenterX() < lX) {
                            lX = cutBound.getCenterX();
                        }
                        if (cutBound.getCenterX() > hX) {
                            hX = cutBound.getCenterX();
                        }
                        if (cutBound.getCenterY() < lY) {
                            lY = cutBound.getCenterY();
                        }
                        if (!(cutBound.getCenterY() > hY)) continue;
                        hY = cutBound.getCenterY();
                    }
                    Rectangle2D.Double contactBound = new Rectangle2D.Double(lX -= trueWidth / 2.0, lY -= trueHeight / 2.0, (hX += trueWidth / 2.0) - lX, (hY += trueHeight / 2.0) - lY);
                    Layer badLayer = this.doesNodeFit(pv, multiCutBounds, originalMerge, ignorePWell, ignoreNWell);
                    if (badLayer == null) {
                        double mw = ((RectangularShape)contactBound).getWidth();
                        double mh = ((RectangularShape)contactBound).getHeight();
                        if (pv.rotation == 90 || pv.rotation == 270) {
                            mw = ((RectangularShape)contactBound).getHeight();
                            mh = ((RectangularShape)contactBound).getWidth();
                        }
                        if ((badLayer = this.realizeBiggestContact(pv.pNp, 0, contactBound.getCenterX(), contactBound.getCenterY(), mw, mh, pv.rotation * 10, originalMerge, newCell, contactNodes, activeCut, polyCut, cutsInArea)) == null) {
                            for (PolyBase cutFound : cutsInArea) {
                                cInfo.removeCut(cutFound);
                            }
                            soFar += cutsInArea.size() - 1;
                            foundCut = true;
                            break;
                        }
                        if (cutsInArea.size() > 1 && pv.pNp.findMulticut() != null) {
                            Layer spreadBadLayer = this.realizeBiggestContact(pv.pNp, 1, contactBound.getCenterX(), contactBound.getCenterY(), mw, mh, pv.rotation * 10, originalMerge, newCell, contactNodes, activeCut, polyCut, cutsInArea);
                            if (spreadBadLayer == null) {
                                for (PolyBase cutFound : cutsInArea) {
                                    cInfo.removeCut(cutFound);
                                }
                                soFar += cutsInArea.size() - 1;
                                foundCut = true;
                                break;
                            }
                            spreadBadLayer = this.realizeBiggestContact(pv.pNp, 2, contactBound.getCenterX(), contactBound.getCenterY(), mw, mh, pv.rotation * 10, originalMerge, newCell, contactNodes, activeCut, polyCut, cutsInArea);
                            if (spreadBadLayer == null) {
                                for (PolyBase cutFound : cutsInArea) {
                                    cInfo.removeCut(cutFound);
                                }
                                soFar += cutsInArea.size() - 1;
                                foundCut = true;
                                break;
                            }
                        }
                    }
                    if ((badLayer = this.doesNodeFit(pv, cutBox, originalMerge, ignorePWell, ignoreNWell)) == null) {
                        this.realizeNode(pv.pNp, 0, cutBox.getCenterX(), cutBox.getCenterY(), pv.minWidth, pv.minHeight, pv.rotation * 10, null, originalMerge, newCell, contactNodes);
                        cInfo.removeCut(cut);
                        foundCut = true;
                        break;
                    }
                    reason = "node " + pv.pNp.describe(false) + ", layer " + badLayer.getName() + " does not fit";
                    if (pv.rotation == 0) continue;
                    reason = reason + " (when rotated " + pv.rotation + ")";
                }
                if (foundCut) continue;
                double centerX = cutBox.getCenterX() / 400.0;
                double centerY = cutBox.getCenterY() / 400.0;
                String msg = "Cell " + newCell.describe(false) + ": Did not extract contact " + cut.getLayer().getName() + " cut at (" + TextUtils.formatDouble(centerX) + "," + TextUtils.formatDouble(centerY) + ")";
                if (reason != null) {
                    msg = msg + " because " + reason;
                }
                this.addErrorLog(newCell, msg, new EPoint(centerX, centerY));
                cInfo.removeCut(cut);
                cutsNotExtracted.add(cut);
            }
            for (PolyBase pb : cutsNotExtracted) {
                cInfo.addCut(pb);
            }
        }
        if (!this.startSection(oldCell, "Finished extracting " + contactNodes.size() + " vias...")) {
            return false;
        }
        RTNode root = RTNode.makeTopLevel();
        for (NodeInst ni : contactNodes) {
            root = RTNode.linkGeom(null, root, ni);
        }
        if (!Extract.isUsePureLayerNodes()) {
            PolyMerge subtractMerge = new PolyMerge();
            this.extractContactNodes(root, merge, subtractMerge, 0, contactNodes.size());
            merge.subtractMerge(subtractMerge);
        }
        return true;
    }

    private Set<PolyBase> getLargestRectangleOfVias(Set<PolyBase> vias, PolyBase initialVia, double xspacing, double yspacing, Rectangle2D bounds) {
        int y;
        xspacing = Math.abs(xspacing);
        yspacing = Math.abs(yspacing);
        if (xspacing == 0.0) {
            xspacing = 400.0;
        }
        if (yspacing == 0.0) {
            yspacing = 400.0;
        }
        int numViasWide = (int)Math.ceil(bounds.getWidth() / xspacing);
        int numViasHigh = (int)Math.ceil(bounds.getHeight() / yspacing);
        PolyBase[][] viaMap = new PolyBase[numViasWide][numViasHigh];
        int nomX = 0;
        int nomY = 0;
        for (int x = 0; x < numViasWide; ++x) {
            Arrays.fill(viaMap[x], null);
        }
        for (PolyBase via : vias) {
            int x = (int)((via.getCenterX() - bounds.getMinX()) / xspacing);
            int y2 = (int)((via.getCenterY() - bounds.getMinY()) / yspacing);
            viaMap[x][y2] = via;
            if (via != initialVia) continue;
            nomX = x;
            nomY = y2;
        }
        int maxY = nomY;
        int minY = nomY;
        boolean initial = true;
        for (int x = 0; x < numViasWide; ++x) {
            if (viaMap[x][nomY] == null) continue;
            int colMaxY = nomY;
            y = nomY;
            while (y < numViasHigh && viaMap[x][y] != null) {
                colMaxY = y++;
            }
            if (initial) {
                maxY = colMaxY;
            } else if (colMaxY < maxY) {
                maxY = colMaxY;
            }
            int colMinY = nomY;
            int y3 = nomY;
            while (y3 >= 0 && viaMap[x][y3] != null) {
                colMinY = y3--;
            }
            if (initial) {
                minY = colMinY;
            } else if (colMinY > minY) {
                minY = colMinY;
            }
            initial = false;
        }
        int maxX = nomX;
        int minX = nomX;
        initial = true;
        for (y = 0; y < numViasHigh; ++y) {
            if (viaMap[nomX][y] == null) continue;
            int colMaxX = nomX;
            int x = nomX;
            while (x < numViasWide && viaMap[x][y] != null) {
                colMaxX = x++;
            }
            if (initial) {
                maxX = colMaxX;
            } else if (colMaxX < maxX) {
                maxX = colMaxX;
            }
            int colMinX = nomX;
            int x2 = nomX;
            while (x2 >= 0 && viaMap[x2][y] != null) {
                colMinX = x2--;
            }
            if (initial) {
                minX = colMinX;
            } else if (colMinX > minX) {
                minX = colMinX;
            }
            initial = false;
        }
        HashSet<PolyBase> rectVias = new HashSet<PolyBase>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y4 = minY; y4 <= maxY; ++y4) {
                rectVias.add(viaMap[x][y4]);
            }
        }
        return rectVias;
    }

    private Layer realizeBiggestContact(PrimitiveNode pNp, int cutVariation, double x, double y, double sX, double sY, int rot, PolyMerge merge, Cell newCell, List<NodeInst> contactNodes, boolean activeCut, boolean polyCut, Set<PolyBase> cutsInArea) {
        NodeInst ni;
        PolyBase error;
        NodeInst ni2;
        PolyBase error2;
        Orientation orient = Orientation.fromAngle(rot);
        if (this.alignment != null) {
            double scale;
            if (this.alignment.getWidth() > 0.0) {
                scale = this.scaleUp(this.alignment.getWidth());
                x = (double)Math.round(x / scale) * scale;
            }
            if (this.alignment.getHeight() > 0.0) {
                scale = this.scaleUp(this.alignment.getHeight());
                y = (double)Math.round(y / scale) * scale;
            }
        }
        EPoint ctr = new EPoint(x / 400.0, y / 400.0);
        double lowXInc = 0.0;
        double highXInc = 800.0;
        while ((error2 = this.dummyNodeFits(ni2 = this.makeDummyNodeInst(pNp, ctr, sX + highXInc, sY, orient, cutVariation), merge, activeCut, polyCut, cutsInArea)) == null) {
            lowXInc = highXInc;
            highXInc *= 2.0;
        }
        while (true) {
            if (highXInc - lowXInc <= 1.0) break;
            double medInc = (lowXInc + highXInc) / 2.0;
            NodeInst ni3 = this.makeDummyNodeInst(pNp, ctr, sX + medInc, sY, orient, cutVariation);
            PolyBase error3 = this.dummyNodeFits(ni3, merge, activeCut, polyCut, cutsInArea);
            if (error3 == null) {
                lowXInc = medInc;
                continue;
            }
            highXInc = medInc;
        }
        lowXInc = Math.floor(lowXInc);
        double lowYInc = 0.0;
        double highYInc = 800.0;
        while ((error = this.dummyNodeFits(ni = this.makeDummyNodeInst(pNp, ctr, sX, sY + highYInc, orient, cutVariation), merge, activeCut, polyCut, cutsInArea)) == null) {
            lowYInc = highYInc;
            highYInc *= 2.0;
        }
        while (true) {
            if (highYInc - lowYInc <= 1.0) break;
            double medInc = (lowYInc + highYInc) / 2.0;
            NodeInst ni4 = this.makeDummyNodeInst(pNp, ctr, sX, sY + medInc, orient, cutVariation);
            PolyBase error4 = this.dummyNodeFits(ni4, merge, activeCut, polyCut, cutsInArea);
            if (error4 == null) {
                lowYInc = medInc;
                continue;
            }
            highYInc = medInc;
        }
        lowYInc = Math.floor(lowYInc);
        if (!this.approximateCuts) {
            ni = this.makeDummyNodeInst(pNp, ctr, sX + lowXInc, sY + lowYInc, orient, cutVariation);
            error = this.dummyNodeFits(ni, merge, activeCut, polyCut, cutsInArea);
            if (error != null) {
                if (lowXInc > lowYInc) {
                    ni = this.makeDummyNodeInst(pNp, ctr, sX + lowXInc, sY, orient, cutVariation);
                    error = this.dummyNodeFits(ni, merge, activeCut, polyCut, cutsInArea);
                    if (error == null) {
                        sX += lowXInc;
                    }
                } else {
                    ni = this.makeDummyNodeInst(pNp, ctr, sX, sY + lowYInc, orient, cutVariation);
                    error = this.dummyNodeFits(ni, merge, activeCut, polyCut, cutsInArea);
                    if (error == null) {
                        sY += lowYInc;
                    }
                }
            } else {
                sX += lowXInc;
                sY += lowYInc;
            }
            if (error != null) {
                return error.getLayer();
            }
        }
        if (this.alignment != null) {
            if (this.alignment.getWidth() > 0.0) {
                double scale = this.scaleUp(this.alignment.getWidth()) * 2.0;
                sX = Math.floor(sX / scale) * scale;
            }
            if (this.alignment.getHeight() > 0.0) {
                double scale = this.scaleUp(this.alignment.getHeight()) * 2.0;
                sY = Math.floor(sY / scale) * scale;
            }
        }
        this.realizeNode(pNp, cutVariation, x, y, sX, sY, rot, null, merge, newCell, contactNodes);
        return null;
    }

    private NodeInst makeDummyNodeInst(PrimitiveNode pNp, EPoint ctr, double sX, double sY, Orientation orient, int cutVariation) {
        NodeInst ni = NodeInst.makeDummyInstance(pNp, ctr, sX / 400.0, sY / 400.0, orient);
        if (ni == null) {
            return null;
        }
        if (cutVariation != 0) {
            ni.newVar(Technology.NodeLayer.CUT_ALIGNMENT, (Object)cutVariation);
        }
        return ni;
    }

    private PolyBase dummyNodeFits(NodeInst ni, PolyMerge merge, boolean activeCut, boolean polyCut, Set<PolyBase> cutsInArea) {
        AffineTransform trans = ni.rotateOut();
        Technology tech = ni.getProto().getTechnology();
        Poly[] polys = tech.getShapeOfNode(ni);
        double biggestArea = 0.0;
        Poly biggestPoly = null;
        ArrayList<Poly> cutsFound = null;
        if (!this.approximateCuts) {
            cutsFound = new ArrayList<Poly>();
        }
        boolean hasPplus = false;
        boolean hasNplus = false;
        boolean hasActive = false;
        for (Poly poly : polys) {
            Layer l = poly.getLayer();
            if (l == null || (l = this.geometricLayer(l)).getFunction() == Layer.Function.WELLP && this.pSubstrateProcess || l.getFunction() == Layer.Function.WELLN && this.nSubstrateProcess) continue;
            if (l.isDiffusionLayer()) {
                hasActive = true;
            }
            if (l.getFunction() == Layer.Function.IMPLANTN) {
                hasNplus = true;
            }
            if (l.getFunction() == Layer.Function.IMPLANTP) {
                hasPplus = true;
            }
            poly.setLayer(l);
            poly.transform(trans);
            if (l.getFunction().isContact()) {
                if (this.approximateCuts) continue;
                cutsFound.add(poly);
                continue;
            }
            double area = poly.getArea();
            if (area > biggestArea) {
                biggestArea = area;
                biggestPoly = poly;
            }
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                poly.setPoint(i, this.scaleUp(points[i].getX()), this.scaleUp(points[i].getY()));
            }
            if (merge.contains(l, poly)) continue;
            return poly;
        }
        PrimitiveNode pn = (PrimitiveNode)ni.getProto();
        PolyBase testPoly = new PolyBase(new Point2D[]{new Point2D.Double(this.scaleUp(ni.getAnchorCenterX()) - 1.0, this.scaleUp(ni.getAnchorCenterY()) - 1.0), new Point2D.Double(this.scaleUp(ni.getAnchorCenterX()) - 1.0, this.scaleUp(ni.getAnchorCenterY()) + 1.0), new Point2D.Double(this.scaleUp(ni.getAnchorCenterX()) + 1.0, this.scaleUp(ni.getAnchorCenterY()) + 1.0), new Point2D.Double(this.scaleUp(ni.getAnchorCenterX()) + 1.0, this.scaleUp(ni.getAnchorCenterY()) - 1.0)});
        testPoly.setLayer(this.wellLayer);
        if (pn.getFunction() == PrimitiveNode.Function.SUBSTRATE && this.wellLayer != null && merge.contains(this.wellLayer, testPoly)) {
            return testPoly;
        }
        if (pn.getFunction() == PrimitiveNode.Function.CONTACT && hasActive && (this.pSubstrateProcess && hasNplus || this.nSubstrateProcess && hasPplus) && merge.contains(this.wellLayer, testPoly)) {
            return testPoly;
        }
        if (!this.approximateCuts && cutsInArea != null) {
            for (PolyBase pb : cutsInArea) {
                boolean foundIt = false;
                for (int i = 0; i < cutsFound.size(); ++i) {
                    PolyBase pb2 = (PolyBase)cutsFound.get(i);
                    if (!DBMath.doublesClose(pb.getCenterX() / 400.0, pb2.getCenterX()) || !DBMath.doublesClose(pb.getCenterY() / 400.0, pb2.getCenterY())) continue;
                    cutsFound.remove(i);
                    foundIt = true;
                    break;
                }
                if (foundIt) continue;
                return pb;
            }
            if (cutsFound.size() > 0) {
                return (PolyBase)cutsFound.get(0);
            }
        }
        if (activeCut && biggestPoly != null && merge.intersects(this.polyLayer, biggestPoly)) {
            return biggestPoly;
        }
        if (polyCut && biggestPoly != null) {
            if (this.pActiveLayer != null && merge.intersects(this.pActiveLayer, biggestPoly)) {
                return biggestPoly;
            }
            if (this.nActiveLayer != null && this.nActiveLayer != this.pActiveLayer && merge.intersects(this.nActiveLayer, biggestPoly)) {
                return biggestPoly;
            }
        }
        return null;
    }

    private int extractContactNodes(RTNode root, PolyMerge merge, PolyMerge subtractMerge, int soFar, int totalContacts) {
        for (int j = 0; j < root.getTotal(); ++j) {
            Object child = root.getChild(j);
            if (root.getFlag()) {
                if (!this.recursive && ++soFar % 100 == 0) {
                    Job.getUserInterface().setProgressValue(soFar * 100 / totalContacts);
                }
                NodeInst ni = (NodeInst)child;
                AffineTransform trans = ni.rotateOut();
                Poly[] polys = this.tech.getShapeOfNode(ni);
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    Layer layer = poly.getLayer();
                    if ((layer = this.geometricLayer(layer)).getFunction().isContact() || layer.getFunction().isMetal() || layer.getFunction().isPoly()) continue;
                    poly.transform(trans);
                    Point2D[] points = poly.getPoints();
                    for (int k = 0; k < points.length; ++k) {
                        poly.setPoint(k, this.scaleUp(points[k].getX()), this.scaleUp(points[k].getY()));
                    }
                    poly.roundPoints();
                    subtractMerge.add(layer, poly);
                }
                if (soFar % 500 != 0) continue;
                merge.subtractMerge(subtractMerge);
                ArrayList<Layer> allLayers = new ArrayList<Layer>();
                for (Layer lay : subtractMerge.getKeySet()) {
                    allLayers.add(lay);
                }
                for (Layer lay : allLayers) {
                    subtractMerge.deleteLayer(lay);
                }
                continue;
            }
            soFar = this.extractContactNodes((RTNode)child, merge, subtractMerge, soFar, totalContacts);
        }
        return soFar;
    }

    private List<PossibleVia> findPossibleVias(Layer lay, EditingPreferences ep) {
        ArrayList<PossibleVia> possibleVias = new ArrayList<PossibleVia>();
        Iterator<PrimitiveNode> nIt = this.tech.getNodes();
        while (nIt.hasNext()) {
            int i;
            PrimitiveNode pNp = nIt.next();
            PrimitiveNode.Function fun = pNp.getFunction();
            if (!fun.isContact() && fun != PrimitiveNode.Function.WELL && fun != PrimitiveNode.Function.SUBSTRATE) continue;
            boolean bogus = false;
            Technology.NodeLayer[] nLs = pNp.getNodeLayers();
            for (int i2 = 0; i2 < nLs.length; ++i2) {
                Technology.NodeLayer nLay = nLs[i2];
                Technology.TechPoint[] debugPoints = nLay.getPoints();
                if (debugPoints != null && debugPoints.length > 0) continue;
                bogus = true;
                break;
            }
            if (bogus) continue;
            NodeInst dummyNI = NodeInst.makeDummyInstance(pNp);
            Poly[] layerPolys = this.tech.getShapeOfNode(dummyNI);
            int cutNodeLayer = -1;
            int m1Layer = -1;
            int m2Layer = -1;
            boolean hasPolyActive = false;
            ArrayList<Integer> pvLayers = new ArrayList<Integer>();
            for (int i3 = 0; i3 < layerPolys.length; ++i3) {
                Poly poly = layerPolys[i3];
                Layer nLayer = poly.getLayer();
                Layer.Function lFun = nLayer.getFunction();
                if (lFun.isMetal()) {
                    if (m1Layer < 0) {
                        m1Layer = i3;
                    } else if (m2Layer < 0) {
                        m2Layer = i3;
                    }
                } else if (lFun.isDiff() || lFun.isPoly()) {
                    hasPolyActive = true;
                }
                if (this.ignoreActiveSelectWell && fun.isContact() && (lFun.isImplant() || lFun.isSubstrate() || lFun.isWell())) continue;
                boolean cutLayer = false;
                if (nLayer == lay) {
                    cutLayer = true;
                } else if (nLayer.getFunction() == lay.getFunction()) {
                    cutLayer = true;
                }
                if (cutLayer) {
                    cutNodeLayer = i3;
                    continue;
                }
                pvLayers.add(new Integer(i3));
            }
            if (cutNodeLayer < 0) continue;
            if (!hasPolyActive && fun.isContact()) {
                boolean badContact = false;
                if (m1Layer < 0 || m2Layer < 0) {
                    badContact = true;
                } else {
                    int highMetal;
                    int lowMetal = layerPolys[m1Layer].getLayer().getFunction().getLevel();
                    if (lowMetal > (highMetal = layerPolys[m2Layer].getLayer().getFunction().getLevel())) {
                        int s = lowMetal;
                        lowMetal = highMetal;
                        highMetal = s;
                    }
                    if (lowMetal != highMetal - 1) {
                        badContact = true;
                    }
                }
                if (badContact) {
                    if (this.bogusContacts.contains(pNp)) continue;
                    this.bogusContacts.add(pNp);
                    System.out.println("Not extracting unusual via contact: " + pNp.describe(false));
                    continue;
                }
            }
            PossibleVia pv = new PossibleVia(pNp, pvLayers.size());
            for (int i4 = 0; i4 < nLs.length; ++i4) {
                Technology.NodeLayer nLay = nLs[i4];
                if (nLay.getLayer() != layerPolys[cutNodeLayer].getLayer()) continue;
                pv.multicutSep1D = nLay.getMulticutSep1D();
                pv.multicutSep2D = nLay.getMulticutSep2D();
                pv.multicutSizeX = nLay.getMulticutSizeX();
                pv.multicutSizeX = nLay.getMulticutSizeY();
            }
            pv.minWidth = this.scaleUp(pNp.getDefWidth());
            pv.minHeight = this.scaleUp(pNp.getDefHeight());
            int fill = 0;
            double cutLX = layerPolys[cutNodeLayer].getBounds2D().getMinX();
            double cutHX = layerPolys[cutNodeLayer].getBounds2D().getMaxX();
            double cutLY = layerPolys[cutNodeLayer].getBounds2D().getMinY();
            double cutHY = layerPolys[cutNodeLayer].getBounds2D().getMaxY();
            for (Integer layIndex : pvLayers) {
                int index = layIndex;
                pv.layers[fill] = this.geometricLayer(layerPolys[index].getLayer());
                double layLX = layerPolys[index].getBounds2D().getMinX();
                double layHX = layerPolys[index].getBounds2D().getMaxX();
                double layLY = layerPolys[index].getBounds2D().getMinY();
                double layHY = layerPolys[index].getBounds2D().getMaxY();
                pv.shrinkL[fill] = this.scaleUp(cutLX - layLX);
                pv.shrinkR[fill] = this.scaleUp(layHX - cutHX);
                pv.shrinkT[fill] = this.scaleUp(layHY - cutHY);
                pv.shrinkB[fill] = this.scaleUp(cutLY - layLY);
                ++fill;
            }
            possibleVias.add(pv);
            boolean hvSymmetry = true;
            boolean rotSymmetry = true;
            for (int i5 = 0; i5 < pv.layers.length; ++i5) {
                if (pv.shrinkL[i5] != pv.shrinkR[i5] || pv.shrinkT[i5] != pv.shrinkB[i5]) {
                    rotSymmetry = false;
                    break;
                }
                if (pv.shrinkL[i5] == pv.shrinkT[i5] && pNp.getDefWidth() == pNp.getDefHeight()) continue;
                hvSymmetry = false;
            }
            if (!hvSymmetry || !rotSymmetry) {
                PossibleVia newPV = new PossibleVia(pv.pNp, pv.layers.length);
                newPV.rotation = 90;
                newPV.multicutSep1D = pv.multicutSep1D;
                newPV.multicutSep2D = pv.multicutSep2D;
                newPV.multicutSizeX = pv.multicutSizeX;
                newPV.multicutSizeY = pv.multicutSizeY;
                newPV.minWidth = pv.minWidth;
                newPV.minHeight = pv.minHeight;
                for (int i6 = 0; i6 < pv.layers.length; ++i6) {
                    newPV.layers[i6] = pv.layers[i6];
                    newPV.shrinkL[i6] = pv.shrinkT[i6];
                    newPV.shrinkR[i6] = pv.shrinkB[i6];
                    newPV.shrinkT[i6] = pv.shrinkR[i6];
                    newPV.shrinkB[i6] = pv.shrinkL[i6];
                }
                possibleVias.add(newPV);
            }
            if (rotSymmetry) continue;
            PossibleVia newPV = new PossibleVia(pv.pNp, pv.layers.length);
            newPV.rotation = 180;
            newPV.multicutSep1D = pv.multicutSep1D;
            newPV.multicutSep2D = pv.multicutSep2D;
            newPV.multicutSizeX = pv.multicutSizeX;
            newPV.multicutSizeY = pv.multicutSizeY;
            newPV.minWidth = pv.minWidth;
            newPV.minHeight = pv.minHeight;
            for (i = 0; i < pv.layers.length; ++i) {
                newPV.layers[i] = pv.layers[i];
                newPV.shrinkL[i] = pv.shrinkR[i];
                newPV.shrinkR[i] = pv.shrinkL[i];
                newPV.shrinkT[i] = pv.shrinkB[i];
                newPV.shrinkB[i] = pv.shrinkT[i];
            }
            possibleVias.add(newPV);
            newPV = new PossibleVia(pv.pNp, pv.layers.length);
            newPV.rotation = 270;
            newPV.multicutSep1D = pv.multicutSep1D;
            newPV.multicutSep2D = pv.multicutSep2D;
            newPV.multicutSizeX = pv.multicutSizeX;
            newPV.multicutSizeY = pv.multicutSizeY;
            newPV.minWidth = pv.minWidth;
            newPV.minHeight = pv.minHeight;
            for (i = 0; i < pv.layers.length; ++i) {
                newPV.layers[i] = pv.layers[i];
                newPV.shrinkL[i] = pv.shrinkB[i];
                newPV.shrinkR[i] = pv.shrinkT[i];
                newPV.shrinkT[i] = pv.shrinkL[i];
                newPV.shrinkB[i] = pv.shrinkR[i];
            }
            possibleVias.add(newPV);
        }
        Collections.sort(possibleVias, new ViasBySize(ep));
        return possibleVias;
    }

    private Layer doesNodeFit(PossibleVia pv, Rectangle2D cutBox, PolyMerge originalMerge, boolean ignorePWell, boolean ignoreNWell) {
        boolean hasPplus = false;
        boolean hasNplus = false;
        boolean hasActive = false;
        for (int i = 0; i < pv.layers.length; ++i) {
            double hY;
            double lY;
            double layerCY;
            double hX;
            double lX;
            double layerCX;
            PolyBase layerPoly;
            Layer l = pv.layers[i];
            if (ignorePWell && l.getFunction() == Layer.Function.WELLP || ignoreNWell && l.getFunction() == Layer.Function.WELLN) continue;
            if (l.isDiffusionLayer()) {
                hasActive = true;
            }
            if (l.getFunction() == Layer.Function.IMPLANTN) {
                hasNplus = true;
            }
            if (l.getFunction() == Layer.Function.IMPLANTP) {
                hasPplus = true;
            }
            if (originalMerge.contains(l, layerPoly = new PolyBase(layerCX = ((lX = cutBox.getMinX() - pv.shrinkL[i]) + (hX = cutBox.getMaxX() + pv.shrinkR[i])) / 2.0, layerCY = ((lY = cutBox.getMinY() - pv.shrinkB[i]) + (hY = cutBox.getMaxY() + pv.shrinkT[i])) / 2.0, hX - lX, hY - lY))) continue;
            return l;
        }
        PolyBase testPoly = new PolyBase(new Point2D[]{new Point2D.Double(cutBox.getCenterX() - 1.0, cutBox.getCenterY() - 1.0), new Point2D.Double(cutBox.getCenterX() - 1.0, cutBox.getCenterY() + 1.0), new Point2D.Double(cutBox.getCenterX() + 1.0, cutBox.getCenterY() + 1.0), new Point2D.Double(cutBox.getCenterX() + 1.0, cutBox.getCenterY() - 1.0)});
        testPoly.setLayer(this.wellLayer);
        if (pv.pNp.getFunction() == PrimitiveNode.Function.SUBSTRATE && this.wellLayer != null && originalMerge.contains(this.wellLayer, testPoly)) {
            return this.wellLayer;
        }
        if (pv.pNp.getFunction() == PrimitiveNode.Function.CONTACT && hasActive && (this.pSubstrateProcess && hasNplus || this.nSubstrateProcess && hasPplus) && originalMerge.contains(this.wellLayer, testPoly)) {
            return this.wellLayer;
        }
        return null;
    }

    private void extractTransistors(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        if (this.polyLayer == null || this.tempLayer1 == null) {
            return;
        }
        ArrayList<PrimitiveNode> pTransistors = new ArrayList<PrimitiveNode>();
        ArrayList<PrimitiveNode> nTransistors = new ArrayList<PrimitiveNode>();
        Iterator<PrimitiveNode> it = this.tech.getNodes();
        while (it.hasNext()) {
            boolean same;
            PrimitiveNode pNp = it.next();
            if (!pNp.getFunction().isPTypeTransistor() && !pNp.getFunction().isNTypeTransistor()) continue;
            ArrayList<PrimitiveNode> listToUse = pTransistors;
            if (pNp.getFunction().isNTypeTransistor()) {
                listToUse = nTransistors;
            }
            if (!(same = true)) continue;
            listToUse.add(pNp);
        }
        if (this.nActiveLayer == this.pActiveLayer) {
            for (PrimitiveNode pNp : nTransistors) {
                pTransistors.add(pNp);
            }
            if (pTransistors.size() > 0) {
                this.findTransistors(pTransistors, this.pActiveLayer, merge, originalMerge, newCell);
            }
        } else {
            if (nTransistors.size() > 0) {
                this.findTransistors(nTransistors, this.nActiveLayer, merge, originalMerge, newCell);
            }
            if (pTransistors.size() > 0) {
                this.findTransistors(pTransistors, this.pActiveLayer, merge, originalMerge, newCell);
            }
        }
    }

    private void findTransistors(List<PrimitiveNode> transistors, Layer activeLayer, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        originalMerge.intersectLayers(this.polyLayer, activeLayer, this.tempLayer1);
        List<PolyBase> polyList = this.getMergePolys(originalMerge, this.tempLayer1, null);
        if (polyList != null) {
            for (PolyBase poly : polyList) {
                Rectangle2D transBox = poly.getBox();
                double cX = poly.getCenterX();
                double cY = poly.getCenterY();
                if (this.alignment != null) {
                    if (this.alignment.getWidth() > 0.0) {
                        cX = (double)Math.round(cX / this.scaleUp(this.alignment.getWidth() / 2.0)) * this.scaleUp(this.alignment.getWidth() / 2.0);
                    }
                    if (this.alignment.getHeight() > 0.0) {
                        cY = (double)Math.round(cY / this.scaleUp(this.alignment.getHeight() / 2.0)) * this.scaleUp(this.alignment.getHeight() / 2.0);
                    }
                }
                if (transBox == null) {
                    this.extractNonManhattanTransistor(poly, transistors.get(0), merge, originalMerge, newCell);
                    continue;
                }
                ArrayList<String> errors = new ArrayList<String>();
                for (PrimitiveNode transistor : transistors) {
                    double height;
                    SizeOffset so;
                    double width;
                    EPoint ctr;
                    NodeInst ni;
                    String msg;
                    NodeInst dni = NodeInst.makeDummyInstance(transistor);
                    Poly[] polys = transistor.getTechnology().getShapeOfNode(dni);
                    double widestPoly = 0.0;
                    double widestActive = 0.0;
                    for (int i = 0; i < polys.length; ++i) {
                        Poly p = polys[i];
                        Rectangle2D bounds = p.getBounds2D();
                        if (p.getLayer().getFunction().isPoly()) {
                            widestPoly = Math.max(widestPoly, bounds.getWidth());
                        }
                        if (!p.getLayer().getFunction().isDiff()) continue;
                        widestActive = Math.max(widestActive, bounds.getWidth());
                    }
                    boolean polyVertical = widestPoly < widestActive;
                    Point2D.Double left = new Point2D.Double(transBox.getMinX() - 1.0, transBox.getCenterY());
                    Point2D.Double right = new Point2D.Double(transBox.getMaxX() + 1.0, transBox.getCenterY());
                    Point2D.Double bottom = new Point2D.Double(transBox.getCenterX(), transBox.getMinY() - 1.0);
                    Point2D.Double top = new Point2D.Double(transBox.getCenterX(), transBox.getMaxY() + 1.0);
                    if (polyVertical) {
                        Point2D.Double swap = left;
                        left = top;
                        top = right;
                        right = bottom;
                        bottom = swap;
                    }
                    int angle = 0;
                    double wid = transBox.getWidth();
                    double hei = transBox.getHeight();
                    if (!(originalMerge.contains(this.polyLayer, left) && originalMerge.contains(this.polyLayer, right) && originalMerge.contains(activeLayer, top) && originalMerge.contains(activeLayer, bottom))) {
                        if (originalMerge.contains(activeLayer, left) && originalMerge.contains(activeLayer, right) && originalMerge.contains(this.polyLayer, top) && originalMerge.contains(this.polyLayer, bottom)) {
                            angle = 900;
                            wid = transBox.getHeight();
                            hei = transBox.getWidth();
                        } else {
                            this.addErrorLog(newCell, "Transistor at (" + TextUtils.formatDistance(transBox.getCenterX() / 400.0) + "," + TextUtils.formatDistance(transBox.getCenterY() / 400.0) + ") doesn't have proper tabs...not extracted at (" + cX + "," + cY + ")", new EPoint[0]);
                            continue;
                        }
                    }
                    if ((msg = this.dummyTransistorFits(ni = this.makeDummyNodeInst(transistor, ctr = new EPoint(cX / 400.0, cY / 400.0), width = wid + this.scaleUp((so = transistor.getProtoSizeOffset()).getLowXOffset() + so.getHighXOffset()), height = hei + this.scaleUp(so.getLowYOffset() + so.getHighYOffset()), Orientation.fromAngle(angle), 0), originalMerge, newCell)) != null) {
                        errors.add(msg);
                        continue;
                    }
                    this.realizeNode(transistor, 0, cX, cY, width, height, angle, null, merge, newCell, null);
                    errors.clear();
                    break;
                }
                if (errors.size() <= 0) continue;
                for (String msg : errors) {
                    this.addErrorLog(newCell, msg, new EPoint(cX / 400.0, cY / 400.0));
                }
            }
        }
        originalMerge.deleteLayer(this.tempLayer1);
    }

    private String dummyTransistorFits(NodeInst ni, PolyMerge merge, Cell cell) {
        Poly[] polys;
        AffineTransform trans = ni.rotateOut();
        Technology tech = ni.getProto().getTechnology();
        for (Poly poly : polys = tech.getShapeOfNode(ni)) {
            Layer.Function fun;
            Layer l = poly.getLayer();
            if (l == null || (fun = (l = this.geometricLayer(l)).getFunction()) == Layer.Function.WELLP && this.pSubstrateProcess || fun == Layer.Function.WELLN && this.nSubstrateProcess) continue;
            poly.setLayer(l);
            poly.transform(trans);
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                poly.setPoint(i, this.scaleUp(points[i].getX()), this.scaleUp(points[i].getY()));
            }
            if (merge.contains(l, poly) || poly == null) continue;
            Rectangle2D bounds = poly.getBounds2D();
            return "Cell " + cell.describe(false) + ": " + ni.getProto().describe(false) + " at (" + TextUtils.formatDistance(ni.getAnchorCenterX()) + "," + TextUtils.formatDistance(ni.getAnchorCenterY()) + "), size " + TextUtils.formatDistance(ni.getLambdaBaseXSize()) + "x" + TextUtils.formatDistance(ni.getLambdaBaseYSize()) + ", is too large on layer " + l.getName() + " (it runs from " + TextUtils.formatDistance(bounds.getMinX() / 400.0) + "<=X<=" + TextUtils.formatDistance(bounds.getMaxX() / 400.0) + " and " + TextUtils.formatDistance(bounds.getMinY() / 400.0) + "<=Y<=" + TextUtils.formatDistance(bounds.getMaxY() / 400.0) + ")";
        }
        return null;
    }

    private void extractNonManhattanTransistor(PolyBase poly, PrimitiveNode transistor, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        SizeOffset so = transistor.getProtoSizeOffset();
        double minWidth = transistor.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
        List<Centerline> lines = this.findCenterlines(poly, this.tempLayer1, minWidth, merge, originalMerge);
        if (lines.size() == 0) {
            return;
        }
        if (lines.size() == 1) {
            Centerline cl = lines.get(0);
            double polySize = cl.start.distance(cl.end);
            double activeSize = cl.width;
            double cX = (cl.start.getX() + cl.end.getX()) / 2.0;
            double cY = (cl.start.getY() + cl.end.getY()) / 2.0;
            double sX = polySize + this.scaleUp(so.getLowXOffset() + so.getHighXOffset());
            double sY = activeSize + this.scaleUp(so.getLowYOffset() + so.getHighYOffset());
            this.realizeNode(transistor, 0, cX, cY, sX, sY, cl.angle, null, merge, newCell, null);
            return;
        }
        Point2D[] points = new EPoint[lines.size() + 1];
        for (Centerline cl : lines) {
            cl.handled = false;
        }
        Centerline firstCL = lines.get(0);
        firstCL.handled = true;
        points[0] = new EPoint(firstCL.start.getX(), firstCL.start.getY());
        points[1] = new EPoint(firstCL.end.getX(), firstCL.end.getY());
        int pointsSeen = 2;
        while (pointsSeen < points.length) {
            boolean added = false;
            for (Centerline cl : lines) {
                int i;
                if (cl.handled) continue;
                EPoint start = new EPoint(cl.start.getX(), cl.start.getY());
                EPoint end = new EPoint(cl.end.getX(), cl.end.getY());
                if (start.equals(points[0])) {
                    for (i = pointsSeen; i > 0; --i) {
                        points[i] = points[i - 1];
                    }
                    points[0] = end;
                    ++pointsSeen;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (end.equals(points[0])) {
                    for (i = pointsSeen; i > 0; --i) {
                        points[i] = points[i - 1];
                    }
                    points[0] = start;
                    ++pointsSeen;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (start.equals(points[pointsSeen - 1])) {
                    points[pointsSeen++] = end;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (!end.equals(points[pointsSeen - 1])) continue;
                points[pointsSeen++] = start;
                cl.handled = true;
                added = true;
                break;
            }
            if (added) continue;
            break;
        }
        if (pointsSeen != points.length) {
            return;
        }
        double lX = points[0].getX();
        double hX = points[0].getX();
        double lY = points[0].getY();
        double hY = points[0].getY();
        for (int i = 1; i < points.length; ++i) {
            if (points[i].getX() < lX) {
                lX = points[i].getX();
            }
            if (points[i].getX() > hX) {
                hX = points[i].getX();
            }
            if (points[i].getY() < lY) {
                lY = points[i].getY();
            }
            if (!(points[i].getY() > hY)) continue;
            hY = points[i].getY();
        }
        double cX = (lX + hX) / 2.0;
        double cY = (lY + hY) / 2.0;
        for (int i = 0; i < points.length; ++i) {
            points[i] = new EPoint(points[i].getX() / 400.0, points[i].getY() / 400.0);
        }
        this.realizeNode(transistor, 0, cX, cY, hX - lX, hY - lY, 0, points, merge, newCell, null);
    }

    private void extendGeometry(PolyMerge merge, PolyMerge originalMerge, Cell newCell, boolean justExtend) {
        ArrayList<Layer> extendableLayers = new ArrayList<Layer>();
        for (Layer layer : merge.getKeySet()) {
            ArcProto ap = this.arcsForLayer.get(layer);
            if (ap == null) continue;
            extendableLayers.add(layer);
        }
        int totExtensions = 0;
        HashMap<Layer, List<PolyBase>> geomToExtend = new HashMap<Layer, List<PolyBase>>();
        int soFar = 0;
        for (Layer layer : extendableLayers) {
            List<PolyBase> polyList = this.getMergePolys(merge, layer, null);
            geomToExtend.put(layer, polyList);
            totExtensions += polyList.size();
            ++soFar;
            if (this.recursive) continue;
            Job.getUserInterface().setProgressValue(soFar * 100 / extendableLayers.size());
        }
        if (!this.recursive) {
            Job.getUserInterface().setProgressValue(0);
        }
        EditingPreferences ep = newCell.getEditingPreferences();
        soFar = 0;
        for (Layer layer : extendableLayers) {
            ArcProto ap = this.arcsForLayer.get(layer);
            if (ap == null) continue;
            double wid = ap.getDefaultLambdaBaseWidth(ep);
            double arcLayerWidth = 2.0 * (ap.getDefaultInst(ep).getLambdaExtendOverMin() + ap.getLayerLambdaExtend(layer));
            List polyList = (List)geomToExtend.get(layer);
            for (PolyBase poly : polyList) {
                GenMath.MutableBoolean tailExtend;
                GenMath.MutableBoolean headExtend;
                Point2D.Double pt2;
                Point2D.Double pt1;
                PortInst pi;
                Map<Network, Object> netsThatTouch;
                ++soFar;
                if (!this.recursive) {
                    Job.getUserInterface().setProgressValue(soFar * 100 / totExtensions);
                }
                if ((netsThatTouch = this.getNetsThatTouch(poly, newCell, justExtend)) == null) continue;
                ArrayList<Object> objectsToConnect = new ArrayList<Object>();
                for (Network net : netsThatTouch.keySet()) {
                    Object entry = netsThatTouch.get(net);
                    if (entry == null) continue;
                    objectsToConnect.add(entry);
                }
                if (objectsToConnect.size() == 1) {
                    this.extendObject((ElectricObject)objectsToConnect.get(0), poly, layer, ap, merge, originalMerge, newCell);
                    continue;
                }
                if (justExtend || objectsToConnect.size() != 2) continue;
                ElectricObject obj1 = (ElectricObject)objectsToConnect.get(0);
                ElectricObject obj2 = (ElectricObject)objectsToConnect.get(1);
                if (obj1 instanceof ArcInst) {
                    pi = this.findArcEnd((ArcInst)obj1, poly);
                    if (pi == null) {
                        this.findArcEnd((ArcInst)obj1, poly);
                        continue;
                    }
                    obj1 = pi;
                }
                if (obj2 instanceof ArcInst) {
                    pi = this.findArcEnd((ArcInst)obj2, poly);
                    if (pi == null) {
                        this.findArcEnd((ArcInst)obj2, poly);
                        continue;
                    }
                    obj2 = pi;
                }
                PortInst pi1 = (PortInst)obj1;
                PortInst pi2 = (PortInst)obj2;
                Poly poly1 = pi1.getPoly();
                Poly poly2 = pi2.getPoly();
                Rectangle2D polyBounds1 = poly1.getBounds2D();
                Rectangle2D polyBounds2 = poly2.getBounds2D();
                if (polyBounds1.getMinX() <= polyBounds2.getMaxX() && polyBounds1.getMaxX() >= polyBounds2.getMinX()) {
                    double xpos = polyBounds1.getCenterX();
                    if (xpos < polyBounds2.getMinX()) {
                        xpos = polyBounds2.getMinX();
                    }
                    if (xpos > polyBounds2.getMaxX()) {
                        xpos = polyBounds2.getMaxX();
                    }
                    if (this.alignment != null && this.alignment.getWidth() > 0.0 && ((xpos = (double)Math.round(xpos / this.scaleUp(this.alignment.getWidth())) * this.scaleUp(this.alignment.getWidth())) < polyBounds2.getMinX() || xpos > polyBounds2.getMaxX())) continue;
                    pt1 = new Point2D.Double(xpos, polyBounds1.getCenterY());
                    pt2 = new Point2D.Double(xpos, polyBounds2.getCenterY());
                    headExtend = new GenMath.MutableBoolean(true);
                    tailExtend = new GenMath.MutableBoolean(true);
                    originalMerge.arcPolyFits(layer, pt1, pt2, arcLayerWidth, headExtend, tailExtend);
                    this.realizeArc(ap, pi1, pi2, pt1, pt2, wid, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
                    continue;
                }
                if (polyBounds1.getMinY() <= polyBounds2.getMaxY() && polyBounds1.getMaxY() >= polyBounds2.getMinY()) {
                    double ypos = polyBounds1.getCenterY();
                    if (ypos < polyBounds2.getMinY()) {
                        ypos = polyBounds2.getMinY();
                    }
                    if (ypos > polyBounds2.getMaxY()) {
                        ypos = polyBounds2.getMaxY();
                    }
                    if (this.alignment != null && this.alignment.getHeight() > 0.0 && ((ypos = (double)Math.round(ypos / this.scaleUp(this.alignment.getHeight())) * this.scaleUp(this.alignment.getHeight())) < polyBounds2.getMinY() || ypos > polyBounds2.getMaxY())) continue;
                    pt1 = new Point2D.Double(polyBounds1.getCenterX(), ypos);
                    pt2 = new Point2D.Double(polyBounds2.getCenterX(), ypos);
                    headExtend = new GenMath.MutableBoolean(true);
                    tailExtend = new GenMath.MutableBoolean(true);
                    originalMerge.arcPolyFits(layer, pt1, pt2, arcLayerWidth, headExtend, tailExtend);
                    this.realizeArc(ap, pi1, pi2, pt1, pt2, wid, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
                    continue;
                }
                Point2D.Double pt12 = new Point2D.Double(polyBounds1.getCenterX(), polyBounds1.getCenterY());
                Point2D.Double pt22 = new Point2D.Double(polyBounds2.getCenterX(), polyBounds2.getCenterY());
                Point2D.Double corner1 = new Point2D.Double(polyBounds1.getCenterX(), polyBounds2.getCenterY());
                Point2D.Double corner2 = new Point2D.Double(polyBounds2.getCenterX(), polyBounds1.getCenterY());
                Point2D.Double containsIt = null;
                if (poly.contains(corner1)) {
                    containsIt = corner1;
                } else if (poly.contains(corner2)) {
                    containsIt = corner2;
                }
                if (containsIt == null) continue;
                PrimitiveNode np = ap.findPinProto();
                NodeInst ni = this.createNode(np, containsIt, np.getDefWidth(), np.getDefHeight(), null, newCell);
                PortInst pi3 = ni.getOnlyPortInst();
                GenMath.MutableBoolean headExtend2 = new GenMath.MutableBoolean(true);
                GenMath.MutableBoolean tailExtend2 = new GenMath.MutableBoolean(true);
                originalMerge.arcPolyFits(layer, pt12, containsIt, arcLayerWidth, headExtend2, tailExtend2);
                this.realizeArc(ap, pi1, pi3, pt12, containsIt, wid, !headExtend2.booleanValue(), !tailExtend2.booleanValue(), merge);
                headExtend2.setValue(true);
                tailExtend2.setValue(true);
                originalMerge.arcPolyFits(layer, pt22, containsIt, arcLayerWidth, headExtend2, tailExtend2);
                this.realizeArc(ap, pi2, pi3, pt22, containsIt, wid, !headExtend2.booleanValue(), !tailExtend2.booleanValue(), merge);
            }
        }
    }

    private void extendObject(ElectricObject obj, PolyBase poly, Layer layer, ArcProto ap, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        Rectangle2D totalBounds;
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null && originalMerge.contains(layer, totalBounds = poly.getBounds2D())) {
            polyBounds = totalBounds;
        }
        if (polyBounds == null) {
            return;
        }
        Point2D.Double polyCtr = new Point2D.Double(polyBounds.getCenterX(), polyBounds.getCenterY());
        if (this.alignment != null) {
            double x = ((Point2D)polyCtr).getX();
            double y = ((Point2D)polyCtr).getY();
            if (this.alignment.getWidth() > 0.0) {
                x = (double)Math.round(x / this.scaleUp(this.alignment.getWidth())) * this.scaleUp(this.alignment.getWidth());
            }
            if (this.alignment.getHeight() > 0.0) {
                y = (double)Math.round(y / this.scaleUp(this.alignment.getHeight())) * this.scaleUp(this.alignment.getHeight());
            }
            ((Point2D)polyCtr).setLocation(x, y);
        }
        if (obj instanceof ArcInst) {
            double tailDist;
            ArcInst ai = (ArcInst)obj;
            double headDist = polyCtr.distance(ai.getHeadLocation());
            obj = headDist < (tailDist = polyCtr.distance(ai.getTailLocation())) ? ai.getHeadPortInst() : ai.getTailPortInst();
        }
        PortInst pi = (PortInst)obj;
        Poly portPoly = pi.getPoly();
        Rectangle2D portRect = portPoly.getBounds2D();
        portRect.setRect(this.scaleUp(portRect.getMinX()), this.scaleUp(portRect.getMinY()), this.scaleUp(portRect.getWidth()), this.scaleUp(portRect.getHeight()));
        PrimitiveNode np = ap.findPinProto();
        if (((Point2D)polyCtr).getY() >= portRect.getMinY() && ((Point2D)polyCtr).getY() <= portRect.getMaxY() && ((Point2D)polyCtr).getX() >= portRect.getMinX() && ((Point2D)polyCtr).getX() <= portRect.getMaxX()) {
            if (polyBounds.getWidth() > polyBounds.getHeight()) {
                double endExtension = polyBounds.getHeight() / 2.0;
                Point2D.Double pinPt1 = new Point2D.Double((polyBounds.getMaxX() - endExtension) / 400.0, ((Point2D)polyCtr).getY() / 400.0);
                Point2D.Double pinPt2 = new Point2D.Double((polyBounds.getMinX() + endExtension) / 400.0, ((Point2D)polyCtr).getY() / 400.0);
                Point2D.Double objPt = new Point2D.Double(portRect.getCenterX() / 400.0, ((Point2D)polyCtr).getY() / 400.0);
                double size = Math.min(polyBounds.getWidth(), polyBounds.getHeight()) / 400.0;
                NodeInst ni1 = this.createNode(np, pinPt1, size, size, null, newCell);
                NodeInst ni2 = this.createNode(np, pinPt2, size, size, null, newCell);
                this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPt1, objPt, polyBounds.getHeight() / 400.0, false, false, merge);
                this.realizeArc(ap, ni2.getOnlyPortInst(), pi, pinPt2, objPt, polyBounds.getHeight() / 400.0, false, false, merge);
            } else {
                double endExtension = polyBounds.getWidth() / 2.0;
                Point2D.Double pinPt1 = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, (polyBounds.getMaxY() - endExtension) / 400.0);
                Point2D.Double pinPt2 = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, (polyBounds.getMinY() + endExtension) / 400.0);
                Point2D.Double objPt = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, portRect.getCenterY() / 400.0);
                double size = Math.min(polyBounds.getWidth(), polyBounds.getHeight()) / 400.0;
                NodeInst ni1 = this.createNode(np, pinPt1, size, size, null, newCell);
                NodeInst ni2 = this.createNode(np, pinPt2, size, size, null, newCell);
                this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPt1, objPt, polyBounds.getWidth() / 400.0, false, false, merge);
                this.realizeArc(ap, ni2.getOnlyPortInst(), pi, pinPt2, objPt, polyBounds.getWidth() / 400.0, false, false, merge);
            }
            return;
        }
        if (((Point2D)polyCtr).getX() >= portRect.getMinX() && ((Point2D)polyCtr).getX() <= portRect.getMaxX()) {
            Point2D.Double objPt = new Point2D.Double(((Point2D)polyCtr).getX(), portRect.getCenterY());
            Point2D.Double objPtNormal = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, portRect.getCenterY() / 400.0);
            Point2D.Double pinPt = null;
            Point2D.Double pinPtNormal = null;
            boolean endExtend = true;
            double endExtension = polyBounds.getWidth() / 2.0;
            if (polyBounds.getHeight() < polyBounds.getWidth()) {
                endExtend = false;
                endExtension = 0.0;
            }
            if (((Point2D)polyCtr).getY() > portRect.getCenterY()) {
                pinPt = new Point2D.Double(((Point2D)polyCtr).getX(), polyBounds.getMaxY() - endExtension);
                pinPtNormal = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, (polyBounds.getMaxY() - endExtension) / 400.0);
            } else {
                pinPt = new Point2D.Double(((Point2D)polyCtr).getX(), polyBounds.getMinY() + endExtension);
                pinPtNormal = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, (polyBounds.getMinY() + endExtension) / 400.0);
            }
            GenMath.MutableBoolean headExtend = new GenMath.MutableBoolean(endExtend);
            GenMath.MutableBoolean tailExtend = new GenMath.MutableBoolean(endExtend);
            double wid = polyBounds.getWidth();
            if (originalMerge.arcPolyFits(layer, pinPt, objPt, wid, headExtend, tailExtend)) {
                double size = Math.min(polyBounds.getWidth(), polyBounds.getHeight()) / 400.0;
                NodeInst ni1 = this.createNode(np, pinPtNormal, size, size, null, newCell);
                this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPtNormal, objPtNormal, wid / 400.0, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
            }
            return;
        }
        if (((Point2D)polyCtr).getY() >= portRect.getMinY() && ((Point2D)polyCtr).getY() <= portRect.getMaxY()) {
            Point2D.Double objPt = new Point2D.Double(portRect.getCenterX(), ((Point2D)polyCtr).getY());
            Point2D.Double objPtNormal = new Point2D.Double(portRect.getCenterX() / 400.0, ((Point2D)polyCtr).getY() / 400.0);
            Point2D.Double pinPt = null;
            Point2D.Double pinPtNormal = null;
            boolean endExtend = true;
            double endExtension = polyBounds.getHeight() / 2.0;
            if (polyBounds.getWidth() < polyBounds.getHeight()) {
                endExtend = false;
                endExtension = 0.0;
            }
            if (((Point2D)polyCtr).getX() > portRect.getCenterX()) {
                pinPt = new Point2D.Double(polyBounds.getMaxX() - endExtension, ((Point2D)polyCtr).getY());
                pinPtNormal = new Point2D.Double((polyBounds.getMaxX() - endExtension) / 400.0, ((Point2D)polyCtr).getY() / 400.0);
            } else {
                pinPt = new Point2D.Double(polyBounds.getMinX() + endExtension, ((Point2D)polyCtr).getY());
                pinPtNormal = new Point2D.Double((polyBounds.getMinX() + endExtension) / 400.0, ((Point2D)polyCtr).getY() / 400.0);
            }
            GenMath.MutableBoolean headExtend = new GenMath.MutableBoolean(endExtend);
            GenMath.MutableBoolean tailExtend = new GenMath.MutableBoolean(endExtend);
            double wid = polyBounds.getHeight();
            if (originalMerge.arcPolyFits(layer, pinPt, objPt, wid, headExtend, tailExtend)) {
                double size = Math.min(polyBounds.getWidth(), polyBounds.getHeight()) / 400.0;
                NodeInst ni1 = this.createNode(np, pinPtNormal, size, size, null, newCell);
                this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPtNormal, objPtNormal, wid / 400.0, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
            }
        }
    }

    private PortInst findArcEnd(ArcInst ai, PolyBase poly) {
        EPoint head = ai.getHeadLocation();
        EPoint tail = ai.getTailLocation();
        int ang = GenMath.figureAngle(tail, head);
        int angPlus = (ang + 900) % 3600;
        double width = ai.getLambdaBaseWidth() / 2.0;
        Point2D.Double headButFarther = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(ang), ((Point2D)head).getY() + width * GenMath.sin(ang));
        if (poly.contains(headButFarther)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double headOneSide = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(angPlus), ((Point2D)head).getY() + width * GenMath.sin(angPlus));
        if (poly.contains(headOneSide)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double headOtherSide = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(angPlus), ((Point2D)head).getY() + width * GenMath.sin(angPlus));
        if (poly.contains(headOtherSide)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double tailButFarther = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(ang), ((Point2D)tail).getY() - width * GenMath.sin(ang));
        if (poly.contains(tailButFarther)) {
            return ai.getTailPortInst();
        }
        Point2D.Double tailOneSide = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(angPlus), ((Point2D)tail).getY() - width * GenMath.sin(angPlus));
        if (poly.contains(tailOneSide)) {
            return ai.getTailPortInst();
        }
        Point2D.Double tailOtherSide = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(angPlus), ((Point2D)tail).getY() - width * GenMath.sin(angPlus));
        if (poly.contains(tailOtherSide)) {
            return ai.getTailPortInst();
        }
        return null;
    }

    private boolean polysTouch(PolyBase poly1, PolyBase poly2) {
        int i;
        Point2D[] points2;
        Point2D[] points1 = poly1.getPoints();
        if (points1.length > (points2 = poly2.getPoints()).length) {
            Point2D[] swapPts = points1;
            points1 = points2;
            points2 = swapPts;
            PolyBase swapPoly = poly1;
            poly1 = poly2;
            poly2 = swapPoly;
        }
        for (i = 0; i < points1.length; ++i) {
            if (!poly2.contains(points1[i])) continue;
            return true;
        }
        for (i = 0; i < points1.length; ++i) {
            Point2D.Double midPoint;
            int last = i - 1;
            if (last < 0) {
                last = points1.length - 1;
            }
            if (!poly2.contains(midPoint = new Point2D.Double((points1[last].getX() + points1[i].getX()) / 2.0, (points1[last].getY() + points1[i].getY()) / 2.0))) continue;
            return true;
        }
        return false;
    }

    private Map<Network, Object> getNetsThatTouch(PolyBase poly, Cell newCell, boolean justExtend) {
        RTBounds geom;
        Point2D[] points = poly.getPoints();
        Point2D[] newPoints = new Point2D[points.length];
        for (int i = 0; i < points.length; ++i) {
            newPoints[i] = new Point2D.Double(points[i].getX() / 400.0, points[i].getY() / 400.0);
        }
        PolyBase newPoly = new PolyBase(newPoints);
        Layer layer = poly.getLayer();
        TreeMap<Network, Object> netsThatTouch = new TreeMap<Network, Object>();
        Rectangle2D bounds = newPoly.getBounds2D();
        Point2D.Double centerPoint = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Netlist nl = newCell.acquireUserNetlist();
        Iterator<RTBounds> it = newCell.searchIterator(bounds);
        block1: while (it.hasNext()) {
            NodeInst ni;
            geom = it.next();
            if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).isCellInstance()) continue;
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] nodePolys = tech.getShapeOfNode(ni, true, true, null);
            for (int i = 0; i < nodePolys.length; ++i) {
                PortInst pi;
                Network net;
                PrimitivePort pp;
                Poly nodePoly = nodePolys[i];
                if (this.geometricLayer(nodePoly.getLayer()) != layer) continue;
                nodePoly.transform(trans);
                if (!this.polysTouch(nodePoly, newPoly) || (pp = (PrimitivePort)nodePoly.getPort()) == null || (net = nl.getNetwork(pi = this.findPortInstClosestToPoly(ni, pp, centerPoint))) == null) continue;
                netsThatTouch.put(net, pi);
                int numNets = netsThatTouch.size();
                if (numNets <= 2 && (numNets <= 1 || !justExtend)) continue block1;
                return null;
            }
        }
        it = newCell.searchIterator(bounds);
        block3: while (it.hasNext()) {
            geom = it.next();
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                int numNets;
                Network net;
                Poly arcPoly = polys[i];
                if (this.geometricLayer(arcPoly.getLayer()) != layer || !this.polysTouch(arcPoly, newPoly) || (net = nl.getNetwork(ai, 0)) == null) continue;
                if (netsThatTouch.get(net) == null) {
                    netsThatTouch.put(net, ai);
                }
                if ((numNets = netsThatTouch.size()) <= 2 && (numNets <= 1 || !justExtend)) continue block3;
                return null;
            }
        }
        return netsThatTouch;
    }

    private List<Centerline> findCenterlines(PolyBase poly, Layer layer, double minWidth, PolyMerge merge, PolyMerge originalMerge) {
        ArrayList<Centerline> validCenterlines = new ArrayList<Centerline>();
        merge.deleteLayer(this.tempLayer1);
        merge.addPolygon(this.tempLayer1, poly);
        List<PolyBase> polysToAnalyze = new ArrayList<PolyBase>();
        polysToAnalyze.add(poly);
        int loop = 1;
        while (true) {
            boolean foundNew = false;
            block1: for (PolyBase aPoly : polysToAnalyze) {
                aPoly.setLayer(layer);
                List<Centerline> centerlines = this.gatherCenterlines(aPoly, merge, originalMerge);
                if (centerlines == null) {
                    merge.subtract(this.tempLayer1, aPoly);
                    continue;
                }
                double lastWidth = -1.0;
                boolean lastWidthNonManhattan = false;
                for (Centerline cl : centerlines) {
                    double smallest;
                    Poly clPoly;
                    double length;
                    if (cl.width < minWidth) continue;
                    if (this.alignment != null) {
                        // empty if block
                    }
                    if ((length = cl.start.distance(cl.end)) < DBMath.getEpsilon() || !merge.intersects(this.tempLayer1, clPoly = Poly.makeEndPointPoly(length, cl.width, cl.angle, cl.start, 0.0, cl.end, 0.0, Poly.Type.FILLED))) continue;
                    if (validCenterlines.size() == 0) {
                        // empty if block
                    }
                    boolean isNonManhattan = false;
                    if (cl.startUnscaled.getX() != cl.endUnscaled.getX() && cl.startUnscaled.getY() != cl.endUnscaled.getY()) {
                        boolean duplicate = false;
                        for (Centerline oCl : validCenterlines) {
                            if (cl.startUnscaled.equals(oCl.startUnscaled) && cl.endUnscaled.equals(oCl.endUnscaled)) {
                                duplicate = true;
                                break;
                            }
                            if (!cl.startUnscaled.equals(oCl.endUnscaled) || !cl.endUnscaled.equals(oCl.startUnscaled)) continue;
                            duplicate = true;
                            break;
                        }
                        if (duplicate) continue;
                        isNonManhattan = true;
                    }
                    if (lastWidth < 0.0) {
                        lastWidth = cl.width;
                        lastWidthNonManhattan = isNonManhattan;
                    }
                    if (Math.abs(cl.width - lastWidth) > 1.0 && (lastWidthNonManhattan != isNonManhattan || (smallest = Math.min(cl.width, lastWidth)) != 0.0 && Math.max(cl.width, lastWidth) / smallest > 1.2)) continue block1;
                    validCenterlines.add(cl);
                    merge.subtract(this.tempLayer1, clPoly);
                    foundNew = true;
                }
            }
            if (!foundNew || (polysToAnalyze = this.getMergePolys(merge, this.tempLayer1, null)) == null) break;
            ++loop;
        }
        merge.deleteLayer(this.tempLayer1);
        ArrayList<Centerline> extraCenterlines = new ArrayList<Centerline>();
        Centerline[] both = new Centerline[2];
        for (int i = 0; i < validCenterlines.size(); ++i) {
            Centerline cl = (Centerline)validCenterlines.get(i);
            double minCLX = Math.min(cl.start.getX(), cl.end.getX()) - cl.width;
            double maxCLX = Math.max(cl.start.getX(), cl.end.getX()) + cl.width;
            double minCLY = Math.min(cl.start.getY(), cl.end.getY()) - cl.width;
            double maxCLY = Math.max(cl.start.getY(), cl.end.getY()) + cl.width;
            for (int j = i + 1; j < validCenterlines.size(); ++j) {
                Point2D intersect;
                Centerline oCl = (Centerline)validCenterlines.get(j);
                double minOCLX = Math.min(oCl.start.getX(), oCl.end.getX()) - oCl.width;
                double maxOCLX = Math.max(oCl.start.getX(), oCl.end.getX()) + oCl.width;
                double minOCLY = Math.min(oCl.start.getY(), oCl.end.getY()) - oCl.width;
                double maxOCLY = Math.max(oCl.start.getY(), oCl.end.getY()) + oCl.width;
                if (minOCLX > maxCLX || maxOCLX < minCLX || minOCLY > maxCLY || maxOCLY < minCLY || (intersect = GenMath.intersect(cl.start, cl.angle, oCl.start, oCl.angle)) == null) continue;
                both[0] = cl;
                both[1] = oCl;
                for (int b = 0; b < 2; ++b) {
                    Centerline newCl;
                    double diffY;
                    int minDistToEnd;
                    Point2D newStart = both[b].start;
                    Point2D newEnd = both[b].end;
                    double distToStart = newStart.distance(intersect);
                    double distToEnd = newEnd.distance(intersect);
                    boolean makeT = this.insideSegment(newStart, newEnd, intersect);
                    if (makeT && (double)(minDistToEnd = (int)Math.min(distToStart, distToEnd)) <= both[b].width / 2.0) {
                        makeT = false;
                    }
                    boolean internalIntersect = false;
                    Line2D.Double lineSeg = new Line2D.Double(newStart, newEnd);
                    if (lineSeg.ptSegDist(intersect) == 0.0) {
                        internalIntersect = true;
                    }
                    boolean offgrid = false;
                    if (this.alignment != null && this.alignment.getWidth() > 0.0 && intersect.getX() % this.scaleUp(this.alignment.getWidth()) != 0.0) {
                        offgrid = true;
                    }
                    if (this.alignment != null && this.alignment.getHeight() > 0.0 && intersect.getY() % this.scaleUp(this.alignment.getHeight()) != 0.0) {
                        offgrid = true;
                    }
                    double extendStart = 0.0;
                    double extendEnd = 0.0;
                    double extendAltStart = 0.0;
                    double extendAltEnd = 0.0;
                    double betterExtension = 0.0;
                    Point2D.Double altNewStart = new Point2D.Double(0.0, 0.0);
                    Point2D.Double altNewEnd = new Point2D.Double(0.0, 0.0);
                    if (distToStart < distToEnd) {
                        betterExtension = newStart.distance(intersect);
                        altNewStart.setLocation(newStart);
                        altNewEnd.setLocation(intersect);
                        newStart = intersect;
                        extendAltEnd = extendStart = both[b].width / 2.0;
                        if (offgrid && !makeT) {
                            if (internalIntersect) {
                                double diffX = ((Point2D)altNewStart).getX() - intersect.getX();
                                diffY = ((Point2D)altNewStart).getY() - intersect.getY();
                                newStart = new Point2D.Double(intersect.getX() - diffX, intersect.getY() - diffY);
                                ((Point2D)altNewEnd).setLocation(intersect.getX() + diffX, intersect.getY() + diffY);
                            } else {
                                newStart.setLocation(altNewStart);
                            }
                            extendAltEnd = extendStart = Math.abs(betterExtension);
                        } else if (!makeT && betterExtension < extendStart) {
                            newCl = new Centerline(both[b].width, altNewStart, intersect);
                            newCl.startHub = false;
                            newCl.endHub = true;
                            if (newCl.start.distance(newCl.end) > 0.0) {
                                extraCenterlines.add(newCl);
                            }
                        }
                    } else {
                        betterExtension = newEnd.distance(intersect);
                        altNewStart.setLocation(intersect);
                        altNewEnd.setLocation(newEnd);
                        newEnd = intersect;
                        extendAltStart = extendEnd = both[b].width / 2.0;
                        if (offgrid && !makeT) {
                            if (internalIntersect) {
                                double diffX = ((Point2D)altNewEnd).getX() - intersect.getX();
                                diffY = ((Point2D)altNewEnd).getY() - intersect.getY();
                                newEnd = new Point2D.Double(intersect.getX() - diffX, intersect.getY() - diffY);
                                ((Point2D)altNewStart).setLocation(intersect.getX() + diffX, intersect.getY() + diffY);
                            } else {
                                newEnd.setLocation(altNewEnd);
                            }
                            extendAltStart = extendEnd = Math.abs(betterExtension);
                        } else if (!makeT && betterExtension < extendEnd) {
                            newCl = new Centerline(both[b].width, intersect, altNewEnd);
                            newCl.startHub = true;
                            newCl.endHub = false;
                            if (newCl.start.distance(newCl.end) > 0.0) {
                                extraCenterlines.add(newCl);
                            }
                        }
                    }
                    Poly extended = Poly.makeEndPointPoly(newStart.distance(newEnd), both[b].width, both[b].angle, newStart, extendStart, newEnd, extendEnd, Poly.Type.FILLED);
                    if (!originalMerge.contains(layer, extended)) {
                        if (extendStart > 0.0) {
                            extendStart = betterExtension;
                        }
                        if (extendEnd > 0.0) {
                            extendEnd = betterExtension;
                        }
                        extended = Poly.makeEndPointPoly(newStart.distance(newEnd), both[b].width, both[b].angle, newStart, extendStart, newEnd, extendEnd, Poly.Type.FILLED);
                    }
                    if (!originalMerge.contains(layer, extended)) continue;
                    both[b].setStart(newStart.getX(), newStart.getY());
                    both[b].setEnd(newEnd.getX(), newEnd.getY());
                    if (extendStart != 0.0) {
                        both[b].startHub = true;
                    }
                    if (extendEnd != 0.0) {
                        both[b].endHub = true;
                    }
                    if (!makeT) continue;
                    Centerline newCL = new Centerline(both[b].width, altNewStart, altNewEnd);
                    if (extendAltStart != 0.0) {
                        newCL.startHub = true;
                    }
                    if (extendAltEnd != 0.0) {
                        newCL.endHub = true;
                    }
                    validCenterlines.add(newCL);
                }
            }
        }
        validCenterlines.addAll(extraCenterlines);
        return validCenterlines;
    }

    private boolean insideSegment(Point2D start, Point2D end, Point2D pt) {
        return !(pt.getX() < Math.min(start.getX(), end.getX()) || pt.getX() > Math.max(start.getX(), end.getX()) || pt.getY() < Math.min(start.getY(), end.getY())) && !(pt.getY() > Math.max(start.getY(), end.getY()));
    }

    private List<Centerline> gatherCenterlines(PolyBase poly, PolyMerge merge, PolyMerge originalMerge) {
        ArrayList<Centerline> centerlines = new ArrayList<Centerline>();
        Point2D[] points = poly.getPoints();
        TreeMap<Integer, ArrayList<Integer>> linesAtAngle = new TreeMap<Integer, ArrayList<Integer>>();
        for (int i = 0; i < points.length; ++i) {
            int angle;
            Point2D thisPt;
            Point2D lastPt;
            int lastI = i - 1;
            if (lastI < 0) {
                lastI = points.length - 1;
            }
            if ((lastPt = points[lastI]).equals(thisPt = points[i])) continue;
            for (angle = GenMath.figureAngle(thisPt, lastPt); angle < 0; angle += 1800) {
            }
            while (angle >= 1800) {
                angle -= 1800;
            }
            Integer iAngle = new Integer(angle);
            ArrayList<Integer> linesSoFar = (ArrayList<Integer>)linesAtAngle.get(iAngle);
            if (linesSoFar == null) {
                linesSoFar = new ArrayList<Integer>();
                linesAtAngle.put(iAngle, linesSoFar);
            }
            linesSoFar.add(new Integer(i));
        }
        int colinearSegs = 0;
        for (Integer iAangle : linesAtAngle.keySet()) {
            List linesAtThisAngle = (List)linesAtAngle.get(iAangle);
            if (linesAtThisAngle == null) continue;
            for (int ai = 0; ai < linesAtThisAngle.size(); ++ai) {
                int i = (Integer)linesAtThisAngle.get(ai);
                int lastI = i - 1;
                if (lastI < 0) {
                    lastI = points.length - 1;
                }
                Point2D lastPt = points[lastI];
                Point2D thisPt = points[i];
                for (int aj = ai + 2; aj < linesAtThisAngle.size() - 1; ++aj) {
                    int j = (Integer)linesAtThisAngle.get(aj);
                    if (!GenMath.isOnLine(lastPt, thisPt, points[j])) continue;
                    ++colinearSegs;
                }
            }
        }
        Point2D[] corners = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
        Point2D[] possibleStart = new Point2D[4];
        Point2D[] possibleEnd = new Point2D[4];
        for (Integer iAangle : linesAtAngle.keySet()) {
            List linesAtThisAngle = (List)linesAtAngle.get(iAangle);
            if (linesAtThisAngle == null) continue;
            int angle = iAangle;
            for (int ai = 0; ai < linesAtThisAngle.size(); ++ai) {
                int i = (Integer)linesAtThisAngle.get(ai);
                int lastI = i - 1;
                if (lastI < 0) {
                    lastI = points.length - 1;
                }
                Point2D lastPt = points[lastI];
                Point2D thisPt = points[i];
                block8: for (int aj = ai + 1; aj < linesAtThisAngle.size(); ++aj) {
                    Point2D oFinish;
                    Point2D finish;
                    Point2D oStart;
                    Point2D start;
                    Point2D swapPt;
                    double swap;
                    int j = (Integer)linesAtThisAngle.get(aj);
                    Point2D oLastPt = points[j - 1];
                    Point2D oThisPt = points[j];
                    int perpAngle = angle + 900;
                    Point2D oneSide = thisPt;
                    Point2D otherSide = GenMath.intersect(thisPt, perpAngle, oThisPt, angle);
                    Point2D.Double centerPt = new Point2D.Double((oneSide.getX() + otherSide.getX()) / 2.0, (oneSide.getY() + otherSide.getY()) / 2.0);
                    Point2D lastPtCL = GenMath.intersect(lastPt, perpAngle, centerPt, angle);
                    Point2D thisPtCL = GenMath.intersect(thisPt, perpAngle, centerPt, angle);
                    Point2D oLastPtCL = GenMath.intersect(oLastPt, perpAngle, centerPt, angle);
                    Point2D oThisPtCL = GenMath.intersect(oThisPt, perpAngle, centerPt, angle);
                    double minX = Math.min(Math.min(lastPtCL.getX(), thisPtCL.getX()), Math.min(oLastPtCL.getX(), oThisPtCL.getX()));
                    double maxX = Math.max(Math.max(lastPtCL.getX(), thisPtCL.getX()), Math.max(oLastPtCL.getX(), oThisPtCL.getX()));
                    double minY = Math.min(Math.min(lastPtCL.getY(), thisPtCL.getY()), Math.min(oLastPtCL.getY(), oThisPtCL.getY()));
                    double maxY = Math.max(Math.max(lastPtCL.getY(), thisPtCL.getY()), Math.max(oLastPtCL.getY(), oThisPtCL.getY()));
                    corners[0].setLocation(minX, minY);
                    corners[1].setLocation(minX, maxY);
                    corners[2].setLocation(maxX, maxY);
                    corners[3].setLocation(maxX, minY);
                    Point2D aCorner = null;
                    for (int k = 0; k < 4; ++k) {
                        if (lastPtCL.equals(corners[k])) {
                            aCorner = lastPtCL;
                        }
                        if (thisPtCL.equals(corners[k])) {
                            aCorner = thisPtCL;
                        }
                        if (oLastPtCL.equals(corners[k])) {
                            aCorner = oLastPtCL;
                        }
                        if (!oThisPtCL.equals(corners[k])) continue;
                        aCorner = oThisPtCL;
                    }
                    double lastDist = aCorner.distance(lastPtCL);
                    double thisDist = aCorner.distance(thisPtCL);
                    double oLastDist = aCorner.distance(oLastPtCL);
                    double oThisDist = aCorner.distance(oThisPtCL);
                    if (Math.min(lastDist, thisDist) >= Math.max(oLastDist, oThisDist) || Math.min(oLastDist, oThisDist) >= Math.max(lastDist, thisDist)) continue;
                    if (lastDist > thisDist) {
                        swap = lastDist;
                        lastDist = thisDist;
                        thisDist = swap;
                        swapPt = lastPtCL;
                        lastPtCL = thisPtCL;
                        thisPtCL = swapPt;
                    }
                    if (oLastDist > oThisDist) {
                        swap = oLastDist;
                        oLastDist = oThisDist;
                        oThisDist = swap;
                        swapPt = oLastPtCL;
                        oLastPtCL = oThisPtCL;
                        oThisPtCL = swapPt;
                    }
                    if (lastDist < oLastDist) {
                        start = oLastPtCL;
                        oStart = lastPtCL;
                    } else {
                        start = lastPtCL;
                        oStart = oLastPtCL;
                    }
                    if (thisDist > oThisDist) {
                        finish = oThisPtCL;
                        oFinish = thisPtCL;
                    } else {
                        finish = thisPtCL;
                        oFinish = oThisPtCL;
                    }
                    possibleStart[0] = oStart;
                    possibleEnd[0] = oFinish;
                    if (start.distance(oStart) < finish.distance(oFinish)) {
                        possibleStart[1] = oStart;
                        possibleEnd[1] = finish;
                        possibleStart[2] = start;
                        possibleEnd[2] = oFinish;
                    } else {
                        possibleStart[1] = start;
                        possibleEnd[1] = oFinish;
                        possibleStart[2] = oStart;
                        possibleEnd[2] = finish;
                    }
                    possibleStart[3] = start;
                    possibleEnd[3] = finish;
                    double width = oneSide.distance(otherSide);
                    for (int p = 0; p < 4; ++p) {
                        double length = possibleStart[p].distance(possibleEnd[p]);
                        Poly clPoly = Poly.makeEndPointPoly(length, width, angle, possibleStart[p], 0.0, possibleEnd[p], 0.0, Poly.Type.FILLED);
                        if (!originalMerge.contains(poly.getLayer(), clPoly)) continue;
                        double psX = possibleStart[p].getX();
                        double psY = possibleStart[p].getY();
                        double peX = possibleEnd[p].getX();
                        double peY = possibleEnd[p].getY();
                        Point2D.Double ps = new Point2D.Double(psX, psY);
                        Point2D.Double pe = new Point2D.Double(peX, peY);
                        Centerline newCL = new Centerline(width, ps, pe);
                        if (newCL.angle < 0) continue block8;
                        boolean comparisonDone = false;
                        for (int ci = 0; ci < centerlines.size(); ++ci) {
                            Centerline acl = (Centerline)centerlines.get(ci);
                            if (!acl.getBounds().equals(newCL.getBounds())) continue;
                            Centerline horCL = null;
                            Centerline verCL = null;
                            if (acl.start.getX() == acl.end.getX()) {
                                verCL = acl;
                            }
                            if (acl.start.getY() == acl.end.getY()) {
                                horCL = acl;
                            }
                            if (newCL.start.getX() == newCL.end.getX()) {
                                verCL = newCL;
                            }
                            if (newCL.start.getY() == newCL.end.getY()) {
                                horCL = newCL;
                            }
                            if (horCL == null || verCL == null) {
                                comparisonDone = true;
                                break;
                            }
                            Rectangle2D bounds = acl.getBounds();
                            int favorHor = 0;
                            int favorVer = 0;
                            Rectangle2D.Double boundsE = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() + 0.0025, bounds.getHeight());
                            Rectangle2D.Double boundsW = new Rectangle2D.Double(bounds.getX() - 0.0025, bounds.getY(), bounds.getWidth() + 0.0025, bounds.getHeight());
                            if (originalMerge.contains(poly.getLayer(), new PolyBase(boundsE))) {
                                ++favorHor;
                            }
                            if (originalMerge.contains(poly.getLayer(), new PolyBase(boundsW))) {
                                ++favorHor;
                            }
                            Rectangle2D.Double boundsN = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight() + 0.0025);
                            Rectangle2D.Double boundsS = new Rectangle2D.Double(bounds.getX(), bounds.getY() - 0.0025, bounds.getWidth(), bounds.getHeight() + 0.0025);
                            if (originalMerge.contains(poly.getLayer(), new PolyBase(boundsN))) {
                                ++favorVer;
                            }
                            if (originalMerge.contains(poly.getLayer(), new PolyBase(boundsS))) {
                                ++favorVer;
                            }
                            if (favorHor > favorVer) {
                                if (centerlines.contains(verCL)) {
                                    centerlines.remove(verCL);
                                }
                                if (!centerlines.contains(horCL)) {
                                    centerlines.add(horCL);
                                }
                                comparisonDone = true;
                            }
                            if (favorVer <= favorHor) break;
                            if (centerlines.contains(horCL)) {
                                centerlines.remove(horCL);
                            }
                            if (!centerlines.contains(verCL)) {
                                centerlines.add(verCL);
                            }
                            comparisonDone = true;
                            break;
                        }
                        if (comparisonDone) continue block8;
                        centerlines.add(newCL);
                        continue block8;
                    }
                }
            }
        }
        Collections.sort(centerlines, new ParallelWiresByLength());
        PolyMerge reCheck = new PolyMerge();
        for (int i = 0; i < centerlines.size(); ++i) {
            Centerline cl = (Centerline)centerlines.get(i);
            Poly clPoly = Poly.makeEndPointPoly(cl.start.distance(cl.end), cl.width, cl.angle, cl.start, 0.0, cl.end, 0.0, Poly.Type.FILLED);
            if (reCheck.contains(this.tempLayer1, clPoly)) {
                centerlines.remove(i);
                --i;
                continue;
            }
            reCheck.addPolygon(this.tempLayer1, clPoly);
        }
        Collections.sort(centerlines, new ParallelWiresByWidth());
        return centerlines;
    }

    private void convertAllGeometry(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        GenMath.MutableInteger numIgnored = new GenMath.MutableInteger(0);
        for (Layer layer : merge.getKeySet()) {
            ArcProto ap = this.arcsForLayer.get(layer);
            List<PolyBase> polyList = this.getMergePolys(merge, layer, numIgnored);
            if (layer.getFunction().isSubstrate() || layer.getFunction().isImplant()) {
                polyList = new ArrayList<PolyBase>(originalMerge.getObjects(layer, false, false));
            }
            for (PolyBase poly : polyList) {
                if (Extract.isUsePureLayerNodes()) {
                    ap = null;
                }
                if (ap != null) {
                    Rectangle2D totalBounds;
                    Rectangle2D polyBounds = poly.getBox();
                    if (polyBounds == null && originalMerge.contains(layer, totalBounds = poly.getBounds2D())) {
                        polyBounds = totalBounds;
                    }
                    if (polyBounds != null) {
                        double width = polyBounds.getWidth();
                        double height = polyBounds.getHeight();
                        double actualWidth = 0.0;
                        if (width >= actualWidth && height >= actualWidth) {
                            PrimitiveNode np = ap.findPinProto();
                            Point2D.Double end1 = null;
                            Point2D.Double end2 = null;
                            double size = 0.0;
                            if (width > height) {
                                end1 = new Point2D.Double(polyBounds.getMinX(), polyBounds.getCenterY());
                                end2 = new Point2D.Double(polyBounds.getMaxX(), polyBounds.getCenterY());
                                size = height;
                            } else {
                                end1 = new Point2D.Double(polyBounds.getCenterX(), polyBounds.getMinY());
                                end2 = new Point2D.Double(polyBounds.getCenterX(), polyBounds.getMaxY());
                                size = width;
                            }
                            GenMath.MutableBoolean headExtend = new GenMath.MutableBoolean(false);
                            GenMath.MutableBoolean tailExtend = new GenMath.MutableBoolean(false);
                            if (originalMerge.arcPolyFits(layer, end1, end2, size, headExtend, tailExtend)) {
                                end1 = new Point2D.Double(((Point2D)end1).getX() / 400.0, ((Point2D)end1).getY() / 400.0);
                                end2 = new Point2D.Double(((Point2D)end2).getX() / 400.0, ((Point2D)end2).getY() / 400.0);
                                NodeInst ni1 = this.createNode(np, end1, size /= 400.0, size, null, newCell);
                                NodeInst ni2 = this.createNode(np, end2, size, size, null, newCell);
                                this.realizeArc(ap, ni1.getOnlyPortInst(), ni2.getOnlyPortInst(), end1, end2, size, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
                                continue;
                            }
                            System.out.println("Arc " + layer.getName() + " did not fit at " + polyBounds.getMinX() / 400.0 + "," + polyBounds.getMinY() / 400.0);
                            continue;
                        }
                    }
                }
                List<NodeInst> niList = this.makePureLayerNodeFromPoly(poly, newCell, originalMerge);
                if (poly.getLayer().getFunction().isSubstrate() || poly.getLayer().getFunction().isImplant()) {
                    for (NodeInst ni : niList) {
                        ni.setHardSelect();
                    }
                }
                if (niList == null || ap == null) continue;
                for (NodeInst ni : niList) {
                    PortInst fPi = ni.getOnlyPortInst();
                    Poly fPortPoly = fPi.getPoly();
                    Rectangle2D polyBounds = poly.getBounds2D();
                    Rectangle2D.Double searchBound = new Rectangle2D.Double(polyBounds.getMinX() / 400.0, polyBounds.getMinY() / 400.0, polyBounds.getWidth() / 400.0, polyBounds.getHeight() / 400.0);
                    PortInst bestTPi = null;
                    double bestLen = Double.MAX_VALUE;
                    Point2D bestFLoc = null;
                    Iterator<RTBounds> it = newCell.searchIterator(searchBound);
                    while (it.hasNext()) {
                        NodeInst oNi;
                        RTBounds geom = it.next();
                        if (!(geom instanceof NodeInst) || (oNi = (NodeInst)geom) == ni || oNi.isCellInstance() || oNi.getProto().getTechnology() != this.tech) continue;
                        Iterator<PortInst> pIt = oNi.getPortInsts();
                        while (pIt.hasNext()) {
                            int angle;
                            PortInst tPi = pIt.next();
                            PortProto pp = tPi.getPortProto();
                            if (!pp.connectsTo(ap)) continue;
                            EPoint tLoc = tPi.getPoly().getCenter();
                            EPoint tLocScaled = new EPoint(this.scaleUp(tLoc.getX()), this.scaleUp(tLoc.getY()));
                            Point2D fLoc = fPortPoly.closestPoint(tLoc);
                            EPoint fLocScaled = new EPoint(this.scaleUp(fLoc.getX()), this.scaleUp(fLoc.getY()));
                            double len = this.scaleUp(fLoc.distance(tLoc));
                            Poly conPoly = Poly.makeEndPointPoly(len, 1.0, angle = GenMath.figureAngle(tLoc, fLoc), fLocScaled, 0.0, tLocScaled, 0.0, Poly.Type.FILLED);
                            if (!originalMerge.contains(layer, conPoly) || !(len < bestLen)) continue;
                            bestLen = len;
                            bestTPi = tPi;
                            bestFLoc = fLoc;
                        }
                    }
                    if (bestTPi != null) {
                        Poly tPortPoly = bestTPi.getPoly();
                        Point2D tLoc = tPortPoly.closestPoint(tPortPoly.getCenter());
                        ArcInst ai = this.realizeArc(ap, fPi, bestTPi, bestFLoc, tLoc, 0.0, false, false, merge);
                        if (ai == null) continue;
                        ai.setFixedAngle(false);
                        continue;
                    }
                    this.addErrorLog(newCell, "Unable to connect unextracted polygon", new EPoint(searchBound.getCenterX(), searchBound.getCenterY()));
                }
            }
        }
        for (Layer layer : this.allCutLayers.keySet()) {
            CutInfo cInfo = this.allCutLayers.get(layer);
            for (PolyBase poly : cInfo.getCuts()) {
                this.makePureLayerNodeFromPoly(poly, newCell, originalMerge);
            }
        }
        if (numIgnored.intValue() > 0) {
            System.out.println("WARNING: Ignored " + numIgnored.intValue() + " tiny polygons (use Network Preferences to control tiny polygon limit)");
        }
    }

    private void addInRoutingLayers(Cell oldCell, Cell newCell, PolyMerge merge, PolyMerge originalMerge) {
        HashMap newNodes = new HashMap();
        Iterator<NodeInst> nit = oldCell.getNodes();
        while (nit.hasNext()) {
            Layer layer;
            Layer.Function fun;
            PrimitiveNode pn;
            NodeInst ni = nit.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof PrimitiveNode) || (pn = (PrimitiveNode)np).getFunction() != PrimitiveNode.Function.NODE || !(fun = (layer = pn.getLayerIterator().next()).getFunction()).isPoly() && !fun.isMetal() && !fun.isDiff()) continue;
            ArrayList<NodeInst> newNis = new ArrayList<NodeInst>();
            if (ni.getTrace() != null && ni.getTrace().length > 0) {
                EPoint[] origPoints = ni.getTrace();
                Point2D[] points = new Point2D[origPoints.length];
                for (int i = 0; i < origPoints.length; ++i) {
                    points[i] = new Point2D.Double(origPoints[i].getX() + ni.getAnchorCenterX(), origPoints[i].getY() + ni.getAnchorCenterY());
                }
                boolean BREAKUPTRACE = true;
                PolyBase poly = new PolyBase(points);
                poly.setLayer(layer);
                if (BREAKUPTRACE) {
                    GeometryHandler thisMerge = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1);
                    thisMerge.add(layer, poly);
                    thisMerge.postProcess(true);
                    Collection<PolyBase> set = ((PolySweepMerge)thisMerge).getPolyPartition(layer);
                    for (PolyBase simplePoly : set) {
                        PolyBase simplePolyScaledUp = this.scaleUpPoly(simplePoly);
                        pn = this.getActiveNodeType(layer, simplePolyScaledUp, originalMerge, pn);
                        layer = pn.getLayerIterator().next();
                        Rectangle2D polyBounds = simplePoly.getBounds2D();
                        NodeInst newNi = NodeInst.makeInstance(pn, simplePoly.getCenter(), polyBounds.getWidth(), polyBounds.getHeight(), newCell);
                        if (newNi == null) continue;
                        newNis.add(newNi);
                    }
                } else {
                    PolyBase polyScaledUp = this.scaleUpPoly(poly);
                    pn = this.getActiveNodeType(layer, polyScaledUp, originalMerge, pn);
                    NodeInst newNi = NodeInst.makeInstance(pn, ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), newCell);
                    if (newNi != null) {
                        newNis.add(newNi);
                        newNi.setTrace(points);
                    }
                }
            } else {
                PolyBase poly = new PolyBase(ni.getBounds());
                PolyBase polyScaledUp = this.scaleUpPoly(poly);
                pn = this.getActiveNodeType(layer, polyScaledUp, originalMerge, pn);
                NodeInst newNi = NodeInst.makeInstance(pn, ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), newCell, ni.getOrient(), null);
                if (newNi != null) {
                    newNis.add(newNi);
                }
            }
            layer = pn.getLayerIterator().next();
            for (NodeInst newNi : newNis) {
                Poly[] polys;
                for (Poly p : polys = this.tech.getShapeOfNode(newNi)) {
                    if (p.getLayer() != layer) continue;
                    this.removePolyFromMerge(merge, layer, p);
                }
            }
            ArrayList list = (ArrayList)newNodes.get(layer);
            if (list == null) {
                list = new ArrayList();
                newNodes.put(layer, list);
            }
            list.addAll(newNis);
        }
        for (Layer layer : newNodes.keySet()) {
            Layer.Function fun = layer.getFunction();
            ArcProto ap = Generic.tech().universal_arc;
            if (fun.isPoly() || fun.isMetal() || fun.isDiff()) {
                ap = this.arcsForLayer.get(layer);
            }
            List nodes = (List)newNodes.get(layer);
            int i = 0;
            int j = 1;
            for (i = 0; i < nodes.size(); ++i) {
                NodeInst ni1 = (NodeInst)nodes.get(i);
                for (j = i + 1; j < nodes.size(); ++j) {
                    double x;
                    NodeInst ni2 = (NodeInst)nodes.get(j);
                    if (ni1 == ni2) continue;
                    Poly poly1 = this.tech.getShapeOfNode(ni1)[0];
                    Poly poly2 = this.tech.getShapeOfNode(ni2)[0];
                    ArrayList<Line2D> overlappingEdges = new ArrayList<Line2D>();
                    List<PolyBase> intersection = poly1.getIntersection(poly2, overlappingEdges);
                    Point2D connectionPoint = null;
                    if (intersection.size() > 0) {
                        PolyBase pint = intersection.get(0);
                        connectionPoint = pint.getCenter();
                        if (this.alignment != null) {
                            x = ((Point2D)connectionPoint).getX();
                            double y = ((Point2D)connectionPoint).getY();
                            if (this.alignment.getWidth() > 0.0) {
                                x = (double)Math.round(x / this.alignment.getWidth()) * this.alignment.getWidth();
                            }
                            if (this.alignment.getHeight() > 0.0) {
                                y = (double)Math.round(y / this.alignment.getHeight()) * this.alignment.getHeight();
                            }
                            if (pint.contains(x, y)) {
                                connectionPoint = new Point2D.Double(x, y);
                            }
                        }
                    } else if (overlappingEdges.size() > 0) {
                        Line2D line = (Line2D)overlappingEdges.get(0);
                        x = (line.getX1() + line.getX2()) / 2.0;
                        double y = (line.getY1() + line.getY2()) / 2.0;
                        if (this.alignment != null) {
                            double newx = x;
                            double newy = y;
                            if (line.getY1() == line.getY2() && !this.isOnGrid(x, this.alignment.getWidth())) {
                                newx = (double)Math.round(x / this.alignment.getWidth()) * this.alignment.getWidth();
                            }
                            if (line.getX1() == line.getX2() && !this.isOnGrid(y, this.alignment.getHeight())) {
                                newy = (double)Math.round(y / this.alignment.getHeight()) * this.alignment.getHeight();
                            }
                            if (line.ptSegDist(newx, newy) == 0.0) {
                                x = newx;
                                y = newy;
                            }
                        }
                        connectionPoint = new Point2D.Double(x, y);
                    }
                    if (connectionPoint == null) continue;
                    PolyBase poly1Scaled = this.scaleUpPoly(poly1);
                    if (fun.isDiff()) {
                        ap = this.findArcProtoForPoly(layer, poly1Scaled, originalMerge);
                    }
                    if (ap == null) {
                        ap = Generic.tech().universal_arc;
                    }
                    double width = ap.getDefaultLambdaBaseWidth();
                    ArcProto arcProto = ap;
                    if (arcProto != Generic.tech().universal_arc) {
                        Point2D.Double connPointScaled = new Point2D.Double(this.scaleUp(((Point2D)connectionPoint).getX()), this.scaleUp(((Point2D)connectionPoint).getY()));
                        Poly test1 = Poly.makeEndPointPoly(0.0, this.scaleUp(width), 0, connPointScaled, this.scaleUp(width / 2.0), connPointScaled, this.scaleUp(width / 2.0), Poly.Type.FILLED);
                        if (this.isOnGrid(test1) && originalMerge.contains(layer, test1)) {
                            this.realizeArc(arcProto, ni1.getOnlyPortInst(), ni2.getOnlyPortInst(), connectionPoint, connectionPoint, width, false, false, merge);
                            continue;
                        }
                        arcProto = Generic.tech().universal_arc;
                        width = 0.0;
                    }
                    this.realizeArc(arcProto, ni1.getOnlyPortInst(), ni2.getOnlyPortInst(), connectionPoint, connectionPoint, width, false, false, merge);
                }
            }
        }
    }

    private PrimitiveNode getActiveNodeType(Layer activeLayer, PolyBase poly, PolyMerge merge, PrimitiveNode defaultNode) {
        if (this.unifyActive || this.ignoreActiveSelectWell) {
            return defaultNode;
        }
        if (defaultNode != this.pDiffNode && defaultNode != this.nDiffNode && defaultNode != this.diffNode) {
            return defaultNode;
        }
        if (activeLayer.getFunction() == Layer.Function.DIFFN && merge.contains(this.pSelectLayer, poly)) {
            return this.pDiffNode;
        }
        if (activeLayer.getFunction() == Layer.Function.DIFFP && merge.contains(this.nSelectLayer, poly)) {
            return this.nDiffNode;
        }
        return defaultNode;
    }

    private boolean isOnGrid(Poly poly) {
        if (this.alignment != null) {
            for (Point2D p : poly.getPoints()) {
                if (this.alignment.getWidth() > 0.0 && !this.isOnGrid(p.getX(), this.alignment.getWidth())) {
                    return false;
                }
                if (!(this.alignment.getHeight() > 0.0) || this.isOnGrid(p.getY(), this.alignment.getHeight())) continue;
                return false;
            }
        }
        return true;
    }

    private PolyBase scaleUpPoly(PolyBase poly) {
        Point2D[] points = new Point2D.Double[poly.getPoints().length];
        for (int p = 0; p < points.length; ++p) {
            points[p] = new Point2D.Double(this.scaleUp(poly.getPoints()[p].getX()), this.scaleUp(poly.getPoints()[p].getY()));
        }
        PolyBase newpoly = new PolyBase(points);
        newpoly.setStyle(poly.getStyle());
        return newpoly;
    }

    private List<NodeInst> makePureLayerNodeFromPoly(PolyBase poly, Cell cell, PolyMerge originalMerge) {
        PrimitiveNode pNp;
        Layer layer = poly.getLayer();
        if (this.unifyActive && (layer == this.pActiveLayer || layer == this.nActiveLayer)) {
            Rectangle2D rect = poly.getBounds2D();
            rect = new Rectangle2D.Double(rect.getMinX() / 400.0 - 1.0, rect.getMinY() / 400.0 - 1.0, rect.getWidth() / 400.0 + 2.0, rect.getHeight() / 400.0 + 2.0);
            int nType = 0;
            int pType = 0;
            Iterator<RTBounds> it = cell.searchIterator(rect);
            while (it.hasNext()) {
                Layer.Function fun;
                int i;
                Poly[] polys;
                RTBounds geom = it.next();
                if (geom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geom;
                    if (ni.isCellInstance()) continue;
                    polys = ni.getProto().getTechnology().getShapeOfNode(ni);
                    for (i = 0; i < polys.length; ++i) {
                        fun = polys[i].getLayer().getFunction();
                        if (!fun.isDiff()) continue;
                        if (fun == Layer.Function.DIFFP) {
                            ++pType;
                        }
                        if (fun != Layer.Function.DIFFN) continue;
                        ++nType;
                    }
                    continue;
                }
                ArcInst ai = (ArcInst)geom;
                polys = ai.getProto().getTechnology().getShapeOfArc(ai);
                for (i = 0; i < polys.length; ++i) {
                    fun = polys[i].getLayer().getFunction();
                    if (!fun.isDiff()) continue;
                    if (fun == Layer.Function.DIFFP) {
                        ++pType;
                    }
                    if (fun != Layer.Function.DIFFN) continue;
                    ++nType;
                }
            }
            layer = pType > nType ? this.realPActiveLayer : this.realNActiveLayer;
            if (layer.getPureLayerNode() == null) {
                layer = poly.getLayer();
            }
        }
        if ((pNp = layer.getPureLayerNode()) == null) {
            System.out.println("CANNOT FIND PURE LAYER NODE FOR LAYER " + layer.getName());
            return null;
        }
        ArrayList<NodeInst> createdNodes = new ArrayList<NodeInst>();
        if (poly.getBox() == null) {
            GeometryHandler thisMerge = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1);
            thisMerge.add(layer, poly);
            thisMerge.postProcess(true);
            Collection<PolyBase> set = ((PolySweepMerge)thisMerge).getPolyPartition(layer);
            for (PolyBase simplePoly : set) {
                Rectangle2D polyBounds = simplePoly.getBounds2D();
                NodeInst ni = this.makeAlignedPoly(polyBounds, layer, originalMerge, pNp, cell);
                if (ni == null) continue;
                createdNodes.add(ni);
            }
            return createdNodes;
        }
        Rectangle2D polyBounds = poly.getBounds2D();
        NodeInst ni = this.makeAlignedPoly(polyBounds, layer, originalMerge, pNp, cell);
        if (ni != null) {
            createdNodes.add(ni);
        }
        return createdNodes;
    }

    private NodeInst makeAlignedPoly(Rectangle2D polyBounds, Layer layer, PolyMerge originalMerge, PrimitiveNode pNp, Cell cell) {
        double centerX = polyBounds.getCenterX() / 400.0;
        double centerY = polyBounds.getCenterY() / 400.0;
        double width = polyBounds.getWidth() / 400.0;
        double height = polyBounds.getHeight() / 400.0;
        if (this.alignment != null) {
            double aliY;
            Poly rectPoly;
            double aliX;
            if (this.alignment.getWidth() > 0.0 && (aliX = (double)Math.round(centerX / (this.alignment.getWidth() / 2.0)) * (this.alignment.getWidth() / 2.0)) != centerX) {
                double newWidth = width + Math.abs(aliX - centerX) * 2.0;
                rectPoly = new Poly(this.scaleUp(aliX), this.scaleUp(centerY), this.scaleUp(newWidth), this.scaleUp(height));
                if (!originalMerge.contains(layer, rectPoly)) {
                    aliX = aliX > centerX ? (aliX -= this.alignment.getWidth()) : (aliX += this.alignment.getWidth());
                    newWidth = width + Math.abs(aliX - centerX) * 2.0;
                    rectPoly = new Poly(this.scaleUp(aliX), this.scaleUp(centerY), this.scaleUp(newWidth), this.scaleUp(height));
                    if (!originalMerge.contains(layer, rectPoly)) {
                        return null;
                    }
                }
                centerX = aliX;
                width = newWidth;
            }
            if (this.alignment.getHeight() > 0.0 && (aliY = (double)Math.round(centerY / (this.alignment.getHeight() / 2.0)) * (this.alignment.getHeight() / 2.0)) != centerY) {
                double newHeight = height + Math.abs(aliY - centerY) * 2.0;
                rectPoly = new Poly(this.scaleUp(centerX), this.scaleUp(aliY), this.scaleUp(width), this.scaleUp(newHeight));
                if (!originalMerge.contains(layer, rectPoly)) {
                    aliY = aliY > centerY ? (aliY -= this.alignment.getHeight()) : (aliY += this.alignment.getHeight());
                    newHeight = height + Math.abs(aliY - centerY) * 2.0;
                    rectPoly = new Poly(this.scaleUp(centerX), this.scaleUp(aliY), this.scaleUp(width), this.scaleUp(newHeight));
                    if (!originalMerge.contains(layer, rectPoly)) {
                        return null;
                    }
                }
                centerY = aliY;
                height = newHeight;
            }
        }
        Point2D.Double center = new Point2D.Double(centerX, centerY);
        NodeInst ni = this.createNode(pNp, center, width, height, null, cell);
        return ni;
    }

    private void cleanupExports(Cell oldCell, Cell newCell) {
        for (Export e : this.exportsToRestore) {
            EPoint loc = e.getPoly().getCenter();
            boolean found = false;
            Rectangle2D.Double bounds = new Rectangle2D.Double(loc.getX(), loc.getY(), 0.0, 0.0);
            Iterator<RTBounds> it = newCell.searchIterator(bounds);
            block1: while (it.hasNext()) {
                RTBounds geom = it.next();
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geom;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    EPoint pLoc;
                    PortInst pi = pIt.next();
                    PortProto pp = pi.getPortProto();
                    if (!this.sameConnection(e, pp) || !loc.equals(pLoc = pi.getPoly().getCenter())) continue;
                    Export.newInstance(newCell, pi, e.getName());
                    found = true;
                    continue block1;
                }
            }
            if (found) continue;
            PrimitiveNode pnUse = null;
            Iterator<PrimitiveNode> it2 = this.tech.getNodes();
            while (it2.hasNext()) {
                PrimitiveNode pn = it2.next();
                if (!pn.getFunction().isPin() || !this.sameConnection(e, pn.getPort(0))) continue;
                pnUse = pn;
                break;
            }
            if (pnUse == null) continue;
            NodeInst ni = NodeInst.makeInstance(pnUse, loc, pnUse.getDefWidth(), pnUse.getDefHeight(), newCell);
            Export.newInstance(newCell, ni.getOnlyPortInst(), e.getName());
        }
        for (ExportedPin ep : this.pinsForLater) {
            Iterator<Export> eIt = ep.ni.getExports();
            while (eIt.hasNext()) {
                Export found;
                Export e = eIt.next();
                ArcProto[] possibleCons = e.getBasePort().getConnections();
                ArcProto ap = possibleCons[0];
                Layer layer = ap.getLayer(0);
                PortInst pi = this.makePort(newCell, layer, ep.location);
                if (pi != null && (found = newCell.findExport(e.getName())) != null) continue;
                double sX = ep.ni.getXSize();
                double sY = ep.ni.getYSize();
                Point2D.Double instanceAnchor = new Point2D.Double(0.0, 0.0);
                ep.trans.transform(ep.ni.getAnchorCenter(), instanceAnchor);
                NodeInst newNi = NodeInst.makeInstance(ep.ni.getProto(), instanceAnchor, sX, sY, newCell);
                if (newNi == null) {
                    this.addErrorLog(newCell, "Problem creating new instance of " + ep.ni.getProto() + " for export", new EPoint(sX, sY));
                    continue;
                }
                PortInst newPi = newNi.findPortInstFromProto(e.getOriginalPort().getPortProto());
                Export.newInstance(newCell, newPi, e.getName());
            }
        }
        for (Export e : this.generatedExports) {
            Cell cell = e.getParent();
            Netlist nl = cell.acquireUserNetlist();
            Network net = nl.getNetwork(e, 0);
            String exportName = null;
            Iterator<String> nIt = net.getExportedNames();
            while (nIt.hasNext()) {
                String eName = nIt.next();
                if (!eName.startsWith("E")) continue;
                boolean isTemp = false;
                for (Export e2 : this.generatedExports) {
                    if (e2.getParent() != cell || !e2.getName().equals(eName)) continue;
                    isTemp = true;
                    break;
                }
                if (isTemp) continue;
                exportName = eName;
                break;
            }
            if (exportName == null) continue;
            exportName = ElectricObject.uniqueObjectName(exportName, cell, PortProto.class, true, true);
            e.rename(exportName);
        }
    }

    private boolean sameConnection(PortProto pp1, PortProto pp2) {
        ArcProto[] arcs2;
        ArcProto[] arcs1 = pp1.getBasePort().getConnections();
        if (arcs1 == (arcs2 = pp2.getBasePort().getConnections())) {
            return true;
        }
        boolean[] found = new boolean[arcs2.length];
        for (int i = 0; i < arcs1.length; ++i) {
            int j;
            if (arcs1[i].getTechnology() == Generic.tech()) continue;
            for (j = 0; j < arcs2.length; ++j) {
                if (arcs1[i] != arcs2[j]) continue;
                found[j] = true;
                break;
            }
            if (j < arcs2.length) continue;
            return false;
        }
        for (int j = 0; j < arcs2.length; ++j) {
            if (found[j] || arcs2[j].getTechnology() == Generic.tech()) continue;
            return false;
        }
        return true;
    }

    private NodeInst createNode(NodeProto np, Point2D loc, double wid, double hei, EPoint[] points, Cell cell) {
        NodeInst ni;
        if (np.getFunction().isPin()) {
            if (wid < np.getDefWidth()) {
                wid = np.getDefWidth();
            }
            if (hei < np.getDefHeight()) {
                hei = np.getDefHeight();
            }
        }
        if ((ni = NodeInst.makeInstance(np, loc, wid, hei, cell)) != null && points != null) {
            ni.setTrace(points);
        }
        return ni;
    }

    private void realizeNode(PrimitiveNode pNp, int cutVariation, double centerX, double centerY, double width, double height, int angle, Point2D[] points, PolyMerge merge, Cell newCell, List<NodeInst> realizedNodes) {
        double cX = centerX / 400.0;
        double cY = centerY / 400.0;
        Orientation orient = Orientation.fromAngle(angle);
        NodeInst ni = NodeInst.makeInstance(pNp, new Point2D.Double(cX, cY), width / 400.0, height / 400.0, newCell, orient, null);
        if (ni == null) {
            return;
        }
        if (cutVariation != 0) {
            ni.newVar(Technology.NodeLayer.CUT_ALIGNMENT, (Object)cutVariation);
        }
        if (points != null) {
            ni.setTrace(points);
        }
        if (realizedNodes != null) {
            realizedNodes.add(ni);
        } else {
            AffineTransform trans = ni.rotateOut();
            Poly[] polys = this.tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer layer = poly.getLayer();
                layer = this.geometricLayer(layer);
                poly.transform(trans);
                if (Extract.isUsePureLayerNodes() && (layer.getFunction().isPoly() || layer.getFunction().isMetal())) continue;
                this.removePolyFromMerge(merge, layer, poly);
            }
        }
    }

    private ArcInst realizeArc(ArcProto ap, PortInst pi1, PortInst pi2, Point2D pt1, Point2D pt2, double width, boolean noHeadExtend, boolean noTailExtend, PolyMerge merge) {
        ArcInst ai;
        if (this.alignment != null && this.alignment.getWidth() > 0.0) {
            width = Math.floor(width / this.alignment.getWidth()) * this.alignment.getWidth();
        }
        if (width == 0.0) {
            ap = Generic.tech().universal_arc;
        }
        if ((ai = ArcInst.makeInstanceBase(ap, width, pi1, pi2, pt1, pt2, null)) == null) {
            return null;
        }
        if (ap.getFunction().isDiffusion() && ai.getLambdaBaseWidth() > ap.getDefaultLambdaBaseWidth()) {
            if (ai.getHeadPortInst().getNodeInst().getFunction().isTransistor()) {
                noHeadExtend = true;
            }
            if (ai.getTailPortInst().getNodeInst().getFunction().isTransistor()) {
                noTailExtend = true;
            }
        }
        if (noHeadExtend) {
            ai.setHeadExtended(false);
        }
        if (noTailExtend) {
            ai.setTailExtended(false);
        }
        EPoint head = ai.getHeadLocation();
        EPoint tail = ai.getTailLocation();
        if (head.getX() != tail.getX() && head.getY() != tail.getY()) {
            ai.setFixedAngle(false);
        }
        Poly[] polys = this.tech.getShapeOfArc(ai);
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            Layer layer = poly.getLayer();
            layer = this.geometricLayer(layer);
            if (Extract.isUsePureLayerNodes()) continue;
            this.removePolyFromMerge(merge, layer, poly);
        }
        return ai;
    }

    private void removePolyFromMerge(PolyMerge merge, Layer layer, Poly poly) {
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            poly.setPoint(i, this.scaleUp(points[i].getX()), this.scaleUp(points[i].getY()));
        }
        poly.roundPoints();
        merge.subtract(layer, poly);
    }

    private double scaleUp(double v) {
        return DBMath.round(v) * 400.0;
    }

    private Layer geometricLayer(Layer layer) {
        Layer properLayer;
        Layer polyLayer;
        if (layer.getTechnology() != this.tech) {
            return layer;
        }
        Layer.Function fun = layer.getFunction();
        if (fun == Layer.Function.GATE && (polyLayer = this.layerForFunction.get((Object)Layer.Function.POLY1)) != null) {
            return polyLayer;
        }
        if (this.unifyActive && (fun == Layer.Function.DIFFP || fun == Layer.Function.DIFFN)) {
            fun = Layer.Function.DIFF;
        }
        if ((properLayer = this.layerForFunction.get((Object)fun)) != null) {
            return properLayer;
        }
        return layer;
    }

    private List<PolyBase> getMergePolys(PolyMerge merge, Layer layer, GenMath.MutableInteger numIgnored) {
        List<PolyBase> polyList = merge.getMergedPoints(layer, true);
        if (polyList == null) {
            return polyList;
        }
        ArrayList<PolyBase> properPolyList = new ArrayList<PolyBase>();
        for (PolyBase poly : polyList) {
            int i;
            Point2D[] origPoints = poly.getPoints();
            Point2D[] points = new Point2D[origPoints.length];
            int len = origPoints.length;
            for (i = 0; i < len; ++i) {
                points[i] = origPoints[i];
            }
            for (i = 1; i < len; ++i) {
                if (!(points[i].distance(points[i - 1]) < 8.0)) continue;
                for (int j = i; j < len; ++j) {
                    points[j - 1] = points[j];
                }
                --len;
                --i;
            }
            if (len > 1 && points[0].distance(points[len - 1]) < 8.0) {
                --len;
            }
            if (len <= 2) continue;
            double area = poly.getArea();
            if (area < this.smallestPoly) {
                if (numIgnored == null) continue;
                numIgnored.increment();
                continue;
            }
            properPolyList.add(poly);
        }
        return properPolyList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShowExtraction
    extends EDialog {
        private List<List<ERectangle>> addedBatchRectangles;
        private List<List<ERectangle>> addedBatchLines;
        private List<String> addedBatchNames;
        private int batchPosition;
        private JLabel comingUp;

        private ShowExtraction(Frame parent, List<List<ERectangle>> addedBatchRectangles, List<List<ERectangle>> addedBatchLines, List<String> addedBatchNames) {
            super(parent, false);
            this.addedBatchRectangles = addedBatchRectangles;
            this.addedBatchLines = addedBatchLines;
            this.addedBatchNames = addedBatchNames;
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Extraction Progress");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ShowExtraction.this.closeDialog();
                }
            });
            this.comingUp = new JLabel("Next step:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.comingUp, gbc);
            JButton prev = new JButton("Prev");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            prev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowExtraction.this.advanceDisplay(false);
                }
            });
            this.getContentPane().add((Component)prev, gbc);
            JButton next = new JButton("Next");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            next.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowExtraction.this.advanceDisplay(true);
                }
            });
            this.getContentPane().add((Component)next, gbc);
            this.batchPosition = -1;
            this.advanceDisplay(true);
            this.getRootPane().setDefaultButton(next);
            this.finishInitialization();
        }

        @Override
        protected void escapePressed() {
            this.closeDialog();
        }

        private void advanceDisplay(boolean forward) {
            if (forward) {
                ++this.batchPosition;
                if (this.batchPosition >= this.addedBatchNames.size()) {
                    this.batchPosition = this.addedBatchNames.size() - 1;
                }
            } else {
                --this.batchPosition;
                if (this.batchPosition < 0) {
                    this.batchPosition = 0;
                }
            }
            this.comingUp.setText("Batch " + (this.batchPosition + 1) + ": " + this.addedBatchNames.get(this.batchPosition));
            this.pack();
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            wnd.clearHighlighting();
            Cell cell = wnd.getCell();
            List<ERectangle> rects = this.addedBatchRectangles.get(this.batchPosition);
            for (ERectangle er : rects) {
                wnd.addHighlightArea(er, cell);
            }
            List<ERectangle> lines = this.addedBatchLines.get(this.batchPosition);
            for (ERectangle er : lines) {
                wnd.addHighlightLine(new Point2D.Double(er.getMinX(), er.getMinY()), new Point2D.Double(er.getMaxX(), er.getMaxY()), cell, false, false);
            }
            wnd.finishedHighlighting();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParallelWiresByLength
    implements Comparator<Centerline> {
        private ParallelWiresByLength() {
        }

        @Override
        public int compare(Centerline cl1, Centerline cl2) {
            double cll2;
            double cll1 = cl1.start.distance(cl1.end);
            if (cll1 > (cll2 = cl2.start.distance(cl2.end))) {
                return -1;
            }
            if (cll1 < cll2) {
                return 1;
            }
            if (cl1.width < cl2.width) {
                return -1;
            }
            if (cl1.width > cl2.width) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParallelWiresByWidth
    implements Comparator<Centerline> {
        private ParallelWiresByWidth() {
        }

        @Override
        public int compare(Centerline cl1, Centerline cl2) {
            double cll2;
            if (cl1.width < cl2.width) {
                return 1;
            }
            if (cl1.width > cl2.width) {
                return -1;
            }
            double cll1 = cl1.start.distance(cl1.end);
            if (cll1 > (cll2 = cl2.start.distance(cl2.end))) {
                return -1;
            }
            if (cll1 < cll2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViasBySize
    implements Comparator<PossibleVia> {
        private final EditingPreferences ep;

        private ViasBySize(EditingPreferences ep) {
            this.ep = ep;
        }

        @Override
        public int compare(PossibleVia pv1, PossibleVia pv2) {
            double area1 = 0.0;
            Technology.NodeLayer[] layers1 = pv1.pNp.getNodeLayers();
            double sizeX = pv1.pNp.getDefaultLambdaExtendX(this.ep) * 2.0;
            double sizeY = pv1.pNp.getDefaultLambdaExtendY(this.ep) * 2.0;
            for (int i = 0; i < layers1.length; ++i) {
                Technology.NodeLayer nl = layers1[i];
                if (nl.getLayer().getFunction().isSubstrate()) continue;
                double lowX = nl.getLeftEdge().getMultiplier() * sizeX + nl.getLeftEdge().getAdder();
                double highX = nl.getRightEdge().getMultiplier() * sizeX + nl.getRightEdge().getAdder();
                double lowY = nl.getBottomEdge().getMultiplier() * sizeY + nl.getBottomEdge().getAdder();
                double highY = nl.getTopEdge().getMultiplier() * sizeY + nl.getTopEdge().getAdder();
                area1 += (highX - lowX) * (highY - lowY);
            }
            double area2 = 0.0;
            Technology.NodeLayer[] layers2 = pv2.pNp.getNodeLayers();
            sizeX = pv2.pNp.getDefaultLambdaExtendX(this.ep) * 2.0;
            sizeY = pv2.pNp.getDefaultLambdaExtendY(this.ep) * 2.0;
            for (int i = 0; i < layers2.length; ++i) {
                Technology.NodeLayer nl = layers2[i];
                if (nl.getLayer().getFunction().isSubstrate()) continue;
                double lowX = nl.getLeftEdge().getMultiplier() * sizeX + nl.getLeftEdge().getAdder();
                double highX = nl.getRightEdge().getMultiplier() * sizeX + nl.getRightEdge().getAdder();
                double lowY = nl.getBottomEdge().getMultiplier() * sizeY + nl.getBottomEdge().getAdder();
                double highY = nl.getTopEdge().getMultiplier() * sizeY + nl.getTopEdge().getAdder();
                area2 += (highX - lowX) * (highY - lowY);
            }
            if (area1 == area2) {
                return 0;
            }
            if (area1 < area2) {
                return 1;
            }
            return -1;
        }
    }

    private static class CutBound
    implements RTBounds {
        private PolyBase cut;

        CutBound(PolyBase cut) {
            this.cut = cut;
        }

        public Rectangle2D getBounds() {
            return this.cut.getBounds2D();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CutsByLocation
    implements Comparator<PolyBase> {
        private CutsByLocation() {
        }

        @Override
        public int compare(PolyBase pb1, PolyBase pb2) {
            double pb1x = pb1.getCenterX();
            double pb1y = pb1.getCenterY();
            double pb2x = pb2.getCenterX();
            double pb2y = pb2.getCenterY();
            if (pb1x < pb2x) {
                return 1;
            }
            if (pb1x > pb2x) {
                return -1;
            }
            if (pb1y < pb2y) {
                return 1;
            }
            if (pb1y > pb2y) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CutInfo {
        private Map<PolyBase, CutBound> cutMap = new HashMap<PolyBase, CutBound>();
        private List<PolyBase> justCuts = new ArrayList<PolyBase>();
        private RTNode cutOrg = RTNode.makeTopLevel();

        public List<PolyBase> getCuts() {
            return this.justCuts;
        }

        public int getNumCuts() {
            return this.justCuts.size();
        }

        public PolyBase getFirstCut() {
            return this.justCuts.get(0);
        }

        public RTNode getRTree() {
            return this.cutOrg;
        }

        public void sortCuts() {
            Collections.sort(this.justCuts, new CutsByLocation());
        }

        public void addCut(PolyBase cut) {
            CutBound cb = new CutBound(cut);
            this.cutOrg = RTNode.linkGeom(null, this.cutOrg, cb);
            this.cutMap.put(cut, cb);
            this.justCuts.add(cut);
        }

        public void removeCut(PolyBase cut) {
            CutBound cb = this.cutMap.get(cut);
            this.cutOrg = RTNode.unLinkGeom(null, this.cutOrg, cb);
            this.cutMap.remove(cut);
            this.justCuts.remove(cut);
        }
    }

    private static class PossibleVia {
        PrimitiveNode pNp;
        int rotation;
        double minWidth;
        double minHeight;
        double multicutSep1D;
        double multicutSep2D;
        double multicutSizeX;
        double multicutSizeY;
        Layer[] layers;
        double[] shrinkL;
        double[] shrinkR;
        double[] shrinkT;
        double[] shrinkB;

        PossibleVia(PrimitiveNode pNp, int numLayers) {
            this.pNp = pNp;
            this.rotation = 0;
            this.layers = new Layer[numLayers];
            this.shrinkL = new double[numLayers];
            this.shrinkR = new double[numLayers];
            this.shrinkT = new double[numLayers];
            this.shrinkB = new double[numLayers];
        }
    }

    private static class Centerline {
        Point2D start;
        Point2D end;
        EPoint startUnscaled;
        EPoint endUnscaled;
        boolean startHub;
        boolean endHub;
        double width;
        boolean handled;
        int angle;

        Centerline(double width, Point2D start, Point2D end) {
            this.width = width;
            this.start = start;
            this.startUnscaled = new EPoint(start.getX() / 400.0, start.getY() / 400.0);
            this.endUnscaled = new EPoint(end.getX() / 400.0, end.getY() / 400.0);
            this.end = end;
            this.endHub = false;
            this.startHub = false;
            this.angle = start.equals(end) ? -1 : GenMath.figureAngle(end, start);
        }

        void setStart(double x, double y) {
            this.start.setLocation(x, y);
            this.startUnscaled = new EPoint(x / 400.0, y / 400.0);
        }

        void setEnd(double x, double y) {
            this.end.setLocation(x, y);
            this.endUnscaled = new EPoint(x / 400.0, y / 400.0);
        }

        Rectangle2D getBounds() {
            if (this.start.getX() == this.end.getX()) {
                double minX = (this.start.getX() < this.end.getX() ? this.start.getX() : this.end.getX()) - this.width / 2.0;
                double minY = this.start.getY() < this.end.getY() ? this.start.getY() : this.end.getY();
                double maxY = this.start.getY() > this.end.getY() ? this.start.getY() : this.end.getY();
                return new Rectangle2D.Double(minX, minY, this.width, maxY - minY);
            }
            if (this.start.getY() == this.end.getY()) {
                double minY = (this.start.getY() < this.end.getY() ? this.start.getY() : this.end.getY()) - this.width / 2.0;
                double minX = this.start.getX() < this.end.getX() ? this.start.getX() : this.end.getX();
                double maxX = this.start.getX() > this.end.getX() ? this.start.getX() : this.end.getX();
                return new Rectangle2D.Double(minX, minY, maxX - minX, this.width);
            }
            return null;
        }

        public String toString() {
            return "CENTERLINE from (" + TextUtils.formatDouble(this.start.getX() / 400.0) + "," + TextUtils.formatDouble(this.start.getY() / 400.0) + ") to (" + TextUtils.formatDouble(this.end.getX() / 400.0) + "," + TextUtils.formatDouble(this.end.getY() / 400.0) + ") wid=" + TextUtils.formatDouble(this.width / 400.0) + ", len=" + TextUtils.formatDouble(this.start.distance(this.end) / 400.0);
        }
    }

    private static class ExportedPin {
        Point2D location;
        NodeInst ni;
        AffineTransform trans;

        ExportedPin(NodeInst ni, Point2D location, AffineTransform trans) {
            this.ni = ni;
            this.location = location;
            this.trans = trans;
        }
    }

    private static class ExtractJob
    extends Job {
        private Cell cell;
        private Cell newCell;
        private boolean recursive;
        private double smallestPolygonSize;
        private int activeHandling;
        private String expansionPattern;
        private boolean gridAlignExtraction;
        private boolean approximateCuts;
        private boolean flattenPcells;
        private List<List<ERectangle>> addedBatchRectangles;
        private List<List<ERectangle>> addedBatchLines;
        private List<String> addedBatchNames;
        private ErrorLogger errorLogger;

        private ExtractJob(Cell cell, boolean recursive) {
            super("Extract Connectivity from " + cell, Extract.getExtractTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.recursive = recursive;
            this.errorLogger = ErrorLogger.newInstance("Extraction Tool on cell " + cell.getName());
            this.smallestPolygonSize = Extract.isIgnoreTinyPolygons() ? Extract.getSmallestPolygonSize() : 0.0;
            this.activeHandling = Extract.getActiveHandling();
            this.expansionPattern = Extract.getCellExpandPattern().trim();
            this.gridAlignExtraction = Extract.isGridAlignExtraction();
            this.approximateCuts = Extract.isApproximateCuts();
            this.flattenPcells = Extract.isFlattenPcells();
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Pattern pat = null;
            if (this.expansionPattern.length() > 0) {
                try {
                    pat = Pattern.compile(this.expansionPattern, 2);
                }
                catch (PatternSyntaxException e) {
                    System.out.println("Pattern syntax error on '" + this.expansionPattern + "': " + e.getMessage());
                }
            }
            Job.getUserInterface().startProgressDialog("Extracting", null);
            Connectivity c = new Connectivity(this.cell, this, this.errorLogger, this.smallestPolygonSize, this.activeHandling, this.gridAlignExtraction, this.approximateCuts, this.recursive, pat);
            if (this.recursive) {
                c.totalCells = c.countExtracted(this.cell, pat, this.flattenPcells);
            }
            c.cellsExtracted = 0;
            this.newCell = c.doExtract(this.cell, this.recursive, pat, this.flattenPcells, true, this, this.addedBatchRectangles, this.addedBatchLines, this.addedBatchNames);
            if (this.newCell == null) {
                System.out.println("ERROR: Extraction of cell " + this.cell.describe(false) + " failed");
            }
            Job.getUserInterface().stopProgressDialog();
            this.fieldVariableChanged("addedBatchRectangles");
            this.fieldVariableChanged("addedBatchLines");
            this.fieldVariableChanged("addedBatchNames");
            this.fieldVariableChanged("newCell");
            this.fieldVariableChanged("errorLogger");
            return true;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.displayCell(this.newCell);
            Job.getUserInterface().termLogging(this.errorLogger, false, false);
            if (this.newCell != null) {
                Iterator<NodeInst> it = this.newCell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    PrimitiveNode.Function fun = ni.getFunction();
                    if (fun != PrimitiveNode.Function.NODE) continue;
                    wnd.addElectricObject(ni, this.newCell);
                }
            } else {
                System.out.println("Extraction job was aborted");
            }
        }
    }
}

