/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParasiticTab
extends PreferencePanel {
    private JCheckBox backannotateLayout;
    private ButtonGroup exemptedNetsGroup;
    private JCheckBox extractC;
    private JRadioButton extractExemptedNets;
    private JCheckBox extractPowerGround;
    private JCheckBox extractR;
    private JRadioButton ignoreExemptedNets;
    private JLabel maxDist;
    private JTextField maxDistValue;
    private JPanel parasiticPanel;
    private JPanel simpleParasiticOptions;
    private JPanel topPanel;
    private JCheckBox useExemptedNetsFile;
    private JCheckBox verboseNaming;

    public ParasiticTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.topPanel;
    }

    public String getName() {
        return "Parasitic";
    }

    public void init() {
        this.verboseNaming.setSelected(Simulation.isParasiticsUseVerboseNaming());
        this.backannotateLayout.setSelected(Simulation.isParasiticsBackAnnotateLayout());
        this.extractPowerGround.setSelected(Simulation.isParasiticsExtractPowerGround());
        this.extractPowerGround.setEnabled(false);
        this.useExemptedNetsFile.setSelected(Simulation.isParasiticsUseExemptedNetsFile());
        this.ignoreExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.extractExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.ignoreExemptedNets.setSelected(Simulation.isParasiticsIgnoreExemptedNets());
        this.extractExemptedNets.setSelected(!Simulation.isParasiticsIgnoreExemptedNets());
        this.extractR.setSelected(Simulation.isParasiticsExtractsR());
        this.extractC.setSelected(Simulation.isParasiticsExtractsC());
        this.maxDistValue.setText(TextUtils.formatDouble(ParasiticTool.getMaxDistance()));
        this.parasiticPanel.setVisible(false);
    }

    public void term() {
        ParasiticTool.setMaxDistance(Double.parseDouble(this.maxDistValue.getText()));
        boolean b = this.verboseNaming.isSelected();
        if (b != Simulation.isParasiticsUseVerboseNaming()) {
            Simulation.setParasiticsUseVerboseNaming(b);
        }
        if ((b = this.backannotateLayout.isSelected()) != Simulation.isParasiticsBackAnnotateLayout()) {
            Simulation.setParasiticsBackAnnotateLayout(b);
        }
        if ((b = this.extractPowerGround.isSelected()) != Simulation.isParasiticsExtractPowerGround()) {
            Simulation.setParasiticsExtractPowerGround(b);
        }
        if ((b = this.useExemptedNetsFile.isSelected()) != Simulation.isParasiticsUseExemptedNetsFile()) {
            Simulation.setParasiticsUseExemptedNetsFile(b);
        }
        b = this.ignoreExemptedNets.isSelected();
        Simulation.setParasiticsIgnoreExemptedNets(b);
        b = this.extractR.isSelected();
        if (b != Simulation.isParasiticsExtractsR()) {
            Simulation.setParasiticsExtractsR(b);
        }
        if ((b = this.extractC.isSelected()) != Simulation.isParasiticsExtractsC()) {
            Simulation.setParasiticsExtractsC(b);
        }
    }

    public void reset() {
        if (Simulation.isFactoryParasiticsUseVerboseNaming() != Simulation.isParasiticsUseVerboseNaming()) {
            Simulation.setParasiticsUseVerboseNaming(Simulation.isFactoryParasiticsUseVerboseNaming());
        }
        if (Simulation.isFactoryParasiticsBackAnnotateLayout() != Simulation.isParasiticsBackAnnotateLayout()) {
            Simulation.setParasiticsBackAnnotateLayout(Simulation.isFactoryParasiticsBackAnnotateLayout());
        }
        if (Simulation.isFactoryParasiticsExtractPowerGround() != Simulation.isParasiticsExtractPowerGround()) {
            Simulation.setParasiticsExtractPowerGround(Simulation.isFactoryParasiticsExtractPowerGround());
        }
        if (Simulation.isFactoryParasiticsUseExemptedNetsFile() != Simulation.isParasiticsUseExemptedNetsFile()) {
            Simulation.setParasiticsUseExemptedNetsFile(Simulation.isFactoryParasiticsUseExemptedNetsFile());
        }
        if (Simulation.isFactoryParasiticsIgnoreExemptedNets() != Simulation.isParasiticsIgnoreExemptedNets()) {
            Simulation.setParasiticsIgnoreExemptedNets(Simulation.isFactoryParasiticsIgnoreExemptedNets());
        }
        if (Simulation.isFactoryParasiticsExtractsR() != Simulation.isParasiticsExtractsR()) {
            Simulation.setParasiticsExtractsR(Simulation.isFactoryParasiticsExtractsR());
        }
        if (Simulation.isFactoryParasiticsExtractsC() != Simulation.isParasiticsExtractsC()) {
            Simulation.setParasiticsExtractsC(Simulation.isFactoryParasiticsExtractsC());
        }
        if (ParasiticTool.getFactoryMaxDistance() != ParasiticTool.getMaxDistance()) {
            ParasiticTool.setMaxDistance(ParasiticTool.getFactoryMaxDistance());
        }
    }

    private void initComponents() {
        this.exemptedNetsGroup = new ButtonGroup();
        this.topPanel = new JPanel();
        this.parasiticPanel = new JPanel();
        this.maxDist = new JLabel();
        this.maxDistValue = new JTextField();
        this.simpleParasiticOptions = new JPanel();
        this.verboseNaming = new JCheckBox();
        this.backannotateLayout = new JCheckBox();
        this.extractPowerGround = new JCheckBox();
        this.useExemptedNetsFile = new JCheckBox();
        this.ignoreExemptedNets = new JRadioButton();
        this.extractExemptedNets = new JRadioButton();
        this.extractR = new JCheckBox();
        this.extractC = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.topPanel.setLayout(new GridBagLayout());
        this.parasiticPanel.setBorder(BorderFactory.createTitledBorder("Parasitic Coupling Options"));
        this.parasiticPanel.setEnabled(false);
        this.parasiticPanel.setLayout(new GridBagLayout());
        this.maxDist.setText("Maximum distance (lambda)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDist, gridBagConstraints);
        this.maxDistValue.setColumns(6);
        this.maxDistValue.setText("20");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parasiticPanel.add((Component)this.maxDistValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.parasiticPanel, gridBagConstraints);
        this.simpleParasiticOptions.setBorder(BorderFactory.createTitledBorder("Simple Parasitic Options"));
        this.simpleParasiticOptions.setLayout(new GridBagLayout());
        this.verboseNaming.setText("Use Verbose Naming");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.verboseNaming, gridBagConstraints);
        this.backannotateLayout.setText("Back-Annotate Layout");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.backannotateLayout, gridBagConstraints);
        this.extractPowerGround.setText("Extract Power/Ground");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.extractPowerGround, gridBagConstraints);
        this.useExemptedNetsFile.setText("Use exemptedNets.txt file");
        this.useExemptedNetsFile.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ParasiticTab.this.useExemptedNetsFileStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.useExemptedNetsFile, gridBagConstraints);
        this.exemptedNetsGroup.add(this.ignoreExemptedNets);
        this.ignoreExemptedNets.setText("Extract everything except exempted nets");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.simpleParasiticOptions.add((Component)this.ignoreExemptedNets, gridBagConstraints);
        this.exemptedNetsGroup.add(this.extractExemptedNets);
        this.extractExemptedNets.setText("Extract only exempted nets");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.simpleParasiticOptions.add((Component)this.extractExemptedNets, gridBagConstraints);
        this.extractR.setText("Extract R");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.extractR, gridBagConstraints);
        this.extractC.setText("Extract C");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.simpleParasiticOptions.add((Component)this.extractC, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.simpleParasiticOptions, gridBagConstraints);
        this.getContentPane().add((Component)this.topPanel, new GridBagConstraints());
        this.pack();
    }

    private void useExemptedNetsFileStateChanged(ChangeEvent evt) {
        this.ignoreExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
        this.extractExemptedNets.setEnabled(this.useExemptedNetsFile.isSelected());
    }

    public static void main(String[] args) {
        new ParasiticTab((Frame)new JFrame(), true).setVisible(true);
    }
}

