/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;

public class GeometrySearch
extends HierarchyEnumerator.Visitor {
    private boolean found = false;
    private ERectangle geomBBnd;
    private Geometric foundElement = null;
    private VarContext context = VarContext.globalContext;
    private boolean visibleObjectsOnly;
    private HashMap<PrimitiveNode, Boolean> cacheVisibilityNodes = new HashMap();
    private HashMap<ArcProto, Boolean> cacheVisibilityArcs = new HashMap();
    private int cellsProcessed;

    public boolean searchGeometries(Cell cell, EPoint point, boolean visibleObjectsOnly) {
        this.found = false;
        this.geomBBnd = ERectangle.fromLambda(point.getX(), point.getY(), 0.0, 0.0);
        this.foundElement = null;
        this.context = VarContext.globalContext;
        this.visibleObjectsOnly = visibleObjectsOnly;
        this.cacheVisibilityArcs.clear();
        this.cacheVisibilityNodes.clear();
        this.cellsProcessed = 0;
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, this);
        return this.found;
    }

    public boolean foundGeometry() {
        return this.found;
    }

    public Geometric getGeometricFound() {
        return this.foundElement;
    }

    public VarContext getContext() {
        return this.context;
    }

    public int getCellsProcessed() {
        return this.cellsProcessed;
    }

    public String describeFoundGeometry() {
        String contextstr = "current cell";
        if (this.context != VarContext.globalContext) {
            contextstr = this.context.getInstPath(".");
        }
        return "Element " + this.foundElement + " in " + contextstr;
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.found) {
            return false;
        }
        Cell cell = info.getCell();
        AffineTransform xformToRoot = null;
        try {
            xformToRoot = info.getTransformToRoot().createInverse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assert (xformToRoot != null);
        Rectangle2D.Double rect = new Rectangle2D.Double();
        ((Rectangle2D)rect).setRect(this.geomBBnd);
        DBMath.transformRect(rect, xformToRoot);
        ++this.cellsProcessed;
        boolean continueDown = false;
        Iterator<RTBounds> it = cell.searchIterator(rect, false);
        while (it.hasNext()) {
            Geometric geom = (Geometric)it.next();
            if (geom instanceof NodeInst) {
                NodeInst oNi = (NodeInst)geom;
                if (oNi.isCellInstance()) {
                    continueDown = true;
                    continue;
                }
                PrimitiveNode node = (PrimitiveNode)oNi.getProto();
                if (this.visibleObjectsOnly && !this.isNodeVisible(node)) continue;
                this.foundElement = geom;
                this.context = info.getContext();
                this.found = true;
                continue;
            }
            ArcProto ap = ((ArcInst)geom).getProto();
            if (this.visibleObjectsOnly && !this.isArcVisible(ap)) continue;
            this.foundElement = geom;
            this.context = info.getContext();
            this.found = true;
        }
        if (this.found) {
            return false;
        }
        return continueDown;
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    @Override
    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        if (this.found) {
            return false;
        }
        return !this.visibleObjectsOnly || no.getNodeInst().isExpanded();
    }

    private boolean isNodeVisible(PrimitiveNode node) {
        Boolean b = this.cacheVisibilityNodes.get(node);
        if (b == null) {
            boolean visible = false;
            Iterator<Layer> it2 = node.getLayerIterator();
            while (it2.hasNext()) {
                Layer lay = it2.next();
                if (!lay.isVisible()) continue;
                visible = true;
                break;
            }
            b = new Boolean(visible);
            this.cacheVisibilityNodes.put(node, b);
        }
        return b;
    }

    private boolean isArcVisible(ArcProto arc) {
        Boolean b = this.cacheVisibilityArcs.get(arc);
        if (b == null) {
            boolean visible = false;
            Iterator<Layer> it2 = arc.getLayerIterator();
            while (it2.hasNext()) {
                Layer lay = it2.next();
                if (!lay.isVisible()) continue;
                visible = true;
                break;
            }
            b = new Boolean(visible);
            this.cacheVisibilityArcs.put(arc, b);
        }
        return b;
    }
}

