/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import java.awt.Color;
import java.io.PrintWriter;

public class PrimitivePort
implements PortProtoId,
PortProto,
Comparable<PrimitivePort> {
    private Name name;
    private PrimitiveNode parent;
    private int portIndex;
    private ArcProto[] portArcs;
    private EdgeH left;
    private EdgeV bottom;
    private EdgeH right;
    private EdgeV top;
    private PortCharacteristic characteristic;
    private int angle;
    private int angleRange;
    private int portTopology;
    private boolean isolated;
    private boolean negatable;

    private PrimitivePort(Technology tech, PrimitiveNode parent, ArcProto[] portArcs, String protoName, int portAngle, int portRange, int portTopology, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
        this.parent = parent;
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("PrimitivePort name " + protoName + " is not safe to write into JELIB");
        }
        this.name = Name.findName(protoName);
        this.setAngle(portAngle);
        this.setAngleRange(portRange);
        this.portTopology = portTopology;
        this.portArcs = portArcs;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
        this.negatable = false;
    }

    void setPortIndex(PrimitiveNode parent, int portIndex) {
        this.parent = parent;
        this.portIndex = portIndex;
    }

    public static PrimitivePort newInstance(Technology tech, PrimitiveNode parent, ArcProto[] portArcs, String protoName, int portAngle, int portRange, int portTopology, PortCharacteristic characteristic, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
        if (parent == null) {
            System.out.println("PrimitivePort " + protoName + " has no parent");
        }
        if (tech != Generic.tech && Generic.tech != null) {
            ArcProto[] realPortArcs = new ArcProto[portArcs.length + 3];
            for (int i = 0; i < portArcs.length; ++i) {
                realPortArcs[i] = portArcs[i];
            }
            realPortArcs[portArcs.length] = Generic.tech.universal_arc;
            realPortArcs[portArcs.length + 1] = Generic.tech.invisible_arc;
            realPortArcs[portArcs.length + 2] = Generic.tech.unrouted_arc;
            portArcs = realPortArcs;
        }
        PrimitivePort pp = new PrimitivePort(tech, parent, portArcs, protoName, portAngle, portRange, portTopology, left, bottom, right, top);
        pp.characteristic = characteristic;
        return pp;
    }

    @Override
    public PrimitivePort inDatabase(EDatabase database) {
        return this;
    }

    @Override
    public PrimitivePort getId() {
        return this;
    }

    @Override
    public Name getNameKey() {
        return this.name;
    }

    @Override
    public Name getNameKey(Snapshot snapshot) {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public String getName(Snapshot snapshot) {
        return this.name.toString();
    }

    @Override
    public PrimitiveNode getParentId() {
        return this.parent;
    }

    @Override
    public PrimitiveNode getParent() {
        return this.parent;
    }

    @Override
    public int getPortIndex() {
        return this.portIndex;
    }

    @Override
    public int getChronIndex() {
        return this.portIndex;
    }

    public void setConnections(ArcProto[] portArcs) {
        this.portArcs = portArcs;
    }

    public ArcProto[] getConnections() {
        return this.portArcs;
    }

    @Override
    public PrimitivePort getBasePort() {
        return this;
    }

    public EdgeH getLeft() {
        return this.left;
    }

    public EdgeH getRight() {
        return this.right;
    }

    public EdgeV getTop() {
        return this.top;
    }

    public EdgeV getBottom() {
        return this.bottom;
    }

    @Override
    public PortCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    @Override
    public boolean isPower() {
        return this.characteristic == PortCharacteristic.PWR;
    }

    @Override
    public boolean isGround() {
        return this.characteristic == PortCharacteristic.GND;
    }

    public boolean isNamedGround() {
        String name = TextUtils.canonicString(this.getName());
        if (name.indexOf("vss") >= 0) {
            return true;
        }
        if (name.indexOf("gnd") >= 0) {
            return true;
        }
        return name.indexOf("ground") >= 0;
    }

    public int getAngle() {
        return this.angle;
    }

    void setAngle(int angle) {
        this.angle = angle;
    }

    public int getAngleRange() {
        return this.angleRange;
    }

    void setAngleRange(int angleRange) {
        this.angleRange = angleRange;
    }

    public int getTopology() {
        return this.portTopology;
    }

    public void setIsolated() {
        this.isolated = true;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public boolean isNegatable() {
        return this.negatable;
    }

    public void setNegatable(boolean negatable) {
        this.negatable = negatable;
    }

    @Override
    public boolean connectsTo(ArcProto arc) {
        for (int i = 0; i < this.portArcs.length; ++i) {
            if (this.portArcs[i] != arc) continue;
            return true;
        }
        return false;
    }

    public Color getPortColor() {
        Technology tech = this.getParent().getTechnology();
        int numColors = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < this.portArcs.length; ++i) {
            ArcProto ap = this.portArcs[i];
            if (ap.getTechnology() != tech) continue;
            Layer layer = ap.getLayer(0);
            EGraphics graphics = layer.getGraphics();
            Color layerCol = graphics.getColor();
            r += layerCol.getRed();
            g += layerCol.getGreen();
            b += layerCol.getBlue();
            ++numColors;
        }
        if (numColors == 0) {
            return null;
        }
        return new Color(r / numColors, g / numColors, b / numColors);
    }

    @Override
    public int compareTo(PrimitivePort that) {
        int cmp;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        return this.portIndex - that.portIndex;
    }

    public String toString() {
        return "PrimitivePort " + this.getName();
    }

    void dump(PrintWriter out) {
        out.println("\tport " + this.getName() + " angle=" + this.getAngle() + " range=" + this.getAngleRange() + " topology=" + this.getTopology() + " " + (Object)((Object)this.getCharacteristic()));
        out.println("\t\tlm=" + this.left.getMultiplier() + " la=" + this.left.getAdder() + " rm=" + this.right.getMultiplier() + " ra=" + this.right.getAdder() + " bm=" + this.bottom.getMultiplier() + " ba=" + this.bottom.getAdder() + " tm=" + this.top.getMultiplier() + " ta=" + this.top.getAdder());
        out.println("\t\tisolated=" + this.isolated + " negatable=" + this.negatable);
        for (ArcProto ap : this.portArcs) {
            out.println("\t\tportArc " + ap.getName());
        }
    }
}

