/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.LibId;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.output.Output;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JELIB
extends Output {
    private boolean oldRevision;
    Snapshot snapshot;
    private Map<LibId, URL> libFiles;
    private HashMap<CellId, String> cellNames = new HashMap();

    JELIB() {
    }

    protected boolean writeLib(Snapshot snapshot, LibId libId, Map<LibId, URL> libFiles, boolean oldRevision) {
        try {
            this.oldRevision = oldRevision;
            this.libFiles = libFiles;
            this.writeTheLibrary(snapshot, libId);
            return false;
        }
        catch (IOException e) {
            System.out.println("End of file reached while writing " + this.filePath);
            return true;
        }
    }

    private void writeTheLibrary(Snapshot snapshot, LibId libId) throws IOException {
        this.snapshot = snapshot;
        LibraryBackup libBackup = snapshot.getLib(libId);
        BitSet usedLibs = new BitSet();
        HashMap<CellId, BitSet> usedExports = new HashMap<CellId, BitSet>();
        TreeMap<CellName, CellBackup> sortedCells = new TreeMap<CellName, CellBackup>();
        libBackup.gatherUsages(usedLibs, usedExports);
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null || cellBackup.d.libId != libId) continue;
            sortedCells.put(cellBackup.d.cellName, cellBackup);
            cellBackup.gatherUsages(usedLibs, usedExports);
        }
        this.gatherLibs(usedLibs, usedExports);
        this.printWriter.println("# header information:");
        Version version = this.oldRevision ? Version.parseVersion("8.04k") : Version.getVersion();
        this.printWriter.print("H" + this.convertString(libBackup.d.libId.libName) + "|" + version);
        this.printlnVars(libBackup.d);
        boolean viewHeaderPrinted = false;
        HashSet<View> usedViews = new HashSet<View>();
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null || cellBackup.d.libId != libId && !usedExports.containsKey(cellBackup.d.cellId)) continue;
            usedViews.add(cellBackup.d.cellName.getView());
        }
        Iterator<View> it = View.getViews();
        while (it.hasNext()) {
            View view = it.next();
            if (!usedViews.contains(view)) continue;
            if (!viewHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Views:");
                viewHeaderPrinted = true;
            }
            this.printWriter.println("V" + this.convertString(view.getFullName()) + "|" + this.convertString(view.getAbbreviation()));
        }
        this.writeExternalLibraryInfo(libId, usedLibs, usedExports);
        boolean toolHeaderPrinted = false;
        Iterator<Tool> it2 = Tool.getTools();
        while (it2.hasNext()) {
            Tool tool = it2.next();
            if (Pref.getMeaningVariables(tool).size() == 0) continue;
            if (!toolHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Tools:");
                toolHeaderPrinted = true;
            }
            this.printWriter.print("O" + this.convertString(tool.getName()));
            this.printlnMeaningPrefs(tool);
        }
        boolean technologyHeaderPrinted = false;
        Iterator<Technology> it3 = Technology.getTechnologies();
        while (it3.hasNext()) {
            Technology tech = it3.next();
            if (Pref.getMeaningVariables(tech).size() == 0) continue;
            if (!technologyHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Technologies:");
                technologyHeaderPrinted = true;
            }
            this.printWriter.print("T" + this.convertString(tech.getTechName()));
            this.printlnMeaningPrefs(tech);
        }
        ArrayList<CellGroup> chronGroups = new ArrayList<CellGroup>();
        ArrayList<CellGroup> sortedGroups = new ArrayList<CellGroup>();
        for (CellBackup cellBackup : sortedCells.values()) {
            CellName cellName = cellBackup.d.cellName;
            this.cellNames.put(cellBackup.d.cellId, this.convertString(cellName.toString()));
            int groupIndex = snapshot.cellGroups[cellBackup.d.cellId.cellIndex];
            while (groupIndex >= chronGroups.size()) {
                chronGroups.add(null);
            }
            CellGroup group = (CellGroup)chronGroups.get(groupIndex);
            if (group == null) {
                group = new CellGroup();
                chronGroups.set(groupIndex, group);
                sortedGroups.add(group);
            }
            group.cellNames.add(cellName);
            if (cellName.getView() != View.SCHEMATIC || group.mainSchematics != null) continue;
            group.mainSchematics = cellName;
        }
        for (CellBackup cellBackup : sortedCells.values()) {
            this.writeCell(cellBackup);
        }
        this.printWriter.println();
        this.printWriter.println("# Groups:");
        for (CellGroup group : sortedGroups) {
            this.writeCellGroup(group);
        }
    }

    void writeCellGroup(CellGroup group) {
        this.printWriter.print("G");
        if (group.mainSchematics != null) {
            this.printWriter.print(this.convertString(group.mainSchematics.toString()));
        }
        for (CellName cellName : group.cellNames) {
            if (cellName.equals(group.mainSchematics)) continue;
            this.printWriter.print("|" + cellName);
        }
        this.printWriter.println();
    }

    void writeCell(CellBackup cellBackup) {
        ImmutableCell d = cellBackup.d;
        this.printWriter.println();
        this.printWriter.println("# Cell " + d.cellName);
        this.printWriter.print("C" + this.convertString(d.cellName.toString()));
        if (!this.oldRevision) {
            this.printWriter.print("|");
            String cellGroupName = d.groupName.getName();
            if (!cellGroupName.equals(d.cellName.getName())) {
                this.printWriter.print(this.convertString(cellGroupName));
            }
        }
        this.printWriter.print("|" + this.convertString(d.tech.getTechName()));
        this.printWriter.print("|" + d.creationDate);
        this.printWriter.print("|" + cellBackup.revisionDate);
        StringBuilder cellBits = new StringBuilder();
        if ((d.flags & 0x400000) != 0) {
            cellBits.append("C");
        }
        if ((d.flags & 2) != 0 || d.cellName.getView() == View.ICON) {
            cellBits.append("E");
        }
        if ((d.flags & 0x200000) != 0) {
            cellBits.append("I");
        }
        if ((d.flags & 0x100000) != 0) {
            cellBits.append("L");
        }
        if ((d.flags & 0x800000) != 0) {
            cellBits.append("T");
        }
        this.printWriter.print("|" + cellBits.toString());
        this.printlnVars(d);
        ArrayList<String> nodeNames = new ArrayList<String>();
        Name prevNodeName = null;
        int duplicate = 0;
        for (ImmutableNodeInst n : cellBackup.nodes) {
            byte ts;
            int angle;
            String diskNodeName;
            NodeProtoId np = n.protoId;
            if (np instanceof CellId) {
                this.printWriter.print("I" + this.cellNames.get(np));
            } else {
                PrimitiveNode prim = (PrimitiveNode)np;
                if (d.tech == prim.getTechnology()) {
                    this.printWriter.print("N" + this.convertString(prim.getName()));
                } else {
                    this.printWriter.print("N" + this.convertString(prim.getFullName()));
                }
            }
            if (n.name != prevNodeName) {
                prevNodeName = n.name;
                duplicate = 0;
                diskNodeName = this.convertString(n.name.toString());
            } else {
                diskNodeName = "\"" + this.convertQuotedString(n.name.toString()) + "\"" + ++duplicate;
            }
            int nodeId = n.nodeId;
            while (nodeId >= nodeNames.size()) {
                nodeNames.add(null);
            }
            nodeNames.set(nodeId, diskNodeName);
            this.printWriter.print("|" + diskNodeName + "|");
            if (!n.name.isTempname()) {
                this.printWriter.print(this.describeDescriptor(null, n.nameDescriptor));
            }
            this.printWriter.print("|" + TextUtils.formatDouble(n.anchor.getX(), 0));
            this.printWriter.print("|" + TextUtils.formatDouble(n.anchor.getY(), 0));
            if (!(np instanceof CellId)) {
                this.printWriter.print("|" + TextUtils.formatDouble(n.width, 0));
                this.printWriter.print("|" + TextUtils.formatDouble(n.height, 0));
            }
            this.printWriter.print('|');
            if (n.orient.isXMirrored()) {
                this.printWriter.print('X');
            }
            if (n.orient.isYMirrored()) {
                this.printWriter.print('Y');
            }
            if ((angle = n.orient.getAngle() % 3600) == 900 || angle == -2700) {
                this.printWriter.print("R");
            } else if (angle == 1800 || angle == -1800) {
                this.printWriter.print("RR");
            } else if (angle == 2700 || angle == -900) {
                this.printWriter.print("RRR");
            } else if (angle != 0) {
                this.printWriter.print(angle);
            }
            StringBuilder nodeBits = new StringBuilder();
            if (n.is(ImmutableNodeInst.HARD_SELECT)) {
                nodeBits.append("A");
            }
            if (n.is(ImmutableNodeInst.LOCKED)) {
                nodeBits.append("L");
            }
            if (n.is(ImmutableNodeInst.VIS_INSIDE)) {
                nodeBits.append("V");
            }
            if ((ts = n.techBits) != 0) {
                nodeBits.append(ts);
            }
            this.printWriter.print("|" + nodeBits.toString());
            if (np instanceof CellId) {
                String tdString = this.describeDescriptor(null, n.protoDescriptor);
                this.printWriter.print("|" + tdString);
            }
            this.printlnVars(n);
        }
        for (ImmutableArcInst a : cellBackup.arcs) {
            ArcProto ap = a.protoType;
            if (cellBackup.d.tech == ap.getTechnology()) {
                this.printWriter.print("A" + this.convertString(ap.getName()));
            } else {
                this.printWriter.print("A" + this.convertString(ap.getFullName()));
            }
            this.printWriter.print("|" + this.convertString(a.name.toString()) + "|");
            if (!a.name.isTempname()) {
                this.printWriter.print(this.describeDescriptor(null, a.nameDescriptor));
            }
            this.printWriter.print("|" + TextUtils.formatDouble(a.width, 0));
            StringBuilder arcBits = new StringBuilder();
            if (a.is(ImmutableArcInst.HARD_SELECT)) {
                arcBits.append("A");
            }
            if (a.is(ImmutableArcInst.BODY_ARROWED)) {
                arcBits.append("B");
            }
            if (!a.is(ImmutableArcInst.FIXED_ANGLE)) {
                arcBits.append("F");
            }
            if (a.is(ImmutableArcInst.HEAD_NEGATED)) {
                arcBits.append("G");
            }
            if (!a.is(ImmutableArcInst.HEAD_EXTENDED)) {
                arcBits.append("I");
            }
            if (!a.is(ImmutableArcInst.TAIL_EXTENDED)) {
                arcBits.append("J");
            }
            if (a.is(ImmutableArcInst.TAIL_NEGATED)) {
                arcBits.append("N");
            }
            if (a.is(ImmutableArcInst.RIGID)) {
                arcBits.append("R");
            }
            if (a.is(ImmutableArcInst.SLIDABLE)) {
                arcBits.append("S");
            }
            if (a.is(ImmutableArcInst.HEAD_ARROWED)) {
                arcBits.append("X");
            }
            if (a.is(ImmutableArcInst.TAIL_ARROWED)) {
                arcBits.append("Y");
            }
            this.printWriter.print("|" + arcBits.toString() + a.angle);
            this.printWriter.print("|" + (String)nodeNames.get(a.headNodeId) + "|" + this.getPortName(a.headPortId));
            this.printWriter.print("|" + TextUtils.formatDouble(a.headLocation.getX(), 0));
            this.printWriter.print("|" + TextUtils.formatDouble(a.headLocation.getY(), 0));
            this.printWriter.print("|" + (String)nodeNames.get(a.tailNodeId) + "|" + this.getPortName(a.tailPortId));
            this.printWriter.print("|" + TextUtils.formatDouble(a.tailLocation.getX(), 0));
            this.printWriter.print("|" + TextUtils.formatDouble(a.tailLocation.getY(), 0));
            this.printlnVars(a);
        }
        for (ImmutableExport e : cellBackup.exports) {
            this.printWriter.print("E" + this.convertString(this.getExportName(e)));
            if (!this.oldRevision) {
                this.printWriter.print("|");
                if (!e.name.toString().equals(e.exportId.externalId)) {
                    this.printWriter.print(this.convertString(e.name.toString()));
                }
            }
            this.printWriter.print("|" + this.describeDescriptor(null, e.nameDescriptor));
            this.printWriter.print("|" + (String)nodeNames.get(e.originalNodeId) + "|" + this.getPortName(e.originalPortId));
            this.printWriter.print("|" + e.characteristic.getShortName());
            if (e.alwaysDrawn) {
                this.printWriter.print("/A");
            }
            if (e.bodyOnly) {
                this.printWriter.print("/B");
            }
            this.printlnVars(e);
        }
        this.printWriter.println("X");
    }

    void writeExternalLibraryInfo(LibId thisLib, BitSet usedLibs, HashMap<CellId, BitSet> usedExports) {
        boolean libraryHeaderPrinted = false;
        TreeMap<String, LibraryBackup> sortedLibraries = new TreeMap<String, LibraryBackup>(TextUtils.STRING_NUMBER_ORDER);
        for (LibraryBackup libBackup : this.snapshot.libBackups) {
            if (libBackup == null || !usedLibs.get(libBackup.d.libId.libIndex)) continue;
            sortedLibraries.put(libBackup.d.libId.libName, libBackup);
        }
        String mainLibPath = TextUtils.getFilePath(this.snapshot.getLib((LibId)thisLib).d.libFile);
        if (this.libFiles != null && this.libFiles.containsKey(thisLib)) {
            mainLibPath = TextUtils.getFilePath(this.libFiles.get(thisLib));
        }
        for (LibraryBackup l : sortedLibraries.values()) {
            String thisLibPath;
            if (l.d.libId == thisLib) continue;
            if (!libraryHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# External Libraries and cells:");
                libraryHeaderPrinted = true;
            }
            URL libUrl = l.d.libFile;
            if (this.libFiles != null && this.libFiles.containsKey(l.d.libId)) {
                libUrl = this.libFiles.get(l.d.libId);
            }
            String libFile = l.d.libId.libName;
            if (libUrl != null && !mainLibPath.equals(thisLibPath = TextUtils.getFilePath(libUrl))) {
                libFile = libUrl.toString();
            }
            this.printWriter.println();
            this.printWriter.println("L" + this.convertString(l.d.libId.libName) + "|" + this.convertString(libFile));
            TreeMap<CellName, CellBackup> sortedCells = new TreeMap<CellName, CellBackup>();
            for (CellBackup cellBackup : this.snapshot.cellBackups) {
                if (cellBackup == null || cellBackup.d.libId != l.d.libId || usedExports.get(cellBackup.d.cellId) == null) continue;
                sortedCells.put(cellBackup.d.cellName, cellBackup);
            }
            for (CellBackup cellBackup : sortedCells.values()) {
                CellId cellId = cellBackup.d.cellId;
                BitSet exportsUsedInCell = usedExports.get(cellId);
                ERectangle bounds = this.snapshot.getCellBounds(cellId);
                this.printWriter.print("R" + this.convertString(cellBackup.d.cellName.toString()) + "||||");
                if (this.oldRevision) {
                    this.printWriter.print("|" + cellBackup.d.creationDate + "|" + cellBackup.revisionDate);
                }
                this.printWriter.println();
                this.cellNames.put(cellId, this.getFullCellName(cellId));
                for (ImmutableExport e : cellBackup.exports) {
                    if (!exportsUsedInCell.get(e.exportId.chronIndex)) continue;
                    this.printWriter.println("F" + this.convertString(this.getExportName(e)) + "||");
                }
            }
        }
    }

    void gatherLibs(BitSet usedLibs, Map<CellId, BitSet> usedExports) {
        for (CellId cellId : usedExports.keySet()) {
            usedLibs.set(this.snapshot.getCell((CellId)cellId).d.libId.libIndex);
        }
    }

    private String describeDescriptor(Variable var, TextDescriptor td) {
        AbstractTextDescriptor.Unit unit;
        Object value;
        StringBuffer ret = new StringBuffer();
        boolean display = false;
        if (var == null || td.isDisplay()) {
            display = true;
        }
        if (display) {
            int color;
            AbstractTextDescriptor.Size size = td.getSize();
            if (size.isAbsolute()) {
                ret.append("A" + (int)size.getSize() + ";");
            }
            if (td.isBold()) {
                ret.append("B");
            }
            if ((color = td.getColorIndex()) != 0) {
                ret.append("C" + color + ";");
            }
            ret.append("D");
            AbstractTextDescriptor.Position pos = td.getPos();
            if (pos == AbstractTextDescriptor.Position.UP) {
                ret.append("8");
            } else if (pos == AbstractTextDescriptor.Position.DOWN) {
                ret.append("2");
            } else if (pos == AbstractTextDescriptor.Position.LEFT) {
                ret.append("4");
            } else if (pos == AbstractTextDescriptor.Position.RIGHT) {
                ret.append("6");
            } else if (pos == AbstractTextDescriptor.Position.UPLEFT) {
                ret.append("7");
            } else if (pos == AbstractTextDescriptor.Position.UPRIGHT) {
                ret.append("9");
            } else if (pos == AbstractTextDescriptor.Position.DOWNLEFT) {
                ret.append("1");
            } else if (pos == AbstractTextDescriptor.Position.DOWNRIGHT) {
                ret.append("3");
            } else if (pos == AbstractTextDescriptor.Position.BOXED) {
                ret.append("0");
            } else {
                ret.append("5");
            }
            int font = td.getFace();
            if (font != 0) {
                AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(font);
                ret.append("F" + this.convertString(af.toString()) + ";");
            }
            if (!size.isAbsolute()) {
                ret.append("G" + TextUtils.formatDouble(size.getSize()) + ";");
            }
        }
        if (td.isInherit()) {
            ret.append("H");
        }
        if (display) {
            AbstractTextDescriptor.DispPos dispPos;
            if (td.isItalic()) {
                ret.append("I");
            }
            if (td.isUnderline()) {
                ret.append("L");
            }
            if ((dispPos = td.getDispPart()) == AbstractTextDescriptor.DispPos.NAMEVALUE) {
                ret.append("N");
            }
        }
        if (var != null && td.isCode() && ((value = var.getObject()) instanceof String || value instanceof String[])) {
            AbstractTextDescriptor.Code codeType = td.getCode();
            if (codeType == AbstractTextDescriptor.Code.JAVA) {
                ret.append("OJ");
            } else if (codeType == AbstractTextDescriptor.Code.SPICE) {
                ret.append("OL");
            } else if (codeType == AbstractTextDescriptor.Code.TCL) {
                ret.append("OT");
            }
        }
        if (var != null && td.isParam()) {
            ret.append("P");
        }
        if (display) {
            AbstractTextDescriptor.Rotation rot = td.getRotation();
            if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                ret.append("R");
            } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                ret.append("RR");
            } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                ret.append("RRR");
            }
        }
        if (td.isInterior()) {
            ret.append("T");
        }
        if ((unit = td.getUnit()) == AbstractTextDescriptor.Unit.RESISTANCE) {
            ret.append("UR");
        } else if (unit == AbstractTextDescriptor.Unit.CAPACITANCE) {
            ret.append("UC");
        } else if (unit == AbstractTextDescriptor.Unit.INDUCTANCE) {
            ret.append("UI");
        } else if (unit == AbstractTextDescriptor.Unit.CURRENT) {
            ret.append("UA");
        } else if (unit == AbstractTextDescriptor.Unit.VOLTAGE) {
            ret.append("UV");
        } else if (unit == AbstractTextDescriptor.Unit.DISTANCE) {
            ret.append("UD");
        } else if (unit == AbstractTextDescriptor.Unit.TIME) {
            ret.append("UT");
        }
        if (display) {
            double offY;
            double offX = td.getXOff();
            if (offX != 0.0) {
                ret.append("X" + TextUtils.formatDouble(offX, 0) + ";");
            }
            if ((offY = td.getYOff()) != 0.0) {
                ret.append("Y" + TextUtils.formatDouble(offY, 0) + ";");
            }
        }
        return ret.toString();
    }

    private void printlnVars(ImmutableElectricObject d) {
        ImmutableNodeInst nid;
        this.printVars(null, d);
        if (d instanceof ImmutableNodeInst && (nid = (ImmutableNodeInst)d).hasPortInstVariables()) {
            if (nid.protoId instanceof CellId) {
                CellBackup protoBackup = this.snapshot.getCell((CellId)nid.protoId);
                for (int portIndex = 0; portIndex < protoBackup.exports.size(); ++portIndex) {
                    ImmutableExport e = (ImmutableExport)protoBackup.exports.get(portIndex);
                    ImmutablePortInst pid = nid.getPortInst(e.exportId);
                    if (pid.getNumVariables() == 0) continue;
                    this.printVars(this.getExportName(e), pid);
                }
            } else {
                PrimitiveNode pn = (PrimitiveNode)nid.protoId;
                for (int portIndex = 0; portIndex < pn.getNumPorts(); ++portIndex) {
                    PrimitivePort pp = pn.getPort(portIndex);
                    ImmutablePortInst pid = nid.getPortInst(pp);
                    if (pid.getNumVariables() == 0) continue;
                    this.printVars(pp.getName(), pid);
                }
            }
        }
        this.printWriter.println();
    }

    private void printVars(String portName, ImmutableElectricObject d) {
        Iterator<Variable> it = d.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            Object varObj = var.getObject();
            String tdString = this.describeDescriptor(var, var.getTextDescriptor());
            this.printWriter.print("|" + this.convertVariableName(this.diskName(portName, var)) + "(" + tdString + ")");
            String pt = this.makeString(varObj);
            if (pt == null) {
                pt = "";
            }
            this.printWriter.print(pt);
        }
    }

    private void printlnMeaningPrefs(Object obj) {
        List<Pref> prefs = Pref.getMeaningVariables(obj);
        for (Pref pref : prefs) {
            Object value = pref.getValue();
            this.printWriter.print("|" + this.convertVariableName(pref.getPrefName()) + "()" + this.makeString(value));
        }
        this.printWriter.println();
    }

    private String makeString(Object obj) {
        StringBuffer infstr = new StringBuffer();
        char type = this.getVarType(obj);
        infstr.append(type);
        if (obj instanceof Object[]) {
            Object[] objArray = (Object[])obj;
            int len = objArray.length;
            infstr.append('[');
            for (int i = 0; i < len; ++i) {
                Object oneObj = objArray[i];
                if (i != 0) {
                    infstr.append(',');
                }
                this.makeStringVar(infstr, type, oneObj, true);
            }
            infstr.append(']');
        } else {
            this.makeStringVar(infstr, type, obj, false);
        }
        return infstr.toString();
    }

    private void makeStringVar(StringBuffer infstr, char type, Object obj, boolean inArray) {
        if (obj == null) {
            return;
        }
        switch (type) {
            case 'B': {
                infstr.append((Boolean)obj != false ? (char)'T' : 'F');
                return;
            }
            case 'C': {
                infstr.append(this.convertString(this.getFullCellName((CellId)obj), inArray));
                return;
            }
            case 'D': {
                infstr.append((Double)obj);
                return;
            }
            case 'E': {
                ExportId pp = (ExportId)obj;
                infstr.append(this.convertString(this.getFullCellName(pp.getParentId()) + ":" + this.getPortName(pp), inArray));
                return;
            }
            case 'F': {
                infstr.append(((Float)obj).floatValue());
                return;
            }
            case 'G': {
                infstr.append((Long)obj);
                return;
            }
            case 'H': {
                infstr.append(((Short)obj).shortValue());
                return;
            }
            case 'I': {
                infstr.append((Integer)obj);
                return;
            }
            case 'L': {
                infstr.append(this.convertString(this.snapshot.getLib((LibId)((LibId)obj)).d.libId.libName, inArray));
                return;
            }
            case 'O': {
                infstr.append(this.convertString(((Tool)obj).getName(), inArray));
                return;
            }
            case 'P': {
                infstr.append(this.convertString(((PrimitiveNode)obj).getFullName(), inArray));
                return;
            }
            case 'R': {
                infstr.append(this.convertString(((ArcProto)obj).getFullName(), inArray));
                return;
            }
            case 'S': {
                infstr.append(this.convertString((String)obj, inArray));
                return;
            }
            case 'T': {
                infstr.append(this.convertString(((Technology)obj).getTechName(), inArray));
                return;
            }
            case 'V': {
                EPoint pt2 = (EPoint)obj;
                infstr.append(TextUtils.formatDouble(pt2.getX(), 0) + "/" + TextUtils.formatDouble(pt2.getY(), 0));
                return;
            }
            case 'Y': {
                infstr.append(((Byte)obj).byteValue());
                return;
            }
        }
    }

    private String getExportName(ImmutableExport e) {
        return this.oldRevision ? e.name.toString() : e.exportId.externalId;
    }

    private String getPortName(PortProtoId portId) {
        if (portId instanceof PrimitivePort) {
            PrimitivePort pp = (PrimitivePort)portId;
            return pp.getParent().getNumPorts() > 1 ? pp.getName() : "";
        }
        ExportId exportId = (ExportId)portId;
        CellBackup cellBackup = this.snapshot.getCell(exportId.parentId);
        ImmutableExport e = cellBackup.getExport(exportId);
        return this.convertString(this.getExportName(e));
    }

    private String getFullCellName(CellId cellId) {
        ImmutableCell d = this.snapshot.getCell((CellId)cellId).d;
        LibraryBackup libBackup = this.snapshot.getLib(d.libId);
        return this.convertString(libBackup.d.libId.libName + ":" + d.cellName);
    }

    private char getVarType(Object obj) {
        if (obj instanceof String || obj instanceof String[]) {
            return 'S';
        }
        if (obj instanceof Boolean || obj instanceof Boolean[]) {
            return 'B';
        }
        if (obj instanceof CellId || obj instanceof CellId[]) {
            return 'C';
        }
        if (obj instanceof Double || obj instanceof Double[]) {
            return 'D';
        }
        if (obj instanceof ExportId || obj instanceof ExportId[]) {
            return 'E';
        }
        if (obj instanceof Float || obj instanceof Float[]) {
            return 'F';
        }
        if (obj instanceof Long || obj instanceof Long[]) {
            return 'G';
        }
        if (obj instanceof Short || obj instanceof Short[]) {
            return 'H';
        }
        if (obj instanceof Integer || obj instanceof Integer[]) {
            return 'I';
        }
        if (obj instanceof LibId || obj instanceof LibId[]) {
            return 'L';
        }
        if (obj instanceof Tool || obj instanceof Tool[]) {
            return 'O';
        }
        if (obj instanceof PrimitiveNode || obj instanceof PrimitiveNode[]) {
            return 'P';
        }
        if (obj instanceof ArcProto || obj instanceof ArcProto[]) {
            return 'R';
        }
        if (obj instanceof Technology || obj instanceof Technology[]) {
            return 'T';
        }
        if (obj instanceof EPoint || obj instanceof EPoint[]) {
            return 'V';
        }
        if (obj instanceof Byte || obj instanceof Byte[]) {
            return 'Y';
        }
        assert (false) : obj;
        return 'X';
    }

    private String convertQuotedString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\n') {
                infstr.append("\\n");
                continue;
            }
            if (ch == '\r') {
                infstr.append("\\r");
                continue;
            }
            if (ch == '\"' || ch == '\\') {
                infstr.append('\\');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    String convertString(String str) {
        return this.convertString(str, '\u0000', '\u0000');
    }

    private String convertString(String str, char delim1, char delim2) {
        if (!(str.length() == 0 || str.indexOf(10) >= 0 || str.indexOf(13) >= 0 || str.indexOf(92) >= 0 || str.indexOf(34) >= 0 || str.indexOf(124) >= 0 || delim1 != '\u0000' && str.indexOf(delim1) >= 0 || delim2 != '\u0000' && str.indexOf(delim2) >= 0)) {
            return str;
        }
        return '\"' + this.convertQuotedString(str) + '\"';
    }

    private String convertVariableName(String str) {
        return this.convertString(str, '(', '\u0000');
    }

    private String convertString(String str, boolean inArray) {
        return inArray ? this.convertString(str, ',', ']') : this.convertString(str, '\u0000', '\u0000');
    }

    static class CellGroup {
        TreeSet<CellName> cellNames = new TreeSet();
        CellName mainSchematics;

        CellGroup() {
        }
    }
}

